/** VSys:$eth-hndl.cc:0.0.3-024$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: eth-hndl.cc; File version: 0.0.3-024
 */
/*
 * Ethernet IP packets parser.
 * Thanks to TCPDUMP Group for their code - it was very usefull in
 * learning BPF/PCAP usage
 */

#include "pcap.local.h"

#ifdef WIN32
#include "win32/ethernet.h"
#include <winsock2.h>
#else
#include <sys/types.h>
#include <unistd.h>

#include "config.h"
#if defined __OS_SOLARIS_LIKE
#include <sys/ethernet.h>
#else
#include <net/ethernet.h>
#endif


#include <arpa/inet.h>
#include <sys/time.h>
#endif

#include <stdlib.h>
#include "nf.h"
#include "nfc.h"
#include "handlers.h"
#include "iptonf.h"
#include "iflist.h"

#include "nethdr.h"
#include "debug.h"

#ifndef ETHER_HDR_LEN
#define ETHER_HDR_LEN sizeof(ether_header)
#endif

void ether_handler( u_char * _if, const struct pcap_pkthdr *h, const u_char *p ) {
	u_int16_t etype;
	struct ether_header *eh;
	eh = ( struct ether_header* ) p;
	etype = ntohs( eh->ether_type );
	if_list *iface = (if_list *) _if;
	if( !iface ) return;

		//fputc( '.', stdout );
	if( h->caplen < ETHER_HDR_LEN + IP_HDR_SZ ) return;
	if( etype == ETHERTYPE_IP ) {
		iptonf( _if, &(h->ts), p+ETHER_HDR_LEN );
	} else  {
		return;
		DEB(print_eth( eh )); fflush( stdout );
		(void)printf( "%lu.%06lu; size: %d;\n",
		h->ts.tv_sec, h->ts.tv_usec, h->len-ETHER_HDR_LEN);
	}
}
