/* input.c: input functions
 *
 * Copyright (C) 1995-97 Roman Hodek <Roman.Hodek@informatik.uni-erlangen.de>
 *               1996-97 Michael Schlueter <schlue00@marvin.informatik.uni-dortmund.de>
 *
 * This program is free software.  You can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation: either version 2 or
 * (at your option) any later version.
 *
 */

/* $Id: input.c,v 1.9 1997/07/10 20:37:17 rnhodek Exp $
 *
 * $Log: input.c,v $
 * Revision 1.9  1997/07/10 20:37:17  rnhodek
 * Print informative message if get_parttion() uses only one partition.
 *
 * Revision 1.8  1997/07/08 18:59:01  rnhodek
 * Ouch, too many changes without commits in between...
 * Implemented moving of partitions
 * Implemented checking of "extended start condition" (great changes in
 *   new_partition())
 * Some more tests in verify()
 *
 * Revision 1.7  1997/06/22 10:30:33  rnhodek
 * In read_int(), display dflt separately if different from base for +-
 * Add __attribute__((unused)) to cvid
 *
 * Revision 1.6  1997/06/21 20:47:43  rnhodek
 * Added RCS keywords
 *
 * Revision 1.5  1997/06/13 12:49:19  rnhodek
 * Also - at start should clear use_default
 * 
 * Revision 1.4  1997/06/12 14:08:11  rnhodek
 * Fix previous fix...
 * 
 * Revision 1.3  1997/06/12 14:00:05  rnhodek
 * Correct for counter-intuitive behaviour in read_int
 * 
 * Revision 1.2  1997/06/12 13:43:38  rnhodek
 * Fix many small bugs here and there. The ones you find when first running a
 * program...
 * 
 * Revision 1.1  1997/06/11 14:36:36  rnhodek
 * Initial revision
 * 
 * Revision 1.1.1.1  1997/06/11 14:36:36  rnhodek
 * Started using CVS for atafdisk
 *
 */

#ifndef lint
static char vcid[] __attribute__ ((unused)) =
"$Id: input.c,v 1.9 1997/07/10 20:37:17 rnhodek Exp $";
#endif /* lint */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "fdisk.h"
#include "input.h"

char read_char( char *mesg )
{
    fputs(mesg, stdout);
    read_line();
    return( *line_ptr );
}

uint read_int( uint low, uint dflt, uint high, enum offset base, char *mesg )
{
    uint i, use_default = 1;
    char ms[100];

    switch(base) {
      case lower:
	sprintf( ms, "%s ([%d]-%d", mesg, low, high );
	if (dflt != low)
	    sprintf( ms+strlen(ms), ", dflt %d", dflt );
	strcat( ms, "): " );
	break;
      case upper:
	sprintf( ms, "%s (%d-[%d]", mesg, low, high );
	if (dflt != high)
	    sprintf( ms+strlen(ms), ", dflt %d", dflt );
	strcat( ms, "): " );
	break;
      case deflt:
	sprintf( ms, "%s (%d-[%d]-%d): ", mesg, low, dflt, high );
	break;
      default:
	sprintf( ms, "%s (%d-%d): ", mesg, low, high );
	break;
    }

    while (1) {
	while( !isdigit(read_char(ms)) &&
	       *line_ptr != '-' && *line_ptr != '+' && *line_ptr )
	    continue;
	if (*line_ptr == '+' || *line_ptr == '-') {
	    if (*line_ptr == '+')
		++line_ptr;
	    i = atoi(line_ptr);
	    while (isdigit(*line_ptr) || *line_ptr == '-') {
		line_ptr++;
		use_default = 0;
	    }
	    switch (*line_ptr) {
	      case 'k':
	      case 'K': i *= 2;
		break;
	      case 'm':
	      case 'M': i *= 2048;
		break;
	      default: break;
	    }
	    switch( base ) {
		/* case lower is special: the user intends something like
		 * "make this partition thus big", but we asked him for the
		 * end sector. Just adding i thus makes the partition 1 sector
		 * larger than intended. correct for that. */
	      case lower: i += low - 1; break;
	      case upper: i += high; break;
	      case deflt: i += dflt; break;
	      case ignore: break;
	    }
	}
	else
	    {
		i = atoi(line_ptr);
		while (isdigit(*line_ptr))
		    {
			line_ptr++;
			use_default = 0;
		    }
	    }
	if (use_default)
	    printf("Using default value %d\n", i = dflt);
	if (i >= low && i <= high)
	    break;
	else
	    printf("Value out of range.\n");
    }
    return i;
}

int read_line(void)
{
    if (!fgets(line_buffer, LINE_LENGTH, stdin))
	exit(0);
    line_ptr = line_buffer;
    while (*line_ptr && !isgraph(*line_ptr))
	line_ptr++;
    return *line_ptr;
}

int read_yesno( char *mesg, int dflt )
{
    char *yes_str = (dflt < 0 ? "yes" : dflt == 0 ? "y" : "Y");
    char *no_str  = (dflt < 0 ? "no"  : dflt == 0 ? "N" : "n");

    for(;;) {
	printf( "%s (%s/%s) ? ", mesg, yes_str, no_str );
	fflush(stdout);

	if (!read_line() && dflt >= 0)
	    return( dflt );
	if (strncasecmp( line_ptr, "yes", 3 ) == 0)
	    return( 1 );
	if (strncasecmp( line_ptr, "no", 2 ) == 0)
	    return( 0 );
	if (dflt >= 0 && strncasecmp( line_ptr, "y", 1 ) == 0)
	    return( 1 );
	if (dflt >= 0 && strncasecmp( line_ptr, "n", 1 ) == 0)
	    return( 0 );
	printf( "Please answer exactly!\n" );
    }
}

int get_partition( int max )
{
    /* don't ask if only one partition to select... */
    if (partitions == 1) {
	printf( "Using only partition 1\n" );
	return( 0 );
    }
    /*
     * try to pick a default least likely to do damage,
     * in case luser just types a newline
     */
    return( read_int( 1, max, max, ignore, "Partition number" ) - 1 );
}

/* Local Variables: */
/* tab-width: 8     */
/* End:             */
