package cloudgameapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetStopGameToken invokes the cloudgameapi.GetStopGameToken API synchronously
func (client *Client) GetStopGameToken(request *GetStopGameTokenRequest) (response *GetStopGameTokenResponse, err error) {
	response = CreateGetStopGameTokenResponse()
	err = client.DoAction(request, response)
	return
}

// GetStopGameTokenWithChan invokes the cloudgameapi.GetStopGameToken API asynchronously
func (client *Client) GetStopGameTokenWithChan(request *GetStopGameTokenRequest) (<-chan *GetStopGameTokenResponse, <-chan error) {
	responseChan := make(chan *GetStopGameTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetStopGameToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetStopGameTokenWithCallback invokes the cloudgameapi.GetStopGameToken API asynchronously
func (client *Client) GetStopGameTokenWithCallback(request *GetStopGameTokenRequest, callback func(response *GetStopGameTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetStopGameTokenResponse
		var err error
		defer close(result)
		response, err = client.GetStopGameToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetStopGameTokenRequest is the request struct for api GetStopGameToken
type GetStopGameTokenRequest struct {
	*requests.RpcRequest
	GameId    string `position:"Query" name:"GameId"`
	AccessKey string `position:"Query" name:"AccessKey"`
}

// GetStopGameTokenResponse is the response struct for api GetStopGameToken
type GetStopGameTokenResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Token      string `json:"Token" xml:"Token"`
	ExpireTime int64  `json:"ExpireTime" xml:"ExpireTime"`
}

// CreateGetStopGameTokenRequest creates a request to invoke GetStopGameToken API
func CreateGetStopGameTokenRequest() (request *GetStopGameTokenRequest) {
	request = &GetStopGameTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudGameAPI", "2020-07-28", "GetStopGameToken", "", "")
	request.Method = requests.POST
	return
}

// CreateGetStopGameTokenResponse creates a response to parse from GetStopGameToken response
func CreateGetStopGameTokenResponse() (response *GetStopGameTokenResponse) {
	response = &GetStopGameTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
