package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVnKnowledge invokes the cloudcallcenter.DescribeVnKnowledge API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnknowledge.html
func (client *Client) DescribeVnKnowledge(request *DescribeVnKnowledgeRequest) (response *DescribeVnKnowledgeResponse, err error) {
	response = CreateDescribeVnKnowledgeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVnKnowledgeWithChan invokes the cloudcallcenter.DescribeVnKnowledge API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnknowledge.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVnKnowledgeWithChan(request *DescribeVnKnowledgeRequest) (<-chan *DescribeVnKnowledgeResponse, <-chan error) {
	responseChan := make(chan *DescribeVnKnowledgeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVnKnowledge(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVnKnowledgeWithCallback invokes the cloudcallcenter.DescribeVnKnowledge API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnknowledge.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVnKnowledgeWithCallback(request *DescribeVnKnowledgeRequest, callback func(response *DescribeVnKnowledgeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVnKnowledgeResponse
		var err error
		defer close(result)
		response, err = client.DescribeVnKnowledge(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVnKnowledgeRequest is the request struct for api DescribeVnKnowledge
type DescribeVnKnowledgeRequest struct {
	*requests.RpcRequest
	InstanceId         string `position:"Query" name:"InstanceId"`
	NavigationScriptId string `position:"Query" name:"NavigationScriptId"`
}

// DescribeVnKnowledgeResponse is the response struct for api DescribeVnKnowledge
type DescribeVnKnowledgeResponse struct {
	*responses.BaseResponse
	RequestId          string   `json:"RequestId" xml:"RequestId"`
	NavigationScriptId string   `json:"NavigationScriptId" xml:"NavigationScriptId"`
	InstanceId         string   `json:"InstanceId" xml:"InstanceId"`
	CategoryId         string   `json:"CategoryId" xml:"CategoryId"`
	UserUtterance      string   `json:"UserUtterance" xml:"UserUtterance"`
	Answer             string   `json:"Answer" xml:"Answer"`
	Interruptible      bool     `json:"Interruptible" xml:"Interruptible"`
	SimilarUtterances  []string `json:"SimilarUtterances" xml:"SimilarUtterances"`
}

// CreateDescribeVnKnowledgeRequest creates a request to invoke DescribeVnKnowledge API
func CreateDescribeVnKnowledgeRequest() (request *DescribeVnKnowledgeRequest) {
	request = &DescribeVnKnowledgeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DescribeVnKnowledge", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeVnKnowledgeResponse creates a response to parse from DescribeVnKnowledge response
func CreateDescribeVnKnowledgeResponse() (response *DescribeVnKnowledgeResponse) {
	response = &DescribeVnKnowledgeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
