package brinekingdom

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitPlanningResult invokes the brinekingdom.SubmitPlanningResult API synchronously
func (client *Client) SubmitPlanningResult(request *SubmitPlanningResultRequest) (response *SubmitPlanningResultResponse, err error) {
	response = CreateSubmitPlanningResultResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitPlanningResultWithChan invokes the brinekingdom.SubmitPlanningResult API asynchronously
func (client *Client) SubmitPlanningResultWithChan(request *SubmitPlanningResultRequest) (<-chan *SubmitPlanningResultResponse, <-chan error) {
	responseChan := make(chan *SubmitPlanningResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitPlanningResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitPlanningResultWithCallback invokes the brinekingdom.SubmitPlanningResult API asynchronously
func (client *Client) SubmitPlanningResultWithCallback(request *SubmitPlanningResultRequest, callback func(response *SubmitPlanningResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitPlanningResultResponse
		var err error
		defer close(result)
		response, err = client.SubmitPlanningResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitPlanningResultRequest is the request struct for api SubmitPlanningResult
type SubmitPlanningResultRequest struct {
	*requests.RpcRequest
	RequireCnt     requests.Integer                      `position:"Query" name:"RequireCnt"`
	DemandId       requests.Integer                      `position:"Query" name:"DemandId"`
	SubDemandId    requests.Integer                      `position:"Query" name:"SubDemandId"`
	BufferCnt      requests.Integer                      `position:"Query" name:"BufferCnt"`
	DemandCount    requests.Integer                      `position:"Query" name:"DemandCount"`
	ResourceMethod *[]SubmitPlanningResultResourceMethod `position:"Query" name:"ResourceMethod"  type:"Repeated"`
}

// SubmitPlanningResultResourceMethod is a repeated param struct in SubmitPlanningResultRequest
type SubmitPlanningResultResourceMethod struct {
	FinalAvzone     string                            `name:"FinalAvzone"`
	Cluster         string                            `name:"Cluster"`
	ConvertHostCnt  string                            `name:"ConvertHostCnt"`
	BufferCnt       string                            `name:"BufferCnt"`
	SupplyPlan      *[]SubmitPlanningResultSupplyPlan `name:"SupplyPlan" type:"Repeated"`
	RoomCode        string                            `name:"RoomCode"`
	Comment         string                            `name:"Comment"`
	Region          string                            `name:"Region"`
	ConvertHostType string                            `name:"ConvertHostType"`
	Azone           string                            `name:"Azone"`
	GapCnt          string                            `name:"GapCnt"`
}

// SubmitPlanningResultSupplyPlan is a repeated param struct in SubmitPlanningResultRequest
type SubmitPlanningResultSupplyPlan struct {
	SafeZone        string `name:"SafeZone"`
	NetArch         string `name:"NetArch"`
	SupplyType      string `name:"SupplyType"`
	LogicZone       string `name:"LogicZone"`
	SupplyAmount    string `name:"SupplyAmount"`
	SupplyDate      string `name:"SupplyDate"`
	Nic             string `name:"Nic"`
	ClassZone       string `name:"ClassZone"`
	ConvertHostType string `name:"ConvertHostType"`
	Product3        string `name:"Product3"`
}

// SubmitPlanningResultResponse is the response struct for api SubmitPlanningResult
type SubmitPlanningResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSubmitPlanningResultRequest creates a request to invoke SubmitPlanningResult API
func CreateSubmitPlanningResultRequest() (request *SubmitPlanningResultRequest) {
	request = &SubmitPlanningResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("brinekingdom", "2019-06-27", "SubmitPlanningResult", "", "")
	request.Method = requests.POST
	return
}

// CreateSubmitPlanningResultResponse creates a response to parse from SubmitPlanningResult response
func CreateSubmitPlanningResultResponse() (response *SubmitPlanningResultResponse) {
	response = &SubmitPlanningResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
