package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMeetingMember invokes the aliyuncvc.GetMeetingMember API synchronously
func (client *Client) GetMeetingMember(request *GetMeetingMemberRequest) (response *GetMeetingMemberResponse, err error) {
	response = CreateGetMeetingMemberResponse()
	err = client.DoAction(request, response)
	return
}

// GetMeetingMemberWithChan invokes the aliyuncvc.GetMeetingMember API asynchronously
func (client *Client) GetMeetingMemberWithChan(request *GetMeetingMemberRequest) (<-chan *GetMeetingMemberResponse, <-chan error) {
	responseChan := make(chan *GetMeetingMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMeetingMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMeetingMemberWithCallback invokes the aliyuncvc.GetMeetingMember API asynchronously
func (client *Client) GetMeetingMemberWithCallback(request *GetMeetingMemberRequest, callback func(response *GetMeetingMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMeetingMemberResponse
		var err error
		defer close(result)
		response, err = client.GetMeetingMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMeetingMemberRequest is the request struct for api GetMeetingMember
type GetMeetingMemberRequest struct {
	*requests.RpcRequest
	MeetingUUID string `position:"Query" name:"MeetingUUID"`
}

// GetMeetingMemberResponse is the response struct for api GetMeetingMember
type GetMeetingMemberResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Message   string                 `json:"Message" xml:"Message"`
	Success   bool                   `json:"Success" xml:"Success"`
	ErrorCode int                    `json:"ErrorCode" xml:"ErrorCode"`
	Members   map[string]interface{} `json:"Members" xml:"Members"`
}

// CreateGetMeetingMemberRequest creates a request to invoke GetMeetingMember API
func CreateGetMeetingMemberRequest() (request *GetMeetingMemberRequest) {
	request = &GetMeetingMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "GetMeetingMember", "aliyuncvc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetMeetingMemberResponse creates a response to parse from GetMeetingMember response
func CreateGetMeetingMemberResponse() (response *GetMeetingMemberResponse) {
	response = &GetMeetingMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
