// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/storagepb/state.proto

package storagepb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import enginepb "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// ReplicaState is the part of the Range Raft state machine which is cached in
// memory and which is manipulated exclusively through consensus.
//
// The struct is also used to transfer state to Replicas in the context of
// proposer-evaluated Raft, in which case it does not represent a complete
// state but instead an update to be applied to an existing state, with each
// field specified in the update overwriting its counterpart on the receiving
// ReplicaState.
//
// For the ReplicaState persisted on the Replica, all optional fields are
// populated (i.e. no nil pointers or enums with the default value).
type ReplicaState struct {
	// The highest (and last) index applied to the state machine.
	RaftAppliedIndex uint64 `protobuf:"varint,1,opt,name=raft_applied_index,json=raftAppliedIndex,proto3" json:"raft_applied_index,omitempty"`
	// The highest (and last) lease index applied to the state machine.
	LeaseAppliedIndex uint64 `protobuf:"varint,2,opt,name=lease_applied_index,json=leaseAppliedIndex,proto3" json:"lease_applied_index,omitempty"`
	// The Range descriptor.
	// The pointer may change, but the referenced RangeDescriptor struct itself
	// must be treated as immutable; it is leaked out of the lock.
	//
	// Changes of the descriptor should always go through one of the
	// (*Replica).setDesc* methods.
	Desc *roachpb.RangeDescriptor `protobuf:"bytes,3,opt,name=desc,proto3" json:"desc,omitempty"`
	// The latest range lease.
	//
	// Note that this message is both sent over the network and used to model
	// replica state in memory. In memory (storage.Replica.mu.state), the lease
	// is never nil (and never zero-valued), but it may be nil when sent over
	// the network as part of ReplicatedEvalResult.
	Lease *roachpb.Lease `protobuf:"bytes,4,opt,name=lease,proto3" json:"lease,omitempty"`
	// The truncation state of the Raft log.
	TruncatedState *roachpb.RaftTruncatedState `protobuf:"bytes,5,opt,name=truncated_state,json=truncatedState,proto3" json:"truncated_state,omitempty"`
	// gcThreshold is the GC threshold of the Range, typically updated when keys
	// are garbage collected. Reads and writes at timestamps <= this time will
	// not be served.
	GCThreshold *hlc.Timestamp      `protobuf:"bytes,6,opt,name=gc_threshold,json=gcThreshold,proto3" json:"gc_threshold,omitempty" cockroachdb:"randnullable"`
	Stats       *enginepb.MVCCStats `protobuf:"bytes,7,opt,name=stats,proto3" json:"stats,omitempty"`
	// txn_span_gc_threshold is the (maximum) timestamp below which transaction
	// records may have been garbage collected (as measured by txn.LastActive()).
	// Transactions at lower timestamps must not be allowed to write their initial
	// transaction entry.
	// TODO(nvanbenschoten): Remove this in 2.3, at which point we won't need to
	// maintain it because no nodes in the cluster will ever consult it.
	TxnSpanGCThreshold *hlc.Timestamp `protobuf:"bytes,9,opt,name=txn_span_gc_threshold,json=txnSpanGcThreshold,proto3" json:"txn_span_gc_threshold,omitempty" cockroachdb:"randnullable"`
	// using_applied_state_key specifies whether the Range has been upgraded
	// to begin using the RangeAppliedState key. This key holds a combination
	// of the Raft applied index, the lease applied index, and the MVCC stats.
	//
	// When set to true in a ReplicatedEvalResult, the flag indicates that the
	// range should begin using the RangeAppliedState key. Handling of this flag
	// is idempotent by Replica state machines, meaning that it is ok for multiple
	// Raft commands to set it to true.
	UsingAppliedStateKey bool     `protobuf:"varint,11,opt,name=using_applied_state_key,json=usingAppliedStateKey,proto3" json:"using_applied_state_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReplicaState) Reset()         { *m = ReplicaState{} }
func (m *ReplicaState) String() string { return proto.CompactTextString(m) }
func (*ReplicaState) ProtoMessage()    {}
func (*ReplicaState) Descriptor() ([]byte, []int) {
	return fileDescriptor_state_d9af2fb9bb51c841, []int{0}
}
func (m *ReplicaState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicaState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ReplicaState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicaState.Merge(dst, src)
}
func (m *ReplicaState) XXX_Size() int {
	return m.Size()
}
func (m *ReplicaState) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicaState.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicaState proto.InternalMessageInfo

// RangeInfo is used for reporting status information about a range out through
// the status server.
type RangeInfo struct {
	ReplicaState `protobuf:"bytes,1,opt,name=state,proto3,embedded=state" json:"state"`
	// The highest (and last) index in the Raft log.
	LastIndex  uint64 `protobuf:"varint,2,opt,name=last_index,json=lastIndex,proto3" json:"last_index,omitempty"`
	NumPending uint64 `protobuf:"varint,3,opt,name=num_pending,json=numPending,proto3" json:"num_pending,omitempty"`
	NumDropped uint64 `protobuf:"varint,5,opt,name=num_dropped,json=numDropped,proto3" json:"num_dropped,omitempty"`
	// raft_log_size may be inaccurate, see storage.Replica.mu.raftLogSizeTrusted.
	RaftLogSize        int64 `protobuf:"varint,6,opt,name=raft_log_size,json=raftLogSize,proto3" json:"raft_log_size,omitempty"`
	RaftLogSizeTrusted bool  `protobuf:"varint,10,opt,name=raft_log_size_trusted,json=raftLogSizeTrusted,proto3" json:"raft_log_size_trusted,omitempty"`
	// Approximately the amount of quota available.
	ApproximateProposalQuota int64 `protobuf:"varint,7,opt,name=approximate_proposal_quota,json=approximateProposalQuota,proto3" json:"approximate_proposal_quota,omitempty"`
	// The max size the range can grow to before it will be split.
	RangeMaxBytes int64 `protobuf:"varint,8,opt,name=range_max_bytes,json=rangeMaxBytes,proto3" json:"range_max_bytes,omitempty"`
	// The highest closed timestamp known to have data for this replica, taken
	// across the data received from all nodes. This does not reflect whether
	// the replica can use this closed timestamp (it may, for example, not have
	// caught up sufficiently to do so).
	NewestClosedTimestamp RangeInfo_CTEntry `protobuf:"bytes,11,opt,name=newest_closed_timestamp,json=newestClosedTimestamp,proto3" json:"newest_closed_timestamp"`
	// The closed timestamp active on the replica when the info was generated.
	// This is the actual timestamp at or below which requests can be served from
	// this replica at this moment (assuming it is not the leaseholder). This takes
	// into account the lease start time, the current lease applied index, and the
	// closed timestamp information received from other nodes, among other things.
	// In practice, this should not usually trail newest_closed_timestamp except
	// for a short moment after newest_closed_timestamp gets updated.
	ActiveClosedTimestamp hlc.Timestamp `protobuf:"bytes,12,opt,name=active_closed_timestamp,json=activeClosedTimestamp,proto3" json:"active_closed_timestamp"`
	XXX_NoUnkeyedLiteral  struct{}      `json:"-"`
	XXX_sizecache         int32         `json:"-"`
}

func (m *RangeInfo) Reset()         { *m = RangeInfo{} }
func (m *RangeInfo) String() string { return proto.CompactTextString(m) }
func (*RangeInfo) ProtoMessage()    {}
func (*RangeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_state_d9af2fb9bb51c841, []int{1}
}
func (m *RangeInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RangeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeInfo.Merge(dst, src)
}
func (m *RangeInfo) XXX_Size() int {
	return m.Size()
}
func (m *RangeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_RangeInfo proto.InternalMessageInfo

type RangeInfo_CTEntry struct {
	NodeID               github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	ClosedTimestamp      hlc.Timestamp                                       `protobuf:"bytes,2,opt,name=closed_timestamp,json=closedTimestamp,proto3" json:"closed_timestamp"`
	MLAI                 int64                                               `protobuf:"varint,3,opt,name=mlai,proto3" json:"mlai,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *RangeInfo_CTEntry) Reset()         { *m = RangeInfo_CTEntry{} }
func (m *RangeInfo_CTEntry) String() string { return proto.CompactTextString(m) }
func (*RangeInfo_CTEntry) ProtoMessage()    {}
func (*RangeInfo_CTEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_state_d9af2fb9bb51c841, []int{1, 0}
}
func (m *RangeInfo_CTEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeInfo_CTEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RangeInfo_CTEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeInfo_CTEntry.Merge(dst, src)
}
func (m *RangeInfo_CTEntry) XXX_Size() int {
	return m.Size()
}
func (m *RangeInfo_CTEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeInfo_CTEntry.DiscardUnknown(m)
}

var xxx_messageInfo_RangeInfo_CTEntry proto.InternalMessageInfo

// LatchManagerInfo is used for reporting status information about a spanlatch
// manager out through the status server.
type LatchManagerInfo struct {
	ReadCount            int64    `protobuf:"varint,1,opt,name=read_count,json=readCount,proto3" json:"read_count,omitempty"`
	WriteCount           int64    `protobuf:"varint,2,opt,name=write_count,json=writeCount,proto3" json:"write_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LatchManagerInfo) Reset()         { *m = LatchManagerInfo{} }
func (m *LatchManagerInfo) String() string { return proto.CompactTextString(m) }
func (*LatchManagerInfo) ProtoMessage()    {}
func (*LatchManagerInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_state_d9af2fb9bb51c841, []int{2}
}
func (m *LatchManagerInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LatchManagerInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *LatchManagerInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LatchManagerInfo.Merge(dst, src)
}
func (m *LatchManagerInfo) XXX_Size() int {
	return m.Size()
}
func (m *LatchManagerInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LatchManagerInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LatchManagerInfo proto.InternalMessageInfo

func init() {
	proto.RegisterType((*ReplicaState)(nil), "cockroach.storage.storagepb.ReplicaState")
	proto.RegisterType((*RangeInfo)(nil), "cockroach.storage.storagepb.RangeInfo")
	proto.RegisterType((*RangeInfo_CTEntry)(nil), "cockroach.storage.storagepb.RangeInfo.CTEntry")
	proto.RegisterType((*LatchManagerInfo)(nil), "cockroach.storage.storagepb.LatchManagerInfo")
}
func (this *ReplicaState) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicaState)
	if !ok {
		that2, ok := that.(ReplicaState)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.RaftAppliedIndex != that1.RaftAppliedIndex {
		return false
	}
	if this.LeaseAppliedIndex != that1.LeaseAppliedIndex {
		return false
	}
	if !this.Desc.Equal(that1.Desc) {
		return false
	}
	if !this.Lease.Equal(that1.Lease) {
		return false
	}
	if !this.TruncatedState.Equal(that1.TruncatedState) {
		return false
	}
	if !this.GCThreshold.Equal(that1.GCThreshold) {
		return false
	}
	if !this.Stats.Equal(that1.Stats) {
		return false
	}
	if !this.TxnSpanGCThreshold.Equal(that1.TxnSpanGCThreshold) {
		return false
	}
	if this.UsingAppliedStateKey != that1.UsingAppliedStateKey {
		return false
	}
	return true
}
func (this *RangeInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RangeInfo)
	if !ok {
		that2, ok := that.(RangeInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ReplicaState.Equal(&that1.ReplicaState) {
		return false
	}
	if this.LastIndex != that1.LastIndex {
		return false
	}
	if this.NumPending != that1.NumPending {
		return false
	}
	if this.NumDropped != that1.NumDropped {
		return false
	}
	if this.RaftLogSize != that1.RaftLogSize {
		return false
	}
	if this.RaftLogSizeTrusted != that1.RaftLogSizeTrusted {
		return false
	}
	if this.ApproximateProposalQuota != that1.ApproximateProposalQuota {
		return false
	}
	if this.RangeMaxBytes != that1.RangeMaxBytes {
		return false
	}
	if !this.NewestClosedTimestamp.Equal(&that1.NewestClosedTimestamp) {
		return false
	}
	if !this.ActiveClosedTimestamp.Equal(&that1.ActiveClosedTimestamp) {
		return false
	}
	return true
}
func (this *RangeInfo_CTEntry) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RangeInfo_CTEntry)
	if !ok {
		that2, ok := that.(RangeInfo_CTEntry)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NodeID != that1.NodeID {
		return false
	}
	if !this.ClosedTimestamp.Equal(&that1.ClosedTimestamp) {
		return false
	}
	if this.MLAI != that1.MLAI {
		return false
	}
	return true
}
func (m *ReplicaState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicaState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RaftAppliedIndex != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintState(dAtA, i, uint64(m.RaftAppliedIndex))
	}
	if m.LeaseAppliedIndex != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintState(dAtA, i, uint64(m.LeaseAppliedIndex))
	}
	if m.Desc != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintState(dAtA, i, uint64(m.Desc.Size()))
		n1, err := m.Desc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Lease != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintState(dAtA, i, uint64(m.Lease.Size()))
		n2, err := m.Lease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.TruncatedState != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintState(dAtA, i, uint64(m.TruncatedState.Size()))
		n3, err := m.TruncatedState.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.GCThreshold != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintState(dAtA, i, uint64(m.GCThreshold.Size()))
		n4, err := m.GCThreshold.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Stats != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintState(dAtA, i, uint64(m.Stats.Size()))
		n5, err := m.Stats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.TxnSpanGCThreshold != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintState(dAtA, i, uint64(m.TxnSpanGCThreshold.Size()))
		n6, err := m.TxnSpanGCThreshold.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.UsingAppliedStateKey {
		dAtA[i] = 0x58
		i++
		if m.UsingAppliedStateKey {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RangeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintState(dAtA, i, uint64(m.ReplicaState.Size()))
	n7, err := m.ReplicaState.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	if m.LastIndex != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintState(dAtA, i, uint64(m.LastIndex))
	}
	if m.NumPending != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintState(dAtA, i, uint64(m.NumPending))
	}
	if m.NumDropped != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintState(dAtA, i, uint64(m.NumDropped))
	}
	if m.RaftLogSize != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintState(dAtA, i, uint64(m.RaftLogSize))
	}
	if m.ApproximateProposalQuota != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintState(dAtA, i, uint64(m.ApproximateProposalQuota))
	}
	if m.RangeMaxBytes != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintState(dAtA, i, uint64(m.RangeMaxBytes))
	}
	if m.RaftLogSizeTrusted {
		dAtA[i] = 0x50
		i++
		if m.RaftLogSizeTrusted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	dAtA[i] = 0x5a
	i++
	i = encodeVarintState(dAtA, i, uint64(m.NewestClosedTimestamp.Size()))
	n8, err := m.NewestClosedTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	dAtA[i] = 0x62
	i++
	i = encodeVarintState(dAtA, i, uint64(m.ActiveClosedTimestamp.Size()))
	n9, err := m.ActiveClosedTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	return i, nil
}

func (m *RangeInfo_CTEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeInfo_CTEntry) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintState(dAtA, i, uint64(m.NodeID))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintState(dAtA, i, uint64(m.ClosedTimestamp.Size()))
	n10, err := m.ClosedTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	if m.MLAI != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintState(dAtA, i, uint64(m.MLAI))
	}
	return i, nil
}

func (m *LatchManagerInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LatchManagerInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ReadCount != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintState(dAtA, i, uint64(m.ReadCount))
	}
	if m.WriteCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintState(dAtA, i, uint64(m.WriteCount))
	}
	return i, nil
}

func encodeVarintState(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *ReplicaState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RaftAppliedIndex != 0 {
		n += 1 + sovState(uint64(m.RaftAppliedIndex))
	}
	if m.LeaseAppliedIndex != 0 {
		n += 1 + sovState(uint64(m.LeaseAppliedIndex))
	}
	if m.Desc != nil {
		l = m.Desc.Size()
		n += 1 + l + sovState(uint64(l))
	}
	if m.Lease != nil {
		l = m.Lease.Size()
		n += 1 + l + sovState(uint64(l))
	}
	if m.TruncatedState != nil {
		l = m.TruncatedState.Size()
		n += 1 + l + sovState(uint64(l))
	}
	if m.GCThreshold != nil {
		l = m.GCThreshold.Size()
		n += 1 + l + sovState(uint64(l))
	}
	if m.Stats != nil {
		l = m.Stats.Size()
		n += 1 + l + sovState(uint64(l))
	}
	if m.TxnSpanGCThreshold != nil {
		l = m.TxnSpanGCThreshold.Size()
		n += 1 + l + sovState(uint64(l))
	}
	if m.UsingAppliedStateKey {
		n += 2
	}
	return n
}

func (m *RangeInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ReplicaState.Size()
	n += 1 + l + sovState(uint64(l))
	if m.LastIndex != 0 {
		n += 1 + sovState(uint64(m.LastIndex))
	}
	if m.NumPending != 0 {
		n += 1 + sovState(uint64(m.NumPending))
	}
	if m.NumDropped != 0 {
		n += 1 + sovState(uint64(m.NumDropped))
	}
	if m.RaftLogSize != 0 {
		n += 1 + sovState(uint64(m.RaftLogSize))
	}
	if m.ApproximateProposalQuota != 0 {
		n += 1 + sovState(uint64(m.ApproximateProposalQuota))
	}
	if m.RangeMaxBytes != 0 {
		n += 1 + sovState(uint64(m.RangeMaxBytes))
	}
	if m.RaftLogSizeTrusted {
		n += 2
	}
	l = m.NewestClosedTimestamp.Size()
	n += 1 + l + sovState(uint64(l))
	l = m.ActiveClosedTimestamp.Size()
	n += 1 + l + sovState(uint64(l))
	return n
}

func (m *RangeInfo_CTEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovState(uint64(m.NodeID))
	}
	l = m.ClosedTimestamp.Size()
	n += 1 + l + sovState(uint64(l))
	if m.MLAI != 0 {
		n += 1 + sovState(uint64(m.MLAI))
	}
	return n
}

func (m *LatchManagerInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ReadCount != 0 {
		n += 1 + sovState(uint64(m.ReadCount))
	}
	if m.WriteCount != 0 {
		n += 1 + sovState(uint64(m.WriteCount))
	}
	return n
}

func sovState(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozState(x uint64) (n int) {
	return sovState(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ReplicaState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowState
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicaState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicaState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftAppliedIndex", wireType)
			}
			m.RaftAppliedIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RaftAppliedIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseAppliedIndex", wireType)
			}
			m.LeaseAppliedIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LeaseAppliedIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Desc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Desc == nil {
				m.Desc = &roachpb.RangeDescriptor{}
			}
			if err := m.Desc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Lease == nil {
				m.Lease = &roachpb.Lease{}
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TruncatedState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TruncatedState == nil {
				m.TruncatedState = &roachpb.RaftTruncatedState{}
			}
			if err := m.TruncatedState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GCThreshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GCThreshold == nil {
				m.GCThreshold = &hlc.Timestamp{}
			}
			if err := m.GCThreshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stats == nil {
				m.Stats = &enginepb.MVCCStats{}
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnSpanGCThreshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TxnSpanGCThreshold == nil {
				m.TxnSpanGCThreshold = &hlc.Timestamp{}
			}
			if err := m.TxnSpanGCThreshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UsingAppliedStateKey", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UsingAppliedStateKey = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipState(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthState
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowState
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ReplicaState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastIndex", wireType)
			}
			m.LastIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumPending", wireType)
			}
			m.NumPending = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumPending |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumDropped", wireType)
			}
			m.NumDropped = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumDropped |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftLogSize", wireType)
			}
			m.RaftLogSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RaftLogSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApproximateProposalQuota", wireType)
			}
			m.ApproximateProposalQuota = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApproximateProposalQuota |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeMaxBytes", wireType)
			}
			m.RangeMaxBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeMaxBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftLogSizeTrusted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RaftLogSizeTrusted = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewestClosedTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.NewestClosedTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveClosedTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ActiveClosedTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipState(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthState
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeInfo_CTEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowState
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CTEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CTEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClosedTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ClosedTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MLAI", wireType)
			}
			m.MLAI = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MLAI |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipState(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthState
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LatchManagerInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowState
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LatchManagerInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LatchManagerInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadCount", wireType)
			}
			m.ReadCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteCount", wireType)
			}
			m.WriteCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WriteCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipState(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthState
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipState(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowState
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowState
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowState
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthState
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowState
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipState(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthState = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowState   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("storage/storagepb/state.proto", fileDescriptor_state_d9af2fb9bb51c841)
}

var fileDescriptor_state_d9af2fb9bb51c841 = []byte{
	// 937 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x55, 0x41, 0x6f, 0xe3, 0x44,
	0x18, 0xad, 0x1b, 0x27, 0x4d, 0xc6, 0x5d, 0x1a, 0x86, 0x2d, 0xb5, 0xb2, 0x34, 0xae, 0x82, 0x40,
	0x45, 0x5a, 0x6c, 0xd1, 0x05, 0x0e, 0x2b, 0x2e, 0x4d, 0x8a, 0x50, 0x4a, 0x5b, 0x2d, 0x6e, 0xc4,
	0x61, 0x39, 0x58, 0x93, 0xf1, 0xd4, 0xb1, 0x6a, 0xcf, 0x0c, 0xe3, 0xf1, 0x6e, 0xba, 0x3f, 0x80,
	0x33, 0x3f, 0x81, 0x3b, 0xe2, 0x7f, 0xf4, 0xb8, 0x47, 0xb8, 0x44, 0x10, 0x2e, 0x9c, 0x39, 0x72,
	0x42, 0x33, 0xb6, 0xb3, 0x49, 0xbb, 0xaa, 0x7a, 0xb2, 0xf3, 0xde, 0xfb, 0xbe, 0xf9, 0xe6, 0xcd,
	0x1b, 0x07, 0xec, 0x66, 0x92, 0x09, 0x14, 0x11, 0xaf, 0x7c, 0xf2, 0xb1, 0x97, 0x49, 0x24, 0x89,
	0xcb, 0x05, 0x93, 0x0c, 0x3e, 0xc2, 0x0c, 0x5f, 0x0a, 0x86, 0xf0, 0xc4, 0x2d, 0x05, 0xee, 0x42,
	0xd8, 0xe9, 0x55, 0xb5, 0x84, 0x46, 0x31, 0xad, 0x1e, 0x7c, 0xec, 0xa5, 0x2f, 0x30, 0x2e, 0x1a,
	0x74, 0x1e, 0xe9, 0x62, 0x3e, 0xf6, 0x62, 0x2a, 0x89, 0xa0, 0x28, 0x09, 0x04, 0xba, 0x90, 0x25,
	0xf9, 0x7e, 0x45, 0xa6, 0x44, 0xa2, 0x10, 0x49, 0x54, 0xe2, 0xb0, 0xc2, 0x97, 0x30, 0x3b, 0x97,
	0x71, 0xe2, 0x4d, 0x12, 0xec, 0xc9, 0x38, 0x25, 0x99, 0x44, 0x29, 0x2f, 0x99, 0x87, 0x11, 0x8b,
	0x98, 0x7e, 0xf5, 0xd4, 0x5b, 0x81, 0xf6, 0x7e, 0xad, 0x83, 0x4d, 0x9f, 0xf0, 0x24, 0xc6, 0xe8,
	0x5c, 0x6d, 0x08, 0x3e, 0x06, 0x50, 0x2d, 0x1d, 0x20, 0xce, 0x93, 0x98, 0x84, 0x41, 0x4c, 0x43,
	0x32, 0xb5, 0x8d, 0x3d, 0x63, 0xdf, 0xf4, 0xdb, 0x8a, 0x39, 0x2c, 0x88, 0xa1, 0xc2, 0xa1, 0x0b,
	0xde, 0x4b, 0x08, 0xca, 0xc8, 0x0d, 0xf9, 0xba, 0x96, 0xbf, 0xab, 0xa9, 0x15, 0xfd, 0x97, 0xc0,
	0x0c, 0x49, 0x86, 0xed, 0xda, 0x9e, 0xb1, 0x6f, 0x1d, 0xf4, 0xdc, 0x37, 0xbe, 0x95, 0x7b, 0x71,
	0x7d, 0x44, 0x23, 0x72, 0x44, 0x32, 0x2c, 0x62, 0x2e, 0x99, 0xf0, 0xb5, 0x1e, 0xba, 0xa0, 0xae,
	0x9b, 0xd9, 0xa6, 0x2e, 0xb4, 0xdf, 0x52, 0x78, 0xa2, 0x78, 0xbf, 0x90, 0xc1, 0x33, 0xb0, 0x25,
	0x45, 0x4e, 0x31, 0x92, 0x24, 0x0c, 0xf4, 0x49, 0xd9, 0x75, 0x5d, 0xf9, 0xd1, 0x5b, 0x97, 0xbc,
	0x90, 0xa3, 0x4a, 0xad, 0x5d, 0xf0, 0xdf, 0x91, 0x2b, 0xbf, 0x21, 0x03, 0x9b, 0x11, 0x0e, 0xe4,
	0x44, 0x90, 0x6c, 0xc2, 0x92, 0xd0, 0x6e, 0xe8, 0x66, 0xbb, 0x4b, 0xcd, 0x94, 0xef, 0xee, 0x24,
	0xc1, 0xee, 0xa8, 0xf2, 0xbd, 0xff, 0xe9, 0x7c, 0xe6, 0x58, 0xdf, 0x0c, 0x46, 0x55, 0xd5, 0xbf,
	0x33, 0xa7, 0xb3, 0x28, 0x08, 0xc7, 0x4f, 0x7b, 0x02, 0xd1, 0x90, 0xe6, 0x49, 0x82, 0xc6, 0x09,
	0xe9, 0xf9, 0x56, 0x84, 0x17, 0x52, 0xd8, 0x07, 0x75, 0x35, 0x76, 0x66, 0x6f, 0xe8, 0x95, 0x1e,
	0xbb, 0xb7, 0x13, 0x56, 0xe4, 0xc8, 0xad, 0xe2, 0xe4, 0x9e, 0x7e, 0x3f, 0x18, 0xa8, 0x69, 0x33,
	0xbf, 0x28, 0x85, 0x3f, 0x19, 0x60, 0x5b, 0x4e, 0x69, 0x90, 0x71, 0x44, 0x83, 0x95, 0xf1, 0x5b,
	0xf7, 0x19, 0xff, 0xf3, 0xf9, 0xcc, 0x81, 0xa3, 0x29, 0x3d, 0xe7, 0x88, 0xde, 0x7f, 0x17, 0x50,
	0x96, 0x15, 0x4b, 0x9b, 0xf9, 0x02, 0xec, 0xe4, 0x59, 0x4c, 0xa3, 0x45, 0x4a, 0xf4, 0x89, 0x04,
	0x97, 0xe4, 0xca, 0xb6, 0xf6, 0x8c, 0xfd, 0xa6, 0xff, 0x50, 0xd3, 0x65, 0x52, 0xb4, 0xe3, 0xdf,
	0x92, 0xab, 0xa7, 0xe6, 0x3f, 0xbf, 0x38, 0xc6, 0xb1, 0xd9, 0x6c, 0xb6, 0x5b, 0xc7, 0x66, 0x13,
	0xb4, 0xad, 0xde, 0x6f, 0x0d, 0xd0, 0xd2, 0x01, 0x19, 0xd2, 0x0b, 0x06, 0x87, 0x85, 0x47, 0x44,
	0xa7, 0xd3, 0x3a, 0xf8, 0xc4, 0xbd, 0xe3, 0x16, 0xba, 0xcb, 0x21, 0xef, 0x37, 0xaf, 0x67, 0xce,
	0xda, 0xeb, 0x99, 0x63, 0x14, 0x56, 0x11, 0xb8, 0x0b, 0x40, 0x82, 0x32, 0xb9, 0x12, 0xdf, 0x96,
	0x42, 0x8a, 0xd8, 0x3a, 0xc0, 0xa2, 0x79, 0x1a, 0x70, 0x42, 0xc3, 0x98, 0x46, 0x3a, 0xbd, 0xa6,
	0x0f, 0x68, 0x9e, 0x3e, 0x2b, 0x90, 0x4a, 0x10, 0x0a, 0xc6, 0x39, 0x09, 0x75, 0xd6, 0x0a, 0xc1,
	0x51, 0x81, 0xc0, 0x1e, 0x78, 0xa0, 0xaf, 0x55, 0xc2, 0xa2, 0x20, 0x8b, 0x5f, 0x11, 0x9d, 0xa0,
	0x9a, 0x6f, 0x29, 0xf0, 0x84, 0x45, 0xe7, 0xf1, 0x2b, 0x02, 0xbf, 0x02, 0x1d, 0xc4, 0xb9, 0x60,
	0xd3, 0x38, 0x55, 0xf6, 0x70, 0xc1, 0x38, 0xcb, 0x50, 0x12, 0xfc, 0x98, 0x33, 0x89, 0x74, 0x10,
	0x6a, 0xbe, 0xbd, 0xa4, 0x78, 0x56, 0x0a, 0xbe, 0x53, 0x3c, 0xfc, 0x18, 0x6c, 0x09, 0x65, 0x4d,
	0x90, 0xa2, 0x69, 0x30, 0xbe, 0x92, 0x24, 0xb3, 0x9b, 0xba, 0xe4, 0x81, 0x86, 0x4f, 0xd1, 0xb4,
	0xaf, 0x40, 0xf8, 0x19, 0xd8, 0x5e, 0x99, 0x24, 0x90, 0x22, 0xcf, 0x24, 0x09, 0x6d, 0xa0, 0x8f,
	0x02, 0x2e, 0x4d, 0x34, 0x2a, 0x18, 0x98, 0x80, 0x1d, 0x4a, 0x5e, 0x92, 0x4c, 0x06, 0x38, 0x61,
	0x19, 0x09, 0x83, 0xc5, 0xb7, 0x45, 0x9f, 0x9f, 0x75, 0xe0, 0xde, 0x6d, 0x7d, 0x75, 0x62, 0xee,
	0x60, 0xf4, 0x35, 0x95, 0xe2, 0xaa, 0x6f, 0x2a, 0xff, 0xfd, 0xed, 0xa2, 0xe9, 0x40, 0xf7, 0x5c,
	0xe4, 0x0e, 0xfe, 0x00, 0x76, 0x10, 0x96, 0xf1, 0x0b, 0x72, 0x7b, 0xb5, 0xcd, 0xfb, 0xe4, 0xb6,
	0x6c, 0x5e, 0xf4, 0xb8, 0xd1, 0xbc, 0xf3, 0x87, 0x01, 0x36, 0xca, 0x29, 0xe0, 0x73, 0xb0, 0x41,
	0x59, 0x48, 0x82, 0x38, 0xd4, 0x09, 0xaa, 0xf7, 0x0f, 0xe7, 0x33, 0xa7, 0x71, 0xc6, 0x42, 0x32,
	0x3c, 0xfa, 0x6f, 0xe6, 0x3c, 0x89, 0x62, 0x39, 0xc9, 0xc7, 0x2e, 0x66, 0xa9, 0xb7, 0x14, 0xf8,
	0x37, 0xef, 0x1e, 0xbf, 0x8c, 0xbc, 0xea, 0x23, 0x52, 0x94, 0xf9, 0x0d, 0xd5, 0x71, 0x18, 0xc2,
	0x33, 0xd0, 0xbe, 0x35, 0xfd, 0xfa, 0xfd, 0xa7, 0xdf, 0xc2, 0x37, 0x4c, 0xf9, 0x00, 0x98, 0x69,
	0x82, 0x62, 0x1d, 0xbd, 0x5a, 0xbf, 0x39, 0x9f, 0x39, 0xe6, 0xe9, 0xc9, 0xe1, 0xd0, 0xd7, 0x68,
	0x71, 0x53, 0x16, 0xf7, 0xc5, 0x6c, 0xd7, 0x8f, 0xcd, 0x66, 0xab, 0x0d, 0x7a, 0x3e, 0x68, 0x9f,
	0x20, 0x89, 0x27, 0xa7, 0x88, 0xa2, 0x88, 0x08, 0x7d, 0x6b, 0x76, 0x01, 0x10, 0x04, 0x85, 0x01,
	0x66, 0x39, 0x95, 0x7a, 0xe3, 0x35, 0xbf, 0xa5, 0x90, 0x81, 0x02, 0x54, 0x92, 0x5f, 0x8a, 0x58,
	0x92, 0x92, 0x5f, 0xd7, 0x3c, 0xd0, 0x90, 0x16, 0xf4, 0x3f, 0xbc, 0xfe, 0xab, 0xbb, 0x76, 0x3d,
	0xef, 0x1a, 0xaf, 0xe7, 0x5d, 0xe3, 0xf7, 0x79, 0xd7, 0xf8, 0x73, 0xde, 0x35, 0x7e, 0xfe, 0xbb,
	0xbb, 0xf6, 0xbc, 0xb5, 0x38, 0xf2, 0x71, 0x43, 0xff, 0xbb, 0x3c, 0xf9, 0x3f, 0x00, 0x00, 0xff,
	0xff, 0x9a, 0x29, 0xa3, 0xf1, 0x38, 0x07, 0x00, 0x00,
}
