/*
 * Copyright 2018 Comcast Cable Communications Management, LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package options

import "testing"

func TestNewOptions(t *testing.T) {
	o := NewOptions()
	if o == nil {
		t.Error("expected non-nil options")
	}
}

func TestCloneAndEqual(t *testing.T) {

	o := NewOptions()
	o2 := o.Clone()

	if !o.Equal(o2) {
		t.Error("expected true")
	}

	if o.Equal(nil) {
		t.Error("expected false")
	}

}
