/* gpx-graph.c generated by valac 0.20.1, the Vala compiler
 * generated from gpx-graph.vala, do not modify */

/* Gpx Viewer
 * Copyright (C) 2009-2011 Qball Cow <qball@sarine.nl>
 * Project homepage: http://blog.sarine.nl/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include "gpx.h"
#include <pango/pango.h>
#include <cairo.h>
#include <time.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <pango/pangocairo.h>
#include <glib/gi18n-lib.h>
#include <gpx-viewer.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _gpx_point_unref0(var) ((var == NULL) ? NULL : (var = (gpx_point_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _GpxGraphPrivate {
	gboolean _do_miles;
	GpxGraphGraphMode _mode;
	gint _smooth_factor;
	gboolean _show_points;
	PangoFontDescription* fd;
	cairo_surface_t* surf;
	gint LEFT_OFFSET;
	gint BOTTOM_OFFSET;
	time_t highlight;
	GpxPoint* draw_current;
	GpxPoint* start;
	GpxPoint* stop;
};


static gpointer gpx_graph_parent_class = NULL;
static gchar** gpx_graph_GraphModeName;
static gint gpx_graph_GraphModeName_length1;
static gchar** gpx_graph_GraphModeName = NULL;
static gint gpx_graph_GraphModeName_length1 = 0;
static gint _gpx_graph_GraphModeName_size_ = 0;
static gchar** gpx_graph_GraphModeMiles;
static gint gpx_graph_GraphModeMiles_length1;
static gchar** gpx_graph_GraphModeMiles = NULL;
static gint gpx_graph_GraphModeMiles_length1 = 0;
static gint _gpx_graph_GraphModeMiles_size_ = 0;

#define LOG_DOMAIN "GPX_GRAPH"
#define unique_graph VERSION
#define GPX_GRAPH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GPX_TYPE_GRAPH, GpxGraphPrivate))
enum  {
	GPX_GRAPH_DUMMY_PROPERTY,
	GPX_GRAPH_SMOOTH_FACTOR,
	GPX_GRAPH_SHOW_POINTS,
	GPX_GRAPH_MODE
};
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void gpx_graph_size_allocate_cb (GpxGraph* self, GtkAllocation* alloc);
static void _gpx_graph_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean gpx_graph_button_press_event_cb (GpxGraph* self, GdkEventButton* event);
static gboolean _gpx_graph_button_press_event_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean gpx_graph_motion_notify_event_cb (GpxGraph* self, GdkEventMotion* event);
static gboolean _gpx_graph_motion_notify_event_cb_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static gboolean gpx_graph_button_release_event_cb (GpxGraph* self, GdkEventButton* event);
static gboolean _gpx_graph_button_release_event_cb_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean gpx_graph_a_expose_event (GpxGraph* self, cairo_t* ctx);
static gboolean _gpx_graph_a_expose_event_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static GpxPoint* gpx_graph_get_point_from_position (GpxGraph* self, gdouble x, gdouble y);
static void gpx_graph_update_surface (GpxGraph* self, GtkWidget* win);
static void gpx_graph_draw_grid (GpxGraph* self, cairo_t* ctx, PangoLayout* layout, gdouble graph_width, gdouble graph_height, gdouble min_value, gdouble max_value, gdouble elapsed_time);
static gdouble gpx_graph_calculate_graph_point_value (GpxGraph* self, GList* ii);
static gdouble gpx_graph_calculate_graph_point_smooth_value (GpxGraph* self, GList* iter);
static void g_cclosure_user_marshal_VOID__GPX_POINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_GPX_POINT_GPX_POINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void gpx_graph_finalize (GObject* obj);
static void _vala_gpx_graph_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gpx_graph_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType gpx_graph_graph_mode_get_type (void) {
	static volatile gsize gpx_graph_graph_mode_type_id__volatile = 0;
	if (g_once_init_enter (&gpx_graph_graph_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{GPX_GRAPH_GRAPH_MODE_SPEED, "GPX_GRAPH_GRAPH_MODE_SPEED", "speed"}, {GPX_GRAPH_GRAPH_MODE_ELEVATION, "GPX_GRAPH_GRAPH_MODE_ELEVATION", "elevation"}, {GPX_GRAPH_GRAPH_MODE_DISTANCE, "GPX_GRAPH_GRAPH_MODE_DISTANCE", "distance"}, {GPX_GRAPH_GRAPH_MODE_ACCELERATION_H, "GPX_GRAPH_GRAPH_MODE_ACCELERATION_H", "acceleration-h"}, {GPX_GRAPH_GRAPH_MODE_SPEED_V, "GPX_GRAPH_GRAPH_MODE_SPEED_V", "speed-v"}, {GPX_GRAPH_GRAPH_MODE_HEARTRATE, "GPX_GRAPH_GRAPH_MODE_HEARTRATE", "heartrate"}, {GPX_GRAPH_GRAPH_MODE_NUM_GRAPH_MODES, "GPX_GRAPH_GRAPH_MODE_NUM_GRAPH_MODES", "num-graph-modes"}, {0, NULL, NULL}};
		GType gpx_graph_graph_mode_type_id;
		gpx_graph_graph_mode_type_id = g_enum_register_static ("GpxGraphGraphMode", values);
		g_once_init_leave (&gpx_graph_graph_mode_type_id__volatile, gpx_graph_graph_mode_type_id);
	}
	return gpx_graph_graph_mode_type_id__volatile;
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


void gpx_graph_hide_info (GpxGraph* self) {
	g_return_if_fail (self != NULL);
	self->priv->draw_current = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void gpx_graph_show_info (GpxGraph* self, GpxPoint* cur_point) {
	GpxPoint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = cur_point;
	self->priv->draw_current = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


/** 
 * @param p A Gpx.Point we want to highlight.
 * pass null to unhighlight.
 */
void gpx_graph_highlight_point (GpxGraph* self, GpxPoint* p) {
	time_t _tmp0_ = 0;
	GpxPoint* _tmp1_;
	time_t _tmp4_;
	time_t pt;
	g_return_if_fail (self != NULL);
	_tmp1_ = p;
	if (_tmp1_ == NULL) {
		_tmp0_ = (time_t) 0;
	} else {
		GpxPoint* _tmp2_;
		time_t _tmp3_ = 0;
		_tmp2_ = p;
		_tmp3_ = gpx_point_get_time (_tmp2_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	pt = _tmp4_;
	gpx_graph_set_highlight (self, pt);
}


void gpx_graph_set_highlight (GpxGraph* self, time_t highlight) {
	time_t _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = highlight;
	self->priv->highlight = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void _gpx_graph_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	gpx_graph_size_allocate_cb (self, allocation);
}


static gboolean _gpx_graph_button_press_event_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = gpx_graph_button_press_event_cb (self, event);
	return result;
}


static gboolean _gpx_graph_motion_notify_event_cb_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = gpx_graph_motion_notify_event_cb (self, event);
	return result;
}


static gboolean _gpx_graph_button_release_event_cb_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = gpx_graph_button_release_event_cb (self, event);
	return result;
}


static gboolean _gpx_graph_a_expose_event_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = gpx_graph_a_expose_event (self, cr);
	return result;
}


GpxGraph* gpx_graph_construct (GType object_type) {
	GpxGraph * self = NULL;
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
	self = (GpxGraph*) g_object_new (object_type, NULL);
	_tmp0_ = pango_font_description_new ();
	__vala_PangoFontDescription_free0 (self->priv->fd);
	self->priv->fd = _tmp0_;
	_tmp1_ = self->priv->fd;
	pango_font_description_set_family (_tmp1_, "sans mono");
	gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
	gtk_event_box_set_visible_window ((GtkEventBox*) self, TRUE);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _gpx_graph_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _gpx_graph_button_press_event_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _gpx_graph_motion_notify_event_cb_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _gpx_graph_button_release_event_cb_gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _gpx_graph_a_expose_event_gtk_widget_draw, self, 0);
	return self;
}


GpxGraph* gpx_graph_new (void) {
	return gpx_graph_construct (GPX_TYPE_GRAPH);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gpx_graph_set_track (GpxGraph* self, GpxTrack* track) {
	GpxTrack* _tmp0_;
	GpxTrack* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GpxTrack* _tmp3_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	self->priv->highlight = (time_t) 0;
	_tmp0_ = track;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->track);
	self->track = _tmp1_;
	_cairo_surface_destroy0 (self->priv->surf);
	self->priv->surf = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
	_gpx_point_unref0 (self->priv->start);
	self->priv->start = NULL;
	_gpx_point_unref0 (self->priv->stop);
	self->priv->stop = NULL;
	_tmp3_ = self->track;
	if (_tmp3_ != NULL) {
		GpxTrack* _tmp4_;
		GList* _tmp5_;
		_tmp4_ = self->track;
		_tmp5_ = _tmp4_->points;
		_tmp2_ = _tmp5_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		GpxTrack* _tmp7_;
		GpxTrack* _tmp8_;
		GList* _tmp9_;
		GList* _tmp10_ = NULL;
		gconstpointer _tmp11_;
		GpxTrack* _tmp12_;
		GList* _tmp13_;
		GList* _tmp14_ = NULL;
		gconstpointer _tmp15_;
		_tmp7_ = self->track;
		_tmp8_ = self->track;
		_tmp9_ = _tmp8_->points;
		_tmp10_ = g_list_first (_tmp9_);
		_tmp11_ = _tmp10_->data;
		_tmp12_ = self->track;
		_tmp13_ = _tmp12_->points;
		_tmp14_ = g_list_last (_tmp13_);
		_tmp15_ = _tmp14_->data;
		g_signal_emit_by_name (self, "selection-changed", _tmp7_, (GpxPoint*) _tmp11_, (GpxPoint*) _tmp15_);
	} else {
		GpxTrack* _tmp16_;
		_tmp16_ = self->track;
		g_signal_emit_by_name (self, "selection-changed", _tmp16_, NULL, NULL);
	}
}


/**
 * Private functions
 */
static gpointer _gpx_point_ref0 (gpointer self) {
	return self ? gpx_point_ref (self) : NULL;
}


static GpxPoint* gpx_graph_get_point_from_position (GpxGraph* self, gdouble x, gdouble y) {
	GpxPoint* result = NULL;
	GtkAllocation alloc = {0};
	GpxTrack* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gdouble _tmp3_;
	gint _tmp4_;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->track;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp1_);
	alloc = _tmp1_;
	_tmp3_ = x;
	_tmp4_ = self->priv->LEFT_OFFSET;
	if (_tmp3_ > ((gdouble) _tmp4_)) {
		gdouble _tmp5_;
		GtkAllocation _tmp6_;
		gint _tmp7_;
		_tmp5_ = x;
		_tmp6_ = alloc;
		_tmp7_ = _tmp6_.width;
		_tmp2_ = _tmp5_ < ((gdouble) (_tmp7_ - 10));
	} else {
		_tmp2_ = FALSE;
	}
	_tmp8_ = _tmp2_;
	if (_tmp8_) {
		GpxTrack* _tmp9_;
		time_t _tmp10_ = 0;
		gdouble elapsed_time;
		gdouble _tmp11_;
		gint _tmp12_;
		GtkAllocation _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gdouble _tmp16_;
		time_t time;
		GpxTrack* _tmp17_;
		GList* _tmp18_;
		GList* _tmp19_ = NULL;
		GList* iter;
		time_t _tmp20_;
		GList* _tmp21_;
		gconstpointer _tmp22_;
		time_t _tmp23_ = 0;
		_tmp9_ = self->track;
		_tmp10_ = gpx_track_get_total_time (_tmp9_);
		elapsed_time = (gdouble) _tmp10_;
		_tmp11_ = x;
		_tmp12_ = self->priv->LEFT_OFFSET;
		_tmp13_ = alloc;
		_tmp14_ = _tmp13_.width;
		_tmp15_ = self->priv->LEFT_OFFSET;
		_tmp16_ = elapsed_time;
		time = (time_t) (((_tmp11_ - _tmp12_) / ((_tmp14_ - 10) - _tmp15_)) * _tmp16_);
		_tmp17_ = self->track;
		_tmp18_ = _tmp17_->points;
		_tmp19_ = g_list_first (_tmp18_);
		iter = _tmp19_;
		_tmp20_ = time;
		_tmp21_ = iter;
		_tmp22_ = _tmp21_->data;
		_tmp23_ = gpx_point_get_time ((GpxPoint*) _tmp22_);
		time = _tmp20_ + _tmp23_;
		while (TRUE) {
			GList* _tmp24_;
			GList* _tmp25_;
			gboolean _tmp26_ = FALSE;
			time_t _tmp27_;
			GList* _tmp28_;
			GList* _tmp29_;
			gconstpointer _tmp30_;
			time_t _tmp31_ = 0;
			gboolean _tmp42_;
			GList* _tmp46_;
			GList* _tmp47_;
			_tmp24_ = iter;
			_tmp25_ = _tmp24_->next;
			if (!(_tmp25_ != NULL)) {
				break;
			}
			_tmp27_ = time;
			_tmp28_ = iter;
			_tmp29_ = _tmp28_->next;
			_tmp30_ = _tmp29_->data;
			_tmp31_ = gpx_point_get_time ((GpxPoint*) _tmp30_);
			if (_tmp27_ < _tmp31_) {
				gboolean _tmp32_ = FALSE;
				time_t _tmp33_;
				GList* _tmp34_;
				gconstpointer _tmp35_;
				time_t _tmp36_ = 0;
				gboolean _tmp41_;
				_tmp33_ = time;
				_tmp34_ = iter;
				_tmp35_ = _tmp34_->data;
				_tmp36_ = gpx_point_get_time ((GpxPoint*) _tmp35_);
				if (_tmp33_ == _tmp36_) {
					_tmp32_ = TRUE;
				} else {
					time_t _tmp37_;
					GList* _tmp38_;
					gconstpointer _tmp39_;
					time_t _tmp40_ = 0;
					_tmp37_ = time;
					_tmp38_ = iter;
					_tmp39_ = _tmp38_->data;
					_tmp40_ = gpx_point_get_time ((GpxPoint*) _tmp39_);
					_tmp32_ = _tmp37_ > _tmp40_;
				}
				_tmp41_ = _tmp32_;
				_tmp26_ = _tmp41_;
			} else {
				_tmp26_ = FALSE;
			}
			_tmp42_ = _tmp26_;
			if (_tmp42_) {
				GList* _tmp43_;
				gconstpointer _tmp44_;
				GpxPoint* _tmp45_;
				_tmp43_ = iter;
				_tmp44_ = _tmp43_->data;
				_tmp45_ = _gpx_point_ref0 ((GpxPoint*) _tmp44_);
				result = _tmp45_;
				return result;
			}
			_tmp46_ = iter;
			_tmp47_ = _tmp46_->next;
			iter = _tmp47_;
		}
	}
	result = NULL;
	return result;
}


static gboolean gpx_graph_button_press_event_cb (GpxGraph* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GpxTrack* _tmp0_;
	GdkEventButton _tmp1_;
	gdouble _tmp2_;
	GdkEventButton _tmp3_;
	gdouble _tmp4_;
	GpxPoint* _tmp5_ = NULL;
	GpxPoint* point;
	GpxPoint* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->track;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.x;
	_tmp3_ = *event;
	_tmp4_ = _tmp3_.y;
	_tmp5_ = gpx_graph_get_point_from_position (self, _tmp2_, _tmp4_);
	point = _tmp5_;
	_tmp6_ = point;
	if (_tmp6_ != NULL) {
		GdkEventButton _tmp7_;
		guint _tmp8_;
		_tmp7_ = *event;
		_tmp8_ = _tmp7_.button;
		if (_tmp8_ == ((guint) 1)) {
			GpxPoint* _tmp9_;
			GpxPoint* _tmp10_;
			_tmp9_ = point;
			_tmp10_ = _gpx_point_ref0 (_tmp9_);
			_gpx_point_unref0 (self->priv->start);
			self->priv->start = _tmp10_;
		} else {
			GpxPoint* _tmp11_;
			_gpx_point_unref0 (self->priv->start);
			self->priv->start = NULL;
			_tmp11_ = point;
			g_signal_emit_by_name (self, "point-clicked", _tmp11_);
		}
	}
	result = TRUE;
	return result;
}


static gboolean gpx_graph_motion_notify_event_cb (GpxGraph* self, GdkEventMotion* event) {
	gboolean result = FALSE;
	GpxTrack* _tmp0_;
	GpxPoint* _tmp1_;
	GdkEventMotion _tmp2_;
	gdouble _tmp3_;
	GdkEventMotion _tmp4_;
	gdouble _tmp5_;
	GpxPoint* _tmp6_ = NULL;
	GpxPoint* point;
	GpxPoint* _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->track;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->start;
	if (_tmp1_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.x;
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.y;
	_tmp6_ = gpx_graph_get_point_from_position (self, _tmp3_, _tmp5_);
	point = _tmp6_;
	_tmp7_ = point;
	if (_tmp7_ != NULL) {
		GpxPoint* _tmp8_;
		GpxPoint* _tmp9_;
		gboolean _tmp10_ = FALSE;
		GpxPoint* _tmp11_;
		gboolean _tmp13_;
		GpxTrack* _tmp28_;
		GpxTrack* _tmp29_;
		GList* _tmp30_;
		GList* _tmp31_ = NULL;
		gconstpointer _tmp32_;
		GpxTrack* _tmp33_;
		GList* _tmp34_;
		GList* _tmp35_ = NULL;
		gconstpointer _tmp36_;
		_tmp8_ = point;
		_tmp9_ = _gpx_point_ref0 (_tmp8_);
		_gpx_point_unref0 (self->priv->stop);
		self->priv->stop = _tmp9_;
		gtk_widget_queue_draw ((GtkWidget*) self);
		_tmp11_ = self->priv->start;
		if (_tmp11_ != NULL) {
			GpxPoint* _tmp12_;
			_tmp12_ = self->priv->stop;
			_tmp10_ = _tmp12_ != NULL;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp13_ = _tmp10_;
		if (_tmp13_) {
			GpxPoint* _tmp14_;
			time_t _tmp15_ = 0;
			GpxPoint* _tmp16_;
			time_t _tmp17_ = 0;
			_tmp14_ = self->priv->start;
			_tmp15_ = gpx_point_get_time (_tmp14_);
			_tmp16_ = self->priv->stop;
			_tmp17_ = gpx_point_get_time (_tmp16_);
			if (_tmp15_ != _tmp17_) {
				GpxPoint* _tmp18_;
				time_t _tmp19_ = 0;
				GpxPoint* _tmp20_;
				time_t _tmp21_ = 0;
				_tmp18_ = self->priv->start;
				_tmp19_ = gpx_point_get_time (_tmp18_);
				_tmp20_ = self->priv->stop;
				_tmp21_ = gpx_point_get_time (_tmp20_);
				if (_tmp19_ < _tmp21_) {
					GpxTrack* _tmp22_;
					GpxPoint* _tmp23_;
					GpxPoint* _tmp24_;
					_tmp22_ = self->track;
					_tmp23_ = self->priv->start;
					_tmp24_ = self->priv->stop;
					g_signal_emit_by_name (self, "selection-changed", _tmp22_, _tmp23_, _tmp24_);
				} else {
					GpxTrack* _tmp25_;
					GpxPoint* _tmp26_;
					GpxPoint* _tmp27_;
					_tmp25_ = self->track;
					_tmp26_ = self->priv->stop;
					_tmp27_ = self->priv->start;
					g_signal_emit_by_name (self, "selection-changed", _tmp25_, _tmp26_, _tmp27_);
				}
				result = TRUE;
				return result;
			}
		}
		_tmp28_ = self->track;
		_tmp29_ = self->track;
		_tmp30_ = _tmp29_->points;
		_tmp31_ = g_list_first (_tmp30_);
		_tmp32_ = _tmp31_->data;
		_tmp33_ = self->track;
		_tmp34_ = _tmp33_->points;
		_tmp35_ = g_list_last (_tmp34_);
		_tmp36_ = _tmp35_->data;
		g_signal_emit_by_name (self, "selection-changed", _tmp28_, (GpxPoint*) _tmp32_, (GpxPoint*) _tmp36_);
	}
	result = TRUE;
	return result;
}


static gboolean gpx_graph_button_release_event_cb (GpxGraph* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GpxTrack* _tmp0_;
	GdkEventButton _tmp1_;
	gdouble _tmp2_;
	GdkEventButton _tmp3_;
	gdouble _tmp4_;
	GpxPoint* _tmp5_ = NULL;
	GpxPoint* point;
	GpxPoint* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->track;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.x;
	_tmp3_ = *event;
	_tmp4_ = _tmp3_.y;
	_tmp5_ = gpx_graph_get_point_from_position (self, _tmp2_, _tmp4_);
	point = _tmp5_;
	_tmp6_ = point;
	if (_tmp6_ != NULL) {
		GdkEventButton _tmp7_;
		guint _tmp8_;
		GdkEventButton _tmp11_;
		guint _tmp12_;
		_tmp7_ = *event;
		_tmp8_ = _tmp7_.button;
		if (_tmp8_ == ((guint) 1)) {
			GpxPoint* _tmp9_;
			GpxPoint* _tmp10_;
			_tmp9_ = point;
			_tmp10_ = _gpx_point_ref0 (_tmp9_);
			_gpx_point_unref0 (self->priv->stop);
			self->priv->stop = _tmp10_;
		} else {
			_gpx_point_unref0 (self->priv->stop);
			self->priv->stop = NULL;
		}
		gtk_widget_queue_draw ((GtkWidget*) self);
		_tmp11_ = *event;
		_tmp12_ = _tmp11_.button;
		if (_tmp12_ == ((guint) 1)) {
			gboolean _tmp13_ = FALSE;
			GpxPoint* _tmp14_;
			gboolean _tmp16_;
			GpxTrack* _tmp31_;
			GpxTrack* _tmp32_;
			GList* _tmp33_;
			GList* _tmp34_ = NULL;
			gconstpointer _tmp35_;
			GpxTrack* _tmp36_;
			GList* _tmp37_;
			GList* _tmp38_ = NULL;
			gconstpointer _tmp39_;
			_tmp14_ = self->priv->start;
			if (_tmp14_ != NULL) {
				GpxPoint* _tmp15_;
				_tmp15_ = self->priv->stop;
				_tmp13_ = _tmp15_ != NULL;
			} else {
				_tmp13_ = FALSE;
			}
			_tmp16_ = _tmp13_;
			if (_tmp16_) {
				GpxPoint* _tmp17_;
				time_t _tmp18_ = 0;
				GpxPoint* _tmp19_;
				time_t _tmp20_ = 0;
				_tmp17_ = self->priv->start;
				_tmp18_ = gpx_point_get_time (_tmp17_);
				_tmp19_ = self->priv->stop;
				_tmp20_ = gpx_point_get_time (_tmp19_);
				if (_tmp18_ != _tmp20_) {
					GpxPoint* _tmp21_;
					time_t _tmp22_ = 0;
					GpxPoint* _tmp23_;
					time_t _tmp24_ = 0;
					_tmp21_ = self->priv->start;
					_tmp22_ = gpx_point_get_time (_tmp21_);
					_tmp23_ = self->priv->stop;
					_tmp24_ = gpx_point_get_time (_tmp23_);
					if (_tmp22_ < _tmp24_) {
						GpxTrack* _tmp25_;
						GpxPoint* _tmp26_;
						GpxPoint* _tmp27_;
						_tmp25_ = self->track;
						_tmp26_ = self->priv->start;
						_tmp27_ = self->priv->stop;
						g_signal_emit_by_name (self, "selection-changed", _tmp25_, _tmp26_, _tmp27_);
					} else {
						GpxTrack* _tmp28_;
						GpxPoint* _tmp29_;
						GpxPoint* _tmp30_;
						_tmp28_ = self->track;
						_tmp29_ = self->priv->stop;
						_tmp30_ = self->priv->start;
						g_signal_emit_by_name (self, "selection-changed", _tmp28_, _tmp29_, _tmp30_);
					}
					result = TRUE;
					return result;
				}
			}
			_tmp31_ = self->track;
			_tmp32_ = self->track;
			_tmp33_ = _tmp32_->points;
			_tmp34_ = g_list_first (_tmp33_);
			_tmp35_ = _tmp34_->data;
			_tmp36_ = self->track;
			_tmp37_ = _tmp36_->points;
			_tmp38_ = g_list_last (_tmp37_);
			_tmp39_ = _tmp38_->data;
			g_signal_emit_by_name (self, "selection-changed", _tmp31_, (GpxPoint*) _tmp35_, (GpxPoint*) _tmp39_);
		}
	}
	result = TRUE;
	return result;
}


static void gpx_graph_size_allocate_cb (GpxGraph* self, GtkAllocation* alloc) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (alloc != NULL);
	_cairo_surface_destroy0 (self->priv->surf);
	self->priv->surf = NULL;
}


static gboolean gpx_graph_a_expose_event (GpxGraph* self, cairo_t* ctx) {
	gboolean result = FALSE;
	cairo_surface_t* _tmp0_;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp1_ = {0};
	cairo_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_ = FALSE;
	GpxPoint* _tmp8_;
	gboolean _tmp10_;
	time_t _tmp45_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->priv->surf;
	if (_tmp0_ == NULL) {
		gpx_graph_update_surface (self, (GtkWidget*) self);
	}
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp1_);
	alloc = _tmp1_;
	_tmp2_ = ctx;
	_tmp3_ = self->priv->surf;
	cairo_set_source_surface (_tmp2_, _tmp3_, (gdouble) 0, (gdouble) 0);
	_tmp4_ = ctx;
	cairo_paint (_tmp4_);
	_tmp5_ = ctx;
	_tmp6_ = self->priv->LEFT_OFFSET;
	cairo_translate (_tmp5_, (gdouble) _tmp6_, (gdouble) 20);
	_tmp8_ = self->priv->start;
	if (_tmp8_ != NULL) {
		GpxPoint* _tmp9_;
		_tmp9_ = self->priv->stop;
		_tmp7_ = _tmp9_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp10_ = _tmp7_;
	if (_tmp10_) {
		GpxPoint* _tmp11_;
		time_t _tmp12_ = 0;
		GpxPoint* _tmp13_;
		time_t _tmp14_ = 0;
		_tmp11_ = self->priv->start;
		_tmp12_ = gpx_point_get_time (_tmp11_);
		_tmp13_ = self->priv->stop;
		_tmp14_ = gpx_point_get_time (_tmp13_);
		if (_tmp12_ != _tmp14_) {
			GpxTrack* _tmp15_;
			GList* _tmp16_;
			GList* _tmp17_ = NULL;
			gconstpointer _tmp18_;
			GpxPoint* _tmp19_;
			GpxPoint* f;
			GpxTrack* _tmp20_;
			time_t _tmp21_ = 0;
			gdouble elapsed_time;
			GtkAllocation _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gdouble graph_width;
			GtkAllocation _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gdouble graph_height;
			cairo_t* _tmp28_;
			cairo_t* _tmp29_;
			GpxPoint* _tmp30_;
			time_t _tmp31_ = 0;
			GpxPoint* _tmp32_;
			time_t _tmp33_ = 0;
			gdouble _tmp34_;
			gdouble _tmp35_;
			GpxPoint* _tmp36_;
			time_t _tmp37_ = 0;
			GpxPoint* _tmp38_;
			time_t _tmp39_ = 0;
			gdouble _tmp40_;
			gdouble _tmp41_;
			gdouble _tmp42_;
			cairo_t* _tmp43_;
			cairo_t* _tmp44_;
			_tmp15_ = self->track;
			_tmp16_ = _tmp15_->points;
			_tmp17_ = g_list_first (_tmp16_);
			_tmp18_ = _tmp17_->data;
			_tmp19_ = _gpx_point_ref0 ((GpxPoint*) _tmp18_);
			f = _tmp19_;
			_tmp20_ = self->track;
			_tmp21_ = gpx_track_get_total_time (_tmp20_);
			elapsed_time = (gdouble) _tmp21_;
			_tmp22_ = alloc;
			_tmp23_ = _tmp22_.width;
			_tmp24_ = self->priv->LEFT_OFFSET;
			graph_width = (gdouble) ((_tmp23_ - _tmp24_) - 10);
			_tmp25_ = alloc;
			_tmp26_ = _tmp25_.height;
			_tmp27_ = self->priv->BOTTOM_OFFSET;
			graph_height = (gdouble) ((_tmp26_ - 20) - _tmp27_);
			_tmp28_ = ctx;
			cairo_set_source_rgba (_tmp28_, 0.3, 0.2, 0.3, 0.8);
			_tmp29_ = ctx;
			_tmp30_ = self->priv->start;
			_tmp31_ = gpx_point_get_time (_tmp30_);
			_tmp32_ = f;
			_tmp33_ = gpx_point_get_time (_tmp32_);
			_tmp34_ = elapsed_time;
			_tmp35_ = graph_width;
			_tmp36_ = self->priv->stop;
			_tmp37_ = gpx_point_get_time (_tmp36_);
			_tmp38_ = self->priv->start;
			_tmp39_ = gpx_point_get_time (_tmp38_);
			_tmp40_ = elapsed_time;
			_tmp41_ = graph_width;
			_tmp42_ = graph_height;
			cairo_rectangle (_tmp29_, ((_tmp31_ - _tmp33_) / _tmp34_) * _tmp35_, (gdouble) 0, ((_tmp37_ - _tmp39_) / _tmp40_) * _tmp41_, _tmp42_);
			_tmp43_ = ctx;
			cairo_stroke_preserve (_tmp43_);
			_tmp44_ = ctx;
			cairo_fill (_tmp44_);
			_gpx_point_unref0 (f);
		}
	}
	_tmp45_ = self->priv->highlight;
	if (_tmp45_ > ((time_t) 0)) {
		GpxTrack* _tmp46_;
		GList* _tmp47_;
		GList* _tmp48_ = NULL;
		gconstpointer _tmp49_;
		GpxPoint* _tmp50_;
		GpxPoint* f;
		GpxTrack* _tmp51_;
		time_t _tmp52_ = 0;
		gdouble elapsed_time;
		GtkAllocation _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gdouble graph_width;
		GtkAllocation _tmp56_;
		gint _tmp57_;
		gint _tmp58_;
		gdouble graph_height;
		time_t _tmp59_;
		GpxPoint* _tmp60_;
		time_t _tmp61_ = 0;
		gdouble _tmp62_;
		gdouble _tmp63_;
		gdouble hl;
		cairo_t* _tmp64_;
		cairo_t* _tmp65_;
		gdouble _tmp66_;
		cairo_t* _tmp67_;
		gdouble _tmp68_;
		gdouble _tmp69_;
		cairo_t* _tmp70_;
		cairo_t* _tmp71_;
		GpxPoint* _tmp72_;
		_tmp46_ = self->track;
		_tmp47_ = _tmp46_->points;
		_tmp48_ = g_list_first (_tmp47_);
		_tmp49_ = _tmp48_->data;
		_tmp50_ = _gpx_point_ref0 ((GpxPoint*) _tmp49_);
		f = _tmp50_;
		_tmp51_ = self->track;
		_tmp52_ = gpx_track_get_total_time (_tmp51_);
		elapsed_time = (gdouble) _tmp52_;
		_tmp53_ = alloc;
		_tmp54_ = _tmp53_.width;
		_tmp55_ = self->priv->LEFT_OFFSET;
		graph_width = (gdouble) ((_tmp54_ - _tmp55_) - 10);
		_tmp56_ = alloc;
		_tmp57_ = _tmp56_.height;
		_tmp58_ = self->priv->BOTTOM_OFFSET;
		graph_height = (gdouble) ((_tmp57_ - 20) - _tmp58_);
		_tmp59_ = self->priv->highlight;
		_tmp60_ = f;
		_tmp61_ = gpx_point_get_time (_tmp60_);
		_tmp62_ = elapsed_time;
		_tmp63_ = graph_width;
		hl = ((_tmp59_ - _tmp61_) / _tmp62_) * _tmp63_;
		_tmp64_ = ctx;
		cairo_set_source_rgba (_tmp64_, 0.8, 0.2, 0.3, 0.8);
		_tmp65_ = ctx;
		_tmp66_ = hl;
		cairo_move_to (_tmp65_, _tmp66_, (gdouble) 0);
		_tmp67_ = ctx;
		_tmp68_ = hl;
		_tmp69_ = graph_height;
		cairo_line_to (_tmp67_, _tmp68_, _tmp69_);
		_tmp70_ = ctx;
		cairo_stroke_preserve (_tmp70_);
		_tmp71_ = ctx;
		cairo_fill (_tmp71_);
		_tmp72_ = self->priv->draw_current;
		if (_tmp72_ != NULL) {
			cairo_t* _tmp73_;
			PangoLayout* _tmp74_ = NULL;
			PangoLayout* layout;
			gint w = 0;
			gint h = 0;
			gchar* _tmp75_;
			gchar* text;
			gdouble x_pos;
			const gchar* _tmp76_ = NULL;
			gchar* _tmp77_;
			gchar* _tmp78_;
			GpxPoint* _tmp79_;
			gdouble _tmp80_;
			gchar* _tmp81_ = NULL;
			gchar* _tmp82_;
			gchar* _tmp83_;
			const gchar* _tmp84_;
			const gchar* _tmp85_ = NULL;
			gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			gchar* _tmp89_;
			GpxPoint* _tmp90_;
			gdouble _tmp91_;
			gchar* _tmp92_ = NULL;
			gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			const gchar* _tmp97_;
			const gchar* _tmp98_ = NULL;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			GpxPoint* _tmp103_;
			gdouble _tmp104_;
			gchar* _tmp105_ = NULL;
			gchar* _tmp106_;
			gchar* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			GpxPoint* _tmp110_;
			GpxHeartRateMonitorPoint _tmp111_;
			gint _tmp112_;
			PangoFontDescription* _tmp130_;
			PangoLayout* _tmp131_;
			PangoFontDescription* _tmp132_;
			PangoLayout* _tmp133_;
			const gchar* _tmp134_;
			PangoLayout* _tmp135_;
			gint _tmp136_ = 0;
			gint _tmp137_ = 0;
			gdouble _tmp138_;
			gint _tmp139_;
			gdouble _tmp140_;
			gint _tmp141_;
			cairo_t* _tmp147_;
			gdouble _tmp148_;
			gint _tmp149_;
			gdouble _tmp150_ = 0.0;
			gint _tmp151_;
			gint _tmp152_;
			cairo_t* _tmp153_;
			cairo_t* _tmp154_;
			cairo_t* _tmp155_;
			cairo_t* _tmp156_;
			cairo_t* _tmp157_;
			gdouble _tmp158_;
			gint _tmp159_;
			gdouble _tmp160_ = 0.0;
			cairo_t* _tmp161_;
			PangoLayout* _tmp162_;
			cairo_t* _tmp163_;
			cairo_t* _tmp164_;
			_tmp73_ = ctx;
			_tmp74_ = pango_cairo_create_layout (_tmp73_);
			layout = _tmp74_;
			_tmp75_ = g_strdup ("");
			text = _tmp75_;
			x_pos = 0.0;
			_tmp76_ = _ ("Speed");
			_tmp77_ = g_strconcat (_tmp76_, ":\t", NULL);
			_tmp78_ = _tmp77_;
			_tmp79_ = self->priv->draw_current;
			_tmp80_ = _tmp79_->speed;
			_tmp81_ = gpx_viewer_misc_convert (_tmp80_, SPEED);
			_tmp82_ = _tmp81_;
			_tmp83_ = g_strconcat (_tmp78_, _tmp82_, NULL);
			_g_free0 (text);
			text = _tmp83_;
			_g_free0 (_tmp82_);
			_g_free0 (_tmp78_);
			_tmp84_ = text;
			_tmp85_ = _ ("Elevation");
			_tmp86_ = g_strconcat ("\n", _tmp85_, NULL);
			_tmp87_ = _tmp86_;
			_tmp88_ = g_strconcat (_tmp87_, ":\t", NULL);
			_tmp89_ = _tmp88_;
			_tmp90_ = self->priv->draw_current;
			_tmp91_ = _tmp90_->elevation;
			_tmp92_ = gpx_viewer_misc_convert (_tmp91_, ELEVATION);
			_tmp93_ = _tmp92_;
			_tmp94_ = g_strconcat (_tmp89_, _tmp93_, NULL);
			_tmp95_ = _tmp94_;
			_tmp96_ = g_strconcat (_tmp84_, _tmp95_, NULL);
			_g_free0 (text);
			text = _tmp96_;
			_g_free0 (_tmp95_);
			_g_free0 (_tmp93_);
			_g_free0 (_tmp89_);
			_g_free0 (_tmp87_);
			_tmp97_ = text;
			_tmp98_ = _ ("Distance");
			_tmp99_ = g_strconcat ("\n", _tmp98_, NULL);
			_tmp100_ = _tmp99_;
			_tmp101_ = g_strconcat (_tmp100_, ":\t", NULL);
			_tmp102_ = _tmp101_;
			_tmp103_ = self->priv->draw_current;
			_tmp104_ = _tmp103_->distance;
			_tmp105_ = gpx_viewer_misc_convert (_tmp104_, DISTANCE);
			_tmp106_ = _tmp105_;
			_tmp107_ = g_strconcat (_tmp102_, _tmp106_, NULL);
			_tmp108_ = _tmp107_;
			_tmp109_ = g_strconcat (_tmp97_, _tmp108_, NULL);
			_g_free0 (text);
			text = _tmp109_;
			_g_free0 (_tmp108_);
			_g_free0 (_tmp106_);
			_g_free0 (_tmp102_);
			_g_free0 (_tmp100_);
			_tmp110_ = f;
			_tmp111_ = _tmp110_->tpe;
			_tmp112_ = _tmp111_.heartrate;
			if (_tmp112_ > 0) {
				const gchar* _tmp113_;
				const gchar* _tmp114_ = NULL;
				gchar* _tmp115_;
				gchar* _tmp116_;
				gchar* _tmp117_;
				gchar* _tmp118_;
				GpxPoint* _tmp119_;
				GpxHeartRateMonitorPoint _tmp120_;
				gint _tmp121_;
				gchar* _tmp122_ = NULL;
				gchar* _tmp123_;
				gchar* _tmp124_;
				gchar* _tmp125_;
				const gchar* _tmp126_ = NULL;
				gchar* _tmp127_;
				gchar* _tmp128_;
				gchar* _tmp129_;
				_tmp113_ = text;
				_tmp114_ = _ ("Heart-rate");
				_tmp115_ = g_strconcat ("\n", _tmp114_, NULL);
				_tmp116_ = _tmp115_;
				_tmp117_ = g_strconcat (_tmp116_, ": ", NULL);
				_tmp118_ = _tmp117_;
				_tmp119_ = self->priv->draw_current;
				_tmp120_ = _tmp119_->tpe;
				_tmp121_ = _tmp120_.heartrate;
				_tmp122_ = g_strdup_printf ("%d", _tmp121_);
				_tmp123_ = _tmp122_;
				_tmp124_ = g_strconcat (_tmp118_, _tmp123_, NULL);
				_tmp125_ = _tmp124_;
				_tmp126_ = _ ("(bpm)");
				_tmp127_ = g_strconcat (_tmp125_, _tmp126_, NULL);
				_tmp128_ = _tmp127_;
				_tmp129_ = g_strconcat (_tmp113_, _tmp128_, NULL);
				_g_free0 (text);
				text = _tmp129_;
				_g_free0 (_tmp128_);
				_g_free0 (_tmp125_);
				_g_free0 (_tmp123_);
				_g_free0 (_tmp118_);
				_g_free0 (_tmp116_);
			}
			_tmp130_ = self->priv->fd;
			pango_font_description_set_absolute_size (_tmp130_, (gdouble) (12 * 1024));
			_tmp131_ = layout;
			_tmp132_ = self->priv->fd;
			pango_layout_set_font_description (_tmp131_, _tmp132_);
			_tmp133_ = layout;
			_tmp134_ = text;
			pango_layout_set_text (_tmp133_, _tmp134_, -1);
			_tmp135_ = layout;
			pango_layout_get_pixel_size (_tmp135_, &_tmp136_, &_tmp137_);
			w = _tmp136_;
			h = _tmp137_;
			_tmp138_ = hl;
			_tmp139_ = w;
			x_pos = _tmp138_ - ((_tmp139_ + 8) / 2.0);
			_tmp140_ = x_pos;
			_tmp141_ = self->priv->LEFT_OFFSET;
			if (_tmp140_ < ((gdouble) (-_tmp141_))) {
				x_pos = 0.0;
			} else {
				gdouble _tmp142_;
				gint _tmp143_;
				gdouble _tmp144_;
				_tmp142_ = hl;
				_tmp143_ = w;
				_tmp144_ = graph_width;
				if ((_tmp142_ + ((_tmp143_ + 8) / 2.0)) >= _tmp144_) {
					gdouble _tmp145_;
					gint _tmp146_;
					_tmp145_ = graph_width;
					_tmp146_ = w;
					x_pos = ((gdouble) _tmp145_) - ((gdouble) (_tmp146_ + 8.0));
				}
			}
			_tmp147_ = ctx;
			_tmp148_ = x_pos;
			_tmp149_ = h;
			_tmp150_ = MAX ((gdouble) ((-_tmp149_) - 2), (gdouble) (-18));
			_tmp151_ = w;
			_tmp152_ = h;
			cairo_rectangle (_tmp147_, _tmp148_, _tmp150_, (gdouble) (_tmp151_ + 8), (gdouble) (_tmp152_ + 4));
			_tmp153_ = ctx;
			cairo_set_source_rgba (_tmp153_, 0.0, 0.0, 0.0, 1.0);
			_tmp154_ = ctx;
			cairo_stroke_preserve (_tmp154_);
			_tmp155_ = ctx;
			cairo_set_source_rgba (_tmp155_, 0.7, 0.7, 0.7, 0.9);
			_tmp156_ = ctx;
			cairo_fill (_tmp156_);
			_tmp157_ = ctx;
			_tmp158_ = x_pos;
			_tmp159_ = h;
			_tmp160_ = MAX ((gdouble) (-_tmp159_), (gdouble) (-16));
			cairo_move_to (_tmp157_, _tmp158_ + 4, _tmp160_);
			_tmp161_ = ctx;
			_tmp162_ = layout;
			pango_cairo_layout_path (_tmp161_, _tmp162_);
			_tmp163_ = ctx;
			cairo_set_source_rgba (_tmp163_, 0.0, 0.0, 0.0, 1.0);
			_tmp164_ = ctx;
			cairo_fill (_tmp164_);
			_g_free0 (text);
			_g_object_unref0 (layout);
		}
		_gpx_point_unref0 (f);
	}
	result = FALSE;
	return result;
}


/**
 * Draw the graph to the required surface.
 */
static void gpx_graph_draw_grid (GpxGraph* self, cairo_t* ctx, PangoLayout* layout, gdouble graph_width, gdouble graph_height, gdouble min_value, gdouble max_value, gdouble elapsed_time) {
	gdouble j;
	gdouble _tmp0_;
	gdouble step_size;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble range;
	cairo_t* _tmp3_;
	PangoFontDescription* _tmp4_;
	PangoLayout* _tmp5_;
	PangoFontDescription* _tmp6_;
	PangoLayout* _tmp7_;
	gint wt = 0;
	gint ht = 0;
	PangoLayout* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gint _tmp13_;
	gdouble _tmp14_ = 0.0;
	cairo_t* _tmp60_;
	cairo_t* _tmp61_;
	cairo_t* _tmp62_;
	cairo_t* _tmp63_;
	gdouble _tmp64_;
	cairo_t* _tmp65_;
	cairo_t* _tmp66_;
	gdouble _tmp67_;
	gdouble _tmp68_;
	gdouble _tmp69_;
	gdouble _tmp70_;
	cairo_t* _tmp71_;
	gdouble _tmp72_;
	gdouble _tmp73_;
	gdouble _tmp74_;
	gdouble _tmp75_;
	gdouble _tmp76_;
	cairo_t* _tmp77_;
	PangoFontDescription* _tmp78_;
	PangoLayout* _tmp79_;
	PangoFontDescription* _tmp80_;
	gdouble _tmp81_;
	gdouble _tmp82_;
	guint interval;
	gint current;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (layout != NULL);
	j = 0.0;
	_tmp0_ = graph_height;
	step_size = _tmp0_ / 8.0;
	_tmp1_ = max_value;
	_tmp2_ = min_value;
	range = _tmp1_ - _tmp2_;
	g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:391: Draw grid lines");
	_tmp3_ = ctx;
	cairo_set_source_rgba (_tmp3_, 0.0, 0.0, 0.0, 1.0);
	_tmp4_ = self->priv->fd;
	pango_font_description_set_absolute_size (_tmp4_, (gdouble) (12 * 1024));
	_tmp5_ = layout;
	_tmp6_ = self->priv->fd;
	pango_layout_set_font_description (_tmp5_, _tmp6_);
	_tmp7_ = layout;
	pango_layout_set_text (_tmp7_, "0.0", -1);
	_tmp8_ = layout;
	pango_layout_get_pixel_size (_tmp8_, &_tmp9_, &_tmp10_);
	wt = _tmp9_;
	ht = _tmp10_;
	_tmp11_ = graph_height;
	_tmp12_ = graph_height;
	_tmp13_ = ht;
	_tmp14_ = ceil ((_tmp12_ / (_tmp13_ + 10)) / 5);
	step_size = _tmp11_ / (_tmp14_ * 5);
	{
		gboolean _tmp15_;
		j = (gdouble) 0;
		_tmp15_ = TRUE;
		while (TRUE) {
			gboolean _tmp16_;
			gdouble _tmp19_;
			gdouble _tmp20_;
			gdouble _tmp21_;
			gdouble _tmp22_;
			gdouble _tmp23_;
			gdouble _tmp24_;
			gdouble _tmp25_;
			gdouble speed;
			gdouble _tmp26_;
			gchar* _tmp27_ = NULL;
			gchar* text;
			gint w = 0;
			gint h = 0;
			cairo_t* _tmp28_;
			PangoLayout* _tmp29_;
			const gchar* _tmp30_;
			PangoLayout* _tmp31_;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			cairo_t* _tmp34_;
			gint _tmp35_;
			gdouble _tmp36_;
			gint _tmp37_;
			cairo_t* _tmp38_;
			PangoLayout* _tmp39_;
			cairo_t* _tmp40_;
			const gchar* _tmp41_;
			cairo_t* _tmp42_;
			gdouble _tmp43_;
			cairo_t* _tmp44_;
			gdouble _tmp45_;
			cairo_t* _tmp46_;
			gboolean _tmp47_ = FALSE;
			gdouble _tmp48_;
			gboolean _tmp51_;
			cairo_t* _tmp52_;
			cairo_t* _tmp53_;
			cairo_t* _tmp54_;
			gdouble _tmp55_;
			cairo_t* _tmp56_;
			gdouble _tmp57_;
			gdouble _tmp58_;
			cairo_t* _tmp59_;
			_tmp16_ = _tmp15_;
			if (!_tmp16_) {
				gdouble _tmp17_;
				gdouble _tmp18_;
				_tmp17_ = j;
				_tmp18_ = step_size;
				j = _tmp17_ + _tmp18_;
			}
			_tmp15_ = FALSE;
			_tmp19_ = j;
			_tmp20_ = graph_height;
			if (!(_tmp19_ <= _tmp20_)) {
				break;
			}
			_tmp21_ = min_value;
			_tmp22_ = range;
			_tmp23_ = graph_height;
			_tmp24_ = j;
			_tmp25_ = graph_height;
			speed = _tmp21_ + (_tmp22_ * ((_tmp23_ - _tmp24_) / _tmp25_));
			_tmp26_ = speed;
			_tmp27_ = g_strdup_printf ("%.1f", _tmp26_);
			text = _tmp27_;
			_tmp28_ = ctx;
			cairo_set_source_rgba (_tmp28_, 0.0, 0.0, 0.0, 1.0);
			_tmp29_ = layout;
			_tmp30_ = text;
			pango_layout_set_text (_tmp29_, _tmp30_, -1);
			_tmp31_ = layout;
			pango_layout_get_pixel_size (_tmp31_, &_tmp32_, &_tmp33_);
			w = _tmp32_;
			h = _tmp33_;
			_tmp34_ = ctx;
			_tmp35_ = w;
			_tmp36_ = j;
			_tmp37_ = h;
			cairo_move_to (_tmp34_, (gdouble) ((-_tmp35_) - 5), _tmp36_ - (_tmp37_ / 2.0));
			_tmp38_ = ctx;
			_tmp39_ = layout;
			pango_cairo_layout_path (_tmp38_, _tmp39_);
			_tmp40_ = ctx;
			cairo_fill (_tmp40_);
			_tmp41_ = text;
			g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:413: Set speed tick: %s", _tmp41_);
			_tmp42_ = ctx;
			_tmp43_ = j;
			cairo_move_to (_tmp42_, (gdouble) (-4), _tmp43_);
			_tmp44_ = ctx;
			_tmp45_ = j;
			cairo_line_to (_tmp44_, (gdouble) 0, _tmp45_);
			_tmp46_ = ctx;
			cairo_stroke (_tmp46_);
			_tmp48_ = j;
			if (_tmp48_ <= 0.00001) {
				_tmp47_ = TRUE;
			} else {
				gdouble _tmp49_;
				gdouble _tmp50_;
				_tmp49_ = j;
				_tmp50_ = graph_height;
				_tmp47_ = _tmp49_ >= (_tmp50_ - 0.00001);
			}
			_tmp51_ = _tmp47_;
			if (_tmp51_) {
				_g_free0 (text);
				continue;
			}
			_tmp52_ = ctx;
			cairo_set_source_rgba (_tmp52_, 0.4, 0.4, 0.4, 0.6);
			_tmp53_ = ctx;
			cairo_set_line_width (_tmp53_, (gdouble) 1);
			_tmp54_ = ctx;
			_tmp55_ = j;
			cairo_move_to (_tmp54_, 0.0, _tmp55_);
			_tmp56_ = ctx;
			_tmp57_ = graph_width;
			_tmp58_ = j;
			cairo_line_to (_tmp56_, _tmp57_, _tmp58_);
			_tmp59_ = ctx;
			cairo_stroke (_tmp59_);
			_g_free0 (text);
		}
	}
	_tmp60_ = ctx;
	cairo_set_line_width (_tmp60_, 2.5);
	_tmp61_ = ctx;
	cairo_set_source_rgba (_tmp61_, 0.0, 0.0, 0.0, (gdouble) 1);
	_tmp62_ = ctx;
	cairo_move_to (_tmp62_, 0.0, 0.0);
	_tmp63_ = ctx;
	_tmp64_ = graph_height;
	cairo_line_to (_tmp63_, 0.0, _tmp64_);
	_tmp65_ = ctx;
	cairo_stroke (_tmp65_);
	_tmp66_ = ctx;
	_tmp67_ = graph_height;
	_tmp68_ = graph_height;
	_tmp69_ = range;
	_tmp70_ = min_value;
	cairo_line_to (_tmp66_, 0.0, _tmp67_ + ((_tmp68_ / _tmp69_) * _tmp70_));
	_tmp71_ = ctx;
	_tmp72_ = graph_width;
	_tmp73_ = graph_height;
	_tmp74_ = graph_height;
	_tmp75_ = range;
	_tmp76_ = min_value;
	cairo_line_to (_tmp71_, _tmp72_, _tmp73_ + ((_tmp74_ / _tmp75_) * _tmp76_));
	_tmp77_ = ctx;
	cairo_stroke (_tmp77_);
	_tmp78_ = self->priv->fd;
	pango_font_description_set_absolute_size (_tmp78_, (gdouble) (12 * 1024));
	_tmp79_ = layout;
	_tmp80_ = self->priv->fd;
	pango_layout_set_font_description (_tmp79_, _tmp80_);
	_tmp81_ = elapsed_time;
	_tmp82_ = graph_width;
	interval = ((guint) _tmp81_) / ((guint) (_tmp82_ / (5 * 12.0)));
	current = 0;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp83_;
			_tmp83_ = TRUE;
			while (TRUE) {
				gboolean _tmp84_;
				gboolean _tmp87_ = FALSE;
				guint _tmp88_;
				gdouble _tmp89_;
				gboolean _tmp91_;
				gdouble _tmp92_;
				guint _tmp93_;
				gdouble _tmp94_;
				gint _tmp147_;
				_tmp84_ = _tmp83_;
				if (!_tmp84_) {
					guint _tmp85_;
					guint _tmp86_;
					_tmp85_ = i;
					_tmp86_ = interval;
					i = _tmp85_ + _tmp86_;
				}
				_tmp83_ = FALSE;
				_tmp88_ = i;
				_tmp89_ = elapsed_time;
				if (((gdouble) _tmp88_) < _tmp89_) {
					guint _tmp90_;
					_tmp90_ = interval;
					_tmp87_ = _tmp90_ > ((guint) 0);
				} else {
					_tmp87_ = FALSE;
				}
				_tmp91_ = _tmp87_;
				if (!_tmp91_) {
					break;
				}
				_tmp92_ = graph_width;
				_tmp93_ = i;
				_tmp94_ = elapsed_time;
				if ((_tmp92_ * (1 - (_tmp93_ / _tmp94_))) > (2.5 * 12)) {
					gint w = 0;
					gint h = 0;
					guint _tmp95_;
					guint _tmp96_;
					gchar* _tmp97_ = NULL;
					gchar* text;
					PangoLayout* _tmp98_;
					const gchar* _tmp99_;
					PangoLayout* _tmp100_;
					gint _tmp101_ = 0;
					gint _tmp102_ = 0;
					cairo_t* _tmp103_;
					gdouble _tmp104_;
					guint _tmp105_;
					gdouble _tmp106_;
					gint _tmp107_;
					gdouble _tmp108_;
					cairo_t* _tmp109_;
					PangoLayout* _tmp110_;
					cairo_t* _tmp111_;
					cairo_t* _tmp112_;
					cairo_t* _tmp113_;
					const gchar* _tmp114_;
					cairo_t* _tmp115_;
					cairo_t* _tmp116_;
					cairo_t* _tmp117_;
					gdouble _tmp118_;
					guint _tmp119_;
					gdouble _tmp120_;
					gdouble _tmp121_;
					cairo_t* _tmp122_;
					gdouble _tmp123_;
					guint _tmp124_;
					gdouble _tmp125_;
					gdouble _tmp126_;
					cairo_t* _tmp127_;
					cairo_t* _tmp128_;
					cairo_t* _tmp129_;
					cairo_t* _tmp130_;
					gdouble _tmp131_;
					guint _tmp132_;
					gdouble _tmp133_;
					gdouble _tmp134_;
					gdouble _tmp135_;
					gdouble _tmp136_;
					gdouble _tmp137_;
					cairo_t* _tmp138_;
					gdouble _tmp139_;
					guint _tmp140_;
					gdouble _tmp141_;
					gdouble _tmp142_;
					gdouble _tmp143_;
					gdouble _tmp144_;
					gdouble _tmp145_;
					cairo_t* _tmp146_;
					_tmp95_ = i;
					_tmp96_ = i;
					_tmp97_ = g_strdup_printf ("%02i:%02i", ((gint) _tmp95_) / 3600, (((gint) _tmp96_) % 3600) / 60);
					text = _tmp97_;
					_tmp98_ = layout;
					_tmp99_ = text;
					pango_layout_set_text (_tmp98_, _tmp99_, -1);
					_tmp100_ = layout;
					pango_layout_get_pixel_size (_tmp100_, &_tmp101_, &_tmp102_);
					w = _tmp101_;
					h = _tmp102_;
					_tmp103_ = ctx;
					_tmp104_ = graph_width;
					_tmp105_ = i;
					_tmp106_ = elapsed_time;
					_tmp107_ = w;
					_tmp108_ = graph_height;
					cairo_move_to (_tmp103_, (_tmp104_ * ((gdouble) (_tmp105_ / _tmp106_))) - (_tmp107_ / 2.0), _tmp108_ + 10);
					_tmp109_ = ctx;
					_tmp110_ = layout;
					pango_cairo_layout_path (_tmp109_, _tmp110_);
					_tmp111_ = ctx;
					cairo_set_line_width (_tmp111_, 1.0);
					_tmp112_ = ctx;
					cairo_set_source_rgba (_tmp112_, 0.0, 0.0, 0.0, 1.0);
					_tmp113_ = ctx;
					cairo_fill (_tmp113_);
					_tmp114_ = text;
					g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:460: Set time tick: %s", _tmp114_);
					_tmp115_ = ctx;
					cairo_set_source_rgba (_tmp115_, 0.4, 0.4, 0.4, 0.6);
					_tmp116_ = ctx;
					cairo_set_line_width (_tmp116_, (gdouble) 1);
					_tmp117_ = ctx;
					_tmp118_ = graph_width;
					_tmp119_ = i;
					_tmp120_ = elapsed_time;
					_tmp121_ = graph_height;
					cairo_move_to (_tmp117_, _tmp118_ * ((gdouble) (_tmp119_ / _tmp120_)), _tmp121_);
					_tmp122_ = ctx;
					_tmp123_ = graph_width;
					_tmp124_ = i;
					_tmp125_ = elapsed_time;
					_tmp126_ = graph_height;
					cairo_line_to (_tmp122_, _tmp123_ * ((gdouble) (_tmp124_ / _tmp125_)), _tmp126_ * 0);
					_tmp127_ = ctx;
					cairo_stroke (_tmp127_);
					_tmp128_ = ctx;
					cairo_set_line_width (_tmp128_, 1.5);
					_tmp129_ = ctx;
					cairo_set_source_rgba (_tmp129_, 0.0, 0.0, 0.0, 1.0);
					_tmp130_ = ctx;
					_tmp131_ = graph_width;
					_tmp132_ = i;
					_tmp133_ = elapsed_time;
					_tmp134_ = graph_height;
					_tmp135_ = graph_height;
					_tmp136_ = range;
					_tmp137_ = min_value;
					cairo_move_to (_tmp130_, _tmp131_ * ((gdouble) (_tmp132_ / _tmp133_)), _tmp134_ + ((_tmp135_ / _tmp136_) * _tmp137_));
					_tmp138_ = ctx;
					_tmp139_ = graph_width;
					_tmp140_ = i;
					_tmp141_ = elapsed_time;
					_tmp142_ = graph_height;
					_tmp143_ = graph_height;
					_tmp144_ = range;
					_tmp145_ = min_value;
					cairo_line_to (_tmp138_, _tmp139_ * ((gdouble) (_tmp140_ / _tmp141_)), (_tmp142_ + ((_tmp143_ / _tmp144_) * _tmp145_)) + 5);
					_tmp146_ = ctx;
					cairo_stroke (_tmp146_);
					_g_free0 (text);
				}
				_tmp147_ = current;
				current = _tmp147_ + 1;
			}
		}
	}
}


static gdouble gpx_graph_calculate_graph_point_value (GpxGraph* self, GList* ii) {
	gdouble result = 0.0;
	gdouble value;
	GpxGraphGraphMode _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	value = (gdouble) 0;
	_tmp0_ = self->priv->_mode;
	if (_tmp0_ == GPX_GRAPH_GRAPH_MODE_SPEED) {
		GList* _tmp1_;
		gconstpointer _tmp2_;
		gdouble _tmp3_;
		_tmp1_ = ii;
		_tmp2_ = _tmp1_->data;
		_tmp3_ = ((GpxPoint*) _tmp2_)->speed;
		value = _tmp3_;
	} else {
		GpxGraphGraphMode _tmp4_;
		_tmp4_ = self->priv->_mode;
		if (_tmp4_ == GPX_GRAPH_GRAPH_MODE_ELEVATION) {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			gdouble _tmp7_;
			_tmp5_ = ii;
			_tmp6_ = _tmp5_->data;
			_tmp7_ = ((GpxPoint*) _tmp6_)->elevation;
			value = _tmp7_;
		} else {
			GpxGraphGraphMode _tmp8_;
			_tmp8_ = self->priv->_mode;
			if (_tmp8_ == GPX_GRAPH_GRAPH_MODE_DISTANCE) {
				GList* _tmp9_;
				gconstpointer _tmp10_;
				GList* _tmp11_;
				GList* _tmp12_ = NULL;
				gconstpointer _tmp13_;
				gdouble _tmp14_ = 0.0;
				_tmp9_ = ii;
				_tmp10_ = _tmp9_->data;
				_tmp11_ = ii;
				_tmp12_ = g_list_first (_tmp11_);
				_tmp13_ = _tmp12_->data;
				_tmp14_ = gpx_track_calculate_distance ((GpxPoint*) _tmp10_, (GpxPoint*) _tmp13_);
				value = _tmp14_;
			} else {
				gboolean _tmp15_ = FALSE;
				GpxGraphGraphMode _tmp16_;
				gboolean _tmp19_;
				_tmp16_ = self->priv->_mode;
				if (_tmp16_ == GPX_GRAPH_GRAPH_MODE_ACCELERATION_H) {
					GList* _tmp17_;
					GList* _tmp18_;
					_tmp17_ = ii;
					_tmp18_ = _tmp17_->prev;
					_tmp15_ = _tmp18_ != NULL;
				} else {
					_tmp15_ = FALSE;
				}
				_tmp19_ = _tmp15_;
				if (_tmp19_) {
					GList* _tmp20_;
					gconstpointer _tmp21_;
					time_t _tmp22_ = 0;
					GList* _tmp23_;
					GList* _tmp24_;
					gconstpointer _tmp25_;
					time_t _tmp26_ = 0;
					GList* _tmp27_;
					gconstpointer _tmp28_;
					gdouble _tmp29_;
					GList* _tmp30_;
					GList* _tmp31_;
					gconstpointer _tmp32_;
					gdouble _tmp33_;
					GList* _tmp34_;
					gconstpointer _tmp35_;
					time_t _tmp36_ = 0;
					GList* _tmp37_;
					GList* _tmp38_;
					gconstpointer _tmp39_;
					time_t _tmp40_ = 0;
					_tmp20_ = ii;
					_tmp21_ = _tmp20_->data;
					_tmp22_ = gpx_point_get_time ((GpxPoint*) _tmp21_);
					_tmp23_ = ii;
					_tmp24_ = _tmp23_->prev;
					_tmp25_ = _tmp24_->data;
					_tmp26_ = gpx_point_get_time ((GpxPoint*) _tmp25_);
					if (_tmp22_ == _tmp26_) {
						result = (gdouble) 0;
						return result;
					}
					_tmp27_ = ii;
					_tmp28_ = _tmp27_->data;
					_tmp29_ = ((GpxPoint*) _tmp28_)->speed;
					_tmp30_ = ii;
					_tmp31_ = _tmp30_->prev;
					_tmp32_ = _tmp31_->data;
					_tmp33_ = ((GpxPoint*) _tmp32_)->speed;
					_tmp34_ = ii;
					_tmp35_ = _tmp34_->data;
					_tmp36_ = gpx_point_get_time ((GpxPoint*) _tmp35_);
					_tmp37_ = ii;
					_tmp38_ = _tmp37_->prev;
					_tmp39_ = _tmp38_->data;
					_tmp40_ = gpx_point_get_time ((GpxPoint*) _tmp39_);
					value = (_tmp29_ - _tmp33_) / (3.6 * (_tmp36_ - _tmp40_));
				} else {
					gboolean _tmp41_ = FALSE;
					GpxGraphGraphMode _tmp42_;
					gboolean _tmp45_;
					_tmp42_ = self->priv->_mode;
					if (_tmp42_ == GPX_GRAPH_GRAPH_MODE_SPEED_V) {
						GList* _tmp43_;
						GList* _tmp44_;
						_tmp43_ = ii;
						_tmp44_ = _tmp43_->prev;
						_tmp41_ = _tmp44_ != NULL;
					} else {
						_tmp41_ = FALSE;
					}
					_tmp45_ = _tmp41_;
					if (_tmp45_) {
						GList* _tmp46_;
						gconstpointer _tmp47_;
						time_t _tmp48_ = 0;
						GList* _tmp49_;
						GList* _tmp50_;
						gconstpointer _tmp51_;
						time_t _tmp52_ = 0;
						GList* _tmp53_;
						gconstpointer _tmp54_;
						gdouble _tmp55_;
						GList* _tmp56_;
						GList* _tmp57_;
						gconstpointer _tmp58_;
						gdouble _tmp59_;
						GList* _tmp60_;
						gconstpointer _tmp61_;
						time_t _tmp62_ = 0;
						GList* _tmp63_;
						GList* _tmp64_;
						gconstpointer _tmp65_;
						time_t _tmp66_ = 0;
						_tmp46_ = ii;
						_tmp47_ = _tmp46_->data;
						_tmp48_ = gpx_point_get_time ((GpxPoint*) _tmp47_);
						_tmp49_ = ii;
						_tmp50_ = _tmp49_->prev;
						_tmp51_ = _tmp50_->data;
						_tmp52_ = gpx_point_get_time ((GpxPoint*) _tmp51_);
						if (_tmp48_ == _tmp52_) {
							result = (gdouble) 0;
							return result;
						}
						_tmp53_ = ii;
						_tmp54_ = _tmp53_->data;
						_tmp55_ = ((GpxPoint*) _tmp54_)->elevation;
						_tmp56_ = ii;
						_tmp57_ = _tmp56_->prev;
						_tmp58_ = _tmp57_->data;
						_tmp59_ = ((GpxPoint*) _tmp58_)->elevation;
						_tmp60_ = ii;
						_tmp61_ = _tmp60_->data;
						_tmp62_ = gpx_point_get_time ((GpxPoint*) _tmp61_);
						_tmp63_ = ii;
						_tmp64_ = _tmp63_->prev;
						_tmp65_ = _tmp64_->data;
						_tmp66_ = gpx_point_get_time ((GpxPoint*) _tmp65_);
						value = (_tmp55_ - _tmp59_) / (3.6 * (_tmp62_ - _tmp66_));
					} else {
						GpxGraphGraphMode _tmp67_;
						_tmp67_ = self->priv->_mode;
						if (_tmp67_ == GPX_GRAPH_GRAPH_MODE_HEARTRATE) {
							GList* _tmp68_;
							gconstpointer _tmp69_;
							GpxHeartRateMonitorPoint _tmp70_;
							gint _tmp71_;
							_tmp68_ = ii;
							_tmp69_ = _tmp68_->data;
							_tmp70_ = ((GpxPoint*) _tmp69_)->tpe;
							_tmp71_ = _tmp70_.heartrate;
							value = (gdouble) _tmp71_;
						}
					}
				}
			}
		}
	}
	result = value;
	return result;
}


static gdouble gpx_graph_calculate_graph_point_smooth_value (GpxGraph* self, GList* iter) {
	gdouble result = 0.0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_smooth_factor;
	if (_tmp0_ == 1) {
		GList* _tmp1_;
		gdouble _tmp2_ = 0.0;
		_tmp1_ = iter;
		_tmp2_ = gpx_graph_calculate_graph_point_value (self, _tmp1_);
		result = _tmp2_;
		return result;
	} else {
		gdouble speed;
		GList* _tmp3_;
		GList* ii;
		gint _tmp4_ = 0;
		gboolean _tmp5_ = FALSE;
		GList* _tmp6_;
		gconstpointer _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp10_;
		gint _tmp12_;
		gint sf;
		gint i = 0;
		gint items;
		GList* _tmp28_;
		GList* _tmp29_;
		gdouble _tmp48_;
		gint _tmp49_;
		speed = (gdouble) 0;
		_tmp3_ = iter;
		ii = _tmp3_;
		_tmp6_ = ii;
		_tmp7_ = _tmp6_->data;
		_tmp8_ = ((GpxPoint*) _tmp7_)->stopped;
		if (_tmp8_) {
			GpxGraphGraphMode _tmp9_;
			_tmp9_ = self->priv->_mode;
			_tmp5_ = _tmp9_ == GPX_GRAPH_GRAPH_MODE_SPEED;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp10_ = _tmp5_;
		if (_tmp10_) {
			_tmp4_ = 1;
		} else {
			gint _tmp11_;
			_tmp11_ = self->priv->_smooth_factor;
			_tmp4_ = _tmp11_;
		}
		_tmp12_ = _tmp4_;
		sf = _tmp12_;
		items = 0;
		{
			gboolean _tmp13_;
			i = 0;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gboolean _tmp16_ = FALSE;
				gint _tmp17_;
				gint _tmp18_;
				gboolean _tmp21_;
				gdouble _tmp22_;
				GList* _tmp23_;
				gdouble _tmp24_ = 0.0;
				gint _tmp25_;
				GList* _tmp26_;
				GList* _tmp27_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp17_ = i;
				_tmp18_ = sf;
				if (_tmp17_ < _tmp18_) {
					GList* _tmp19_;
					GList* _tmp20_;
					_tmp19_ = ii;
					_tmp20_ = _tmp19_->prev;
					_tmp16_ = _tmp20_ != NULL;
				} else {
					_tmp16_ = FALSE;
				}
				_tmp21_ = _tmp16_;
				if (!_tmp21_) {
					break;
				}
				_tmp22_ = speed;
				_tmp23_ = ii;
				_tmp24_ = gpx_graph_calculate_graph_point_value (self, _tmp23_);
				speed = _tmp22_ + _tmp24_;
				_tmp25_ = items;
				items = _tmp25_ + 1;
				_tmp26_ = ii;
				_tmp27_ = _tmp26_->prev;
				ii = _tmp27_;
			}
		}
		_tmp28_ = iter;
		_tmp29_ = _tmp28_->next;
		ii = _tmp29_;
		{
			gboolean _tmp30_;
			i = 1;
			_tmp30_ = TRUE;
			while (TRUE) {
				gboolean _tmp31_;
				gboolean _tmp33_ = FALSE;
				gboolean _tmp34_ = FALSE;
				gint _tmp35_;
				gint _tmp36_;
				gboolean _tmp38_;
				gboolean _tmp41_;
				gdouble _tmp42_;
				GList* _tmp43_;
				gdouble _tmp44_ = 0.0;
				gint _tmp45_;
				GList* _tmp46_;
				GList* _tmp47_;
				_tmp31_ = _tmp30_;
				if (!_tmp31_) {
					gint _tmp32_;
					_tmp32_ = i;
					i = _tmp32_ + 1;
				}
				_tmp30_ = FALSE;
				_tmp35_ = i;
				_tmp36_ = sf;
				if (_tmp35_ < _tmp36_) {
					GList* _tmp37_;
					_tmp37_ = ii;
					_tmp34_ = _tmp37_ != NULL;
				} else {
					_tmp34_ = FALSE;
				}
				_tmp38_ = _tmp34_;
				if (_tmp38_) {
					GList* _tmp39_;
					GList* _tmp40_;
					_tmp39_ = ii;
					_tmp40_ = _tmp39_->next;
					_tmp33_ = _tmp40_ != NULL;
				} else {
					_tmp33_ = FALSE;
				}
				_tmp41_ = _tmp33_;
				if (!_tmp41_) {
					break;
				}
				_tmp42_ = speed;
				_tmp43_ = ii;
				_tmp44_ = gpx_graph_calculate_graph_point_value (self, _tmp43_);
				speed = _tmp42_ + _tmp44_;
				_tmp45_ = items;
				items = _tmp45_ + 1;
				_tmp46_ = ii;
				_tmp47_ = _tmp46_->next;
				ii = _tmp47_;
			}
		}
		_tmp48_ = speed;
		_tmp49_ = items;
		speed = _tmp48_ / _tmp49_;
		result = speed;
		return result;
	}
}


static void gpx_graph_update_surface (GpxGraph* self, GtkWidget* win) {
	GtkWidget* _tmp0_;
	GdkWindow* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	cairo_t* ctx;
	GtkAllocation alloc = {0};
	GtkWidget* _tmp3_;
	GtkAllocation _tmp4_ = {0};
	cairo_t* _tmp5_;
	cairo_surface_t* _tmp6_ = NULL;
	GtkAllocation _tmp7_;
	gint _tmp8_;
	GtkAllocation _tmp9_;
	gint _tmp10_;
	cairo_surface_t* _tmp11_;
	cairo_surface_t* _tmp12_;
	cairo_t* _tmp13_;
	cairo_t* _tmp14_;
	cairo_t* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GpxTrack* _tmp17_;
	gboolean _tmp20_;
	gdouble max_value;
	gdouble min_value;
	gdouble range;
	gboolean _tmp21_ = FALSE;
	GpxGraphGraphMode _tmp22_;
	gboolean _tmp24_;
	gdouble _tmp95_;
	gdouble _tmp96_ = 0.0;
	gdouble _tmp97_;
	gdouble _tmp98_;
	gdouble _tmp99_;
	gdouble _tmp100_;
	GpxTrack* _tmp101_;
	time_t _tmp102_ = 0;
	gdouble elapsed_time;
	cairo_t* _tmp103_;
	gint _tmp104_;
	GpxTrack* _tmp105_;
	GList* _tmp106_;
	gconstpointer _tmp107_;
	GpxPoint* _tmp108_;
	GpxPoint* f;
	GtkAllocation _tmp109_;
	gint _tmp110_;
	gint _tmp111_;
	gdouble graph_width;
	GtkAllocation _tmp112_;
	gint _tmp113_;
	gint _tmp114_;
	gdouble graph_height;
	gdouble _tmp115_;
	cairo_t* _tmp116_;
	PangoLayout* _tmp117_ = NULL;
	PangoLayout* layout;
	cairo_t* _tmp118_;
	PangoLayout* _tmp119_;
	gdouble _tmp120_;
	gdouble _tmp121_;
	gdouble _tmp122_;
	gdouble _tmp123_;
	gdouble _tmp124_;
	cairo_t* _tmp125_;
	cairo_t* _tmp126_;
	GpxTrack* _tmp127_;
	GList* _tmp128_;
	GList* _tmp129_ = NULL;
	GList* iter;
	gboolean _tmp130_ = FALSE;
	gdouble _tmp131_;
	gboolean _tmp133_;
	gboolean _tmp201_ = FALSE;
	gdouble _tmp202_;
	gboolean _tmp204_;
	cairo_t* _tmp213_;
	cairo_t* _tmp214_;
	cairo_t* _tmp215_;
	cairo_t* _tmp216_;
	gboolean _tmp217_;
	gboolean _tmp218_;
	GpxGraphGraphMode _tmp250_;
	gint w = 0;
	gint h = 0;
	cairo_t* _tmp289_;
	PangoFontDescription* _tmp290_;
	PangoLayout* _tmp291_;
	PangoFontDescription* _tmp292_;
	gchar* _tmp293_;
	gchar* mtext;
	gboolean _tmp294_;
	gint _tmp305_;
	PangoLayout* _tmp316_;
	gint _tmp317_ = 0;
	gint _tmp318_ = 0;
	cairo_t* _tmp319_;
	gdouble _tmp320_;
	gint _tmp321_;
	cairo_t* _tmp322_;
	PangoLayout* _tmp323_;
	cairo_t* _tmp324_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	_tmp0_ = win;
	_tmp1_ = gtk_widget_get_window (_tmp0_);
	_tmp2_ = gdk_cairo_create (_tmp1_);
	ctx = _tmp2_;
	g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:534: Updating surface");
	_tmp3_ = win;
	gtk_widget_get_allocation (_tmp3_, &_tmp4_);
	alloc = _tmp4_;
	_tmp5_ = ctx;
	_tmp6_ = cairo_get_target (_tmp5_);
	_tmp7_ = alloc;
	_tmp8_ = _tmp7_.width;
	_tmp9_ = alloc;
	_tmp10_ = _tmp9_.height;
	_tmp11_ = cairo_surface_create_similar (_tmp6_, CAIRO_CONTENT_COLOR_ALPHA, _tmp8_, _tmp10_);
	_cairo_surface_destroy0 (self->priv->surf);
	self->priv->surf = _tmp11_;
	_tmp12_ = self->priv->surf;
	_tmp13_ = cairo_create (_tmp12_);
	_cairo_destroy0 (ctx);
	ctx = _tmp13_;
	_tmp14_ = ctx;
	cairo_set_source_rgba (_tmp14_, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp15_ = ctx;
	cairo_paint (_tmp15_);
	_tmp17_ = self->track;
	if (_tmp17_ == NULL) {
		_tmp16_ = TRUE;
	} else {
		GpxTrack* _tmp18_;
		GList* _tmp19_;
		_tmp18_ = self->track;
		_tmp19_ = _tmp18_->points;
		_tmp16_ = _tmp19_ == NULL;
	}
	_tmp20_ = _tmp16_;
	if (_tmp20_) {
		_cairo_destroy0 (ctx);
		return;
	}
	max_value = (gdouble) 0;
	min_value = (gdouble) 0;
	range = (gdouble) 0;
	_tmp22_ = self->priv->_mode;
	if (_tmp22_ == GPX_GRAPH_GRAPH_MODE_SPEED) {
		_tmp21_ = TRUE;
	} else {
		GpxGraphGraphMode _tmp23_;
		_tmp23_ = self->priv->_mode;
		_tmp21_ = _tmp23_ == GPX_GRAPH_GRAPH_MODE_DISTANCE;
	}
	_tmp24_ = _tmp21_;
	if (_tmp24_) {
		GpxTrack* _tmp25_;
		GList* _tmp26_;
		GList* _tmp27_ = NULL;
		GList* iter;
		_tmp25_ = self->track;
		_tmp26_ = _tmp25_->points;
		_tmp27_ = g_list_first (_tmp26_);
		iter = _tmp27_;
		while (TRUE) {
			GList* _tmp28_;
			GList* _tmp29_;
			GList* _tmp30_;
			GList* _tmp31_;
			GList* ii;
			GList* _tmp32_;
			gdouble _tmp33_ = 0.0;
			gdouble _tmp34_;
			gdouble speed;
			gdouble _tmp35_ = 0.0;
			gdouble _tmp36_;
			gdouble _tmp37_;
			gdouble _tmp40_;
			GList* _tmp41_;
			GList* _tmp42_;
			_tmp28_ = iter;
			_tmp29_ = _tmp28_->next;
			if (!(_tmp29_ != NULL)) {
				break;
			}
			_tmp30_ = iter;
			_tmp31_ = _tmp30_->next;
			ii = _tmp31_;
			_tmp32_ = ii;
			_tmp33_ = gpx_graph_calculate_graph_point_smooth_value (self, _tmp32_);
			_tmp34_ = min_value;
			speed = _tmp33_ - _tmp34_;
			_tmp36_ = speed;
			_tmp37_ = max_value;
			if (_tmp36_ > _tmp37_) {
				gdouble _tmp38_;
				_tmp38_ = speed;
				_tmp35_ = _tmp38_;
			} else {
				gdouble _tmp39_;
				_tmp39_ = max_value;
				_tmp35_ = _tmp39_;
			}
			_tmp40_ = _tmp35_;
			max_value = _tmp40_;
			_tmp41_ = iter;
			_tmp42_ = _tmp41_->next;
			iter = _tmp42_;
		}
	} else {
		GpxGraphGraphMode _tmp43_;
		_tmp43_ = self->priv->_mode;
		if (_tmp43_ == GPX_GRAPH_GRAPH_MODE_ELEVATION) {
			GpxTrack* _tmp44_;
			gdouble _tmp45_;
			GpxTrack* _tmp46_;
			gdouble _tmp47_;
			_tmp44_ = self->track;
			_tmp45_ = _tmp44_->max_elevation;
			max_value = _tmp45_;
			_tmp46_ = self->track;
			_tmp47_ = _tmp46_->min_elevation;
			min_value = _tmp47_;
		} else {
			gboolean _tmp48_ = FALSE;
			GpxGraphGraphMode _tmp49_;
			gboolean _tmp51_;
			_tmp49_ = self->priv->_mode;
			if (_tmp49_ == GPX_GRAPH_GRAPH_MODE_SPEED_V) {
				_tmp48_ = TRUE;
			} else {
				GpxGraphGraphMode _tmp50_;
				_tmp50_ = self->priv->_mode;
				_tmp48_ = _tmp50_ == GPX_GRAPH_GRAPH_MODE_ACCELERATION_H;
			}
			_tmp51_ = _tmp48_;
			if (_tmp51_) {
				GpxTrack* _tmp52_;
				GList* _tmp53_;
				GList* _tmp54_ = NULL;
				GList* iter;
				_tmp52_ = self->track;
				_tmp53_ = _tmp52_->points;
				_tmp54_ = g_list_first (_tmp53_);
				iter = _tmp54_;
				while (TRUE) {
					GList* _tmp55_;
					GList* _tmp56_;
					GList* _tmp57_;
					GList* _tmp58_;
					GList* ii;
					GList* _tmp59_;
					gdouble _tmp60_ = 0.0;
					gdouble _tmp61_;
					gdouble speed;
					gdouble _tmp62_ = 0.0;
					gdouble _tmp63_;
					gdouble _tmp64_;
					gdouble _tmp67_;
					gdouble _tmp68_ = 0.0;
					gdouble _tmp69_;
					gdouble _tmp70_;
					gdouble _tmp73_;
					GList* _tmp74_;
					GList* _tmp75_;
					_tmp55_ = iter;
					_tmp56_ = _tmp55_->next;
					if (!(_tmp56_ != NULL)) {
						break;
					}
					_tmp57_ = iter;
					_tmp58_ = _tmp57_->next;
					ii = _tmp58_;
					_tmp59_ = ii;
					_tmp60_ = gpx_graph_calculate_graph_point_smooth_value (self, _tmp59_);
					_tmp61_ = min_value;
					speed = _tmp60_ - _tmp61_;
					_tmp63_ = speed;
					_tmp64_ = max_value;
					if (_tmp63_ > _tmp64_) {
						gdouble _tmp65_;
						_tmp65_ = speed;
						_tmp62_ = _tmp65_;
					} else {
						gdouble _tmp66_;
						_tmp66_ = max_value;
						_tmp62_ = _tmp66_;
					}
					_tmp67_ = _tmp62_;
					max_value = _tmp67_;
					_tmp69_ = speed;
					_tmp70_ = min_value;
					if (_tmp69_ < _tmp70_) {
						gdouble _tmp71_;
						_tmp71_ = speed;
						_tmp68_ = _tmp71_;
					} else {
						gdouble _tmp72_;
						_tmp72_ = min_value;
						_tmp68_ = _tmp72_;
					}
					_tmp73_ = _tmp68_;
					min_value = _tmp73_;
					_tmp74_ = iter;
					_tmp75_ = _tmp74_->next;
					iter = _tmp75_;
				}
			} else {
				GpxGraphGraphMode _tmp76_;
				GpxGraphGraphMode _tmp77_;
				_tmp76_ = gpx_graph_get_mode (self);
				_tmp77_ = _tmp76_;
				if (_tmp77_ == GPX_GRAPH_GRAPH_MODE_HEARTRATE) {
					GpxTrack* _tmp78_;
					GList* _tmp79_;
					GList* _tmp80_ = NULL;
					GList* iter;
					min_value = 0.0;
					max_value = 0.0;
					_tmp78_ = self->track;
					_tmp79_ = _tmp78_->points;
					_tmp80_ = g_list_first (_tmp79_);
					iter = _tmp80_;
					while (TRUE) {
						GList* _tmp81_;
						GList* _tmp82_;
						GList* _tmp83_;
						GList* _tmp84_;
						GList* ii;
						GList* _tmp85_;
						gdouble _tmp86_ = 0.0;
						gdouble speed;
						gdouble _tmp87_ = 0.0;
						gdouble _tmp88_;
						gdouble _tmp89_;
						gdouble _tmp92_;
						GList* _tmp93_;
						GList* _tmp94_;
						_tmp81_ = iter;
						_tmp82_ = _tmp81_->next;
						if (!(_tmp82_ != NULL)) {
							break;
						}
						_tmp83_ = iter;
						_tmp84_ = _tmp83_->next;
						ii = _tmp84_;
						_tmp85_ = ii;
						_tmp86_ = gpx_graph_calculate_graph_point_smooth_value (self, _tmp85_);
						speed = _tmp86_;
						_tmp88_ = speed;
						_tmp89_ = max_value;
						if (_tmp88_ > _tmp89_) {
							gdouble _tmp90_;
							_tmp90_ = speed;
							_tmp87_ = _tmp90_;
						} else {
							gdouble _tmp91_;
							_tmp91_ = max_value;
							_tmp87_ = _tmp91_;
						}
						_tmp92_ = _tmp87_;
						max_value = _tmp92_;
						_tmp93_ = iter;
						_tmp94_ = _tmp93_->next;
						iter = _tmp94_;
					}
				}
			}
		}
	}
	_tmp95_ = max_value;
	_tmp96_ = ceil (_tmp95_);
	max_value = _tmp96_;
	_tmp97_ = max_value;
	_tmp98_ = min_value;
	if (_tmp97_ == _tmp98_) {
		_cairo_destroy0 (ctx);
		return;
	}
	_tmp99_ = max_value;
	_tmp100_ = min_value;
	range = _tmp99_ - _tmp100_;
	_tmp101_ = self->track;
	_tmp102_ = gpx_track_get_total_time (_tmp101_);
	elapsed_time = (gdouble) _tmp102_;
	g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:599: Draw Axis");
	_tmp103_ = ctx;
	_tmp104_ = self->priv->LEFT_OFFSET;
	cairo_translate (_tmp103_, (gdouble) _tmp104_, (gdouble) 20);
	_tmp105_ = self->track;
	_tmp106_ = _tmp105_->points;
	_tmp107_ = _tmp106_->data;
	_tmp108_ = _gpx_point_ref0 ((GpxPoint*) _tmp107_);
	f = _tmp108_;
	_tmp109_ = alloc;
	_tmp110_ = _tmp109_.width;
	_tmp111_ = self->priv->LEFT_OFFSET;
	graph_width = (gdouble) ((_tmp110_ - _tmp111_) - 10);
	_tmp112_ = alloc;
	_tmp113_ = _tmp112_.height;
	_tmp114_ = self->priv->BOTTOM_OFFSET;
	graph_height = (gdouble) ((_tmp113_ - 20) - _tmp114_);
	_tmp115_ = graph_height;
	if (_tmp115_ < ((gdouble) 50)) {
		_gpx_point_unref0 (f);
		_cairo_destroy0 (ctx);
		return;
	}
	_tmp116_ = ctx;
	_tmp117_ = pango_cairo_create_layout (_tmp116_);
	layout = _tmp117_;
	_tmp118_ = ctx;
	_tmp119_ = layout;
	_tmp120_ = graph_width;
	_tmp121_ = graph_height;
	_tmp122_ = min_value;
	_tmp123_ = max_value;
	_tmp124_ = elapsed_time;
	gpx_graph_draw_grid (self, _tmp118_, _tmp119_, _tmp120_, _tmp121_, _tmp122_, _tmp123_, _tmp124_);
	_tmp125_ = ctx;
	cairo_set_source_rgba (_tmp125_, 0.1, 0.2, 0.3, (gdouble) 1);
	_tmp126_ = ctx;
	cairo_set_line_width (_tmp126_, (gdouble) 1);
	_tmp127_ = self->track;
	_tmp128_ = _tmp127_->points;
	_tmp129_ = g_list_first (_tmp128_);
	iter = _tmp129_;
	_tmp131_ = min_value;
	if (_tmp131_ < ((gdouble) 0)) {
		gdouble _tmp132_;
		_tmp132_ = max_value;
		_tmp130_ = _tmp132_ > ((gdouble) 0);
	} else {
		_tmp130_ = FALSE;
	}
	_tmp133_ = _tmp130_;
	if (_tmp133_) {
		cairo_t* _tmp134_;
		gdouble _tmp135_;
		gdouble _tmp136_;
		gdouble _tmp137_;
		_tmp134_ = ctx;
		_tmp135_ = graph_height;
		_tmp136_ = max_value;
		_tmp137_ = range;
		cairo_move_to (_tmp134_, 0.0, _tmp135_ * (_tmp136_ / _tmp137_));
	} else {
		cairo_t* _tmp138_;
		gdouble _tmp139_;
		_tmp138_ = ctx;
		_tmp139_ = graph_height;
		cairo_move_to (_tmp138_, 0.0, _tmp139_);
	}
	while (TRUE) {
		GList* _tmp140_;
		GList* _tmp141_;
		GList* _tmp142_;
		gconstpointer _tmp143_;
		time_t _tmp144_ = 0;
		GpxPoint* _tmp145_;
		time_t _tmp146_ = 0;
		gdouble time_offset;
		GList* _tmp147_;
		gdouble _tmp148_ = 0.0;
		gdouble _tmp149_;
		gdouble speed;
		GpxGraphGraphMode _tmp150_;
		GList* _tmp199_;
		GList* _tmp200_;
		_tmp140_ = iter;
		_tmp141_ = _tmp140_->next;
		if (!(_tmp141_ != NULL)) {
			break;
		}
		_tmp142_ = iter;
		_tmp143_ = _tmp142_->data;
		_tmp144_ = gpx_point_get_time ((GpxPoint*) _tmp143_);
		_tmp145_ = f;
		_tmp146_ = gpx_point_get_time (_tmp145_);
		time_offset = (gdouble) (_tmp144_ - _tmp146_);
		_tmp147_ = iter;
		_tmp148_ = gpx_graph_calculate_graph_point_smooth_value (self, _tmp147_);
		_tmp149_ = min_value;
		speed = _tmp148_ - _tmp149_;
		_tmp150_ = self->priv->_mode;
		if (_tmp150_ == GPX_GRAPH_GRAPH_MODE_SPEED) {
			gboolean _tmp151_ = FALSE;
			GList* _tmp152_;
			GList* _tmp153_;
			gboolean _tmp158_;
			GList* _tmp164_;
			gconstpointer _tmp165_;
			gboolean _tmp166_;
			gboolean _tmp179_ = FALSE;
			GList* _tmp180_;
			GList* _tmp181_;
			gboolean _tmp186_;
			_tmp152_ = iter;
			_tmp153_ = _tmp152_->prev;
			if (_tmp153_ != NULL) {
				GList* _tmp154_;
				GList* _tmp155_;
				gconstpointer _tmp156_;
				gboolean _tmp157_;
				_tmp154_ = iter;
				_tmp155_ = _tmp154_->prev;
				_tmp156_ = _tmp155_->data;
				_tmp157_ = ((GpxPoint*) _tmp156_)->stopped;
				_tmp151_ = _tmp157_;
			} else {
				_tmp151_ = FALSE;
			}
			_tmp158_ = _tmp151_;
			if (_tmp158_) {
				cairo_t* _tmp159_;
				gdouble _tmp160_;
				gdouble _tmp161_;
				gdouble _tmp162_;
				gdouble _tmp163_;
				_tmp159_ = ctx;
				_tmp160_ = graph_width;
				_tmp161_ = time_offset;
				_tmp162_ = elapsed_time;
				_tmp163_ = graph_height;
				cairo_line_to (_tmp159_, _tmp160_ * ((gdouble) (_tmp161_ / ((gdouble) _tmp162_))), _tmp163_);
			}
			_tmp164_ = iter;
			_tmp165_ = _tmp164_->data;
			_tmp166_ = ((GpxPoint*) _tmp165_)->stopped;
			if (_tmp166_) {
				cairo_t* _tmp167_;
				gdouble _tmp168_;
				gdouble _tmp169_;
				gdouble _tmp170_;
				gdouble _tmp171_;
				_tmp167_ = ctx;
				_tmp168_ = graph_width;
				_tmp169_ = time_offset;
				_tmp170_ = elapsed_time;
				_tmp171_ = graph_height;
				cairo_line_to (_tmp167_, _tmp168_ * ((gdouble) (_tmp169_ / ((gdouble) _tmp170_))), _tmp171_);
			} else {
				cairo_t* _tmp172_;
				gdouble _tmp173_;
				gdouble _tmp174_;
				gdouble _tmp175_;
				gdouble _tmp176_;
				gdouble _tmp177_;
				gdouble _tmp178_;
				_tmp172_ = ctx;
				_tmp173_ = graph_width;
				_tmp174_ = time_offset;
				_tmp175_ = elapsed_time;
				_tmp176_ = graph_height;
				_tmp177_ = speed;
				_tmp178_ = range;
				cairo_line_to (_tmp172_, _tmp173_ * ((gdouble) (_tmp174_ / ((gdouble) _tmp175_))), _tmp176_ * ((gdouble) (1.0 - (_tmp177_ / _tmp178_))));
			}
			_tmp180_ = iter;
			_tmp181_ = _tmp180_->next;
			if (_tmp181_ != NULL) {
				GList* _tmp182_;
				GList* _tmp183_;
				gconstpointer _tmp184_;
				gboolean _tmp185_;
				_tmp182_ = iter;
				_tmp183_ = _tmp182_->next;
				_tmp184_ = _tmp183_->data;
				_tmp185_ = ((GpxPoint*) _tmp184_)->stopped;
				_tmp179_ = _tmp185_;
			} else {
				_tmp179_ = FALSE;
			}
			_tmp186_ = _tmp179_;
			if (_tmp186_) {
				cairo_t* _tmp187_;
				gdouble _tmp188_;
				gdouble _tmp189_;
				gdouble _tmp190_;
				gdouble _tmp191_;
				_tmp187_ = ctx;
				_tmp188_ = graph_width;
				_tmp189_ = time_offset;
				_tmp190_ = elapsed_time;
				_tmp191_ = graph_height;
				cairo_line_to (_tmp187_, _tmp188_ * ((gdouble) (_tmp189_ / ((gdouble) _tmp190_))), _tmp191_ * ((gdouble) 1.0));
			}
		} else {
			cairo_t* _tmp192_;
			gdouble _tmp193_;
			gdouble _tmp194_;
			gdouble _tmp195_;
			gdouble _tmp196_;
			gdouble _tmp197_;
			gdouble _tmp198_;
			_tmp192_ = ctx;
			_tmp193_ = graph_width;
			_tmp194_ = time_offset;
			_tmp195_ = elapsed_time;
			_tmp196_ = graph_height;
			_tmp197_ = speed;
			_tmp198_ = range;
			cairo_line_to (_tmp192_, _tmp193_ * ((gdouble) (_tmp194_ / ((gdouble) _tmp195_))), _tmp196_ * ((gdouble) (1.0 - (_tmp197_ / _tmp198_))));
		}
		_tmp199_ = iter;
		_tmp200_ = _tmp199_->next;
		iter = _tmp200_;
	}
	_tmp202_ = min_value;
	if (_tmp202_ < ((gdouble) 0)) {
		gdouble _tmp203_;
		_tmp203_ = max_value;
		_tmp201_ = _tmp203_ > ((gdouble) 0);
	} else {
		_tmp201_ = FALSE;
	}
	_tmp204_ = _tmp201_;
	if (_tmp204_) {
		cairo_t* _tmp205_;
		gdouble _tmp206_;
		gdouble _tmp207_;
		gdouble _tmp208_;
		gdouble _tmp209_;
		_tmp205_ = ctx;
		_tmp206_ = graph_width;
		_tmp207_ = graph_height;
		_tmp208_ = max_value;
		_tmp209_ = range;
		cairo_line_to (_tmp205_, _tmp206_, _tmp207_ * (_tmp208_ / _tmp209_));
	} else {
		cairo_t* _tmp210_;
		gdouble _tmp211_;
		gdouble _tmp212_;
		_tmp210_ = ctx;
		_tmp211_ = graph_width;
		_tmp212_ = graph_height;
		cairo_line_to (_tmp210_, _tmp211_, _tmp212_ * 1);
	}
	_tmp213_ = ctx;
	cairo_close_path (_tmp213_);
	_tmp214_ = ctx;
	cairo_stroke_preserve (_tmp214_);
	_tmp215_ = ctx;
	cairo_set_source_rgba (_tmp215_, 0.6, 0.8, 0.9, 0.8);
	_tmp216_ = ctx;
	cairo_fill (_tmp216_);
	_tmp217_ = gpx_graph_get_show_points (self);
	_tmp218_ = _tmp217_;
	if (_tmp218_) {
		cairo_t* _tmp219_;
		GpxTrack* _tmp220_;
		GList* _tmp221_;
		GList* _tmp222_ = NULL;
		g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:675: Draw data points");
		_tmp219_ = ctx;
		cairo_set_source_rgba (_tmp219_, 0.0, 0.0, 0.0, 1.0);
		_tmp220_ = self->track;
		_tmp221_ = _tmp220_->points;
		_tmp222_ = g_list_first (_tmp221_);
		iter = _tmp222_;
		while (TRUE) {
			GList* _tmp223_;
			GList* _tmp224_;
			GList* _tmp225_;
			GList* _tmp226_;
			GList* ii;
			GList* _tmp227_;
			gconstpointer _tmp228_;
			time_t _tmp229_ = 0;
			GpxPoint* _tmp230_;
			time_t _tmp231_ = 0;
			gdouble time_offset;
			GList* _tmp232_;
			gdouble _tmp233_ = 0.0;
			gdouble _tmp234_;
			gdouble speed;
			GList* _tmp235_;
			gconstpointer _tmp236_;
			gboolean _tmp237_;
			cairo_t* _tmp240_;
			gdouble _tmp241_;
			gdouble _tmp242_;
			gdouble _tmp243_;
			gdouble _tmp244_;
			gdouble _tmp245_;
			gdouble _tmp246_;
			cairo_t* _tmp247_;
			GList* _tmp248_;
			GList* _tmp249_;
			_tmp223_ = iter;
			_tmp224_ = _tmp223_->next;
			if (!(_tmp224_ != NULL)) {
				break;
			}
			_tmp225_ = iter;
			_tmp226_ = _tmp225_->next;
			ii = _tmp226_;
			_tmp227_ = ii;
			_tmp228_ = _tmp227_->data;
			_tmp229_ = gpx_point_get_time ((GpxPoint*) _tmp228_);
			_tmp230_ = f;
			_tmp231_ = gpx_point_get_time (_tmp230_);
			time_offset = (gdouble) (_tmp229_ - _tmp231_);
			_tmp232_ = ii;
			_tmp233_ = gpx_graph_calculate_graph_point_smooth_value (self, _tmp232_);
			_tmp234_ = min_value;
			speed = _tmp233_ - _tmp234_;
			_tmp235_ = ii;
			_tmp236_ = _tmp235_->data;
			_tmp237_ = ((GpxPoint*) _tmp236_)->stopped;
			if (_tmp237_) {
				cairo_t* _tmp238_;
				_tmp238_ = ctx;
				cairo_set_source_rgba (_tmp238_, 1.0, 0.0, 0.0, 1.0);
			} else {
				cairo_t* _tmp239_;
				_tmp239_ = ctx;
				cairo_set_source_rgba (_tmp239_, 0.0, 0.0, 0.0, 1.0);
			}
			_tmp240_ = ctx;
			_tmp241_ = graph_width;
			_tmp242_ = time_offset;
			_tmp243_ = elapsed_time;
			_tmp244_ = graph_height;
			_tmp245_ = speed;
			_tmp246_ = range;
			cairo_rectangle (_tmp240_, (_tmp241_ * ((gdouble) (_tmp242_ / ((gdouble) _tmp243_)))) - 1, (_tmp244_ * ((gdouble) (1.0 - (_tmp245_ / _tmp246_)))) - 1, (gdouble) 2, (gdouble) 2);
			_tmp247_ = ctx;
			cairo_stroke (_tmp247_);
			_tmp248_ = iter;
			_tmp249_ = _tmp248_->next;
			iter = _tmp249_;
		}
	}
	g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:699: Draw graph");
	_tmp250_ = self->priv->_mode;
	if (_tmp250_ == GPX_GRAPH_GRAPH_MODE_SPEED) {
		GpxTrack* _tmp251_;
		gdouble _tmp252_ = 0.0;
		gdouble avg;
		cairo_t* _tmp253_;
		gdouble _tmp254_;
		gdouble _tmp255_;
		gdouble _tmp256_;
		cairo_t* _tmp257_;
		gdouble _tmp258_;
		gdouble _tmp259_;
		gdouble _tmp260_;
		gdouble _tmp261_;
		cairo_t* _tmp262_;
		cairo_t* _tmp263_;
		cairo_t* _tmp264_;
		gdouble _tmp265_;
		time_t moving_time = 0;
		GpxTrack* _tmp266_;
		GpxTrack* _tmp267_;
		GList* _tmp268_;
		GList* _tmp269_ = NULL;
		gconstpointer _tmp270_;
		GpxTrack* _tmp271_;
		GList* _tmp272_;
		GList* _tmp273_ = NULL;
		gconstpointer _tmp274_;
		time_t _tmp275_ = 0;
		gdouble _tmp276_ = 0.0;
		cairo_t* _tmp277_;
		cairo_t* _tmp278_;
		gdouble _tmp279_;
		gdouble _tmp280_;
		gdouble _tmp281_;
		cairo_t* _tmp282_;
		gdouble _tmp283_;
		gdouble _tmp284_;
		gdouble _tmp285_;
		gdouble _tmp286_;
		cairo_t* _tmp287_;
		gdouble _tmp288_;
		_tmp251_ = self->track;
		_tmp252_ = gpx_track_get_track_average (_tmp251_);
		avg = _tmp252_;
		_tmp253_ = ctx;
		_tmp254_ = graph_height;
		_tmp255_ = avg;
		_tmp256_ = max_value;
		cairo_move_to (_tmp253_, 0.0, _tmp254_ * (1 - (_tmp255_ / _tmp256_)));
		_tmp257_ = ctx;
		_tmp258_ = graph_width;
		_tmp259_ = graph_height;
		_tmp260_ = avg;
		_tmp261_ = max_value;
		cairo_line_to (_tmp257_, _tmp258_, _tmp259_ * (1 - (_tmp260_ / _tmp261_)));
		_tmp262_ = ctx;
		cairo_set_line_width (_tmp262_, 2.5);
		_tmp263_ = ctx;
		cairo_set_source_rgba (_tmp263_, 1.00, 0.33, 0.00, 1.0);
		_tmp264_ = ctx;
		cairo_stroke (_tmp264_);
		_tmp265_ = avg;
		g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:711: Draw average speed line @ %.02f km/h", _tmp265_);
		_tmp266_ = self->track;
		_tmp267_ = self->track;
		_tmp268_ = _tmp267_->points;
		_tmp269_ = g_list_first (_tmp268_);
		_tmp270_ = _tmp269_->data;
		_tmp271_ = self->track;
		_tmp272_ = _tmp271_->points;
		_tmp273_ = g_list_last (_tmp272_);
		_tmp274_ = _tmp273_->data;
		_tmp276_ = gpx_track_calculate_moving_average (_tmp266_, (GpxPoint*) _tmp270_, (GpxPoint*) _tmp274_, &_tmp275_);
		moving_time = _tmp275_;
		avg = _tmp276_;
		_tmp277_ = ctx;
		cairo_set_source_rgba (_tmp277_, 0.7, 0.0, 0.0, 1.0);
		_tmp278_ = ctx;
		_tmp279_ = graph_height;
		_tmp280_ = avg;
		_tmp281_ = max_value;
		cairo_move_to (_tmp278_, 0.0, _tmp279_ * (1 - (_tmp280_ / _tmp281_)));
		_tmp282_ = ctx;
		_tmp283_ = graph_width;
		_tmp284_ = graph_height;
		_tmp285_ = avg;
		_tmp286_ = max_value;
		cairo_line_to (_tmp282_, _tmp283_, _tmp284_ * (1 - (_tmp285_ / _tmp286_)));
		_tmp287_ = ctx;
		cairo_stroke (_tmp287_);
		_tmp288_ = avg;
		g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:721: Draw moving average speed line @ %.02f km/h", _tmp288_);
	}
	_tmp289_ = ctx;
	cairo_set_source_rgba (_tmp289_, 0.0, 0.0, 0.0, 1.0);
	_tmp290_ = self->priv->fd;
	pango_font_description_set_absolute_size (_tmp290_, (gdouble) (12 * 1024));
	_tmp291_ = layout;
	_tmp292_ = self->priv->fd;
	pango_layout_set_font_description (_tmp291_, _tmp292_);
	_tmp293_ = g_strdup ("");
	mtext = _tmp293_;
	_tmp294_ = self->priv->_do_miles;
	if (_tmp294_) {
		gchar** _tmp295_;
		gint _tmp295__length1;
		GpxGraphGraphMode _tmp296_;
		const gchar* _tmp297_;
		const gchar* _tmp298_ = NULL;
		gchar* _tmp299_;
		_tmp295_ = gpx_graph_GraphModeMiles;
		_tmp295__length1 = gpx_graph_GraphModeMiles_length1;
		_tmp296_ = self->priv->_mode;
		_tmp297_ = _tmp295_[_tmp296_];
		_tmp298_ = _ (_tmp297_);
		_tmp299_ = g_strdup (_tmp298_);
		_g_free0 (mtext);
		mtext = _tmp299_;
	} else {
		gchar** _tmp300_;
		gint _tmp300__length1;
		GpxGraphGraphMode _tmp301_;
		const gchar* _tmp302_;
		const gchar* _tmp303_ = NULL;
		gchar* _tmp304_;
		_tmp300_ = gpx_graph_GraphModeName;
		_tmp300__length1 = gpx_graph_GraphModeName_length1;
		_tmp301_ = self->priv->_mode;
		_tmp302_ = _tmp300_[_tmp301_];
		_tmp303_ = _ (_tmp302_);
		_tmp304_ = g_strdup (_tmp303_);
		_g_free0 (mtext);
		mtext = _tmp304_;
	}
	_tmp305_ = self->priv->_smooth_factor;
	if (_tmp305_ != 1) {
		const gchar* _tmp306_ = NULL;
		const gchar* _tmp307_;
		gint _tmp308_;
		gchar* _tmp309_ = NULL;
		gchar* markup;
		PangoLayout* _tmp310_;
		const gchar* _tmp311_;
		const gchar* _tmp312_;
		_tmp306_ = _ ("%s <i>(smooth window: %i)</i>");
		_tmp307_ = mtext;
		_tmp308_ = self->priv->_smooth_factor;
		_tmp309_ = g_strdup_printf (_tmp306_, _tmp307_, _tmp308_);
		markup = _tmp309_;
		_tmp310_ = layout;
		_tmp311_ = markup;
		pango_layout_set_markup (_tmp310_, _tmp311_, -1);
		_tmp312_ = markup;
		g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:739: Set graph title: %s", _tmp312_);
		_g_free0 (markup);
	} else {
		PangoLayout* _tmp313_;
		const gchar* _tmp314_;
		const gchar* _tmp315_;
		_tmp313_ = layout;
		_tmp314_ = mtext;
		pango_layout_set_text (_tmp313_, _tmp314_, -1);
		_tmp315_ = mtext;
		g_log (LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gpx-graph.vala:745: Set graph title: %s", _tmp315_);
	}
	_tmp316_ = layout;
	pango_layout_get_pixel_size (_tmp316_, &_tmp317_, &_tmp318_);
	w = _tmp317_;
	h = _tmp318_;
	_tmp319_ = ctx;
	_tmp320_ = graph_width;
	_tmp321_ = w;
	cairo_move_to (_tmp319_, (_tmp320_ / 2) - (_tmp321_ / 2), (gdouble) (-20));
	_tmp322_ = ctx;
	_tmp323_ = layout;
	pango_cairo_layout_path (_tmp322_, _tmp323_);
	_tmp324_ = ctx;
	cairo_fill (_tmp324_);
	_g_free0 (mtext);
	_g_object_unref0 (layout);
	_gpx_point_unref0 (f);
	_cairo_destroy0 (ctx);
}


gint gpx_graph_get_smooth_factor (GpxGraph* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_smooth_factor;
	result = _tmp0_;
	return result;
}


void gpx_graph_set_smooth_factor (GpxGraph* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_smooth_factor = _tmp0_;
	_cairo_surface_destroy0 (self->priv->surf);
	self->priv->surf = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "smooth-factor");
}


gboolean gpx_graph_get_show_points (GpxGraph* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_points;
	result = _tmp0_;
	return result;
}


void gpx_graph_set_show_points (GpxGraph* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_points = _tmp0_;
	_cairo_surface_destroy0 (self->priv->surf);
	self->priv->surf = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "show-points");
}


GpxGraphGraphMode gpx_graph_get_mode (GpxGraph* self) {
	GpxGraphGraphMode result;
	GpxGraphGraphMode _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_mode;
	result = _tmp0_;
	return result;
}


void gpx_graph_set_mode (GpxGraph* self, GpxGraphGraphMode value) {
	GpxGraphGraphMode _tmp0_;
	GpxGraphGraphMode _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = self->priv->_mode;
	if (_tmp0_ != _tmp1_) {
		GpxGraphGraphMode _tmp2_;
		_tmp2_ = value;
		self->priv->_mode = _tmp2_;
		_cairo_surface_destroy0 (self->priv->surf);
		self->priv->surf = NULL;
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	g_object_notify ((GObject *) self, "mode");
}


static void g_cclosure_user_marshal_VOID__GPX_POINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__GPX_POINT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__GPX_POINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__GPX_POINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, gpx_value_get_point (param_values + 1), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_GPX_POINT_GPX_POINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_GPX_POINT_GPX_POINT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_GPX_POINT_GPX_POINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_GPX_POINT_GPX_POINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), gpx_value_get_point (param_values + 2), gpx_value_get_point (param_values + 3), data2);
}


static void gpx_graph_class_init (GpxGraphClass * klass) {
	gchar** _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gpx_graph_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GpxGraphPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gpx_graph_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gpx_graph_set_property;
	G_OBJECT_CLASS (klass)->finalize = gpx_graph_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_GRAPH_SMOOTH_FACTOR, g_param_spec_int ("smooth-factor", "smooth-factor", "smooth-factor", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_GRAPH_SHOW_POINTS, g_param_spec_boolean ("show-points", "show-points", "show-points", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_GRAPH_MODE, g_param_spec_enum ("mode", "mode", "mode", GPX_GRAPH_TYPE_GRAPH_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("point_clicked", GPX_TYPE_GRAPH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__GPX_POINT, G_TYPE_NONE, 1, GPX_TYPE_POINT);
	g_signal_new ("selection_changed", GPX_TYPE_GRAPH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_GPX_POINT_GPX_POINT, G_TYPE_NONE, 3, GPX_TYPE_TRACK, GPX_TYPE_POINT, GPX_TYPE_POINT);
	_tmp0_ = g_new0 (gchar*, 6 + 1);
	_tmp0_[0] = "Speed (km/h) vs Time (HH:MM)";
	_tmp0_[1] = "Elevation (m) vs Time (HH:MM)";
	_tmp0_[2] = "Absolute Distance (km) vs Time (HH:MM)";
	_tmp0_[3] = "Horizontal acceleration (m/s²) vs Time (HH:MM)";
	_tmp0_[4] = "Vertical speed (m/s) vs Time (HH:MM)";
	_tmp0_[5] = "Heart-rate (bpm) vs Time (HH:MM)";
	gpx_graph_GraphModeName = _tmp0_;
	gpx_graph_GraphModeName_length1 = 6;
	_tmp1_ = g_new0 (gchar*, 6 + 1);
	_tmp1_[0] = "Speed (Miles/h) vs Time (HH:MM)";
	_tmp1_[1] = "Elevation (feet) vs Time (HH:MM)";
	_tmp1_[2] = "Distance (Miles) vs Time (HH:MM)";
	_tmp1_[3] = "Horizontal acceleration (Miles/s²) vs Time (HH:MM)";
	_tmp1_[4] = "Vertical speed (feet/s) vs Time (HH:MM)";
	_tmp1_[5] = "Heart-rate (bpm) vs Time (HH:MM)";
	gpx_graph_GraphModeMiles = _tmp1_;
	gpx_graph_GraphModeMiles_length1 = 6;
}


static void gpx_graph_instance_init (GpxGraph * self) {
	self->priv = GPX_GRAPH_GET_PRIVATE (self);
	self->track = NULL;
	self->priv->_do_miles = FALSE;
	self->priv->_mode = GPX_GRAPH_GRAPH_MODE_ELEVATION;
	self->priv->_smooth_factor = 1;
	self->priv->_show_points = TRUE;
	self->priv->fd = NULL;
	self->priv->surf = NULL;
	self->priv->LEFT_OFFSET = 60;
	self->priv->BOTTOM_OFFSET = 30;
	self->priv->highlight = (time_t) 0;
	self->priv->draw_current = NULL;
	self->priv->start = NULL;
	self->priv->stop = NULL;
}


static void gpx_graph_finalize (GObject* obj) {
	GpxGraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_TYPE_GRAPH, GpxGraph);
	g_debug ("gpx-graph.vala:755: Destroying graph");
	_g_object_unref0 (self->track);
	__vala_PangoFontDescription_free0 (self->priv->fd);
	_cairo_surface_destroy0 (self->priv->surf);
	_gpx_point_unref0 (self->priv->start);
	_gpx_point_unref0 (self->priv->stop);
	G_OBJECT_CLASS (gpx_graph_parent_class)->finalize (obj);
}


GType gpx_graph_get_type (void) {
	static volatile gsize gpx_graph_type_id__volatile = 0;
	if (g_once_init_enter (&gpx_graph_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GpxGraphClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_graph_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxGraph), 0, (GInstanceInitFunc) gpx_graph_instance_init, NULL };
		GType gpx_graph_type_id;
		gpx_graph_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "GpxGraph", &g_define_type_info, 0);
		g_once_init_leave (&gpx_graph_type_id__volatile, gpx_graph_type_id);
	}
	return gpx_graph_type_id__volatile;
}


static void _vala_gpx_graph_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GpxGraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GPX_TYPE_GRAPH, GpxGraph);
	switch (property_id) {
		case GPX_GRAPH_SMOOTH_FACTOR:
		g_value_set_int (value, gpx_graph_get_smooth_factor (self));
		break;
		case GPX_GRAPH_SHOW_POINTS:
		g_value_set_boolean (value, gpx_graph_get_show_points (self));
		break;
		case GPX_GRAPH_MODE:
		g_value_set_enum (value, gpx_graph_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gpx_graph_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GpxGraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GPX_TYPE_GRAPH, GpxGraph);
	switch (property_id) {
		case GPX_GRAPH_SMOOTH_FACTOR:
		gpx_graph_set_smooth_factor (self, g_value_get_int (value));
		break;
		case GPX_GRAPH_SHOW_POINTS:
		gpx_graph_set_show_points (self, g_value_get_boolean (value));
		break;
		case GPX_GRAPH_MODE:
		gpx_graph_set_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



