/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import java.util.Stack;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.Option;
import org.apache.log4j.joran.action.ActionData;
import org.apache.log4j.joran.action.ImplicitAction;
import org.apache.log4j.joran.spi.ExecutionContext;
import org.apache.log4j.joran.spi.Pattern;
import org.apache.log4j.spi.Component;
import org.apache.log4j.spi.ErrorItem;
import org.apache.log4j.spi.OptionHandler;
import org.xml.sax.Attributes;

public class NestComponentIA
extends ImplicitAction {
    Stack actionDataStack = new Stack();

    public boolean isApplicable(Pattern pattern, Attributes attributes, ExecutionContext ec) {
        String nestedElementTagName = pattern.peekLast();
        Object o = ec.peekObject();
        PropertySetter parentBean = new PropertySetter(o);
        int containmentType = parentBean.canContainComponent(nestedElementTagName);
        switch (containmentType) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: {
                ActionData ad = new ActionData(parentBean, containmentType);
                this.actionDataStack.push(ad);
                return true;
            }
        }
        ec.addError(new ErrorItem("PropertySetter.canContainComponent returned " + containmentType));
        return false;
    }

    public void begin(ExecutionContext ec, String localName, Attributes attributes) {
        ActionData actionData = (ActionData)this.actionDataStack.peek();
        String className = attributes.getValue("class");
        if (Option.isEmpty(className = ec.subst(className))) {
            actionData.inError = true;
            String errMsg = "No class name attribute in <" + localName + ">";
            this.getLogger().error(errMsg);
            ec.addError(new ErrorItem(errMsg));
            return;
        }
        try {
            this.getLogger().debug("About to instantiate component <{}> of type [{}]", localName, className);
            actionData.nestedComponent = Loader.loadClass(className).newInstance();
            if (actionData.nestedComponent instanceof Component) {
                ((Component)actionData.nestedComponent).setLoggerRepository(this.repository);
            }
            this.getLogger().debug((Object)"Pushing component <{}> on top of the object stack.", localName);
            ec.pushObject(actionData.nestedComponent);
        }
        catch (Exception oops) {
            actionData.inError = true;
            String msg = "Could not create component <" + localName + ">.";
            this.getLogger().error((Object)msg, oops);
            ec.addError(new ErrorItem(msg));
        }
    }

    public void end(ExecutionContext ec, String tagName) {
        Object o;
        this.getLogger().debug("entering end method");
        ActionData actionData = (ActionData)this.actionDataStack.pop();
        if (actionData.inError) {
            return;
        }
        if (actionData.nestedComponent instanceof OptionHandler) {
            ((OptionHandler)actionData.nestedComponent).activateOptions();
        }
        if ((o = ec.peekObject()) != actionData.nestedComponent) {
            this.getLogger().warn("The object on the top the of the stack is not the component pushed earlier.");
        } else {
            this.getLogger().debug("Removing component from the object stack");
            ec.popObject();
            switch (actionData.containmentType) {
                case 1: {
                    this.getLogger().debug("Setting [{}] to parent of type [{}]", tagName, actionData.parentBean.getObjClass());
                    actionData.parentBean.setComponent(tagName, actionData.nestedComponent);
                    break;
                }
                case 2: {
                    this.getLogger().debug("Adding [{}] to parent of type [{}]", tagName, actionData.parentBean.getObjClass());
                    actionData.parentBean.addComponent(tagName, actionData.nestedComponent);
                }
            }
        }
    }

    public void finish(ExecutionContext ec) {
    }
}

