/* Libreswan config file parser
 * This header is only for use by code within libipsecconf.
 *
 * Copyright (C) 2001-2002 Mathieu Lafon - Arkoon Network Security
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <https://www.gnu.org/licenses/gpl2.txt>.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#ifndef IPSECCONF_PARSER_H
#define IPSECCONF_PARSER_H

#include <sys/queue.h>		/* for TAILQ_* */

#include "shunk.h"
#include "deltatime.h"
#include "lswlog.h"		/* for enum stream */

struct jambuf;
struct logger;
struct parser;
enum end;

/* Source-And-Line */
struct ipsec_conf_sal {
	const char *source;
	unsigned line;
};

struct ipsec_conf_keyval {
	const struct keyword_def *key;
	char *val;
	/* for "conn" keywords which like to take sides */
	bool left;
	bool right;
	struct ipsec_conf_sal sal;
};

#define PRI_KEYVAL_SAL "%s:%u"
#define pri_keyval_sal(KV) (KV)->sal.source, (KV)->sal.line

diag_t parse_kt_unsigned(const struct ipsec_conf_keyval *key,
			 shunk_t value, uintmax_t *number);
diag_t parse_kt_deltatime(const struct ipsec_conf_keyval *key,
			  shunk_t value, enum timescale default_timescale,
			  deltatime_t *deltatime);
diag_t parse_kt_sparse_name(const struct ipsec_conf_keyval *key,
			    shunk_t value, uintmax_t *number,
			    enum stream stream, struct logger *logger);

/* note: these lists are dynamic */

struct keyval_entry {
	struct ipsec_conf_keyval keyval;
	uintmax_t number;
	deltatime_t deltatime;

	TAILQ_ENTRY(keyval_entry) next;
};

TAILQ_HEAD(keyval_list, keyval_entry);

struct section_list {
	char *name;
	struct keyval_list keyvals;
	bool beenhere;

	TAILQ_ENTRY(section_list) next;
};

struct ipsec_conf_source {
	char *name;

	TAILQ_ENTRY(ipsec_conf_source) next;
};

TAILQ_HEAD(ipsec_conf_sources, ipsec_conf_source);

const char *add_ipsec_conf_source(struct ipsec_conf *cfg, const char *name);

struct ipsec_conf {
	struct keyval_list config_setup;

	TAILQ_HEAD(sectionhead, section_list) sections;
	int ipsec_conf_version;

	struct section_list conn_default;

	struct ipsec_conf_sources sources;
};

struct parser {
	struct ipsec_conf *cfg;
	struct keyval_list *keyvals;
	enum section { SECTION_CONFIG_SETUP, SECTION_CONN_DEFAULT, SECTION_CONN, } section;
#define str_parser_section(PARSER)					\
	((PARSER)->section == SECTION_CONFIG_SETUP ? "config setup" :	\
	 (PARSER)->section == SECTION_CONN_DEFAULT ? "conn %default" :	\
	 (PARSER)->section == SECTION_CONN ? "conn" :		      \
	 "???")
	struct starter_comments_list *comments;
	struct logger *logger;
	enum stream error_stream;
	unsigned verbosity;
	bool setuponly;
	struct input_source *input;
};

#include "ipsecconf/parser.tab.h"	/* generated by bison */

/* defined in parser.y */

void parser_warning(struct parser *parser, int eerror/*can be 0*/,
		    const char *s, ...) PRINTF_LIKE(3);

void parser_fatal(struct parser *parser, int eerror/*can be 0*/,
		  const char *s, ...) PRINTF_LIKE(3) NEVER_RETURNS;

struct ipsec_conf *load_ipsec_conf(const char *file, struct logger *logger,
				   bool setuponly, unsigned verbosity);
struct ipsec_conf *argv_ipsec_conf(const char *name, char *argv[], int start, struct logger *logger);

void pfree_ipsec_conf(struct ipsec_conf **cfg);

#define THIS_IPSEC_CONF_VERSION 2

#endif /* _IPSEC_PARSER_H_ */
