#include "uocompiler.h"
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include "mtalib.h"
#include "uostr.h"

const char *mta_errtxt;
const char *mta_hcmssc;
char *mta_hostname;

mta_ret_t
mta_set_hostname(const char *s)
{
	/* 120 chars ought to be enough for a hostname ... */
	char mhn[120];
	if (!s) {
		if (mta_hostname) return MTA_SUCCESS; /* already did it */
		if (-1==gethostname(mhn,sizeof(mhn)-1)) {
			mta_set_err("hostname error","(#4.3.0)",errno);return MTA_DEFER;
		}
		s=mhn;
	}
	if (mta_hostname) free(mta_hostname);
	mta_hostname=strdup(s);
	if (!mta_hostname) {mta_set_err("out of memory","(#4.3.0)",0); return MTA_DEFER;}
	return MTA_SUCCESS;
}

void
mta_set_err(const char *s1,const char *s2,int e)
{
	static char buf1[128];
	static char buf2[10];
	if (s2) {
		size_t l=strlen(s2);
		if (l>=sizeof(buf2)) {
			strcpy(buf1,"internal trouble: mta_set_err failed, s2 too long");
			strcpy(buf2,"(#4.3.0)");
			goto out;
		}
		strcpy(buf2,s2);
	} else
		*buf2=0;
	if (!e) {
		size_t l=strlen(s1);
		if (l>=sizeof(buf1)) {
			strcpy(buf1,"internal trouble: mta_set_err failed, s1 too long");
			strcpy(buf2,"(#4.3.0)");
			goto out;
		}
		strcpy(buf1,s1);
	} else {
		uostr_t s;s.data=0;
		if (!uostr_dup_cstrmulti(&s,s1,": ",strerror(e),0)) {
			strcpy(buf1,"out of memory");
			strcpy(buf2,"(#4.3.0)");
		} else {
			if (s.len>=sizeof(buf1)) memcpy(buf1,s.data,sizeof(buf1)-1);
			else memcpy(buf1,s.data,s.len);
			buf1[sizeof(buf1)-1]=0;
		}
	}
  out:
	mta_errtxt=buf1;
	if (!*buf2) mta_hcmssc=0;
	else mta_hcmssc=buf2;
}
