/*
** Copyright (C) 2003, Nik Reiman - nik@aboleo.net
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/wait.h>

#include "config.h"
#include "portmon.h"

int exec_proc(char *command, time_t cur_time, char *hostname, char *err_msg) {
 int ret, arg_count = 0;
 char run_string[STRLARGE], *p, *run_cmd_args[STRSMALL];

 strncpy(run_string, command, STRLARGE);

 // this is all ugly and needs to die, probably.  it seems to work, so
 // maybe keep it.  who knows.  life is full of hard choices.
 while((p = strchr(run_string, ' ')) != NULL) {
  run_cmd_args[arg_count] = (char *)malloc(sizeof(char) * STRMED);
  bzero(run_cmd_args[arg_count], STRMED);
  strncpy(run_cmd_args[arg_count], run_string, p - run_string);

  if(!strcmp(run_cmd_args[arg_count], "%h")) {
   strcpy(run_cmd_args[arg_count], hostname);
  }
  else if(!strcmp(run_cmd_args[arg_count], "%t")) {
   strcpy(run_cmd_args[arg_count], get_time(time(NULL)));
  }
  else if(!strcmp(run_cmd_args[arg_count], "%m")) {
   strcpy(run_cmd_args[arg_count], err_msg);
  }
  arg_count++;
  strcpy(run_string, p + 1);
 }
 run_cmd_args[arg_count] = (char *)malloc(sizeof(char) * STRMED);
 bzero(run_cmd_args[arg_count], STRMED);
 strcpy(run_cmd_args[arg_count], run_string);

 if(!strcmp(run_cmd_args[arg_count], "%h")) {
  strcpy(run_cmd_args[arg_count], hostname);
 }
 else if(!strcmp(run_cmd_args[arg_count], "%t")) {
  strcpy(run_cmd_args[arg_count], get_time(time(NULL)));
 }
 else if(!strcmp(run_cmd_args[arg_count], "%m")) {
  strcpy(run_cmd_args[arg_count], err_msg);
 }

 run_cmd_args[++arg_count] = (char *)0;

 if(!fork()) {
  ret = execvp(run_cmd_args[0], run_cmd_args);
  // should never reach here
  if(ret < 0) {
   exit(-1);
  }
 }
 else {
  return 0;
 }

 return 0;
}
