/*
  Archive Diff - display differences between two archives
  Copyright (C) 2011  Christopher Howard
  
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*  Lifted (mostly) from the HOLY GNU LIBC MANUAL */

#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

char * concat (const char *str, ...)
{
  va_list ap;
  /* 64 sounds about right... */
  size_t allocated = 64;
  char *result = (char *) malloc (allocated);
  const char * s;
  
  if (result != NULL)
    {
      char *newp;
      char *wp;
      
      va_start (ap, str);
      
      wp = result;
      for (s = str; s != NULL; s = va_arg (ap, const char *))
	{
	  size_t len = strlen (s);
	  
	  /* Resize the allocated memory if necessary.  */
	  if (wp + len + 1 > result + allocated)
	    {
	      allocated = (allocated + len) * 2;
	      newp = (char *) realloc (result, allocated);
	      if (newp == NULL)
		{
		  free (result);
		  return NULL;
		}
	      wp = newp + (wp - result);
	      result = newp;
	    }
	  
	  /* we won't use mempcpy because that requires _GNU_SOURCE */
	  wp = (char *) memcpy (wp, s, len) + len;
	}
      
      /* Terminate the result string.  */
      *wp++ = '\0';
      
      /* Resize memory to the optimal size.  */
      newp = realloc (result, wp - result);
      if (newp != NULL)
	result = newp;
      
      va_end (ap);
    }
  
  return result;
}
