 
C AMPLITUDE SQUARED (MATRIX ELEMENTS) FOR THE PROCESSES:
C GG->TBH^+, QQBAR->TBH^+
C AS A FUNCTION OF 4-MOMENTA FOR SUITABLE INTERFACE
C (FOR INSTANCE WITH PYTHIA)
C------------------------------------------------------------
C BASED ON F. BORZUMATI, J.-L. KNEUR, N. POLONSKY  HEP-PH/9905443,
C PHYS REV. D 60 (1999) 115011
C (THESE FILES PREPARED BY J.-L. KNEUR)
C------------------------------------------------------------
C 1)  GG->TBH^+
       SUBROUTINE PYTBHG(Q1,Q2,P1,P2,P3,MT,MB,RMB,MHP,AMP2)
C
C CONVENTIONS AND INPUT/OUTPUT DEFINITIONS:
C
C INPUT: Q1,Q2 ARE ENTERING 4-MOMENTA OF INITIAL GLUONS OR QUARKS;
C        P1, P2 ARE THE TOP AND BOTTOM OUTGOING 4-MOMENTA;
C        P3 IS OUTGOING CHARGED HIGGS 4-MOMENTA.
C  (NB FOR ALL 4-MOMENTA P(4) IS TIME-COMPONENT)
C "PHYSICAL PARAMETERS" INPUT:
C        MT,MB TOP AND BOTTOM MASSES;
C        MHP CHARGED HIGGS MASS
C   FURTHER PARAMETERS INPUT IS NEEDED FROM COMMON/PARAM/ (SEE BELOW)
C
C OUTPUT: AMP2  IS MATRIX ELEMENT (AMPLITUDE**2) FOR GG->TB H^+
C (NB AMP2 IS TRULY AMPLITUDE SQUARRED, I.E. WITHOUT ANY
C PHASE SPACE FACTORS INCLUDED. IT INCLUDES COLOUR AND COUPLING
C FACTORS, AS EXPLICIT BELOW. ACCORDINGLY, FOR EXAMPLE THE TOTAL
C CROSS-SECTION SHOULD BE (SYMBOLICALLY):
C   SIGMA = INTEGRATE [PARTON DENSITY FUNCTIONS * 3-PARTICLE FINAL
C           STATE PHASE-SPACE (STANDARDLY NORMALIZED) * AMP2 ]
C
      IMPLICIT DOUBLE PRECISION(A-H, O-Z)
      IMPLICIT INTEGER(I-N)
      DOUBLE PRECISION MW2,MT,MB,MHP,MW
      DIMENSION Q1(4),Q2(4),P1(4),P2(4),P3(4)
      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)
      COMMON/PYDAT2/KCHG(500,4),PMAS(500,4),PARF(2000),VCKM(4,4)
      COMMON/PYMSSM/IMSS(0:99),RMSS(0:99)
 
      COMMON/PYCTBH/ ALPHA,ALPHAS,SW2,MW2,TANB,VTB,V,A
      SAVE /PYDAT1/,/PYDAT2/,/PYMSSM/,/PYCTBH/
C !THE RELEVANT INPUT PARAMETERS ABOVE ARE NEEDED FOR CALCULATION
C BUT ARE NOT DEFINED HERE SO THAT ONE MAY CHOOSE/VARY THEIR VALUES:
C ACCORDINGLY, WHEN CALLING THESE SUBROUTINES, PLEASE SUPPLY VIA
C THIS COMMON/PARAM/ YOUR PREFERRED ALPHA, ALPHAS,..AND TANB
C (TAN BETA) VALUES
C
C THE NORMALIZED V,A COUPLINGS ARE DEFINED BELOW AND USED BOTH
C IN THIS ROUTINE AND IN THE TOP WIDTH CALCULATION PYTBHB(..).
 
      PI = 4*DATAN(1.D0)
      MW = DSQRT(MW2)
C
C COLLECTING THE RELEVANT OVERALL FACTORS:
C 8X8 INITIAL GLUON COLOR AVERAGE, 2X2 GLUON SPIN AVERAGE
      PS=1.D0/(8.D0*8.D0 *2.D0*2.D0)
C COUPLING CONSTANT (OVERALL NORMALIZATION)
      FACT=(4.D0*PI*ALPHA)*(4.D0*PI*ALPHAS)**2/SW2/2.D0
C NB ALPHA IS E^2/4/PI, BUT BETTER DEFINED IN TERMS OF G_FERMI:
C ALPHA= DSQRT(2.D0)*GF*SW2*MW**2/PI
C ALPHAS IS ALPHA_STRONG;
C SW2 IS SIN(THETA_W)**2.
C
C      VTB=.998D0
C VTB IS TOP-BOTTOM CKM MATRIX ELEMENT (APPROXIMATE VALUE HERE)
C
      V = ( MT/MW/TANB +RMB/MW*TANB)/2.D0
      A = (-MT/MW/TANB +RMB/MW*TANB)/2.D0
C V AND A ARE (NORMALIZED) VECTOR AND AXIAL TBH^+ COUPLINGS
C
C REDEFINING P2 INGOING FROM OVERALL MOMENTUM CONSERVATION
C (BECAUSE P2 INGOING WAS USED IN OUR GRAPH CALCULATION CONVENTIONS)
      DO 100 KK=1,4
      P2(KK)=P3(KK)-Q1(KK)-Q2(KK)+P1(KK)
  100 CONTINUE
C DEFINING VARIOUS RELEVANT 4-SCALAR PRODUCTS:
      S = 2*PYTBHS(Q1,Q2)
      P1Q1=PYTBHS(Q1,P1)
      P1Q2=PYTBHS(P1,Q2)
      P2Q1=PYTBHS(P2,Q1)
      P2Q2=PYTBHS(P2,Q2)
      P1P2=PYTBHS(P1,P2)
C
C   TOP WIDTH CALCULATION
      CALL PYTBHB(MT,MB,MHP,BR,GAMT)
C   GAMT IS THE TOP WIDTH: T->BH^+ AND/OR T->B W^+
C THEN DEFINE TOP (RESONANT) PROPAGATOR:
      A1INV= S -2*P1Q1 -2*P1Q2
      A1 =A1INV/(A1INV**2+ (GAMT*MT)**2)
C (I.E. INTRODUCE THE TOP WIDTH IN A1 TO REGULARISE THE POLE)
C  NB:    A12 = A1*A1 BUT CORRECT EXPRESSION BELOW BECAUSE OF
C  THE TOP WIDTH
      A12 = 1.D0/(A1INV**2+ (GAMT*MT)**2)
      A2 =1.D0/(S +2*P2Q1 +2*P2Q2)
C NOTE A2 IS B PROPAGATOR, DOES NOT NEED A WIDTH
C  NOW COMES THE AMP**2:
C NB COLOR FACTOR (COMING FROM GRAPHS) ALREADY INCLUDED IN
C THE EXPRESSIONS BELOW
      V18=0.D0
      A18=0.D0
      V18= 640*A1/3+640*A2/3+32*A1*A2*MB**2-368*A12*MB*MT-
     &512*A1*A2*MB*MT/3-
     &368*A2**2*MB*MT+32*A1*A2*MT**2+496*A12*P1P2/3+
     &320*A1*A2*P1P2+496*A2**2*P1P2/3+128*A1*MB*MT**3/(3*P1Q1**2)+
     &128*A1*MT**4/(3*P1Q1**2)-256*A12*MB*MT**5/(3*P1Q1**2)+
     &256*A1*MT**2*P1P2/(3*P1Q1**2)-256*A12*MT**4*P1P2/(3*P1Q1**2)+
     &8/(3*P1Q1)-32*A1*MB*MT/P1Q1-56*A2*MB*MT/(3*P1Q1)+
     &88*A1*MT**2/(3*P1Q1)+72*A2*MT**2/P1Q1+
     &704*A12*MB*MT**3/(3*P1Q1)-224*A1*A2*MB*MT**3/(3*P1Q1)+
     &104*A1*P1P2/(3*P1Q1)+48*A2*P1P2/P1Q1+
     &128*A1*A2*MB*MT*P1P2/(3*P1Q1)+512*A12*MT**2*P1P2/(3*P1Q1)-
     &448*A1*A2*MT**2*P1P2/(3*P1Q1)-32*A1*A2*P1P2**2/P1Q1-
     &656*A1*A2*P1Q1/3-224*A2**2*P1Q1+128*A1*MB*MT**3/(3*P1Q2**2)+
     &128*A1*MT**4/(3*P1Q2**2)-256*A12*MB*MT**5/(3*P1Q2**2)+
     &256*A1*MT**2*P1P2/(3*P1Q2**2)-256*A12*MT**4*P1P2/(3*P1Q2**2)+
     &256*A1*MT**2*P1Q1/(3*P1Q2**2)+256*A12*MB*MT**3*P1Q1/(3*P1Q2**2)+
     &8/(3*P1Q2)-32*A1*MB*MT/P1Q2-56*A2*MB*MT/(3*P1Q2)
      V18=V18+88*A1*MT**2/(3*P1Q2)+72*A2*MT**2/P1Q2+
     &704*A12*MB*MT**3/(3*P1Q2)-224*A1*A2*MB*MT**3/(3*P1Q2)+
     &104*A1*P1P2/(3*P1Q2)+48*A2*P1P2/P1Q2+
     &128*A1*A2*MB*MT*P1P2/(3*P1Q2)+512*A12*MT**2*P1P2/(3*P1Q2)-
     &448*A1*A2*MT**2*P1P2/(3*P1Q2)-32*A1*A2*P1P2**2/P1Q2-
     &32*A1*MB*MT**3/(3*P1Q1*P1Q2)-32*A1*MT**4/(3*P1Q1*P1Q2)+
     &64*A12*MB*MT**5/(3*P1Q1*P1Q2)+16*P1P2/(3*P1Q1*P1Q2)-
     &64*A1*MT**2*P1P2/(3*P1Q1*P1Q2)+64*A12*MT**4*P1P2/(3*P1Q1*P1Q2)+
     &112*A1*P1Q1/P1Q2+272*A2*P1Q1/(3*P1Q2)-
     &272*A1*A2*MB**2*P1Q1/(3*P1Q2)+208*A12*MB*MT*P1Q1/(3*P1Q2)-
     &400*A1*A2*MB*MT*P1Q1/(3*P1Q2)-80*A1*A2*MT**2*P1Q1/P1Q2+
     &96*A12*P1P2*P1Q1/P1Q2-320*A1*A2*P1P2*P1Q1/P1Q2-
     &544*A1*A2*P1Q1**2/(3*P1Q2)-656*A1*A2*P1Q2/3-224*A2**2*P1Q2+
     &256*A1*MT**2*P1Q2/(3*P1Q1**2)+256*A12*MB*MT**3*P1Q2/(3*P1Q1**2)+
     &112*A1*P1Q2/P1Q1+272*A2*P1Q2/(3*P1Q1)-
     &272*A1*A2*MB**2*P1Q2/(3*P1Q1)+208*A12*MB*MT*P1Q2/(3*P1Q1)-
     &400*A1*A2*MB*MT*P1Q2/(3*P1Q1)-80*A1*A2*MT**2*P1Q2/P1Q1
      V18=V18+96*A12*P1P2*P1Q2/P1Q1-320*A1*A2*P1P2*P1Q2/P1Q1-
     &544*A1*A2*P1Q2**2/(3*P1Q1)+128*A2*MB**4/(3*P2Q1**2)+
     &128*A2*MB**3*MT/(3*P2Q1**2)-256*A2**2*MB**5*MT/(3*P2Q1**2)+
     &256*A2*MB**2*P1P2/(3*P2Q1**2)-256*A2**2*MB**4*P1P2/(3*P2Q1**2)+
     &256*A2*MB**2*P1Q1/(3*P2Q1**2)-256*A2**2*MB**4*P1Q1/(3*P2Q1**2)-
     &64*MB**3*MT**3/(3*P1Q2**2*P2Q1**2)-
     &64*MB**2*MT**2*P1P2/(3*P1Q2**2*P2Q1**2)-
     &64*MB**2*MT**2*P1Q1/(3*P1Q2**2*P2Q1**2)+
     &64*MB**3*MT/(3*P1Q2*P2Q1**2)+
     &256*A2*MB**3*MT*P1P2/(3*P1Q2*P2Q1**2)+
     &256*A2*MB**2*P1P2**2/(3*P1Q2*P2Q1**2)+
     &256*A2*MB**3*MT*P1Q1/(3*P1Q2*P2Q1**2)+
     &512*A2*MB**2*P1P2*P1Q1/(3*P1Q2*P2Q1**2)+
     &256*A2*MB**2*P1Q1**2/(3*P1Q2*P2Q1**2)-
     &256*A2**2*MB**4*P1Q2/(3*P2Q1**2)-8/(3*P2Q1)-72*A1*MB**2/P2Q1-
     &88*A2*MB**2/(3*P2Q1)+56*A1*MB*MT/(3*P2Q1)+32*A2*MB*MT/P2Q1+
     &224*A1*A2*MB**3*MT/(3*P2Q1)-704*A2**2*MB**3*MT/(3*P2Q1)
      V18=V18-48*A1*P1P2/P2Q1-104*A2*P1P2/(3*P2Q1)+
     &448*A1*A2*MB**2*P1P2/(3*P2Q1)-512*A2**2*MB**2*P1P2/(3*P2Q1)-
     &128*A1*A2*MB*MT*P1P2/(3*P2Q1)+32*A1*A2*P1P2**2/P2Q1-
     &16*P1P2/(3*P1Q1*P2Q1)-32*A1*MB*MT*P1P2/(3*P1Q1*P2Q1)-
     &32*A2*MB*MT*P1P2/(3*P1Q1*P2Q1)-
     &64*A1*A2*MB*MT*P1P2**2/(3*P1Q1*P2Q1)-
     &64*A1*A2*P1P2**3/(3*P1Q1*P2Q1)-256*A2*P1Q1/(3*P2Q1)+
     &448*A1*A2*MB**2*P1Q1/(3*P2Q1)-368*A2**2*MB**2*P1Q1/(3*P2Q1)+
     &224*A1*A2*MB*MT*P1Q1/(3*P2Q1)+304*A1*A2*P1P2*P1Q1/(3*P2Q1)-
     &64*MB*MT**3/(3*P1Q2**2*P2Q1)-
     &256*A1*MB*MT**3*P1P2/(3*P1Q2**2*P2Q1)-
     &256*A1*MT**2*P1P2**2/(3*P1Q2**2*P2Q1)+
     &64*MT**2*P1Q1/(3*P1Q2**2*P2Q1)-
     &128*A1*MB**2*MT**2*P1Q1/(3*P1Q2**2*P2Q1)-
     &128*A1*MB*MT**3*P1Q1/(3*P1Q2**2*P2Q1)-
     &256*A1*MT**2*P1P2*P1Q1/(3*P1Q2**2*P2Q1)-4*MB**2/(3*P1Q2*P2Q1)+
     &64*MB*MT/(3*P1Q2*P2Q1)-128*A2*MB**3*MT/(3*P1Q2*P2Q1)
      V18=V18-4*MT**2/(3*P1Q2*P2Q1)-128*A1*MB**2*MT**2/(3*P1Q2*P2Q1)-
     &128*A2*MB**2*MT**2/(3*P1Q2*P2Q1)-128*A1*MB*MT**3/(3*P1Q2*P2Q1)-
     &112*A2*MB**2*P1P2/(3*P1Q2*P2Q1)-32*A1*MB*MT*P1P2/(3*P1Q2*P2Q1)-
     &32*A2*MB*MT*P1P2/(3*P1Q2*P2Q1)-112*A1*MT**2*P1P2/(3*P1Q2*P2Q1)-
     &48*A1*P1P2**2/(P1Q2*P2Q1)-48*A2*P1P2**2/(P1Q2*P2Q1)+
     &512*A1*A2*MB*MT*P1P2**2/(3*P1Q2*P2Q1)+
     &512*A1*A2*P1P2**3/(3*P1Q2*P2Q1)-8*MB*MT*P1P2/(3*P1Q1*P1Q2*P2Q1)-
     &8*MT**2*P1P2/(3*P1Q1*P1Q2*P2Q1)+
     &32*A1*MB*MT**3*P1P2/(3*P1Q1*P1Q2*P2Q1)-
     &16*P1P2**2/(3*P1Q1*P1Q2*P2Q1)+
     &32*A1*MT**2*P1P2**2/(3*P1Q1*P1Q2*P2Q1)+8*P1Q1/(3*P1Q2*P2Q1)-
     &160*A1*MB**2*P1Q1/(3*P1Q2*P2Q1)-272*A2*MB**2*P1Q1/(3*P1Q2*P2Q1)+
     &56*A1*MB*MT*P1Q1/(3*P1Q2*P2Q1)+200*A2*MB*MT*P1Q1/(3*P1Q2*P2Q1)-
     &48*A1*P1P2*P1Q1/(P1Q2*P2Q1)-256*A2*P1P2*P1Q1/(3*P1Q2*P2Q1)+
     &256*A1*A2*MB**2*P1P2*P1Q1/(3*P1Q2*P2Q1)+
     &256*A1*A2*MB*MT*P1P2*P1Q1/(P1Q2*P2Q1)+
     &1024*A1*A2*P1P2**2*P1Q1/(3*P1Q2*P2Q1)
      V18=V18-272*A2*P1Q1**2/(3*P1Q2*P2Q1)+
     &256*A1*A2*MB**2*P1Q1**2/(3*P1Q2*P2Q1)+
     &256*A1*A2*MB*MT*P1Q1**2/(3*P1Q2*P2Q1)+
     &512*A1*A2*P1P2*P1Q1**2/(3*P1Q2*P2Q1)+16*A2*P1Q2/(3*P2Q1)+
     &64*A1*A2*MB**2*P1Q2/P2Q1+32*A2**2*MB**2*P1Q2/(3*P2Q1)+
     &112*A1*A2*MB*MT*P1Q2/(3*P2Q1)+368*A1*A2*P1P2*P1Q2/(3*P2Q1)+
     &32*A2*P1P2*P1Q2/(3*P1Q1*P2Q1)-
     &32*A1*A2*MB**2*P1P2*P1Q2/(3*P1Q1*P2Q1)-
     &32*A1*A2*MB*MT*P1P2*P1Q2/(3*P1Q1*P2Q1)-
     &64*A1*A2*P1P2**2*P1Q2/(3*P1Q1*P2Q1)+224*A12*P2Q1+
     &656*A1*A2*P2Q1/3-256*A1*MT**2*P2Q1/(3*P1Q1**2)+
     &256*A12*MT**4*P2Q1/(3*P1Q1**2)-256*A1*P2Q1/(3*P1Q1)+
     &224*A1*A2*MB*MT*P2Q1/(3*P1Q1)-368*A12*MT**2*P2Q1/(3*P1Q1)+
     &448*A1*A2*MT**2*P2Q1/(3*P1Q1)+304*A1*A2*P1P2*P2Q1/(3*P1Q1)+
     &256*A12*MT**4*P2Q1/(3*P1Q2**2)+
     &256*A12*MT**2*P1Q1*P2Q1/(3*P1Q2**2)+16*A1*P2Q1/(3*P1Q2)+
     &112*A1*A2*MB*MT*P2Q1/(3*P1Q2)+32*A12*MT**2*P2Q1/(3*P1Q2)
      V18=V18+64*A1*A2*MT**2*P2Q1/P1Q2+368*A1*A2*P1P2*P2Q1/(3*P1Q2)+
     &16*A1*MT**2*P2Q1/(3*P1Q1*P1Q2)-64*A12*MT**4*P2Q1/(3*P1Q1*P1Q2)+
     &640*A12*P1Q1*P2Q1/(3*P1Q2)+544*A1*A2*P1Q1*P2Q1/(3*P1Q2)+
     &32*A12*P1Q2*P2Q1/P1Q1+944*A1*A2*P1Q2*P2Q1/(3*P1Q1)+
     &128*A2*MB**4/(3*P2Q2**2)+128*A2*MB**3*MT/(3*P2Q2**2)-
     &256*A2**2*MB**5*MT/(3*P2Q2**2)+256*A2*MB**2*P1P2/(3*P2Q2**2)-
     &256*A2**2*MB**4*P1P2/(3*P2Q2**2)-
     &64*MB**3*MT**3/(3*P1Q1**2*P2Q2**2)-
     &64*MB**2*MT**2*P1P2/(3*P1Q1**2*P2Q2**2)+
     &64*MB**3*MT/(3*P1Q1*P2Q2**2)+
     &256*A2*MB**3*MT*P1P2/(3*P1Q1*P2Q2**2)+
     &256*A2*MB**2*P1P2**2/(3*P1Q1*P2Q2**2)-
     &256*A2**2*MB**4*P1Q1/(3*P2Q2**2)+256*A2*MB**2*P1Q2/(3*P2Q2**2)-
     &256*A2**2*MB**4*P1Q2/(3*P2Q2**2)-
     &64*MB**2*MT**2*P1Q2/(3*P1Q1**2*P2Q2**2)+
     &256*A2*MB**3*MT*P1Q2/(3*P1Q1*P2Q2**2)+
     &512*A2*MB**2*P1P2*P1Q2/(3*P1Q1*P2Q2**2)
      V18=V18+256*A2*MB**2*P1Q2**2/(3*P1Q1*P2Q2**2)-
     &256*A2*MB**2*P2Q1/(3*P2Q2**2)-256*A2**2*MB**3*MT*P2Q1/(3*P2Q2**2)+
     &64*MB**2*MT**2*P2Q1/(3*P1Q1**2*P2Q2**2)+
     &64*MB**2*P2Q1/(3*P1Q1*P2Q2**2)-
     &128*A2*MB**3*MT*P2Q1/(3*P1Q1*P2Q2**2)-
     &128*A2*MB**2*MT**2*P2Q1/(3*P1Q1*P2Q2**2)-
     &256*A2*MB**2*P1P2*P2Q1/(3*P1Q1*P2Q2**2)+
     &256*A2**2*MB**2*P1Q1*P2Q1/(3*P2Q2**2)-
     &256*A2*MB**2*P1Q2*P2Q1/(3*P1Q1*P2Q2**2)-8/(3*P2Q2)-
     &72*A1*MB**2/P2Q2-88*A2*MB**2/(3*P2Q2)+56*A1*MB*MT/(3*P2Q2)+
     &32*A2*MB*MT/P2Q2+224*A1*A2*MB**3*MT/(3*P2Q2)-
     &704*A2**2*MB**3*MT/(3*P2Q2)-48*A1*P1P2/P2Q2-
     &104*A2*P1P2/(3*P2Q2)+448*A1*A2*MB**2*P1P2/(3*P2Q2)-
     &512*A2**2*MB**2*P1P2/(3*P2Q2)-128*A1*A2*MB*MT*P1P2/(3*P2Q2)+
     &32*A1*A2*P1P2**2/P2Q2-64*MB*MT**3/(3*P1Q1**2*P2Q2)-
     &256*A1*MB*MT**3*P1P2/(3*P1Q1**2*P2Q2)-
     &256*A1*MT**2*P1P2**2/(3*P1Q1**2*P2Q2)-4*MB**2/(3*P1Q1*P2Q2)
      V18=V18+64*MB*MT/(3*P1Q1*P2Q2)-128*A2*MB**3*MT/(3*P1Q1*P2Q2)-
     &4*MT**2/(3*P1Q1*P2Q2)-128*A1*MB**2*MT**2/(3*P1Q1*P2Q2)-
     &128*A2*MB**2*MT**2/(3*P1Q1*P2Q2)-128*A1*MB*MT**3/(3*P1Q1*P2Q2)-
     &112*A2*MB**2*P1P2/(3*P1Q1*P2Q2)-32*A1*MB*MT*P1P2/(3*P1Q1*P2Q2)-
     &32*A2*MB*MT*P1P2/(3*P1Q1*P2Q2)-112*A1*MT**2*P1P2/(3*P1Q1*P2Q2)-
     &48*A1*P1P2**2/(P1Q1*P2Q2)-48*A2*P1P2**2/(P1Q1*P2Q2)+
     &512*A1*A2*MB*MT*P1P2**2/(3*P1Q1*P2Q2)+
     &512*A1*A2*P1P2**3/(3*P1Q1*P2Q2)+16*A2*P1Q1/(3*P2Q2)+
     &64*A1*A2*MB**2*P1Q1/P2Q2+32*A2**2*MB**2*P1Q1/(3*P2Q2)+
     &112*A1*A2*MB*MT*P1Q1/(3*P2Q2)+368*A1*A2*P1P2*P1Q1/(3*P2Q2)-
     &16*P1P2/(3*P1Q2*P2Q2)-32*A1*MB*MT*P1P2/(3*P1Q2*P2Q2)-
     &32*A2*MB*MT*P1P2/(3*P1Q2*P2Q2)-
     &64*A1*A2*MB*MT*P1P2**2/(3*P1Q2*P2Q2)-
     &64*A1*A2*P1P2**3/(3*P1Q2*P2Q2)-8*MB*MT*P1P2/(3*P1Q1*P1Q2*P2Q2)-
     &8*MT**2*P1P2/(3*P1Q1*P1Q2*P2Q2)+
     &32*A1*MB*MT**3*P1P2/(3*P1Q1*P1Q2*P2Q2)-
     &16*P1P2**2/(3*P1Q1*P1Q2*P2Q2)
      V18=V18+32*A1*MT**2*P1P2**2/(3*P1Q1*P1Q2*P2Q2)+
     &32*A2*P1P2*P1Q1/(3*P1Q2*P2Q2)-
     &32*A1*A2*MB**2*P1P2*P1Q1/(3*P1Q2*P2Q2)-
     &32*A1*A2*MB*MT*P1P2*P1Q1/(3*P1Q2*P2Q2)-
     &64*A1*A2*P1P2**2*P1Q1/(3*P1Q2*P2Q2)-256*A2*P1Q2/(3*P2Q2)+
     &448*A1*A2*MB**2*P1Q2/(3*P2Q2)-368*A2**2*MB**2*P1Q2/(3*P2Q2)+
     &224*A1*A2*MB*MT*P1Q2/(3*P2Q2)+304*A1*A2*P1P2*P1Q2/(3*P2Q2)+
     &64*MT**2*P1Q2/(3*P1Q1**2*P2Q2)-
     &128*A1*MB**2*MT**2*P1Q2/(3*P1Q1**2*P2Q2)-
     &128*A1*MB*MT**3*P1Q2/(3*P1Q1**2*P2Q2)-
     &256*A1*MT**2*P1P2*P1Q2/(3*P1Q1**2*P2Q2)+8*P1Q2/(3*P1Q1*P2Q2)-
     &160*A1*MB**2*P1Q2/(3*P1Q1*P2Q2)-272*A2*MB**2*P1Q2/(3*P1Q1*P2Q2)+
     &56*A1*MB*MT*P1Q2/(3*P1Q1*P2Q2)+200*A2*MB*MT*P1Q2/(3*P1Q1*P2Q2)-
     &48*A1*P1P2*P1Q2/(P1Q1*P2Q2)-256*A2*P1P2*P1Q2/(3*P1Q1*P2Q2)+
     &256*A1*A2*MB**2*P1P2*P1Q2/(3*P1Q1*P2Q2)+
     &256*A1*A2*MB*MT*P1P2*P1Q2/(P1Q1*P2Q2)+
     &1024*A1*A2*P1P2**2*P1Q2/(3*P1Q1*P2Q2)
      V18=V18-272*A2*P1Q2**2/(3*P1Q1*P2Q2)+
     &256*A1*A2*MB**2*P1Q2**2/(3*P1Q1*P2Q2)+
     &256*A1*A2*MB*MT*P1Q2**2/(3*P1Q1*P2Q2)+
     &512*A1*A2*P1P2*P1Q2**2/(3*P1Q1*P2Q2)-32*A2*MB**4/(3*P2Q1*P2Q2)-
     &32*A2*MB**3*MT/(3*P2Q1*P2Q2)+64*A2**2*MB**5*MT/(3*P2Q1*P2Q2)+
     &16*P1P2/(3*P2Q1*P2Q2)-64*A2*MB**2*P1P2/(3*P2Q1*P2Q2)+
     &64*A2**2*MB**4*P1P2/(3*P2Q1*P2Q2)+8*MB**2*P1P2/(3*P1Q1*P2Q1*P2Q2)+
     &8*MB*MT*P1P2/(3*P1Q1*P2Q1*P2Q2)-
     &32*A2*MB**3*MT*P1P2/(3*P1Q1*P2Q1*P2Q2)+
     &16*P1P2**2/(3*P1Q1*P2Q1*P2Q2)-
     &32*A2*MB**2*P1P2**2/(3*P1Q1*P2Q1*P2Q2)-
     &16*A2*MB**2*P1Q1/(3*P2Q1*P2Q2)+64*A2**2*MB**4*P1Q1/(3*P2Q1*P2Q2)+
     &8*MB**2*P1P2/(3*P1Q2*P2Q1*P2Q2)+8*MB*MT*P1P2/(3*P1Q2*P2Q1*P2Q2)-
     &32*A2*MB**3*MT*P1P2/(3*P1Q2*P2Q1*P2Q2)+
     &16*P1P2**2/(3*P1Q2*P2Q1*P2Q2)-
     &32*A2*MB**2*P1P2**2/(3*P1Q2*P2Q1*P2Q2)+
     &16*MB*MT*P1P2**2/(3*P1Q1*P1Q2*P2Q1*P2Q2)
      V18=V18+16*P1P2**3/(3*P1Q1*P1Q2*P2Q1*P2Q2)-
     &32*A2*MB**2*P1P2*P1Q1/(3*P1Q2*P2Q1*P2Q2)-
     &16*A2*MB**2*P1Q2/(3*P2Q1*P2Q2)+64*A2**2*MB**4*P1Q2/(3*P2Q1*P2Q2)-
     &32*A2*MB**2*P1P2*P1Q2/(3*P1Q1*P2Q1*P2Q2)+272*A1*P2Q1/(3*P2Q2)+
     &112*A2*P2Q1/P2Q2-80*A1*A2*MB**2*P2Q1/P2Q2-
     &400*A1*A2*MB*MT*P2Q1/(3*P2Q2)+208*A2**2*MB*MT*P2Q1/(3*P2Q2)-
     &272*A1*A2*MT**2*P2Q1/(3*P2Q2)-320*A1*A2*P1P2*P2Q1/P2Q2+
     &96*A2**2*P1P2*P2Q1/P2Q2+256*A1*MB*MT**3*P2Q1/(3*P1Q1**2*P2Q2)+
     &512*A1*MT**2*P1P2*P2Q1/(3*P1Q1**2*P2Q2)-8*P2Q1/(3*P1Q1*P2Q2)-
     &200*A1*MB*MT*P2Q1/(3*P1Q1*P2Q2)-56*A2*MB*MT*P2Q1/(3*P1Q1*P2Q2)+
     &272*A1*MT**2*P2Q1/(3*P1Q1*P2Q2)+160*A2*MT**2*P2Q1/(3*P1Q1*P2Q2)+
     &256*A1*P1P2*P2Q1/(3*P1Q1*P2Q2)+48*A2*P1P2*P2Q1/(P1Q1*P2Q2)-
     &256*A1*A2*MB*MT*P1P2*P2Q1/(P1Q1*P2Q2)-
     &256*A1*A2*MT**2*P1P2*P2Q1/(3*P1Q1*P2Q2)-
     &1024*A1*A2*P1P2**2*P2Q1/(3*P1Q1*P2Q2)-
     &544*A1*A2*P1Q1*P2Q1/(3*P2Q2)-640*A2**2*P1Q1*P2Q1/(3*P2Q2)-
     &32*A1*P1P2*P2Q1/(3*P1Q2*P2Q2)
      V18=V18+32*A1*A2*MB*MT*P1P2*P2Q1/(3*P1Q2*P2Q2)+
     &32*A1*A2*MT**2*P1P2*P2Q1/(3*P1Q2*P2Q2)+
     &64*A1*A2*P1P2**2*P2Q1/(3*P1Q2*P2Q2)-
     &32*A1*MT**2*P1P2*P2Q1/(3*P1Q1*P1Q2*P2Q2)+
     &64*A1*A2*P1P2*P1Q1*P2Q1/(3*P1Q2*P2Q2)-
     &944*A1*A2*P1Q2*P2Q1/(3*P2Q2)-32*A2**2*P1Q2*P2Q1/P2Q2+
     &256*A1*MT**2*P1Q2*P2Q1/(3*P1Q1**2*P2Q2)+
     &96*A1*P1Q2*P2Q1/(P1Q1*P2Q2)+96*A2*P1Q2*P2Q1/(P1Q1*P2Q2)-
     &128*A1*A2*MB**2*P1Q2*P2Q1/(3*P1Q1*P2Q2)-
     &256*A1*A2*MB*MT*P1Q2*P2Q1/(P1Q1*P2Q2)-
     &128*A1*A2*MT**2*P1Q2*P2Q1/(3*P1Q1*P2Q2)-
     &512*A1*A2*P1P2*P1Q2*P2Q1/(P1Q1*P2Q2)-
     &512*A1*A2*P1Q2**2*P2Q1/(3*P1Q1*P2Q2)+544*A1*A2*P2Q1**2/(3*P2Q2)-
     &256*A1*MT**2*P2Q1**2/(3*P1Q1**2*P2Q2)-
     &272*A1*P2Q1**2/(3*P1Q1*P2Q2)+
     &256*A1*A2*MB*MT*P2Q1**2/(3*P1Q1*P2Q2)+
     &256*A1*A2*MT**2*P2Q1**2/(3*P1Q1*P2Q2)
      V18=V18+512*A1*A2*P1P2*P2Q1**2/(3*P1Q1*P2Q2)+
     &512*A1*A2*P1Q2*P2Q1**2/(3*P1Q1*P2Q2)+224*A12*P2Q2+
     &656*A1*A2*P2Q2/3+256*A12*MT**4*P2Q2/(3*P1Q1**2)+
     &16*A1*P2Q2/(3*P1Q1)+112*A1*A2*MB*MT*P2Q2/(3*P1Q1)+
     &32*A12*MT**2*P2Q2/(3*P1Q1)+64*A1*A2*MT**2*P2Q2/P1Q1+
     &368*A1*A2*P1P2*P2Q2/(3*P1Q1)-256*A1*MT**2*P2Q2/(3*P1Q2**2)+
     &256*A12*MT**4*P2Q2/(3*P1Q2**2)-256*A1*P2Q2/(3*P1Q2)+
     &224*A1*A2*MB*MT*P2Q2/(3*P1Q2)-368*A12*MT**2*P2Q2/(3*P1Q2)+
     &448*A1*A2*MT**2*P2Q2/(3*P1Q2)+304*A1*A2*P1P2*P2Q2/(3*P1Q2)+
     &16*A1*MT**2*P2Q2/(3*P1Q1*P1Q2)-64*A12*MT**4*P2Q2/(3*P1Q1*P1Q2)+
     &32*A12*P1Q1*P2Q2/P1Q2+944*A1*A2*P1Q1*P2Q2/(3*P1Q2)+
     &256*A12*MT**2*P1Q2*P2Q2/(3*P1Q1**2)+
     &640*A12*P1Q2*P2Q2/(3*P1Q1)+544*A1*A2*P1Q2*P2Q2/(3*P1Q1)-
     &256*A2*MB**2*P2Q2/(3*P2Q1**2)-256*A2**2*MB**3*MT*P2Q2/(3*P2Q1**2)+
     &64*MB**2*MT**2*P2Q2/(3*P1Q2**2*P2Q1**2)+
     &64*MB**2*P2Q2/(3*P1Q2*P2Q1**2)-
     &128*A2*MB**3*MT*P2Q2/(3*P1Q2*P2Q1**2)
      V18=V18-128*A2*MB**2*MT**2*P2Q2/(3*P1Q2*P2Q1**2)-
     &256*A2*MB**2*P1P2*P2Q2/(3*P1Q2*P2Q1**2)-
     &256*A2*MB**2*P1Q1*P2Q2/(3*P1Q2*P2Q1**2)+
     &256*A2**2*MB**2*P1Q2*P2Q2/(3*P2Q1**2)+272*A1*P2Q2/(3*P2Q1)+
     &112*A2*P2Q2/P2Q1-80*A1*A2*MB**2*P2Q2/P2Q1-
     &400*A1*A2*MB*MT*P2Q2/(3*P2Q1)+208*A2**2*MB*MT*P2Q2/(3*P2Q1)-
     &272*A1*A2*MT**2*P2Q2/(3*P2Q1)-320*A1*A2*P1P2*P2Q2/P2Q1+
     &96*A2**2*P1P2*P2Q2/P2Q1-32*A1*P1P2*P2Q2/(3*P1Q1*P2Q1)+
     &32*A1*A2*MB*MT*P1P2*P2Q2/(3*P1Q1*P2Q1)+
     &32*A1*A2*MT**2*P1P2*P2Q2/(3*P1Q1*P2Q1)+
     &64*A1*A2*P1P2**2*P2Q2/(3*P1Q1*P2Q1)-944*A1*A2*P1Q1*P2Q2/(3*P2Q1)-
     &32*A2**2*P1Q1*P2Q2/P2Q1+256*A1*MB*MT**3*P2Q2/(3*P1Q2**2*P2Q1)+
     &512*A1*MT**2*P1P2*P2Q2/(3*P1Q2**2*P2Q1)+
     &256*A1*MT**2*P1Q1*P2Q2/(3*P1Q2**2*P2Q1)-8*P2Q2/(3*P1Q2*P2Q1)-
     &200*A1*MB*MT*P2Q2/(3*P1Q2*P2Q1)-56*A2*MB*MT*P2Q2/(3*P1Q2*P2Q1)+
     &272*A1*MT**2*P2Q2/(3*P1Q2*P2Q1)+160*A2*MT**2*P2Q2/(3*P1Q2*P2Q1)+
     &256*A1*P1P2*P2Q2/(3*P1Q2*P2Q1)+48*A2*P1P2*P2Q2/(P1Q2*P2Q1)
      V18=V18-256*A1*A2*MB*MT*P1P2*P2Q2/(P1Q2*P2Q1)-
     &256*A1*A2*MT**2*P1P2*P2Q2/(3*P1Q2*P2Q1)-
     &1024*A1*A2*P1P2**2*P2Q2/(3*P1Q2*P2Q1)-
     &32*A1*MT**2*P1P2*P2Q2/(3*P1Q1*P1Q2*P2Q1)+
     &96*A1*P1Q1*P2Q2/(P1Q2*P2Q1)+96*A2*P1Q1*P2Q2/(P1Q2*P2Q1)-
     &128*A1*A2*MB**2*P1Q1*P2Q2/(3*P1Q2*P2Q1)-
     &256*A1*A2*MB*MT*P1Q1*P2Q2/(P1Q2*P2Q1)-
     &128*A1*A2*MT**2*P1Q1*P2Q2/(3*P1Q2*P2Q1)-
     &512*A1*A2*P1P2*P1Q1*P2Q2/(P1Q2*P2Q1)-
     &512*A1*A2*P1Q1**2*P2Q2/(3*P1Q2*P2Q1)-544*A1*A2*P1Q2*P2Q2/(3*P2Q1)-
     &640*A2**2*P1Q2*P2Q2/(3*P2Q1)+
     &64*A1*A2*P1P2*P1Q2*P2Q2/(3*P1Q1*P2Q1)+544*A1*A2*P2Q2**2/(3*P2Q1)-
     &256*A1*MT**2*P2Q2**2/(3*P1Q2**2*P2Q1)-
     &272*A1*P2Q2**2/(3*P1Q2*P2Q1)+
     &256*A1*A2*MB*MT*P2Q2**2/(3*P1Q2*P2Q1)+
     &256*A1*A2*MT**2*P2Q2**2/(3*P1Q2*P2Q1)+
     &512*A1*A2*P1P2*P2Q2**2/(3*P1Q2*P2Q1)
      V18=V18+512*A1*A2*P1Q1*P2Q2**2/(3*P1Q2*P2Q1)+
     &384*A12*MB*MT*P1Q1**2/S**2+
     &384*A12*P1P2*P1Q1**2/S**2+2688*A12*MB*MT*P1Q1*P1Q2/S**2+
     &2688*A12*P1P2*P1Q1*P1Q2/S**2+384*A12*MB*MT*P1Q2**2/S**2+
     &384*A12*P1P2*P1Q2**2/S**2+768*A1*A2*MB*MT*P1Q1*P2Q1/S**2+
     &768*A1*A2*P1P2*P1Q1*P2Q1/S**2+2688*A1*A2*MB*MT*P1Q2*P2Q1/S**2+
     &2688*A1*A2*P1P2*P1Q2*P2Q1/S**2-960*A12*P1Q1*P1Q2*P2Q1/S**2-
     &960*A1*A2*P1Q1*P1Q2*P2Q1/S**2+960*A12*P1Q2**2*P2Q1/S**2+
     &960*A1*A2*P1Q2**2*P2Q1/S**2+384*A2**2*MB*MT*P2Q1**2/S**2+
     &384*A2**2*P1P2*P2Q1**2/S**2-960*A1*A2*P1Q2*P2Q1**2/S**2-
     &960*A2**2*P1Q2*P2Q1**2/S**2+2688*A1*A2*MB*MT*P1Q1*P2Q2/S**2+
     &2688*A1*A2*P1P2*P1Q1*P2Q2/S**2+960*A12*P1Q1**2*P2Q2/S**2+
     &960*A1*A2*P1Q1**2*P2Q2/S**2+768*A1*A2*MB*MT*P1Q2*P2Q2/S**2+
     &768*A1*A2*P1P2*P1Q2*P2Q2/S**2-960*A12*P1Q1*P1Q2*P2Q2/S**2-
     &960*A1*A2*P1Q1*P1Q2*P2Q2/S**2+2688*A2**2*MB*MT*P2Q1*P2Q2/S**2+
     &2688*A2**2*P1P2*P2Q1*P2Q2/S**2+960*A1*A2*P1Q1*P2Q1*P2Q2/S**2+
     &960*A2**2*P1Q1*P2Q1*P2Q2/S**2+960*A1*A2*P1Q2*P2Q1*P2Q2/S**2+
     &960*A2**2*P1Q2*P2Q1*P2Q2/S**2+384*A2**2*MB*MT*P2Q2**2/S**2
      V18=V18+384*A2**2*P1P2*P2Q2**2/S**2-960*A1*A2*P1Q1*P2Q2**2/S**2-
     &960*A2**2*P1Q1*P2Q2**2/S**2+96*A1*MB*MT/S+96*A2*MB*MT/S-
     &768*A2**2*MB**3*MT/S-768*A12*MB*MT**3/S-192*A1*P1P2/S-
     &192*A2*P1P2/S-768*A2**2*MB**2*P1P2/S-2304*A1*A2*MB*MT*P1P2/S-
     &768*A12*MT**2*P1P2/S-2304*A1*A2*P1P2**2/S-
     &96*A1*MB*MT**3/(P1Q1*S)-192*A2*MB*MT*P1P2/(P1Q1*S)-
     &96*A1*MT**2*P1P2/(P1Q1*S)-192*A2*P1P2**2/(P1Q1*S)-192*A1*P1Q1/S-
     &144*A2*P1Q1/S-384*A1*A2*MB**2*P1Q1/S-480*A2**2*MB**2*P1Q1/S-
     &480*A12*MB*MT*P1Q1/S+96*A1*A2*MB*MT*P1Q1/S-
     &864*A12*P1P2*P1Q1/S-672*A1*A2*P1P2*P1Q1/S-96*A1*A2*P1Q1**2/S-
     &96*A1*MB*MT**3/(P1Q2*S)-192*A2*MB*MT*P1P2/(P1Q2*S)-
     &96*A1*MT**2*P1P2/(P1Q2*S)-192*A2*P1P2**2/(P1Q2*S)-
     &48*A1*MB*MT*P1Q1/(P1Q2*S)+96*A2*MB*MT*P1Q1/(P1Q2*S)-
     &48*A1*MT**2*P1Q1/(P1Q2*S)-192*A1*P1P2*P1Q1/(P1Q2*S)-
     &192*A2*P1P2*P1Q1/(P1Q2*S)+192*A1*A2*MB*MT*P1P2*P1Q1/(P1Q2*S)+
     &192*A1*A2*P1P2**2*P1Q1/(P1Q2*S)-192*A1*P1Q1**2/(P1Q2*S)-
     &192*A2*P1Q1**2/(P1Q2*S)+192*A1*A2*MB**2*P1Q1**2/(P1Q2*S)
      V18=V18-192*A12*MB*MT*P1Q1**2/(P1Q2*S)+
     &96*A1*A2*MB*MT*P1Q1**2/(P1Q2*S)+
     &192*A1*A2*P1P2*P1Q1**2/(P1Q2*S)-192*A1*P1Q2/S-144*A2*P1Q2/S-
     &384*A1*A2*MB**2*P1Q2/S-480*A2**2*MB**2*P1Q2/S-
     &480*A12*MB*MT*P1Q2/S+96*A1*A2*MB*MT*P1Q2/S-
     &864*A12*P1P2*P1Q2/S-672*A1*A2*P1P2*P1Q2/S-
     &48*A1*MB*MT*P1Q2/(P1Q1*S)+96*A2*MB*MT*P1Q2/(P1Q1*S)-
     &48*A1*MT**2*P1Q2/(P1Q1*S)-192*A1*P1P2*P1Q2/(P1Q1*S)-
     &192*A2*P1P2*P1Q2/(P1Q1*S)+192*A1*A2*MB*MT*P1P2*P1Q2/(P1Q1*S)+
     &192*A1*A2*P1P2**2*P1Q2/(P1Q1*S)-576*A1*A2*P1Q1*P1Q2/S-
     &96*A1*A2*P1Q2**2/S-192*A1*P1Q2**2/(P1Q1*S)-
     &192*A2*P1Q2**2/(P1Q1*S)+192*A1*A2*MB**2*P1Q2**2/(P1Q1*S)-
     &192*A12*MB*MT*P1Q2**2/(P1Q1*S)+96*A1*A2*MB*MT*P1Q2**2/(P1Q1*S)+
     &192*A1*A2*P1P2*P1Q2**2/(P1Q1*S)+96*A2*MB**3*MT/(P2Q1*S)+
     &96*A2*MB**2*P1P2/(P2Q1*S)+192*A1*MB*MT*P1P2/(P2Q1*S)+
     &192*A1*P1P2**2/(P2Q1*S)+96*A1*MB**2*P1Q1/(P2Q1*S)+
     &192*A2*MB**2*P1Q1/(P2Q1*S)+96*A1*MB*MT*P1Q1/(P2Q1*S)+
     &192*A1*A2*MB**3*MT*P1Q1/(P2Q1*S)+192*A1*P1P2*P1Q1/(P2Q1*S)
      V18=V18+192*A1*A2*MB**2*P1P2*P1Q1/(P2Q1*S)+
     &96*A1*A2*MB**2*P1Q1**2/(P2Q1*S)+
     &192*A2*MB**3*MT*P1Q1/(P1Q2*P2Q1*S)+
     &192*A2*MB**2*P1P2*P1Q1/(P1Q2*P2Q1*S)+
     &96*A1*MB*MT*P1P2*P1Q1/(P1Q2*P2Q1*S)+
     &96*A1*P1P2**2*P1Q1/(P1Q2*P2Q1*S)+
     &96*A1*MB**2*P1Q1**2/(P1Q2*P2Q1*S)+
     &192*A2*MB**2*P1Q1**2/(P1Q2*P2Q1*S)+
     &48*A1*MB*MT*P1Q1**2/(P1Q2*P2Q1*S)+
     &96*A1*P1P2*P1Q1**2/(P1Q2*P2Q1*S)+96*A1*MB**2*P1Q2/(P2Q1*S)+
     &48*A2*MB**2*P1Q2/(P2Q1*S)-192*A1*A2*MB**3*MT*P1Q2/(P2Q1*S)-
     &192*A1*A2*MB**2*P1P2*P1Q2/(P2Q1*S)-
     &96*A1*A2*MB**2*P1Q2**2/(P2Q1*S)+144*A1*P2Q1/S+192*A2*P2Q1/S-
     &96*A1*A2*MB*MT*P2Q1/S+480*A2**2*MB*MT*P2Q1/S+
     &480*A12*MT**2*P2Q1/S+384*A1*A2*MT**2*P2Q1/S+
     &672*A1*A2*P1P2*P2Q1/S+864*A2**2*P1P2*P2Q1/S+
     &96*A2*MB*MT*P2Q1/(P1Q1*S)+192*A1*MT**2*P2Q1/(P1Q1*S)
      V18=V18+96*A2*MT**2*P2Q1/(P1Q1*S)+
     &192*A1*A2*MB*MT**3*P2Q1/(P1Q1*S)+
     &192*A2*P1P2*P2Q1/(P1Q1*S)+192*A1*A2*MT**2*P1P2*P2Q1/(P1Q1*S)-
     &192*A12*P1Q1*P2Q1/S-192*A2**2*P1Q1*P2Q1/S+
     &48*A1*MT**2*P2Q1/(P1Q2*S)+96*A2*MT**2*P2Q1/(P1Q2*S)-
     &192*A1*A2*MB*MT**3*P2Q1/(P1Q2*S)-
     &192*A1*A2*MT**2*P1P2*P2Q1/(P1Q2*S)-
     &96*A1*A2*MB*MT*P1Q1*P2Q1/(P1Q2*S)-
     &192*A12*MT**2*P1Q1*P2Q1/(P1Q2*S)-
     &96*A1*A2*MT**2*P1Q1*P2Q1/(P1Q2*S)-
     &384*A1*A2*P1P2*P1Q1*P2Q1/(P1Q2*S)-384*A12*P1Q1**2*P2Q1/(P1Q2*S)-
     &384*A1*A2*P1Q1**2*P2Q1/(P1Q2*S)-480*A12*P1Q2*P2Q1/S-
     &960*A1*A2*P1Q2*P2Q1/S-480*A2**2*P1Q2*P2Q1/S+
     &144*A1*P1Q2*P2Q1/(P1Q1*S)+96*A2*P1Q2*P2Q1/(P1Q1*S)-
     &384*A1*A2*MB*MT*P1Q2*P2Q1/(P1Q1*S)-
     &96*A12*MT**2*P1Q2*P2Q1/(P1Q1*S)+
     &96*A1*A2*MT**2*P1Q2*P2Q1/(P1Q1*S)-
     &576*A1*A2*P1P2*P1Q2*P2Q1/(P1Q1*S)-192*A12*P1Q2**2*P2Q1/(P1Q1*S)
      V18=V18-384*A1*A2*P1Q2**2*P2Q1/(P1Q1*S)-96*A1*A2*P2Q1**2/S-
     &96*A1*A2*MT**2*P2Q1**2/(P1Q1*S)+96*A1*A2*MT**2*P2Q1**2/(P1Q2*S)+
     &288*A1*A2*P1Q2*P2Q1**2/(P1Q1*S)+96*A2*MB**3*MT/(P2Q2*S)+
     &96*A2*MB**2*P1P2/(P2Q2*S)+192*A1*MB*MT*P1P2/(P2Q2*S)+
     &192*A1*P1P2**2/(P2Q2*S)+96*A1*MB**2*P1Q1/(P2Q2*S)+
     &48*A2*MB**2*P1Q1/(P2Q2*S)-192*A1*A2*MB**3*MT*P1Q1/(P2Q2*S)-
     &192*A1*A2*MB**2*P1P2*P1Q1/(P2Q2*S)-
     &96*A1*A2*MB**2*P1Q1**2/(P2Q2*S)+96*A1*MB**2*P1Q2/(P2Q2*S)+
     &192*A2*MB**2*P1Q2/(P2Q2*S)+96*A1*MB*MT*P1Q2/(P2Q2*S)+
     &192*A1*A2*MB**3*MT*P1Q2/(P2Q2*S)+192*A1*P1P2*P1Q2/(P2Q2*S)+
     &192*A1*A2*MB**2*P1P2*P1Q2/(P2Q2*S)+
     &192*A2*MB**3*MT*P1Q2/(P1Q1*P2Q2*S)+
     &192*A2*MB**2*P1P2*P1Q2/(P1Q1*P2Q2*S)+
     &96*A1*MB*MT*P1P2*P1Q2/(P1Q1*P2Q2*S)+
     &96*A1*P1P2**2*P1Q2/(P1Q1*P2Q2*S)+96*A1*A2*MB**2*P1Q2**2/(P2Q2*S)+
     &96*A1*MB**2*P1Q2**2/(P1Q1*P2Q2*S)+
     &192*A2*MB**2*P1Q2**2/(P1Q1*P2Q2*S)
      V18=V18+48*A1*MB*MT*P1Q2**2/(P1Q1*P2Q2*S)+
     &96*A1*P1P2*P1Q2**2/(P1Q1*P2Q2*S)-48*A2*MB**2*P2Q1/(P2Q2*S)+
     &96*A1*MB*MT*P2Q1/(P2Q2*S)-48*A2*MB*MT*P2Q1/(P2Q2*S)-
     &192*A1*P1P2*P2Q1/(P2Q2*S)-192*A2*P1P2*P2Q1/(P2Q2*S)+
     &192*A1*A2*MB*MT*P1P2*P2Q1/(P2Q2*S)+
     &192*A1*A2*P1P2**2*P2Q1/(P2Q2*S)-
     &192*A1*MB*MT**3*P2Q1/(P1Q1*P2Q2*S)-
     &96*A2*MB*MT*P1P2*P2Q1/(P1Q1*P2Q2*S)-
     &192*A1*MT**2*P1P2*P2Q1/(P1Q1*P2Q2*S)-
     &96*A2*P1P2**2*P2Q1/(P1Q1*P2Q2*S)+
     &96*A1*A2*MB**2*P1Q1*P2Q1/(P2Q2*S)+
     &192*A2**2*MB**2*P1Q1*P2Q1/(P2Q2*S)+
     &96*A1*A2*MB*MT*P1Q1*P2Q1/(P2Q2*S)+
     &384*A1*A2*P1P2*P1Q1*P2Q1/(P2Q2*S)-96*A1*P1Q2*P2Q1/(P2Q2*S)-
     &144*A2*P1Q2*P2Q1/(P2Q2*S)-96*A1*A2*MB**2*P1Q2*P2Q1/(P2Q2*S)+
     &96*A2**2*MB**2*P1Q2*P2Q1/(P2Q2*S)+
     &384*A1*A2*MB*MT*P1Q2*P2Q1/(P2Q2*S)
      V18=V18+576*A1*A2*P1P2*P1Q2*P2Q1/(P2Q2*S)-
     &96*A2*MB**2*P1Q2*P2Q1/(P1Q1*P2Q2*S)+
     &48*A1*MB*MT*P1Q2*P2Q1/(P1Q1*P2Q2*S)+
     &48*A2*MB*MT*P1Q2*P2Q1/(P1Q1*P2Q2*S)-
     &96*A1*MT**2*P1Q2*P2Q1/(P1Q1*P2Q2*S)-
     &96*A1*P1P2*P1Q2*P2Q1/(P1Q1*P2Q2*S)-
     &96*A2*P1P2*P1Q2*P2Q1/(P1Q1*P2Q2*S)+
     &96*A1*A2*P1Q1*P1Q2*P2Q1/(P2Q2*S)+288*A1*A2*P1Q2**2*P2Q1/(P2Q2*S)-
     &96*A1*P1Q2**2*P2Q1/(P1Q1*P2Q2*S)-96*A2*P1Q2**2*P2Q1/(P1Q1*P2Q2*S)+
     &192*A1*P2Q1**2/(P2Q2*S)+192*A2*P2Q1**2/(P2Q2*S)-
     &96*A1*A2*MB*MT*P2Q1**2/(P2Q2*S)+192*A2**2*MB*MT*P2Q1**2/(P2Q2*S)-
     &192*A1*A2*MT**2*P2Q1**2/(P2Q2*S)-192*A1*A2*P1P2*P2Q1**2/(P2Q2*S)+
     &48*A2*MB*MT*P2Q1**2/(P1Q1*P2Q2*S)+
     &192*A1*MT**2*P2Q1**2/(P1Q1*P2Q2*S)+
     &96*A2*MT**2*P2Q1**2/(P1Q1*P2Q2*S)+
     &96*A2*P1P2*P2Q1**2/(P1Q1*P2Q2*S)-384*A1*A2*P1Q1*P2Q1**2/(P2Q2*S)-
     &384*A2**2*P1Q1*P2Q1**2/(P2Q2*S)-384*A1*A2*P1Q2*P2Q1**2/(P2Q2*S)
      V18=V18-192*A2**2*P1Q2*P2Q1**2/(P2Q2*S)+
     &96*A1*P1Q2*P2Q1**2/(P1Q1*P2Q2*S)+
     &96*A2*P1Q2*P2Q1**2/(P1Q1*P2Q2*S)+144*A1*P2Q2/S+192*A2*P2Q2/S-
     &96*A1*A2*MB*MT*P2Q2/S+480*A2**2*MB*MT*P2Q2/S+
     &480*A12*MT**2*P2Q2/S+384*A1*A2*MT**2*P2Q2/S+
     &672*A1*A2*P1P2*P2Q2/S+864*A2**2*P1P2*P2Q2/S+
     &48*A1*MT**2*P2Q2/(P1Q1*S)+96*A2*MT**2*P2Q2/(P1Q1*S)-
     &192*A1*A2*MB*MT**3*P2Q2/(P1Q1*S)-
     &192*A1*A2*MT**2*P1P2*P2Q2/(P1Q1*S)-480*A12*P1Q1*P2Q2/S-
     &960*A1*A2*P1Q1*P2Q2/S-480*A2**2*P1Q1*P2Q2/S+
     &96*A2*MB*MT*P2Q2/(P1Q2*S)+192*A1*MT**2*P2Q2/(P1Q2*S)+
     &96*A2*MT**2*P2Q2/(P1Q2*S)+192*A1*A2*MB*MT**3*P2Q2/(P1Q2*S)+
     &192*A2*P1P2*P2Q2/(P1Q2*S)+192*A1*A2*MT**2*P1P2*P2Q2/(P1Q2*S)+
     &144*A1*P1Q1*P2Q2/(P1Q2*S)+96*A2*P1Q1*P2Q2/(P1Q2*S)-
     &384*A1*A2*MB*MT*P1Q1*P2Q2/(P1Q2*S)-
     &96*A12*MT**2*P1Q1*P2Q2/(P1Q2*S)+
     &96*A1*A2*MT**2*P1Q1*P2Q2/(P1Q2*S)
      V18=V18-576*A1*A2*P1P2*P1Q1*P2Q2/(P1Q2*S)-
     &192*A12*P1Q1**2*P2Q2/(P1Q2*S)-
     &384*A1*A2*P1Q1**2*P2Q2/(P1Q2*S)-192*A12*P1Q2*P2Q2/S-
     &192*A2**2*P1Q2*P2Q2/S-96*A1*A2*MB*MT*P1Q2*P2Q2/(P1Q1*S)-
     &192*A12*MT**2*P1Q2*P2Q2/(P1Q1*S)-
     &96*A1*A2*MT**2*P1Q2*P2Q2/(P1Q1*S)-
     &384*A1*A2*P1P2*P1Q2*P2Q2/(P1Q1*S)-384*A12*P1Q2**2*P2Q2/(P1Q1*S)-
     &384*A1*A2*P1Q2**2*P2Q2/(P1Q1*S)-48*A2*MB**2*P2Q2/(P2Q1*S)+
     &96*A1*MB*MT*P2Q2/(P2Q1*S)-48*A2*MB*MT*P2Q2/(P2Q1*S)-
     &192*A1*P1P2*P2Q2/(P2Q1*S)-192*A2*P1P2*P2Q2/(P2Q1*S)+
     &192*A1*A2*MB*MT*P1P2*P2Q2/(P2Q1*S)+
     &192*A1*A2*P1P2**2*P2Q2/(P2Q1*S)-96*A1*P1Q1*P2Q2/(P2Q1*S)-
     &144*A2*P1Q1*P2Q2/(P2Q1*S)-96*A1*A2*MB**2*P1Q1*P2Q2/(P2Q1*S)+
     &96*A2**2*MB**2*P1Q1*P2Q2/(P2Q1*S)+
     &384*A1*A2*MB*MT*P1Q1*P2Q2/(P2Q1*S)+
     &576*A1*A2*P1P2*P1Q1*P2Q2/(P2Q1*S)+288*A1*A2*P1Q1**2*P2Q2/(P2Q1*S)-
     &192*A1*MB*MT**3*P2Q2/(P1Q2*P2Q1*S)
      V18=V18-96*A2*MB*MT*P1P2*P2Q2/(P1Q2*P2Q1*S)-
     &192*A1*MT**2*P1P2*P2Q2/(P1Q2*P2Q1*S)-
     &96*A2*P1P2**2*P2Q2/(P1Q2*P2Q1*S)-
     &96*A2*MB**2*P1Q1*P2Q2/(P1Q2*P2Q1*S)+
     &48*A1*MB*MT*P1Q1*P2Q2/(P1Q2*P2Q1*S)
 
      V18BIS=
     &48*A2*MB*MT*P1Q1*P2Q2/(P1Q2*P2Q1*S)-
     &96*A1*MT**2*P1Q1*P2Q2/(P1Q2*P2Q1*S)-
     &96*A1*P1P2*P1Q1*P2Q2/(P1Q2*P2Q1*S)-
     &96*A2*P1P2*P1Q1*P2Q2/(P1Q2*P2Q1*S)-
     &96*A1*P1Q1**2*P2Q2/(P1Q2*P2Q1*S)-96*A2*P1Q1**2*P2Q2/(P1Q2*P2Q1*S)+
     &96*A1*A2*MB**2*P1Q2*P2Q2/(P2Q1*S)+
     &192*A2**2*MB**2*P1Q2*P2Q2/(P2Q1*S)+
     &96*A1*A2*MB*MT*P1Q2*P2Q2/(P2Q1*S)+
     &384*A1*A2*P1P2*P1Q2*P2Q2/(P2Q1*S)+
     &96*A1*A2*P1Q1*P1Q2*P2Q2/(P2Q1*S)-576*A1*A2*P2Q1*P2Q2/S+
     &96*A1*A2*P1Q1*P2Q1*P2Q2/(P1Q2*S)+96*A1*A2*P1Q2*P2Q1*P2Q2/(P1Q1*S)-
     &96*A1*A2*P2Q2**2/S+96*A1*A2*MT**2*P2Q2**2/(P1Q1*S)-
     &96*A1*A2*MT**2*P2Q2**2/(P1Q2*S)+288*A1*A2*P1Q1*P2Q2**2/(P1Q2*S)+
     &192*A1*P2Q2**2/(P2Q1*S)+192*A2*P2Q2**2/(P2Q1*S)-
     &96*A1*A2*MB*MT*P2Q2**2/(P2Q1*S)+192*A2**2*MB*MT*P2Q2**2/(P2Q1*S)-
     &192*A1*A2*MT**2*P2Q2**2/(P2Q1*S)-192*A1*A2*P1P2*P2Q2**2/(P2Q1*S)
      V18BIS=V18BIS-384*A1*A2*P1Q1*P2Q2**2/(P2Q1*S)-
     &192*A2**2*P1Q1*P2Q2**2/(P2Q1*S)+
     &48*A2*MB*MT*P2Q2**2/(P1Q2*P2Q1*S)+
     &192*A1*MT**2*P2Q2**2/(P1Q2*P2Q1*S)+
     &96*A2*MT**2*P2Q2**2/(P1Q2*P2Q1*S)+
     &96*A2*P1P2*P2Q2**2/(P1Q2*P2Q1*S)+96*A1*P1Q1*P2Q2**2/(P1Q2*P2Q1*S)+
     &96*A2*P1Q1*P2Q2**2/(P1Q2*P2Q1*S)-384*A1*A2*P1Q2*P2Q2**2/(P2Q1*S)-
     &384*A2**2*P1Q2*P2Q2**2/(P2Q1*S)+512*A1*A2*S/3-
     &128*A1*MT**2*S/(3*P1Q1**2)-128*A12*MB*MT**3*S/(3*P1Q1**2)-
     &152*A1*S/(3*P1Q1)+152*A12*MB*MT*S/(3*P1Q1)+
     &128*A1*A2*MB*MT*S/(3*P1Q1)+112*A1*A2*MT**2*S/(3*P1Q1)-
     &16*A12*P1P2*S/P1Q1+152*A1*A2*P1P2*S/(3*P1Q1)-
     &128*A1*MT**2*S/(3*P1Q2**2)-128*A12*MB*MT**3*S/(3*P1Q2**2)-
     &152*A1*S/(3*P1Q2)+152*A12*MB*MT*S/(3*P1Q2)+
     &128*A1*A2*MB*MT*S/(3*P1Q2)+112*A1*A2*MT**2*S/(3*P1Q2)-
     &16*A12*P1P2*S/P1Q2+152*A1*A2*P1P2*S/(3*P1Q2)-
     &16*A1*MB*MT*S/(3*P1Q1*P1Q2)+32*A12*MB*MT**3*S/(3*P1Q1*P1Q2)
      V18BIS=V18BIS-16*A1*P1P2*S/(3*P1Q1*P1Q2)+
     &272*A1*A2*P1Q1*S/(3*P1Q2)+
     &272*A1*A2*P1Q2*S/(3*P1Q1)-128*A2*MB**2*S/(3*P2Q1**2)-
     &128*A2**2*MB**3*MT*S/(3*P2Q1**2)+
     &32*MB**2*MT**2*S/(3*P1Q2**2*P2Q1**2)+32*MB**2*S/(3*P1Q2*P2Q1**2)-
     &64*A2*MB**3*MT*S/(3*P1Q2*P2Q1**2)-
     &64*A2*MB**2*MT**2*S/(3*P1Q2*P2Q1**2)-
     &128*A2*MB**2*P1P2*S/(3*P1Q2*P2Q1**2)-
     &128*A2*MB**2*P1Q1*S/(3*P1Q2*P2Q1**2)+
     &128*A2**2*MB**2*P1Q2*S/(3*P2Q1**2)+152*A2*S/(3*P2Q1)-
     &112*A1*A2*MB**2*S/(3*P2Q1)-128*A1*A2*MB*MT*S/(3*P2Q1)-
     &152*A2**2*MB*MT*S/(3*P2Q1)-152*A1*A2*P1P2*S/(3*P2Q1)+
     &16*A2**2*P1P2*S/P2Q1+8*A1*A2*MB**3*MT*S/(3*P1Q1*P2Q1)+
     &16*A1*A2*MB**2*MT**2*S/(3*P1Q1*P2Q1)+
     &8*A1*A2*MB*MT**3*S/(3*P1Q1*P2Q1)-8*A1*P1P2*S/(3*P1Q1*P2Q1)-
     &8*A2*P1P2*S/(3*P1Q1*P2Q1)+8*A1*A2*MB**2*P1P2*S/(3*P1Q1*P2Q1)+
     &16*A1*A2*MB*MT*P1P2*S/(3*P1Q1*P2Q1)
      V18BIS=V18BIS+8*A1*A2*MT**2*P1P2*S/(3*P1Q1*P2Q1)+
     &32*A1*A2*P1P2**2*S/(3*P1Q1*P2Q1)-32*A2**2*P1Q1*S/(3*P2Q1)-
     &32*MT**2*S/(3*P1Q2**2*P2Q1)+64*A1*MB**2*MT**2*S/(3*P1Q2**2*P2Q1)+
     &64*A1*MB*MT**3*S/(3*P1Q2**2*P2Q1)+
     &128*A1*MT**2*P1P2*S/(3*P1Q2**2*P2Q1)-12*S/(P1Q2*P2Q1)+
     &24*A1*MB**2*S/(P1Q2*P2Q1)-64*A1*A2*MB**3*MT*S/(3*P1Q2*P2Q1)+
     &24*A2*MT**2*S/(P1Q2*P2Q1)-128*A1*A2*MB**2*MT**2*S/(3*P1Q2*P2Q1)-
     &64*A1*A2*MB*MT**3*S/(3*P1Q2*P2Q1)+56*A1*P1P2*S/(3*P1Q2*P2Q1)+
     &56*A2*P1P2*S/(3*P1Q2*P2Q1)-64*A1*A2*MB**2*P1P2*S/(3*P1Q2*P2Q1)-
     &128*A1*A2*MB*MT*P1P2*S/(3*P1Q2*P2Q1)-
     &64*A1*A2*MT**2*P1P2*S/(3*P1Q2*P2Q1)-
     &256*A1*A2*P1P2**2*S/(3*P1Q2*P2Q1)+4*P1P2*S/(3*P1Q1*P1Q2*P2Q1)+
     &8*A1*MB*MT*P1P2*S/(3*P1Q1*P1Q2*P2Q1)-
     &8*A1*MT**2*P1P2*S/(3*P1Q1*P1Q2*P2Q1)+136*A2*P1Q1*S/(3*P1Q2*P2Q1)-
     &128*A1*A2*MB**2*P1Q1*S/(3*P1Q2*P2Q1)-
     &128*A1*A2*MB*MT*P1Q1*S/(3*P1Q2*P2Q1)-
     &256*A1*A2*P1P2*P1Q1*S/(3*P1Q2*P2Q1)-160*A2**2*P1Q2*S/(3*P2Q1)
      V18BIS=V18BIS+16*A1*A2*P1P2*P1Q2*S/(3*P1Q1*P2Q1)-
     &32*A12*P2Q1*S/(3*P1Q1)-
     &128*A12*MT**2*P2Q1*S/(3*P1Q2**2)-160*A12*P2Q1*S/(3*P1Q2)-
     &128*A2*MB**2*S/(3*P2Q2**2)-128*A2**2*MB**3*MT*S/(3*P2Q2**2)+
     &32*MB**2*MT**2*S/(3*P1Q1**2*P2Q2**2)+32*MB**2*S/(3*P1Q1*P2Q2**2)-
     &64*A2*MB**3*MT*S/(3*P1Q1*P2Q2**2)-
     &64*A2*MB**2*MT**2*S/(3*P1Q1*P2Q2**2)-
     &128*A2*MB**2*P1P2*S/(3*P1Q1*P2Q2**2)+
     &128*A2**2*MB**2*P1Q1*S/(3*P2Q2**2)-
     &128*A2*MB**2*P1Q2*S/(3*P1Q1*P2Q2**2)+152*A2*S/(3*P2Q2)-
     &112*A1*A2*MB**2*S/(3*P2Q2)-128*A1*A2*MB*MT*S/(3*P2Q2)-
     &152*A2**2*MB*MT*S/(3*P2Q2)-152*A1*A2*P1P2*S/(3*P2Q2)+
     &16*A2**2*P1P2*S/P2Q2-32*MT**2*S/(3*P1Q1**2*P2Q2)+
     &64*A1*MB**2*MT**2*S/(3*P1Q1**2*P2Q2)+
     &64*A1*MB*MT**3*S/(3*P1Q1**2*P2Q2)+
     &128*A1*MT**2*P1P2*S/(3*P1Q1**2*P2Q2)-12*S/(P1Q1*P2Q2)+
     &24*A1*MB**2*S/(P1Q1*P2Q2)-64*A1*A2*MB**3*MT*S/(3*P1Q1*P2Q2)
      V18BIS=V18BIS+24*A2*MT**2*S/(P1Q1*P2Q2)-
     &128*A1*A2*MB**2*MT**2*S/(3*P1Q1*P2Q2)-
     &64*A1*A2*MB*MT**3*S/(3*P1Q1*P2Q2)+56*A1*P1P2*S/(3*P1Q1*P2Q2)+
     &56*A2*P1P2*S/(3*P1Q1*P2Q2)-64*A1*A2*MB**2*P1P2*S/(3*P1Q1*P2Q2)-
     &128*A1*A2*MB*MT*P1P2*S/(3*P1Q1*P2Q2)-
     &64*A1*A2*MT**2*P1P2*S/(3*P1Q1*P2Q2)-
     &256*A1*A2*P1P2**2*S/(3*P1Q1*P2Q2)-160*A2**2*P1Q1*S/(3*P2Q2)+
     &8*A1*A2*MB**3*MT*S/(3*P1Q2*P2Q2)+
     &16*A1*A2*MB**2*MT**2*S/(3*P1Q2*P2Q2)+
     &8*A1*A2*MB*MT**3*S/(3*P1Q2*P2Q2)-8*A1*P1P2*S/(3*P1Q2*P2Q2)-
     &8*A2*P1P2*S/(3*P1Q2*P2Q2)+8*A1*A2*MB**2*P1P2*S/(3*P1Q2*P2Q2)+
     &16*A1*A2*MB*MT*P1P2*S/(3*P1Q2*P2Q2)+
     &8*A1*A2*MT**2*P1P2*S/(3*P1Q2*P2Q2)+
     &32*A1*A2*P1P2**2*S/(3*P1Q2*P2Q2)+4*P1P2*S/(3*P1Q1*P1Q2*P2Q2)+
     &8*A1*MB*MT*P1P2*S/(3*P1Q1*P1Q2*P2Q2)-
     &8*A1*MT**2*P1P2*S/(3*P1Q1*P1Q2*P2Q2)+
     &16*A1*A2*P1P2*P1Q1*S/(3*P1Q2*P2Q2)-32*A2**2*P1Q2*S/(3*P2Q2)
      V18BIS=V18BIS+136*A2*P1Q2*S/(3*P1Q1*P2Q2)-
     &128*A1*A2*MB**2*P1Q2*S/(3*P1Q1*P2Q2)-
     &128*A1*A2*MB*MT*P1Q2*S/(3*P1Q1*P2Q2)-
     &256*A1*A2*P1P2*P1Q2*S/(3*P1Q1*P2Q2)-16*A2*MB*MT*S/(3*P2Q1*P2Q2)+
     &32*A2**2*MB**3*MT*S/(3*P2Q1*P2Q2)-16*A2*P1P2*S/(3*P2Q1*P2Q2)-
     &4*P1P2*S/(3*P1Q1*P2Q1*P2Q2)+8*A2*MB**2*P1P2*S/(3*P1Q1*P2Q1*P2Q2)-
     &8*A2*MB*MT*P1P2*S/(3*P1Q1*P2Q1*P2Q2)-4*P1P2*S/(3*P1Q2*P2Q1*P2Q2)+
     &8*A2*MB**2*P1P2*S/(3*P1Q2*P2Q1*P2Q2)-
     &8*A2*MB*MT*P1P2*S/(3*P1Q2*P2Q1*P2Q2)+
     &2*MB**3*MT*S/(3*P1Q1*P1Q2*P2Q1*P2Q2)+
     &4*MB**2*MT**2*S/(3*P1Q1*P1Q2*P2Q1*P2Q2)+
     &2*MB*MT**3*S/(3*P1Q1*P1Q2*P2Q1*P2Q2)-
     &2*MB**2*P1P2*S/(3*P1Q1*P1Q2*P2Q1*P2Q2)-
     &4*MB*MT*P1P2*S/(3*P1Q1*P1Q2*P2Q1*P2Q2)-
     &2*MT**2*P1P2*S/(3*P1Q1*P1Q2*P2Q1*P2Q2)-
     &8*P1P2**2*S/(3*P1Q1*P1Q2*P2Q1*P2Q2)+
     &8*A2*P1P2*P1Q1*S/(3*P1Q2*P2Q1*P2Q2)
      V18BIS=V18BIS+8*A2*P1P2*P1Q2*S/(3*P1Q1*P2Q1*P2Q2)+
     &272*A1*A2*P2Q1*S/(3*P2Q2)-
     &128*A1*MT**2*P2Q1*S/(3*P1Q1**2*P2Q2)-136*A1*P2Q1*S/(3*P1Q1*P2Q2)+
     &128*A1*A2*MB*MT*P2Q1*S/(3*P1Q1*P2Q2)+
     &128*A1*A2*MT**2*P2Q1*S/(3*P1Q1*P2Q2)+
     &256*A1*A2*P1P2*P2Q1*S/(3*P1Q1*P2Q2)-
     &16*A1*A2*P1P2*P2Q1*S/(3*P1Q2*P2Q2)+
     &8*A1*P1P2*P2Q1*S/(3*P1Q1*P1Q2*P2Q2)+
     &256*A1*A2*P1Q2*P2Q1*S/(3*P1Q1*P2Q2)-
     &128*A12*MT**2*P2Q2*S/(3*P1Q1**2)-160*A12*P2Q2*S/(3*P1Q1)-
     &32*A12*P2Q2*S/(3*P1Q2)+272*A1*A2*P2Q2*S/(3*P2Q1)-
     &16*A1*A2*P1P2*P2Q2*S/(3*P1Q1*P2Q1)-
     &128*A1*MT**2*P2Q2*S/(3*P1Q2**2*P2Q1)-136*A1*P2Q2*S/(3*P1Q2*P2Q1)+
     &128*A1*A2*MB*MT*P2Q2*S/(3*P1Q2*P2Q1)+
     &128*A1*A2*MT**2*P2Q2*S/(3*P1Q2*P2Q1)+
     &256*A1*A2*P1P2*P2Q2*S/(3*P1Q2*P2Q1)+
     &8*A1*P1P2*P2Q2*S/(3*P1Q1*P1Q2*P2Q1)
      V18BIS=V18BIS+256*A1*A2*P1Q1*P2Q2*S/(3*P1Q2*P2Q1)+
     &8*A12*MB*MT*S**2/(3*P1Q1*P1Q2)+16*A12*P1P2*S**2/(3*P1Q1*P1Q2)-
     &8*A1*A2*P1P2*S**2/(3*P1Q1*P2Q1)+4*A1*P1P2*S**2/(3*P1Q1*P1Q2*P2Q1)-
     &8*A1*A2*P1P2*S**2/(3*P1Q2*P2Q2)+4*A1*P1P2*S**2/(3*P1Q1*P1Q2*P2Q2)+
     &8*A2**2*MB*MT*S**2/(3*P2Q1*P2Q2)+16*A2**2*P1P2*S**2/(3*P2Q1*P2Q2)-
     &4*A2*P1P2*S**2/(3*P1Q1*P2Q1*P2Q2)-
     &4*A2*P1P2*S**2/(3*P1Q2*P2Q1*P2Q2)+
     &2*P1P2*S**2/(3*P1Q1*P1Q2*P2Q1*P2Q2)
C
 
      A18 = 640*A1/3+640*A2/3+32*A1*A2*MB**2+368*A12*MB*MT+
     &512*A1*A2*MB*MT/3+
     &368*A2**2*MB*MT+32*A1*A2*MT**2+496*A12*P1P2/3+
     &320*A1*A2*P1P2+496*A2**2*P1P2/3-128*A1*MB*MT**3/(3*P1Q1**2)+
     &128*A1*MT**4/(3*P1Q1**2)+256*A12*MB*MT**5/(3*P1Q1**2)+
     &256*A1*MT**2*P1P2/(3*P1Q1**2)-256*A12*MT**4*P1P2/(3*P1Q1**2)+
     &8/(3*P1Q1)+32*A1*MB*MT/P1Q1+56*A2*MB*MT/(3*P1Q1)+
     &88*A1*MT**2/(3*P1Q1)+72*A2*MT**2/P1Q1-
     &704*A12*MB*MT**3/(3*P1Q1)+224*A1*A2*MB*MT**3/(3*P1Q1)+
     &104*A1*P1P2/(3*P1Q1)+48*A2*P1P2/P1Q1-
     &128*A1*A2*MB*MT*P1P2/(3*P1Q1)+512*A12*MT**2*P1P2/(3*P1Q1)-
     &448*A1*A2*MT**2*P1P2/(3*P1Q1)-32*A1*A2*P1P2**2/P1Q1-
     &656*A1*A2*P1Q1/3-224*A2**2*P1Q1-128*A1*MB*MT**3/(3*P1Q2**2)+
     &128*A1*MT**4/(3*P1Q2**2)+256*A12*MB*MT**5/(3*P1Q2**2)+
     &256*A1*MT**2*P1P2/(3*P1Q2**2)-256*A12*MT**4*P1P2/(3*P1Q2**2)+
     &256*A1*MT**2*P1Q1/(3*P1Q2**2)-256*A12*MB*MT**3*P1Q1/(3*P1Q2**2)+
     &8/(3*P1Q2)+32*A1*MB*MT/P1Q2+56*A2*MB*MT/(3*P1Q2)
      A18=A18+88*A1*MT**2/(3*P1Q2)+72*A2*MT**2/P1Q2-
     &704*A12*MB*MT**3/(3*P1Q2)+224*A1*A2*MB*MT**3/(3*P1Q2)+
     &104*A1*P1P2/(3*P1Q2)+48*A2*P1P2/P1Q2-
     &128*A1*A2*MB*MT*P1P2/(3*P1Q2)+512*A12*MT**2*P1P2/(3*P1Q2)-
     &448*A1*A2*MT**2*P1P2/(3*P1Q2)-32*A1*A2*P1P2**2/P1Q2+
     &32*A1*MB*MT**3/(3*P1Q1*P1Q2)-32*A1*MT**4/(3*P1Q1*P1Q2)-
     &64*A12*MB*MT**5/(3*P1Q1*P1Q2)+16*P1P2/(3*P1Q1*P1Q2)-
     &64*A1*MT**2*P1P2/(3*P1Q1*P1Q2)+64*A12*MT**4*P1P2/(3*P1Q1*P1Q2)+
     &112*A1*P1Q1/P1Q2+272*A2*P1Q1/(3*P1Q2)-
     &272*A1*A2*MB**2*P1Q1/(3*P1Q2)-208*A12*MB*MT*P1Q1/(3*P1Q2)+
     &400*A1*A2*MB*MT*P1Q1/(3*P1Q2)-80*A1*A2*MT**2*P1Q1/P1Q2+
     &96*A12*P1P2*P1Q1/P1Q2-320*A1*A2*P1P2*P1Q1/P1Q2-
     &544*A1*A2*P1Q1**2/(3*P1Q2)-656*A1*A2*P1Q2/3-224*A2**2*P1Q2+
     &256*A1*MT**2*P1Q2/(3*P1Q1**2)-256*A12*MB*MT**3*P1Q2/(3*P1Q1**2)+
     &112*A1*P1Q2/P1Q1+272*A2*P1Q2/(3*P1Q1)-
     &272*A1*A2*MB**2*P1Q2/(3*P1Q1)-208*A12*MB*MT*P1Q2/(3*P1Q1)+
     &400*A1*A2*MB*MT*P1Q2/(3*P1Q1)-80*A1*A2*MT**2*P1Q2/P1Q1
      A18=A18+96*A12*P1P2*P1Q2/P1Q1-320*A1*A2*P1P2*P1Q2/P1Q1-
     &544*A1*A2*P1Q2**2/(3*P1Q1)+128*A2*MB**4/(3*P2Q1**2)-
     &128*A2*MB**3*MT/(3*P2Q1**2)+256*A2**2*MB**5*MT/(3*P2Q1**2)+
     &256*A2*MB**2*P1P2/(3*P2Q1**2)-256*A2**2*MB**4*P1P2/(3*P2Q1**2)+
     &256*A2*MB**2*P1Q1/(3*P2Q1**2)-256*A2**2*MB**4*P1Q1/(3*P2Q1**2)+
     &64*MB**3*MT**3/(3*P1Q2**2*P2Q1**2)-
     &64*MB**2*MT**2*P1P2/(3*P1Q2**2*P2Q1**2)-
     &64*MB**2*MT**2*P1Q1/(3*P1Q2**2*P2Q1**2)-
     &64*MB**3*MT/(3*P1Q2*P2Q1**2)-
     &256*A2*MB**3*MT*P1P2/(3*P1Q2*P2Q1**2)+
     &256*A2*MB**2*P1P2**2/(3*P1Q2*P2Q1**2)-
     &256*A2*MB**3*MT*P1Q1/(3*P1Q2*P2Q1**2)+
     &512*A2*MB**2*P1P2*P1Q1/(3*P1Q2*P2Q1**2)+
     &256*A2*MB**2*P1Q1**2/(3*P1Q2*P2Q1**2)-
     &256*A2**2*MB**4*P1Q2/(3*P2Q1**2)-8/(3*P2Q1)-72*A1*MB**2/P2Q1-
     &88*A2*MB**2/(3*P2Q1)-56*A1*MB*MT/(3*P2Q1)-32*A2*MB*MT/P2Q1-
     &224*A1*A2*MB**3*MT/(3*P2Q1)+704*A2**2*MB**3*MT/(3*P2Q1)
      A18=A18-48*A1*P1P2/P2Q1-104*A2*P1P2/(3*P2Q1)+
     &448*A1*A2*MB**2*P1P2/(3*P2Q1)-512*A2**2*MB**2*P1P2/(3*P2Q1)+
     &128*A1*A2*MB*MT*P1P2/(3*P2Q1)+32*A1*A2*P1P2**2/P2Q1-
     &16*P1P2/(3*P1Q1*P2Q1)+32*A1*MB*MT*P1P2/(3*P1Q1*P2Q1)+
     &32*A2*MB*MT*P1P2/(3*P1Q1*P2Q1)+
     &64*A1*A2*MB*MT*P1P2**2/(3*P1Q1*P2Q1)-
     &64*A1*A2*P1P2**3/(3*P1Q1*P2Q1)-256*A2*P1Q1/(3*P2Q1)+
     &448*A1*A2*MB**2*P1Q1/(3*P2Q1)-368*A2**2*MB**2*P1Q1/(3*P2Q1)-
     &224*A1*A2*MB*MT*P1Q1/(3*P2Q1)+304*A1*A2*P1P2*P1Q1/(3*P2Q1)+
     &64*MB*MT**3/(3*P1Q2**2*P2Q1)+
     &256*A1*MB*MT**3*P1P2/(3*P1Q2**2*P2Q1)-
     &256*A1*MT**2*P1P2**2/(3*P1Q2**2*P2Q1)+
     &64*MT**2*P1Q1/(3*P1Q2**2*P2Q1)-
     &128*A1*MB**2*MT**2*P1Q1/(3*P1Q2**2*P2Q1)+
     &128*A1*MB*MT**3*P1Q1/(3*P1Q2**2*P2Q1)-
     &256*A1*MT**2*P1P2*P1Q1/(3*P1Q2**2*P2Q1)-4*MB**2/(3*P1Q2*P2Q1)-
     &64*MB*MT/(3*P1Q2*P2Q1)+128*A2*MB**3*MT/(3*P1Q2*P2Q1)
      A18=A18-4*MT**2/(3*P1Q2*P2Q1)-128*A1*MB**2*MT**2/(3*P1Q2*P2Q1)-
     &128*A2*MB**2*MT**2/(3*P1Q2*P2Q1)+128*A1*MB*MT**3/(3*P1Q2*P2Q1)-
     &112*A2*MB**2*P1P2/(3*P1Q2*P2Q1)+32*A1*MB*MT*P1P2/(3*P1Q2*P2Q1)+
     &32*A2*MB*MT*P1P2/(3*P1Q2*P2Q1)-112*A1*MT**2*P1P2/(3*P1Q2*P2Q1)-
     &48*A1*P1P2**2/(P1Q2*P2Q1)-48*A2*P1P2**2/(P1Q2*P2Q1)-
     &512*A1*A2*MB*MT*P1P2**2/(3*P1Q2*P2Q1)+
     &512*A1*A2*P1P2**3/(3*P1Q2*P2Q1)+8*MB*MT*P1P2/(3*P1Q1*P1Q2*P2Q1)-
     &8*MT**2*P1P2/(3*P1Q1*P1Q2*P2Q1)-
     &32*A1*MB*MT**3*P1P2/(3*P1Q1*P1Q2*P2Q1)-
     &16*P1P2**2/(3*P1Q1*P1Q2*P2Q1)+
     &32*A1*MT**2*P1P2**2/(3*P1Q1*P1Q2*P2Q1)+8*P1Q1/(3*P1Q2*P2Q1)-
     &160*A1*MB**2*P1Q1/(3*P1Q2*P2Q1)-272*A2*MB**2*P1Q1/(3*P1Q2*P2Q1)-
     &56*A1*MB*MT*P1Q1/(3*P1Q2*P2Q1)-200*A2*MB*MT*P1Q1/(3*P1Q2*P2Q1)-
     &48*A1*P1P2*P1Q1/(P1Q2*P2Q1)-256*A2*P1P2*P1Q1/(3*P1Q2*P2Q1)+
     &256*A1*A2*MB**2*P1P2*P1Q1/(3*P1Q2*P2Q1)-
     &256*A1*A2*MB*MT*P1P2*P1Q1/(P1Q2*P2Q1)+
     &1024*A1*A2*P1P2**2*P1Q1/(3*P1Q2*P2Q1)
      A18=A18-272*A2*P1Q1**2/(3*P1Q2*P2Q1)+
     &256*A1*A2*MB**2*P1Q1**2/(3*P1Q2*P2Q1)-
     &256*A1*A2*MB*MT*P1Q1**2/(3*P1Q2*P2Q1)+
     &512*A1*A2*P1P2*P1Q1**2/(3*P1Q2*P2Q1)+16*A2*P1Q2/(3*P2Q1)+
     &64*A1*A2*MB**2*P1Q2/P2Q1+32*A2**2*MB**2*P1Q2/(3*P2Q1)-
     &112*A1*A2*MB*MT*P1Q2/(3*P2Q1)+368*A1*A2*P1P2*P1Q2/(3*P2Q1)+
     &32*A2*P1P2*P1Q2/(3*P1Q1*P2Q1)-
     &32*A1*A2*MB**2*P1P2*P1Q2/(3*P1Q1*P2Q1)+
     &32*A1*A2*MB*MT*P1P2*P1Q2/(3*P1Q1*P2Q1)-
     &64*A1*A2*P1P2**2*P1Q2/(3*P1Q1*P2Q1)+224*A12*P2Q1+
     &656*A1*A2*P2Q1/3-256*A1*MT**2*P2Q1/(3*P1Q1**2)+
     &256*A12*MT**4*P2Q1/(3*P1Q1**2)-256*A1*P2Q1/(3*P1Q1)-
     &224*A1*A2*MB*MT*P2Q1/(3*P1Q1)-368*A12*MT**2*P2Q1/(3*P1Q1)+
     &448*A1*A2*MT**2*P2Q1/(3*P1Q1)+304*A1*A2*P1P2*P2Q1/(3*P1Q1)+
     &256*A12*MT**4*P2Q1/(3*P1Q2**2)+
     &256*A12*MT**2*P1Q1*P2Q1/(3*P1Q2**2)+16*A1*P2Q1/(3*P1Q2)-
     &112*A1*A2*MB*MT*P2Q1/(3*P1Q2)+32*A12*MT**2*P2Q1/(3*P1Q2)
      A18=A18+64*A1*A2*MT**2*P2Q1/P1Q2+368*A1*A2*P1P2*P2Q1/(3*P1Q2)+
     &16*A1*MT**2*P2Q1/(3*P1Q1*P1Q2)-64*A12*MT**4*P2Q1/(3*P1Q1*P1Q2)+
     &640*A12*P1Q1*P2Q1/(3*P1Q2)+544*A1*A2*P1Q1*P2Q1/(3*P1Q2)+
     &32*A12*P1Q2*P2Q1/P1Q1+944*A1*A2*P1Q2*P2Q1/(3*P1Q1)+
     &128*A2*MB**4/(3*P2Q2**2)-128*A2*MB**3*MT/(3*P2Q2**2)+
     &256*A2**2*MB**5*MT/(3*P2Q2**2)+256*A2*MB**2*P1P2/(3*P2Q2**2)-
     &256*A2**2*MB**4*P1P2/(3*P2Q2**2)+
     &64*MB**3*MT**3/(3*P1Q1**2*P2Q2**2)-
     &64*MB**2*MT**2*P1P2/(3*P1Q1**2*P2Q2**2)-
     &64*MB**3*MT/(3*P1Q1*P2Q2**2)-
     &256*A2*MB**3*MT*P1P2/(3*P1Q1*P2Q2**2)+
     &256*A2*MB**2*P1P2**2/(3*P1Q1*P2Q2**2)-
     &256*A2**2*MB**4*P1Q1/(3*P2Q2**2)+256*A2*MB**2*P1Q2/(3*P2Q2**2)-
     &256*A2**2*MB**4*P1Q2/(3*P2Q2**2)-
     &64*MB**2*MT**2*P1Q2/(3*P1Q1**2*P2Q2**2)-
     &256*A2*MB**3*MT*P1Q2/(3*P1Q1*P2Q2**2)+
     &512*A2*MB**2*P1P2*P1Q2/(3*P1Q1*P2Q2**2)
      A18=A18+256*A2*MB**2*P1Q2**2/(3*P1Q1*P2Q2**2)-
     &256*A2*MB**2*P2Q1/(3*P2Q2**2)+256*A2**2*MB**3*MT*P2Q1/(3*P2Q2**2)+
     &64*MB**2*MT**2*P2Q1/(3*P1Q1**2*P2Q2**2)+
     &64*MB**2*P2Q1/(3*P1Q1*P2Q2**2)+
     &128*A2*MB**3*MT*P2Q1/(3*P1Q1*P2Q2**2)-
     &128*A2*MB**2*MT**2*P2Q1/(3*P1Q1*P2Q2**2)-
     &256*A2*MB**2*P1P2*P2Q1/(3*P1Q1*P2Q2**2)+
     &256*A2**2*MB**2*P1Q1*P2Q1/(3*P2Q2**2)-
     &256*A2*MB**2*P1Q2*P2Q1/(3*P1Q1*P2Q2**2)-8/(3*P2Q2)-
     &72*A1*MB**2/P2Q2-88*A2*MB**2/(3*P2Q2)-56*A1*MB*MT/(3*P2Q2)-
     &32*A2*MB*MT/P2Q2-224*A1*A2*MB**3*MT/(3*P2Q2)+
     &704*A2**2*MB**3*MT/(3*P2Q2)-48*A1*P1P2/P2Q2-
     &104*A2*P1P2/(3*P2Q2)+448*A1*A2*MB**2*P1P2/(3*P2Q2)-
     &512*A2**2*MB**2*P1P2/(3*P2Q2)+128*A1*A2*MB*MT*P1P2/(3*P2Q2)+
     &32*A1*A2*P1P2**2/P2Q2+64*MB*MT**3/(3*P1Q1**2*P2Q2)+
     &256*A1*MB*MT**3*P1P2/(3*P1Q1**2*P2Q2)-
     &256*A1*MT**2*P1P2**2/(3*P1Q1**2*P2Q2)-4*MB**2/(3*P1Q1*P2Q2)
      A18=A18-64*MB*MT/(3*P1Q1*P2Q2)+128*A2*MB**3*MT/(3*P1Q1*P2Q2)-
     &4*MT**2/(3*P1Q1*P2Q2)-128*A1*MB**2*MT**2/(3*P1Q1*P2Q2)-
     &128*A2*MB**2*MT**2/(3*P1Q1*P2Q2)+128*A1*MB*MT**3/(3*P1Q1*P2Q2)-
     &112*A2*MB**2*P1P2/(3*P1Q1*P2Q2)+32*A1*MB*MT*P1P2/(3*P1Q1*P2Q2)+
     &32*A2*MB*MT*P1P2/(3*P1Q1*P2Q2)-112*A1*MT**2*P1P2/(3*P1Q1*P2Q2)-
     &48*A1*P1P2**2/(P1Q1*P2Q2)-48*A2*P1P2**2/(P1Q1*P2Q2)-
     &512*A1*A2*MB*MT*P1P2**2/(3*P1Q1*P2Q2)+
     &512*A1*A2*P1P2**3/(3*P1Q1*P2Q2)+16*A2*P1Q1/(3*P2Q2)+
     &64*A1*A2*MB**2*P1Q1/P2Q2+32*A2**2*MB**2*P1Q1/(3*P2Q2)-
     &112*A1*A2*MB*MT*P1Q1/(3*P2Q2)+368*A1*A2*P1P2*P1Q1/(3*P2Q2)-
     &16*P1P2/(3*P1Q2*P2Q2)+32*A1*MB*MT*P1P2/(3*P1Q2*P2Q2)+
     &32*A2*MB*MT*P1P2/(3*P1Q2*P2Q2)+
     &64*A1*A2*MB*MT*P1P2**2/(3*P1Q2*P2Q2)-
     &64*A1*A2*P1P2**3/(3*P1Q2*P2Q2)+8*MB*MT*P1P2/(3*P1Q1*P1Q2*P2Q2)-
     &8*MT**2*P1P2/(3*P1Q1*P1Q2*P2Q2)-
     &32*A1*MB*MT**3*P1P2/(3*P1Q1*P1Q2*P2Q2)-
     &16*P1P2**2/(3*P1Q1*P1Q2*P2Q2)
      A18=A18+32*A1*MT**2*P1P2**2/(3*P1Q1*P1Q2*P2Q2)+
     &32*A2*P1P2*P1Q1/(3*P1Q2*P2Q2)-
     &32*A1*A2*MB**2*P1P2*P1Q1/(3*P1Q2*P2Q2)+
     &32*A1*A2*MB*MT*P1P2*P1Q1/(3*P1Q2*P2Q2)-
     &64*A1*A2*P1P2**2*P1Q1/(3*P1Q2*P2Q2)-256*A2*P1Q2/(3*P2Q2)+
     &448*A1*A2*MB**2*P1Q2/(3*P2Q2)-368*A2**2*MB**2*P1Q2/(3*P2Q2)-
     &224*A1*A2*MB*MT*P1Q2/(3*P2Q2)+304*A1*A2*P1P2*P1Q2/(3*P2Q2)+
     &64*MT**2*P1Q2/(3*P1Q1**2*P2Q2)-
     &128*A1*MB**2*MT**2*P1Q2/(3*P1Q1**2*P2Q2)+
     &128*A1*MB*MT**3*P1Q2/(3*P1Q1**2*P2Q2)-
     &256*A1*MT**2*P1P2*P1Q2/(3*P1Q1**2*P2Q2)+8*P1Q2/(3*P1Q1*P2Q2)-
     &160*A1*MB**2*P1Q2/(3*P1Q1*P2Q2)-272*A2*MB**2*P1Q2/(3*P1Q1*P2Q2)-
     &56*A1*MB*MT*P1Q2/(3*P1Q1*P2Q2)-200*A2*MB*MT*P1Q2/(3*P1Q1*P2Q2)-
     &48*A1*P1P2*P1Q2/(P1Q1*P2Q2)-256*A2*P1P2*P1Q2/(3*P1Q1*P2Q2)+
     &256*A1*A2*MB**2*P1P2*P1Q2/(3*P1Q1*P2Q2)-
     &256*A1*A2*MB*MT*P1P2*P1Q2/(P1Q1*P2Q2)+
     &1024*A1*A2*P1P2**2*P1Q2/(3*P1Q1*P2Q2)
      A18=A18-272*A2*P1Q2**2/(3*P1Q1*P2Q2)+
     &256*A1*A2*MB**2*P1Q2**2/(3*P1Q1*P2Q2)-
     &256*A1*A2*MB*MT*P1Q2**2/(3*P1Q1*P2Q2)+
     &512*A1*A2*P1P2*P1Q2**2/(3*P1Q1*P2Q2)-32*A2*MB**4/(3*P2Q1*P2Q2)+
     &32*A2*MB**3*MT/(3*P2Q1*P2Q2)-64*A2**2*MB**5*MT/(3*P2Q1*P2Q2)+
     &16*P1P2/(3*P2Q1*P2Q2)-64*A2*MB**2*P1P2/(3*P2Q1*P2Q2)+
     &64*A2**2*MB**4*P1P2/(3*P2Q1*P2Q2)+8*MB**2*P1P2/(3*P1Q1*P2Q1*P2Q2)-
     &8*MB*MT*P1P2/(3*P1Q1*P2Q1*P2Q2)+
     &32*A2*MB**3*MT*P1P2/(3*P1Q1*P2Q1*P2Q2)+
     &16*P1P2**2/(3*P1Q1*P2Q1*P2Q2)-
     &32*A2*MB**2*P1P2**2/(3*P1Q1*P2Q1*P2Q2)-
     &16*A2*MB**2*P1Q1/(3*P2Q1*P2Q2)+64*A2**2*MB**4*P1Q1/(3*P2Q1*P2Q2)+
     &8*MB**2*P1P2/(3*P1Q2*P2Q1*P2Q2)-8*MB*MT*P1P2/(3*P1Q2*P2Q1*P2Q2)+
     &32*A2*MB**3*MT*P1P2/(3*P1Q2*P2Q1*P2Q2)+
     &16*P1P2**2/(3*P1Q2*P2Q1*P2Q2)-
     &32*A2*MB**2*P1P2**2/(3*P1Q2*P2Q1*P2Q2)-
     &16*MB*MT*P1P2**2/(3*P1Q1*P1Q2*P2Q1*P2Q2)
      A18=A18+16*P1P2**3/(3*P1Q1*P1Q2*P2Q1*P2Q2)-
     &32*A2*MB**2*P1P2*P1Q1/(3*P1Q2*P2Q1*P2Q2)-
     &16*A2*MB**2*P1Q2/(3*P2Q1*P2Q2)+64*A2**2*MB**4*P1Q2/(3*P2Q1*P2Q2)-
     &32*A2*MB**2*P1P2*P1Q2/(3*P1Q1*P2Q1*P2Q2)+272*A1*P2Q1/(3*P2Q2)+
     &112*A2*P2Q1/P2Q2-80*A1*A2*MB**2*P2Q1/P2Q2+
     &400*A1*A2*MB*MT*P2Q1/(3*P2Q2)-208*A2**2*MB*MT*P2Q1/(3*P2Q2)-
     &272*A1*A2*MT**2*P2Q1/(3*P2Q2)-320*A1*A2*P1P2*P2Q1/P2Q2+
     &96*A2**2*P1P2*P2Q1/P2Q2-256*A1*MB*MT**3*P2Q1/(3*P1Q1**2*P2Q2)+
     &512*A1*MT**2*P1P2*P2Q1/(3*P1Q1**2*P2Q2)-8*P2Q1/(3*P1Q1*P2Q2)+
     &200*A1*MB*MT*P2Q1/(3*P1Q1*P2Q2)+56*A2*MB*MT*P2Q1/(3*P1Q1*P2Q2)+
     &272*A1*MT**2*P2Q1/(3*P1Q1*P2Q2)+160*A2*MT**2*P2Q1/(3*P1Q1*P2Q2)+
     &256*A1*P1P2*P2Q1/(3*P1Q1*P2Q2)+48*A2*P1P2*P2Q1/(P1Q1*P2Q2)+
     &256*A1*A2*MB*MT*P1P2*P2Q1/(P1Q1*P2Q2)-
     &256*A1*A2*MT**2*P1P2*P2Q1/(3*P1Q1*P2Q2)-
     &1024*A1*A2*P1P2**2*P2Q1/(3*P1Q1*P2Q2)-
     &544*A1*A2*P1Q1*P2Q1/(3*P2Q2)-640*A2**2*P1Q1*P2Q1/(3*P2Q2)-
     &32*A1*P1P2*P2Q1/(3*P1Q2*P2Q2)
      A18=A18-32*A1*A2*MB*MT*P1P2*P2Q1/(3*P1Q2*P2Q2)+
     &32*A1*A2*MT**2*P1P2*P2Q1/(3*P1Q2*P2Q2)+
     &64*A1*A2*P1P2**2*P2Q1/(3*P1Q2*P2Q2)-
     &32*A1*MT**2*P1P2*P2Q1/(3*P1Q1*P1Q2*P2Q2)+
     &64*A1*A2*P1P2*P1Q1*P2Q1/(3*P1Q2*P2Q2)-
     &944*A1*A2*P1Q2*P2Q1/(3*P2Q2)-32*A2**2*P1Q2*P2Q1/P2Q2+
     &256*A1*MT**2*P1Q2*P2Q1/(3*P1Q1**2*P2Q2)+
     &96*A1*P1Q2*P2Q1/(P1Q1*P2Q2)+96*A2*P1Q2*P2Q1/(P1Q1*P2Q2)-
     &128*A1*A2*MB**2*P1Q2*P2Q1/(3*P1Q1*P2Q2)+
     &256*A1*A2*MB*MT*P1Q2*P2Q1/(P1Q1*P2Q2)-
     &128*A1*A2*MT**2*P1Q2*P2Q1/(3*P1Q1*P2Q2)-
     &512*A1*A2*P1P2*P1Q2*P2Q1/(P1Q1*P2Q2)-
     &512*A1*A2*P1Q2**2*P2Q1/(3*P1Q1*P2Q2)+544*A1*A2*P2Q1**2/(3*P2Q2)-
     &256*A1*MT**2*P2Q1**2/(3*P1Q1**2*P2Q2)-
     &272*A1*P2Q1**2/(3*P1Q1*P2Q2)-
     &256*A1*A2*MB*MT*P2Q1**2/(3*P1Q1*P2Q2)+
     &256*A1*A2*MT**2*P2Q1**2/(3*P1Q1*P2Q2)
      A18=A18+512*A1*A2*P1P2*P2Q1**2/(3*P1Q1*P2Q2)+
     &512*A1*A2*P1Q2*P2Q1**2/(3*P1Q1*P2Q2)+224*A12*P2Q2+
     &656*A1*A2*P2Q2/3+256*A12*MT**4*P2Q2/(3*P1Q1**2)+
     &16*A1*P2Q2/(3*P1Q1)-112*A1*A2*MB*MT*P2Q2/(3*P1Q1)+
     &32*A12*MT**2*P2Q2/(3*P1Q1)+64*A1*A2*MT**2*P2Q2/P1Q1+
     &368*A1*A2*P1P2*P2Q2/(3*P1Q1)-256*A1*MT**2*P2Q2/(3*P1Q2**2)+
     &256*A12*MT**4*P2Q2/(3*P1Q2**2)-256*A1*P2Q2/(3*P1Q2)-
     &224*A1*A2*MB*MT*P2Q2/(3*P1Q2)-368*A12*MT**2*P2Q2/(3*P1Q2)+
     &448*A1*A2*MT**2*P2Q2/(3*P1Q2)+304*A1*A2*P1P2*P2Q2/(3*P1Q2)+
     &16*A1*MT**2*P2Q2/(3*P1Q1*P1Q2)-64*A12*MT**4*P2Q2/(3*P1Q1*P1Q2)+
     &32*A12*P1Q1*P2Q2/P1Q2+944*A1*A2*P1Q1*P2Q2/(3*P1Q2)+
     &256*A12*MT**2*P1Q2*P2Q2/(3*P1Q1**2)+
     &640*A12*P1Q2*P2Q2/(3*P1Q1)+544*A1*A2*P1Q2*P2Q2/(3*P1Q1)-
     &256*A2*MB**2*P2Q2/(3*P2Q1**2)+256*A2**2*MB**3*MT*P2Q2/(3*P2Q1**2)+
     &64*MB**2*MT**2*P2Q2/(3*P1Q2**2*P2Q1**2)+
     &64*MB**2*P2Q2/(3*P1Q2*P2Q1**2)+
     &128*A2*MB**3*MT*P2Q2/(3*P1Q2*P2Q1**2)
      A18=A18-128*A2*MB**2*MT**2*P2Q2/(3*P1Q2*P2Q1**2)-
     &256*A2*MB**2*P1P2*P2Q2/(3*P1Q2*P2Q1**2)-
     &256*A2*MB**2*P1Q1*P2Q2/(3*P1Q2*P2Q1**2)+
     &256*A2**2*MB**2*P1Q2*P2Q2/(3*P2Q1**2)+272*A1*P2Q2/(3*P2Q1)+
     &112*A2*P2Q2/P2Q1-80*A1*A2*MB**2*P2Q2/P2Q1+
     &400*A1*A2*MB*MT*P2Q2/(3*P2Q1)-208*A2**2*MB*MT*P2Q2/(3*P2Q1)-
     &272*A1*A2*MT**2*P2Q2/(3*P2Q1)-320*A1*A2*P1P2*P2Q2/P2Q1+
     &96*A2**2*P1P2*P2Q2/P2Q1-32*A1*P1P2*P2Q2/(3*P1Q1*P2Q1)-
     &32*A1*A2*MB*MT*P1P2*P2Q2/(3*P1Q1*P2Q1)+
     &32*A1*A2*MT**2*P1P2*P2Q2/(3*P1Q1*P2Q1)+
     &64*A1*A2*P1P2**2*P2Q2/(3*P1Q1*P2Q1)-944*A1*A2*P1Q1*P2Q2/(3*P2Q1)-
     &32*A2**2*P1Q1*P2Q2/P2Q1-256*A1*MB*MT**3*P2Q2/(3*P1Q2**2*P2Q1)+
     &512*A1*MT**2*P1P2*P2Q2/(3*P1Q2**2*P2Q1)+
     &256*A1*MT**2*P1Q1*P2Q2/(3*P1Q2**2*P2Q1)-8*P2Q2/(3*P1Q2*P2Q1)+
     &200*A1*MB*MT*P2Q2/(3*P1Q2*P2Q1)+56*A2*MB*MT*P2Q2/(3*P1Q2*P2Q1)+
     &272*A1*MT**2*P2Q2/(3*P1Q2*P2Q1)+160*A2*MT**2*P2Q2/(3*P1Q2*P2Q1)+
     &256*A1*P1P2*P2Q2/(3*P1Q2*P2Q1)+48*A2*P1P2*P2Q2/(P1Q2*P2Q1)
      A18=A18+256*A1*A2*MB*MT*P1P2*P2Q2/(P1Q2*P2Q1)-
     &256*A1*A2*MT**2*P1P2*P2Q2/(3*P1Q2*P2Q1)-
     &1024*A1*A2*P1P2**2*P2Q2/(3*P1Q2*P2Q1)-
     &32*A1*MT**2*P1P2*P2Q2/(3*P1Q1*P1Q2*P2Q1)+
     &96*A1*P1Q1*P2Q2/(P1Q2*P2Q1)+96*A2*P1Q1*P2Q2/(P1Q2*P2Q1)-
     &128*A1*A2*MB**2*P1Q1*P2Q2/(3*P1Q2*P2Q1)+
     &256*A1*A2*MB*MT*P1Q1*P2Q2/(P1Q2*P2Q1)-
     &128*A1*A2*MT**2*P1Q1*P2Q2/(3*P1Q2*P2Q1)-
     &512*A1*A2*P1P2*P1Q1*P2Q2/(P1Q2*P2Q1)-
     &512*A1*A2*P1Q1**2*P2Q2/(3*P1Q2*P2Q1)-544*A1*A2*P1Q2*P2Q2/(3*P2Q1)-
     &640*A2**2*P1Q2*P2Q2/(3*P2Q1)+
     &64*A1*A2*P1P2*P1Q2*P2Q2/(3*P1Q1*P2Q1)+544*A1*A2*P2Q2**2/(3*P2Q1)-
     &256*A1*MT**2*P2Q2**2/(3*P1Q2**2*P2Q1)-
     &272*A1*P2Q2**2/(3*P1Q2*P2Q1)-
     &256*A1*A2*MB*MT*P2Q2**2/(3*P1Q2*P2Q1)+
     &256*A1*A2*MT**2*P2Q2**2/(3*P1Q2*P2Q1)+
     &512*A1*A2*P1P2*P2Q2**2/(3*P1Q2*P2Q1)
      A18=A18+512*A1*A2*P1Q1*P2Q2**2/(3*P1Q2*P2Q1)-
     &384*A12*MB*MT*P1Q1**2/S**2+
     &384*A12*P1P2*P1Q1**2/S**2-2688*A12*MB*MT*P1Q1*P1Q2/S**2+
     &2688*A12*P1P2*P1Q1*P1Q2/S**2-384*A12*MB*MT*P1Q2**2/S**2+
     &384*A12*P1P2*P1Q2**2/S**2-768*A1*A2*MB*MT*P1Q1*P2Q1/S**2+
     &768*A1*A2*P1P2*P1Q1*P2Q1/S**2-2688*A1*A2*MB*MT*P1Q2*P2Q1/S**2+
     &2688*A1*A2*P1P2*P1Q2*P2Q1/S**2-960*A12*P1Q1*P1Q2*P2Q1/S**2-
     &960*A1*A2*P1Q1*P1Q2*P2Q1/S**2+960*A12*P1Q2**2*P2Q1/S**2+
     &960*A1*A2*P1Q2**2*P2Q1/S**2-384*A2**2*MB*MT*P2Q1**2/S**2+
     &384*A2**2*P1P2*P2Q1**2/S**2-960*A1*A2*P1Q2*P2Q1**2/S**2-
     &960*A2**2*P1Q2*P2Q1**2/S**2-2688*A1*A2*MB*MT*P1Q1*P2Q2/S**2+
     &2688*A1*A2*P1P2*P1Q1*P2Q2/S**2+960*A12*P1Q1**2*P2Q2/S**2+
     &960*A1*A2*P1Q1**2*P2Q2/S**2-768*A1*A2*MB*MT*P1Q2*P2Q2/S**2+
     &768*A1*A2*P1P2*P1Q2*P2Q2/S**2-960*A12*P1Q1*P1Q2*P2Q2/S**2-
     &960*A1*A2*P1Q1*P1Q2*P2Q2/S**2-2688*A2**2*MB*MT*P2Q1*P2Q2/S**2+
     &2688*A2**2*P1P2*P2Q1*P2Q2/S**2+960*A1*A2*P1Q1*P2Q1*P2Q2/S**2+
     &960*A2**2*P1Q1*P2Q1*P2Q2/S**2+960*A1*A2*P1Q2*P2Q1*P2Q2/S**2
      A18=A18+960*A2**2*P1Q2*P2Q1*P2Q2/S**2-
     &384*A2**2*MB*MT*P2Q2**2/S**2+
     &384*A2**2*P1P2*P2Q2**2/S**2-960*A1*A2*P1Q1*P2Q2**2/S**2-
     &960*A2**2*P1Q1*P2Q2**2/S**2-96*A1*MB*MT/S-96*A2*MB*MT/S+
     &768*A2**2*MB**3*MT/S+768*A12*MB*MT**3/S-192*A1*P1P2/S-
     &192*A2*P1P2/S-768*A2**2*MB**2*P1P2/S+2304*A1*A2*MB*MT*P1P2/S-
     &768*A12*MT**2*P1P2/S-2304*A1*A2*P1P2**2/S+
     &96*A1*MB*MT**3/(P1Q1*S)+192*A2*MB*MT*P1P2/(P1Q1*S)-
     &96*A1*MT**2*P1P2/(P1Q1*S)-192*A2*P1P2**2/(P1Q1*S)-192*A1*P1Q1/S-
     &144*A2*P1Q1/S-384*A1*A2*MB**2*P1Q1/S-480*A2**2*MB**2*P1Q1/S+
     &480*A12*MB*MT*P1Q1/S-96*A1*A2*MB*MT*P1Q1/S-
     &864*A12*P1P2*P1Q1/S-672*A1*A2*P1P2*P1Q1/S-96*A1*A2*P1Q1**2/S+
     &96*A1*MB*MT**3/(P1Q2*S)+192*A2*MB*MT*P1P2/(P1Q2*S)-
     &96*A1*MT**2*P1P2/(P1Q2*S)-192*A2*P1P2**2/(P1Q2*S)+
     &48*A1*MB*MT*P1Q1/(P1Q2*S)-96*A2*MB*MT*P1Q1/(P1Q2*S)-
     &48*A1*MT**2*P1Q1/(P1Q2*S)-192*A1*P1P2*P1Q1/(P1Q2*S)-
     &192*A2*P1P2*P1Q1/(P1Q2*S)-192*A1*A2*MB*MT*P1P2*P1Q1/(P1Q2*S)
      A18=A18+192*A1*A2*P1P2**2*P1Q1/(P1Q2*S)-192*A1*P1Q1**2/(P1Q2*S)-
     &192*A2*P1Q1**2/(P1Q2*S)+192*A1*A2*MB**2*P1Q1**2/(P1Q2*S)+
     &192*A12*MB*MT*P1Q1**2/(P1Q2*S)-96*A1*A2*MB*MT*P1Q1**2/(P1Q2*S)+
     &192*A1*A2*P1P2*P1Q1**2/(P1Q2*S)-192*A1*P1Q2/S-144*A2*P1Q2/S-
     &384*A1*A2*MB**2*P1Q2/S-480*A2**2*MB**2*P1Q2/S+
     &480*A12*MB*MT*P1Q2/S-96*A1*A2*MB*MT*P1Q2/S-
     &864*A12*P1P2*P1Q2/S-672*A1*A2*P1P2*P1Q2/S+
     &48*A1*MB*MT*P1Q2/(P1Q1*S)-96*A2*MB*MT*P1Q2/(P1Q1*S)-
     &48*A1*MT**2*P1Q2/(P1Q1*S)-192*A1*P1P2*P1Q2/(P1Q1*S)-
     &192*A2*P1P2*P1Q2/(P1Q1*S)-192*A1*A2*MB*MT*P1P2*P1Q2/(P1Q1*S)+
     &192*A1*A2*P1P2**2*P1Q2/(P1Q1*S)-576*A1*A2*P1Q1*P1Q2/S-
     &96*A1*A2*P1Q2**2/S-192*A1*P1Q2**2/(P1Q1*S)-
     &192*A2*P1Q2**2/(P1Q1*S)+192*A1*A2*MB**2*P1Q2**2/(P1Q1*S)+
     &192*A12*MB*MT*P1Q2**2/(P1Q1*S)-96*A1*A2*MB*MT*P1Q2**2/(P1Q1*S)+
     &192*A1*A2*P1P2*P1Q2**2/(P1Q1*S)-96*A2*MB**3*MT/(P2Q1*S)+
     &96*A2*MB**2*P1P2/(P2Q1*S)-192*A1*MB*MT*P1P2/(P2Q1*S)+
     &192*A1*P1P2**2/(P2Q1*S)+96*A1*MB**2*P1Q1/(P2Q1*S)
      A18=A18+192*A2*MB**2*P1Q1/(P2Q1*S)-96*A1*MB*MT*P1Q1/(P2Q1*S)-
     &192*A1*A2*MB**3*MT*P1Q1/(P2Q1*S)+192*A1*P1P2*P1Q1/(P2Q1*S)+
     &192*A1*A2*MB**2*P1P2*P1Q1/(P2Q1*S)+
     &96*A1*A2*MB**2*P1Q1**2/(P2Q1*S)-
     &192*A2*MB**3*MT*P1Q1/(P1Q2*P2Q1*S)+
     &192*A2*MB**2*P1P2*P1Q1/(P1Q2*P2Q1*S)-
     &96*A1*MB*MT*P1P2*P1Q1/(P1Q2*P2Q1*S)+
     &96*A1*P1P2**2*P1Q1/(P1Q2*P2Q1*S)+
     &96*A1*MB**2*P1Q1**2/(P1Q2*P2Q1*S)+
     &192*A2*MB**2*P1Q1**2/(P1Q2*P2Q1*S)-
     &48*A1*MB*MT*P1Q1**2/(P1Q2*P2Q1*S)+
     &96*A1*P1P2*P1Q1**2/(P1Q2*P2Q1*S)+96*A1*MB**2*P1Q2/(P2Q1*S)+
     &48*A2*MB**2*P1Q2/(P2Q1*S)+192*A1*A2*MB**3*MT*P1Q2/(P2Q1*S)-
     &192*A1*A2*MB**2*P1P2*P1Q2/(P2Q1*S)-
     &96*A1*A2*MB**2*P1Q2**2/(P2Q1*S)+144*A1*P2Q1/S+192*A2*P2Q1/S+
     &96*A1*A2*MB*MT*P2Q1/S-480*A2**2*MB*MT*P2Q1/S+
     &480*A12*MT**2*P2Q1/S+384*A1*A2*MT**2*P2Q1/S
      A18=A18+672*A1*A2*P1P2*P2Q1/S+864*A2**2*P1P2*P2Q1/S-
     &96*A2*MB*MT*P2Q1/(P1Q1*S)+192*A1*MT**2*P2Q1/(P1Q1*S)+
     &96*A2*MT**2*P2Q1/(P1Q1*S)-192*A1*A2*MB*MT**3*P2Q1/(P1Q1*S)+
     &192*A2*P1P2*P2Q1/(P1Q1*S)+192*A1*A2*MT**2*P1P2*P2Q1/(P1Q1*S)-
     &192*A12*P1Q1*P2Q1/S-192*A2**2*P1Q1*P2Q1/S+
     &48*A1*MT**2*P2Q1/(P1Q2*S)+96*A2*MT**2*P2Q1/(P1Q2*S)+
     &192*A1*A2*MB*MT**3*P2Q1/(P1Q2*S)-
     &192*A1*A2*MT**2*P1P2*P2Q1/(P1Q2*S)+
     &96*A1*A2*MB*MT*P1Q1*P2Q1/(P1Q2*S)-
     &192*A12*MT**2*P1Q1*P2Q1/(P1Q2*S)-
     &96*A1*A2*MT**2*P1Q1*P2Q1/(P1Q2*S)-
     &384*A1*A2*P1P2*P1Q1*P2Q1/(P1Q2*S)-384*A12*P1Q1**2*P2Q1/(P1Q2*S)-
     &384*A1*A2*P1Q1**2*P2Q1/(P1Q2*S)-480*A12*P1Q2*P2Q1/S-
     &960*A1*A2*P1Q2*P2Q1/S-480*A2**2*P1Q2*P2Q1/S+
     &144*A1*P1Q2*P2Q1/(P1Q1*S)+96*A2*P1Q2*P2Q1/(P1Q1*S)+
     &384*A1*A2*MB*MT*P1Q2*P2Q1/(P1Q1*S)-
     &96*A12*MT**2*P1Q2*P2Q1/(P1Q1*S)
      A18=A18+96*A1*A2*MT**2*P1Q2*P2Q1/(P1Q1*S)-
     &576*A1*A2*P1P2*P1Q2*P2Q1/(P1Q1*S)-192*A12*P1Q2**2*P2Q1/(P1Q1*S)-
     &384*A1*A2*P1Q2**2*P2Q1/(P1Q1*S)-96*A1*A2*P2Q1**2/S-
     &96*A1*A2*MT**2*P2Q1**2/(P1Q1*S)+96*A1*A2*MT**2*P2Q1**2/(P1Q2*S)+
     &288*A1*A2*P1Q2*P2Q1**2/(P1Q1*S)-96*A2*MB**3*MT/(P2Q2*S)+
     &96*A2*MB**2*P1P2/(P2Q2*S)-192*A1*MB*MT*P1P2/(P2Q2*S)+
     &192*A1*P1P2**2/(P2Q2*S)+96*A1*MB**2*P1Q1/(P2Q2*S)+
     &48*A2*MB**2*P1Q1/(P2Q2*S)+192*A1*A2*MB**3*MT*P1Q1/(P2Q2*S)-
     &192*A1*A2*MB**2*P1P2*P1Q1/(P2Q2*S)-
     &96*A1*A2*MB**2*P1Q1**2/(P2Q2*S)+96*A1*MB**2*P1Q2/(P2Q2*S)+
     &192*A2*MB**2*P1Q2/(P2Q2*S)-96*A1*MB*MT*P1Q2/(P2Q2*S)-
     &192*A1*A2*MB**3*MT*P1Q2/(P2Q2*S)+192*A1*P1P2*P1Q2/(P2Q2*S)+
     &192*A1*A2*MB**2*P1P2*P1Q2/(P2Q2*S)-
     &192*A2*MB**3*MT*P1Q2/(P1Q1*P2Q2*S)+
     &192*A2*MB**2*P1P2*P1Q2/(P1Q1*P2Q2*S)-
     &96*A1*MB*MT*P1P2*P1Q2/(P1Q1*P2Q2*S)+
     &96*A1*P1P2**2*P1Q2/(P1Q1*P2Q2*S)+96*A1*A2*MB**2*P1Q2**2/(P2Q2*S)
      A18=A18+96*A1*MB**2*P1Q2**2/(P1Q1*P2Q2*S)+
     &192*A2*MB**2*P1Q2**2/(P1Q1*P2Q2*S)-
     &48*A1*MB*MT*P1Q2**2/(P1Q1*P2Q2*S)+
     &96*A1*P1P2*P1Q2**2/(P1Q1*P2Q2*S)-48*A2*MB**2*P2Q1/(P2Q2*S)-
     &96*A1*MB*MT*P2Q1/(P2Q2*S)+48*A2*MB*MT*P2Q1/(P2Q2*S)-
     &192*A1*P1P2*P2Q1/(P2Q2*S)-192*A2*P1P2*P2Q1/(P2Q2*S)-
     &192*A1*A2*MB*MT*P1P2*P2Q1/(P2Q2*S)+
     &192*A1*A2*P1P2**2*P2Q1/(P2Q2*S)+
     &192*A1*MB*MT**3*P2Q1/(P1Q1*P2Q2*S)+
     &96*A2*MB*MT*P1P2*P2Q1/(P1Q1*P2Q2*S)-
     &192*A1*MT**2*P1P2*P2Q1/(P1Q1*P2Q2*S)-
     &96*A2*P1P2**2*P2Q1/(P1Q1*P2Q2*S)+
     &96*A1*A2*MB**2*P1Q1*P2Q1/(P2Q2*S)+
     &192*A2**2*MB**2*P1Q1*P2Q1/(P2Q2*S)-
     &96*A1*A2*MB*MT*P1Q1*P2Q1/(P2Q2*S)+
     &384*A1*A2*P1P2*P1Q1*P2Q1/(P2Q2*S)-96*A1*P1Q2*P2Q1/(P2Q2*S)-
     &144*A2*P1Q2*P2Q1/(P2Q2*S)-96*A1*A2*MB**2*P1Q2*P2Q1/(P2Q2*S)
      A18=A18+96*A2**2*MB**2*P1Q2*P2Q1/(P2Q2*S)-
     &384*A1*A2*MB*MT*P1Q2*P2Q1/(P2Q2*S)+
     &576*A1*A2*P1P2*P1Q2*P2Q1/(P2Q2*S)-
     &96*A2*MB**2*P1Q2*P2Q1/(P1Q1*P2Q2*S)-
     &48*A1*MB*MT*P1Q2*P2Q1/(P1Q1*P2Q2*S)-
     &48*A2*MB*MT*P1Q2*P2Q1/(P1Q1*P2Q2*S)-
     &96*A1*MT**2*P1Q2*P2Q1/(P1Q1*P2Q2*S)-
     &96*A1*P1P2*P1Q2*P2Q1/(P1Q1*P2Q2*S)-
     &96*A2*P1P2*P1Q2*P2Q1/(P1Q1*P2Q2*S)+
     &96*A1*A2*P1Q1*P1Q2*P2Q1/(P2Q2*S)+288*A1*A2*P1Q2**2*P2Q1/(P2Q2*S)-
     &96*A1*P1Q2**2*P2Q1/(P1Q1*P2Q2*S)-96*A2*P1Q2**2*P2Q1/(P1Q1*P2Q2*S)+
     &192*A1*P2Q1**2/(P2Q2*S)+192*A2*P2Q1**2/(P2Q2*S)+
     &96*A1*A2*MB*MT*P2Q1**2/(P2Q2*S)-192*A2**2*MB*MT*P2Q1**2/(P2Q2*S)-
     &192*A1*A2*MT**2*P2Q1**2/(P2Q2*S)-192*A1*A2*P1P2*P2Q1**2/(P2Q2*S)-
     &48*A2*MB*MT*P2Q1**2/(P1Q1*P2Q2*S)+
     &192*A1*MT**2*P2Q1**2/(P1Q1*P2Q2*S)+
     &96*A2*MT**2*P2Q1**2/(P1Q1*P2Q2*S)
      A18=A18+96*A2*P1P2*P2Q1**2/(P1Q1*P2Q2*S)-
     &384*A1*A2*P1Q1*P2Q1**2/(P2Q2*S)-
     &384*A2**2*P1Q1*P2Q1**2/(P2Q2*S)-384*A1*A2*P1Q2*P2Q1**2/(P2Q2*S)-
     &192*A2**2*P1Q2*P2Q1**2/(P2Q2*S)+96*A1*P1Q2*P2Q1**2/(P1Q1*P2Q2*S)+
     &96*A2*P1Q2*P2Q1**2/(P1Q1*P2Q2*S)+144*A1*P2Q2/S+192*A2*P2Q2/S+
     &96*A1*A2*MB*MT*P2Q2/S-480*A2**2*MB*MT*P2Q2/S+
     &480*A12*MT**2*P2Q2/S+384*A1*A2*MT**2*P2Q2/S+
     &672*A1*A2*P1P2*P2Q2/S+864*A2**2*P1P2*P2Q2/S+
     &48*A1*MT**2*P2Q2/(P1Q1*S)+96*A2*MT**2*P2Q2/(P1Q1*S)+
     &192*A1*A2*MB*MT**3*P2Q2/(P1Q1*S)-
     &192*A1*A2*MT**2*P1P2*P2Q2/(P1Q1*S)-480*A12*P1Q1*P2Q2/S-
     &960*A1*A2*P1Q1*P2Q2/S-480*A2**2*P1Q1*P2Q2/S-
     &96*A2*MB*MT*P2Q2/(P1Q2*S)+192*A1*MT**2*P2Q2/(P1Q2*S)+
     &96*A2*MT**2*P2Q2/(P1Q2*S)-192*A1*A2*MB*MT**3*P2Q2/(P1Q2*S)+
     &192*A2*P1P2*P2Q2/(P1Q2*S)+192*A1*A2*MT**2*P1P2*P2Q2/(P1Q2*S)+
     &144*A1*P1Q1*P2Q2/(P1Q2*S)+96*A2*P1Q1*P2Q2/(P1Q2*S)+
     &384*A1*A2*MB*MT*P1Q1*P2Q2/(P1Q2*S)
      A18=A18-96*A12*MT**2*P1Q1*P2Q2/(P1Q2*S)+
     &96*A1*A2*MT**2*P1Q1*P2Q2/(P1Q2*S)-
     &576*A1*A2*P1P2*P1Q1*P2Q2/(P1Q2*S)-192*A12*P1Q1**2*P2Q2/(P1Q2*S)-
     &384*A1*A2*P1Q1**2*P2Q2/(P1Q2*S)-192*A12*P1Q2*P2Q2/S-
     &192*A2**2*P1Q2*P2Q2/S+96*A1*A2*MB*MT*P1Q2*P2Q2/(P1Q1*S)-
     &192*A12*MT**2*P1Q2*P2Q2/(P1Q1*S)-
     &96*A1*A2*MT**2*P1Q2*P2Q2/(P1Q1*S)-
     &384*A1*A2*P1P2*P1Q2*P2Q2/(P1Q1*S)-384*A12*P1Q2**2*P2Q2/(P1Q1*S)-
     &384*A1*A2*P1Q2**2*P2Q2/(P1Q1*S)-48*A2*MB**2*P2Q2/(P2Q1*S)-
     &96*A1*MB*MT*P2Q2/(P2Q1*S)+48*A2*MB*MT*P2Q2/(P2Q1*S)-
     &192*A1*P1P2*P2Q2/(P2Q1*S)-192*A2*P1P2*P2Q2/(P2Q1*S)-
     &192*A1*A2*MB*MT*P1P2*P2Q2/(P2Q1*S)+
     &192*A1*A2*P1P2**2*P2Q2/(P2Q1*S)-96*A1*P1Q1*P2Q2/(P2Q1*S)-
     &144*A2*P1Q1*P2Q2/(P2Q1*S)-96*A1*A2*MB**2*P1Q1*P2Q2/(P2Q1*S)+
     &96*A2**2*MB**2*P1Q1*P2Q2/(P2Q1*S)-
     &384*A1*A2*MB*MT*P1Q1*P2Q2/(P2Q1*S)+
     &576*A1*A2*P1P2*P1Q1*P2Q2/(P2Q1*S)+288*A1*A2*P1Q1**2*P2Q2/(P2Q1*S)
      A18=A18+192*A1*MB*MT**3*P2Q2/(P1Q2*P2Q1*S)+
     &96*A2*MB*MT*P1P2*P2Q2/(P1Q2*P2Q1*S)-
     &192*A1*MT**2*P1P2*P2Q2/(P1Q2*P2Q1*S)-
     &96*A2*P1P2**2*P2Q2/(P1Q2*P2Q1*S)-
     &96*A2*MB**2*P1Q1*P2Q2/(P1Q2*P2Q1*S)-
     &48*A1*MB*MT*P1Q1*P2Q2/(P1Q2*P2Q1*S)-
     &48*A2*MB*MT*P1Q1*P2Q2/(P1Q2*P2Q1*S)-
     &96*A1*MT**2*P1Q1*P2Q2/(P1Q2*P2Q1*S)-
     &96*A1*P1P2*P1Q1*P2Q2/(P1Q2*P2Q1*S)-
     &96*A2*P1P2*P1Q1*P2Q2/(P1Q2*P2Q1*S)-
     &96*A1*P1Q1**2*P2Q2/(P1Q2*P2Q1*S)-96*A2*P1Q1**2*P2Q2/(P1Q2*P2Q1*S)+
     &96*A1*A2*MB**2*P1Q2*P2Q2/(P2Q1*S)+
     &192*A2**2*MB**2*P1Q2*P2Q2/(P2Q1*S)-
     &96*A1*A2*MB*MT*P1Q2*P2Q2/(P2Q1*S)+
     &384*A1*A2*P1P2*P1Q2*P2Q2/(P2Q1*S)+
     &96*A1*A2*P1Q1*P1Q2*P2Q2/(P2Q1*S)-576*A1*A2*P2Q1*P2Q2/S+
     &96*A1*A2*P1Q1*P2Q1*P2Q2/(P1Q2*S)+96*A1*A2*P1Q2*P2Q1*P2Q2/(P1Q1*S)
      A18=A18-96*A1*A2*P2Q2**2/S+96*A1*A2*MT**2*P2Q2**2/(P1Q1*S)-
     &96*A1*A2*MT**2*P2Q2**2/(P1Q2*S)+288*A1*A2*P1Q1*P2Q2**2/(P1Q2*S)+
     &192*A1*P2Q2**2/(P2Q1*S)+192*A2*P2Q2**2/(P2Q1*S)+
     &96*A1*A2*MB*MT*P2Q2**2/(P2Q1*S)-192*A2**2*MB*MT*P2Q2**2/(P2Q1*S)-
     &192*A1*A2*MT**2*P2Q2**2/(P2Q1*S)-192*A1*A2*P1P2*P2Q2**2/(P2Q1*S)-
     &384*A1*A2*P1Q1*P2Q2**2/(P2Q1*S)-192*A2**2*P1Q1*P2Q2**2/(P2Q1*S)-
     &48*A2*MB*MT*P2Q2**2/(P1Q2*P2Q1*S)+
     &192*A1*MT**2*P2Q2**2/(P1Q2*P2Q1*S)+
     &96*A2*MT**2*P2Q2**2/(P1Q2*P2Q1*S)+
     &96*A2*P1P2*P2Q2**2/(P1Q2*P2Q1*S)+96*A1*P1Q1*P2Q2**2/(P1Q2*P2Q1*S)+
     &96*A2*P1Q1*P2Q2**2/(P1Q2*P2Q1*S)-384*A1*A2*P1Q2*P2Q2**2/(P2Q1*S)-
     &384*A2**2*P1Q2*P2Q2**2/(P2Q1*S)+512*A1*A2*S/3-
     &128*A1*MT**2*S/(3*P1Q1**2)+128*A12*MB*MT**3*S/(3*P1Q1**2)-
     &152*A1*S/(3*P1Q1)-152*A12*MB*MT*S/(3*P1Q1)-
     &128*A1*A2*MB*MT*S/(3*P1Q1)+112*A1*A2*MT**2*S/(3*P1Q1)-
     &16*A12*P1P2*S/P1Q1+152*A1*A2*P1P2*S/(3*P1Q1)-
     &128*A1*MT**2*S/(3*P1Q2**2)+128*A12*MB*MT**3*S/(3*P1Q2**2)
      A18=A18-152*A1*S/(3*P1Q2)-152*A12*MB*MT*S/(3*P1Q2)-
     &128*A1*A2*MB*MT*S/(3*P1Q2)+112*A1*A2*MT**2*S/(3*P1Q2)-
     &16*A12*P1P2*S/P1Q2+152*A1*A2*P1P2*S/(3*P1Q2)+
     &16*A1*MB*MT*S/(3*P1Q1*P1Q2)-32*A12*MB*MT**3*S/(3*P1Q1*P1Q2)-
     &16*A1*P1P2*S/(3*P1Q1*P1Q2)+272*A1*A2*P1Q1*S/(3*P1Q2)+
     &272*A1*A2*P1Q2*S/(3*P1Q1)-128*A2*MB**2*S/(3*P2Q1**2)+
     &128*A2**2*MB**3*MT*S/(3*P2Q1**2)+
     &32*MB**2*MT**2*S/(3*P1Q2**2*P2Q1**2)+32*MB**2*S/(3*P1Q2*P2Q1**2)
 
      A18BIS=
     &64*A2*MB**3*MT*S/(3*P1Q2*P2Q1**2)-
     &64*A2*MB**2*MT**2*S/(3*P1Q2*P2Q1**2)-
     &128*A2*MB**2*P1P2*S/(3*P1Q2*P2Q1**2)-
     &128*A2*MB**2*P1Q1*S/(3*P1Q2*P2Q1**2)+
     &128*A2**2*MB**2*P1Q2*S/(3*P2Q1**2)+152*A2*S/(3*P2Q1)-
     &112*A1*A2*MB**2*S/(3*P2Q1)+128*A1*A2*MB*MT*S/(3*P2Q1)+
     &152*A2**2*MB*MT*S/(3*P2Q1)-152*A1*A2*P1P2*S/(3*P2Q1)+
     &16*A2**2*P1P2*S/P2Q1-8*A1*A2*MB**3*MT*S/(3*P1Q1*P2Q1)+
     &16*A1*A2*MB**2*MT**2*S/(3*P1Q1*P2Q1)-
     &8*A1*A2*MB*MT**3*S/(3*P1Q1*P2Q1)-8*A1*P1P2*S/(3*P1Q1*P2Q1)-
     &8*A2*P1P2*S/(3*P1Q1*P2Q1)+8*A1*A2*MB**2*P1P2*S/(3*P1Q1*P2Q1)-
     &16*A1*A2*MB*MT*P1P2*S/(3*P1Q1*P2Q1)+
     &8*A1*A2*MT**2*P1P2*S/(3*P1Q1*P2Q1)+
     &32*A1*A2*P1P2**2*S/(3*P1Q1*P2Q1)-32*A2**2*P1Q1*S/(3*P2Q1)-
     &32*MT**2*S/(3*P1Q2**2*P2Q1)+64*A1*MB**2*MT**2*S/(3*P1Q2**2*P2Q1)-
     &64*A1*MB*MT**3*S/(3*P1Q2**2*P2Q1)
      A18BIS=A18BIS+128*A1*MT**2*P1P2*S/(3*P1Q2**2*P2Q1)-
     &12*S/(P1Q2*P2Q1)+
     &24*A1*MB**2*S/(P1Q2*P2Q1)+64*A1*A2*MB**3*MT*S/(3*P1Q2*P2Q1)+
     &24*A2*MT**2*S/(P1Q2*P2Q1)-128*A1*A2*MB**2*MT**2*S/(3*P1Q2*P2Q1)+
     &64*A1*A2*MB*MT**3*S/(3*P1Q2*P2Q1)+56*A1*P1P2*S/(3*P1Q2*P2Q1)+
     &56*A2*P1P2*S/(3*P1Q2*P2Q1)-64*A1*A2*MB**2*P1P2*S/(3*P1Q2*P2Q1)+
     &128*A1*A2*MB*MT*P1P2*S/(3*P1Q2*P2Q1)-
     &64*A1*A2*MT**2*P1P2*S/(3*P1Q2*P2Q1)-
     &256*A1*A2*P1P2**2*S/(3*P1Q2*P2Q1)+4*P1P2*S/(3*P1Q1*P1Q2*P2Q1)-
     &8*A1*MB*MT*P1P2*S/(3*P1Q1*P1Q2*P2Q1)-
     &8*A1*MT**2*P1P2*S/(3*P1Q1*P1Q2*P2Q1)+136*A2*P1Q1*S/(3*P1Q2*P2Q1)-
     &128*A1*A2*MB**2*P1Q1*S/(3*P1Q2*P2Q1)+
     &128*A1*A2*MB*MT*P1Q1*S/(3*P1Q2*P2Q1)-
     &256*A1*A2*P1P2*P1Q1*S/(3*P1Q2*P2Q1)-160*A2**2*P1Q2*S/(3*P2Q1)+
     &16*A1*A2*P1P2*P1Q2*S/(3*P1Q1*P2Q1)-32*A12*P2Q1*S/(3*P1Q1)-
     &128*A12*MT**2*P2Q1*S/(3*P1Q2**2)-160*A12*P2Q1*S/(3*P1Q2)-
     &128*A2*MB**2*S/(3*P2Q2**2)+128*A2**2*MB**3*MT*S/(3*P2Q2**2)
      A18BIS=A18BIS+32*MB**2*MT**2*S/(3*P1Q1**2*P2Q2**2)+
     &32*MB**2*S/(3*P1Q1*P2Q2**2)+
     &64*A2*MB**3*MT*S/(3*P1Q1*P2Q2**2)-
     &64*A2*MB**2*MT**2*S/(3*P1Q1*P2Q2**2)-
     &128*A2*MB**2*P1P2*S/(3*P1Q1*P2Q2**2)+
     &128*A2**2*MB**2*P1Q1*S/(3*P2Q2**2)-
     &128*A2*MB**2*P1Q2*S/(3*P1Q1*P2Q2**2)+152*A2*S/(3*P2Q2)-
     &112*A1*A2*MB**2*S/(3*P2Q2)+128*A1*A2*MB*MT*S/(3*P2Q2)+
     &152*A2**2*MB*MT*S/(3*P2Q2)-152*A1*A2*P1P2*S/(3*P2Q2)+
     &16*A2**2*P1P2*S/P2Q2-32*MT**2*S/(3*P1Q1**2*P2Q2)+
     &64*A1*MB**2*MT**2*S/(3*P1Q1**2*P2Q2)-
     &64*A1*MB*MT**3*S/(3*P1Q1**2*P2Q2)+
     &128*A1*MT**2*P1P2*S/(3*P1Q1**2*P2Q2)-12*S/(P1Q1*P2Q2)+
     &24*A1*MB**2*S/(P1Q1*P2Q2)+64*A1*A2*MB**3*MT*S/(3*P1Q1*P2Q2)+
     &24*A2*MT**2*S/(P1Q1*P2Q2)-128*A1*A2*MB**2*MT**2*S/(3*P1Q1*P2Q2)+
     &64*A1*A2*MB*MT**3*S/(3*P1Q1*P2Q2)+56*A1*P1P2*S/(3*P1Q1*P2Q2)+
     &56*A2*P1P2*S/(3*P1Q1*P2Q2)-64*A1*A2*MB**2*P1P2*S/(3*P1Q1*P2Q2)
      A18BIS=A18BIS+128*A1*A2*MB*MT*P1P2*S/(3*P1Q1*P2Q2)-
     &64*A1*A2*MT**2*P1P2*S/(3*P1Q1*P2Q2)-
     &256*A1*A2*P1P2**2*S/(3*P1Q1*P2Q2)-160*A2**2*P1Q1*S/(3*P2Q2)-
     &8*A1*A2*MB**3*MT*S/(3*P1Q2*P2Q2)+
     &16*A1*A2*MB**2*MT**2*S/(3*P1Q2*P2Q2)-
     &8*A1*A2*MB*MT**3*S/(3*P1Q2*P2Q2)-8*A1*P1P2*S/(3*P1Q2*P2Q2)-
     &8*A2*P1P2*S/(3*P1Q2*P2Q2)+8*A1*A2*MB**2*P1P2*S/(3*P1Q2*P2Q2)-
     &16*A1*A2*MB*MT*P1P2*S/(3*P1Q2*P2Q2)+
     &8*A1*A2*MT**2*P1P2*S/(3*P1Q2*P2Q2)+
     &32*A1*A2*P1P2**2*S/(3*P1Q2*P2Q2)+4*P1P2*S/(3*P1Q1*P1Q2*P2Q2)-
     &8*A1*MB*MT*P1P2*S/(3*P1Q1*P1Q2*P2Q2)-
     &8*A1*MT**2*P1P2*S/(3*P1Q1*P1Q2*P2Q2)+
     &16*A1*A2*P1P2*P1Q1*S/(3*P1Q2*P2Q2)-32*A2**2*P1Q2*S/(3*P2Q2)+
     &136*A2*P1Q2*S/(3*P1Q1*P2Q2)-128*A1*A2*MB**2*P1Q2*S/(3*P1Q1*P2Q2)+
     &128*A1*A2*MB*MT*P1Q2*S/(3*P1Q1*P2Q2)-
     &256*A1*A2*P1P2*P1Q2*S/(3*P1Q1*P2Q2)+16*A2*MB*MT*S/(3*P2Q1*P2Q2)-
     &32*A2**2*MB**3*MT*S/(3*P2Q1*P2Q2)-16*A2*P1P2*S/(3*P2Q1*P2Q2)
      A18BIS=A18BIS-4*P1P2*S/(3*P1Q1*P2Q1*P2Q2)+
     &8*A2*MB**2*P1P2*S/(3*P1Q1*P2Q1*P2Q2)+
     &8*A2*MB*MT*P1P2*S/(3*P1Q1*P2Q1*P2Q2)-4*P1P2*S/(3*P1Q2*P2Q1*P2Q2)+
     &8*A2*MB**2*P1P2*S/(3*P1Q2*P2Q1*P2Q2)+
     &8*A2*MB*MT*P1P2*S/(3*P1Q2*P2Q1*P2Q2)-
     &2*MB**3*MT*S/(3*P1Q1*P1Q2*P2Q1*P2Q2)+
     &4*MB**2*MT**2*S/(3*P1Q1*P1Q2*P2Q1*P2Q2)-
     &2*MB*MT**3*S/(3*P1Q1*P1Q2*P2Q1*P2Q2)-
     &2*MB**2*P1P2*S/(3*P1Q1*P1Q2*P2Q1*P2Q2)+
     &4*MB*MT*P1P2*S/(3*P1Q1*P1Q2*P2Q1*P2Q2)-
     &2*MT**2*P1P2*S/(3*P1Q1*P1Q2*P2Q1*P2Q2)-
     &8*P1P2**2*S/(3*P1Q1*P1Q2*P2Q1*P2Q2)+
     &8*A2*P1P2*P1Q1*S/(3*P1Q2*P2Q1*P2Q2)+
     &8*A2*P1P2*P1Q2*S/(3*P1Q1*P2Q1*P2Q2)+272*A1*A2*P2Q1*S/(3*P2Q2)-
     &128*A1*MT**2*P2Q1*S/(3*P1Q1**2*P2Q2)-136*A1*P2Q1*S/(3*P1Q1*P2Q2)-
     &128*A1*A2*MB*MT*P2Q1*S/(3*P1Q1*P2Q2)+
     &128*A1*A2*MT**2*P2Q1*S/(3*P1Q1*P2Q2)
      A18BIS=A18BIS+256*A1*A2*P1P2*P2Q1*S/(3*P1Q1*P2Q2)-
     &16*A1*A2*P1P2*P2Q1*S/(3*P1Q2*P2Q2)+
     &8*A1*P1P2*P2Q1*S/(3*P1Q1*P1Q2*P2Q2)+
     &256*A1*A2*P1Q2*P2Q1*S/(3*P1Q1*P2Q2)-
     &128*A12*MT**2*P2Q2*S/(3*P1Q1**2)-160*A12*P2Q2*S/(3*P1Q1)-
     &32*A12*P2Q2*S/(3*P1Q2)+272*A1*A2*P2Q2*S/(3*P2Q1)-
     &16*A1*A2*P1P2*P2Q2*S/(3*P1Q1*P2Q1)-
     &128*A1*MT**2*P2Q2*S/(3*P1Q2**2*P2Q1)-136*A1*P2Q2*S/(3*P1Q2*P2Q1)-
     &128*A1*A2*MB*MT*P2Q2*S/(3*P1Q2*P2Q1)+
     &128*A1*A2*MT**2*P2Q2*S/(3*P1Q2*P2Q1)+
     &256*A1*A2*P1P2*P2Q2*S/(3*P1Q2*P2Q1)+
     &8*A1*P1P2*P2Q2*S/(3*P1Q1*P1Q2*P2Q1)+
     &256*A1*A2*P1Q1*P2Q2*S/(3*P1Q2*P2Q1)-
     &8*A12*MB*MT*S**2/(3*P1Q1*P1Q2)+16*A12*P1P2*S**2/(3*P1Q1*P1Q2)-
     &8*A1*A2*P1P2*S**2/(3*P1Q1*P2Q1)+4*A1*P1P2*S**2/(3*P1Q1*P1Q2*P2Q1)-
     &8*A1*A2*P1P2*S**2/(3*P1Q2*P2Q2)+4*A1*P1P2*S**2/(3*P1Q1*P1Q2*P2Q2)-
     &8*A2**2*MB*MT*S**2/(3*P2Q1*P2Q2)+16*A2**2*P1P2*S**2/(3*P2Q1*P2Q2)
      A18BIS=A18BIS-4*A2*P1P2*S**2/(3*P1Q1*P2Q1*P2Q2)-
     &4*A2*P1P2*S**2/(3*P1Q2*P2Q1*P2Q2)+
     &2*P1P2*S**2/(3*P1Q1*P1Q2*P2Q1*P2Q2)
C
      V18=V18+V18BIS
      A18=A18+A18BIS
      V910 =-48*A12*MB*MT-48*A2**2*MB*MT-48*A12*P1P2-48*A2**2*P1P2-
     &384*A12*MB*MT*P1Q1*P1Q2/S**2-384*A12*P1P2*P1Q1*P1Q2/S**2-
     &384*A1*A2*MB*MT*P1Q2*P2Q1/S**2-384*A1*A2*P1P2*P1Q2*P2Q1/S**2+
     &192*A12*P1Q1*P1Q2*P2Q1/S**2+192*A1*A2*P1Q1*P1Q2*P2Q1/S**2-
     &192*A12*P1Q2**2*P2Q1/S**2-192*A1*A2*P1Q2**2*P2Q1/S**2+
     &192*A1*A2*P1Q2*P2Q1**2/S**2+192*A2**2*P1Q2*P2Q1**2/S**2-
     &384*A1*A2*MB*MT*P1Q1*P2Q2/S**2-384*A1*A2*P1P2*P1Q1*P2Q2/S**2-
     &192*A12*P1Q1**2*P2Q2/S**2-192*A1*A2*P1Q1**2*P2Q2/S**2+
     &192*A12*P1Q1*P1Q2*P2Q2/S**2+192*A1*A2*P1Q1*P1Q2*P2Q2/S**2-
     &384*A2**2*MB*MT*P2Q1*P2Q2/S**2-384*A2**2*P1P2*P2Q1*P2Q2/S**2-
     &192*A1*A2*P1Q1*P2Q1*P2Q2/S**2-192*A2**2*P1Q1*P2Q1*P2Q2/S**2-
     &192*A1*A2*P1Q2*P2Q1*P2Q2/S**2-192*A2**2*P1Q2*P2Q1*P2Q2/S**2+
     &192*A1*A2*P1Q1*P2Q2**2/S**2+192*A2**2*P1Q1*P2Q2**2/S**2+
     &96*A12*MB*MT*P1Q1/S-96*A1*A2*MB*MT*P1Q1/S+
     &96*A12*P1P2*P1Q1/S-96*A1*A2*P1P2*P1Q1/S+96*A12*MB*MT*P1Q2/S-
     &96*A1*A2*MB*MT*P1Q2/S+96*A12*P1P2*P1Q2/S-96*A1*A2*P1P2*P1Q2/S+
     &96*A1*A2*MB*MT*P2Q1/S-96*A2**2*MB*MT*P2Q1/S
      V910=V910+96*A1*A2*P1P2*P2Q1/S-
     &96*A2**2*P1P2*P2Q1/S+96*A12*P1Q2*P2Q1/S+
     &192*A1*A2*P1Q2*P2Q1/S+96*A2**2*P1Q2*P2Q1/S+
     &96*A1*A2*MB*MT*P2Q2/S-96*A2**2*MB*MT*P2Q2/S+
     &96*A1*A2*P1P2*P2Q2/S-96*A2**2*P1P2*P2Q2/S+96*A12*P1Q1*P2Q2/S+
     &192*A1*A2*P1Q1*P2Q2/S+96*A2**2*P1Q1*P2Q2/S
C
      A910 = 48*A12*MB*MT+48*A2**2*MB*MT-48*A12*P1P2-48*A2**2*P1P2+
     &384*A12*MB*MT*P1Q1*P1Q2/S**2-384*A12*P1P2*P1Q1*P1Q2/S**2+
     &384*A1*A2*MB*MT*P1Q2*P2Q1/S**2-384*A1*A2*P1P2*P1Q2*P2Q1/S**2+
     &192*A12*P1Q1*P1Q2*P2Q1/S**2+192*A1*A2*P1Q1*P1Q2*P2Q1/S**2-
     &192*A12*P1Q2**2*P2Q1/S**2-192*A1*A2*P1Q2**2*P2Q1/S**2+
     &192*A1*A2*P1Q2*P2Q1**2/S**2+192*A2**2*P1Q2*P2Q1**2/S**2+
     &384*A1*A2*MB*MT*P1Q1*P2Q2/S**2-384*A1*A2*P1P2*P1Q1*P2Q2/S**2-
     &192*A12*P1Q1**2*P2Q2/S**2-192*A1*A2*P1Q1**2*P2Q2/S**2+
     &192*A12*P1Q1*P1Q2*P2Q2/S**2+192*A1*A2*P1Q1*P1Q2*P2Q2/S**2+
     &384*A2**2*MB*MT*P2Q1*P2Q2/S**2-384*A2**2*P1P2*P2Q1*P2Q2/S**2-
     &192*A1*A2*P1Q1*P2Q1*P2Q2/S**2-192*A2**2*P1Q1*P2Q1*P2Q2/S**2-
     &192*A1*A2*P1Q2*P2Q1*P2Q2/S**2-192*A2**2*P1Q2*P2Q1*P2Q2/S**2+
     &192*A1*A2*P1Q1*P2Q2**2/S**2+192*A2**2*P1Q1*P2Q2**2/S**2-
     &96*A12*MB*MT*P1Q1/S+96*A1*A2*MB*MT*P1Q1/S+
     &96*A12*P1P2*P1Q1/S-96*A1*A2*P1P2*P1Q1/S-96*A12*MB*MT*P1Q2/S+
     &96*A1*A2*MB*MT*P1Q2/S+96*A12*P1P2*P1Q2/S-96*A1*A2*P1P2*P1Q2/S-
     &96*A1*A2*MB*MT*P2Q1/S+96*A2**2*MB*MT*P2Q1/S
      A910=A910+96*A1*A2*P1P2*P2Q1/S-
     &96*A2**2*P1P2*P2Q1/S+96*A12*P1Q2*P2Q1/S+
     &192*A1*A2*P1Q2*P2Q1/S+96*A2**2*P1Q2*P2Q1/S-
     &96*A1*A2*MB*MT*P2Q2/S+96*A2**2*MB*MT*P2Q2/S+
     &96*A1*A2*P1P2*P2Q2/S-96*A2**2*P1P2*P2Q2/S+96*A12*P1Q1*P2Q2/S+
     &192*A1*A2*P1Q1*P2Q2/S+96*A2**2*P1Q1*P2Q2/S
C
C FINAL RESULT;
C
      AMP2= FACT*PS*VTB**2*(V**2 *(V18 +V910)+A**2 *(A18+A910) )
 
      END
