 
C*********************************************************************
 
C...PYCT5M
C...Auxiliary function for parametrization of CTEQ5M1.
C...Author: J. Pumplin 9/99.
 
      FUNCTION PYCT5M(IFL,X,Q)
 
C...Double precision declaration.
      IMPLICIT DOUBLE PRECISION(A-H, O-Z)
      IMPLICIT INTEGER(I-N)
 
      PARAMETER (NEX=8, NLF=2)
      DIMENSION AM(0:NEX,0:NLF,-5:2)
      DIMENSION ALFVEC(-5:2), QMAVEC(-5:2)
      DIMENSION MEXVEC(-5:2), MLFVEC(-5:2)
      DIMENSION UT1VEC(-5:2), UT2VEC(-5:2)
      DIMENSION AF(0:NEX)
 
      DATA MEXVEC( 2) / 8 /
      DATA MLFVEC( 2) / 2 /
      DATA UT1VEC( 2) /  0.5141718E+01 /
      DATA UT2VEC( 2) / -0.1346944E+01 /
      DATA ALFVEC( 2) /  0.5260555E+00 /
      DATA QMAVEC( 2) /  0.0000000E+00 /
      DATA (AM( 0,K, 2),K=0, 2)
     & /  0.4289071E+01, -0.2536870E+01, -0.1259948E+01 /
      DATA (AM( 1,K, 2),K=0, 2)
     & /  0.9839410E+00,  0.4168426E-01, -0.5018952E-01 /
      DATA (AM( 2,K, 2),K=0, 2)
     & / -0.1651961E+02,  0.9246261E+01,  0.5996400E+01 /
      DATA (AM( 3,K, 2),K=0, 2)
     & / -0.2077936E+02,  0.9786469E+01,  0.7656465E+01 /
      DATA (AM( 4,K, 2),K=0, 2)
     & /  0.3054926E+02,  0.1889536E+01,  0.1380541E+01 /
      DATA (AM( 5,K, 2),K=0, 2)
     & /  0.3084695E+02, -0.1212303E+02, -0.1053551E+02 /
      DATA (AM( 6,K, 2),K=0, 2)
     & / -0.1426778E+02,  0.6239537E+01,  0.5254819E+01 /
      DATA (AM( 7,K, 2),K=0, 2)
     & / -0.1909811E+02,  0.3695678E+01,  0.5495729E+01 /
      DATA (AM( 8,K, 2),K=0, 2)
     & /  0.1889751E-01,  0.5027193E-02,  0.6624896E-03 /
 
      DATA MEXVEC( 1) / 8 /
      DATA MLFVEC( 1) / 2 /
      DATA UT1VEC( 1) /  0.4138426E+01 /
      DATA UT2VEC( 1) / -0.3221374E+01 /
      DATA ALFVEC( 1) /  0.4960962E+00 /
      DATA QMAVEC( 1) /  0.0000000E+00 /
      DATA (AM( 0,K, 1),K=0, 2)
     & /  0.1332497E+01, -0.3703718E+00,  0.1288638E+00 /
      DATA (AM( 1,K, 1),K=0, 2)
     & /  0.7544687E+00,  0.3255075E-01, -0.4706680E-01 /
      DATA (AM( 2,K, 1),K=0, 2)
     & / -0.7638814E+00,  0.5008313E+00, -0.9237374E-01 /
      DATA (AM( 3,K, 1),K=0, 2)
     & / -0.3689889E+00, -0.1055098E+01, -0.4645065E+00 /
      DATA (AM( 4,K, 1),K=0, 2)
     & /  0.3991610E+02,  0.1979881E+01,  0.1775814E+01 /
      DATA (AM( 5,K, 1),K=0, 2)
     & /  0.6201080E+01,  0.2046288E+01,  0.3804571E+00 /
      DATA (AM( 6,K, 1),K=0, 2)
     & / -0.8027900E+00, -0.7011688E+00, -0.8049612E+00 /
      DATA (AM( 7,K, 1),K=0, 2)
     & / -0.8631305E+01, -0.3981200E+01,  0.6970153E+00 /
      DATA (AM( 8,K, 1),K=0, 2)
     & /  0.2371230E-01,  0.5372683E-02,  0.1118701E-02 /
 
      DATA MEXVEC( 0) / 8 /
      DATA MLFVEC( 0) / 2 /
      DATA UT1VEC( 0) / -0.1026789E+01 /
      DATA UT2VEC( 0) / -0.9051707E+01 /
      DATA ALFVEC( 0) /  0.9462977E+00 /
      DATA QMAVEC( 0) /  0.0000000E+00 /
      DATA (AM( 0,K, 0),K=0, 2)
     & /  0.1191990E+03, -0.8548739E+00, -0.1963040E+01 /
      DATA (AM( 1,K, 0),K=0, 2)
     & / -0.9449972E+02,  0.1074771E+01,  0.2056055E+01 /
      DATA (AM( 2,K, 0),K=0, 2)
     & /  0.3701064E+01, -0.1167947E-02,  0.1933573E+00 /
      DATA (AM( 3,K, 0),K=0, 2)
     & /  0.1171345E+03, -0.1064540E+01, -0.1875312E+01 /
      DATA (AM( 4,K, 0),K=0, 2)
     & / -0.1014453E+03, -0.5707427E+00,  0.4511242E-01 /
      DATA (AM( 5,K, 0),K=0, 2)
     & /  0.6365168E+01,  0.1275354E+01, -0.4964081E+00 /
      DATA (AM( 6,K, 0),K=0, 2)
     & / -0.3370693E+01, -0.1122020E+01,  0.5947751E-01 /
      DATA (AM( 7,K, 0),K=0, 2)
     & / -0.5327270E+01, -0.9293556E+00,  0.6629940E+00 /
      DATA (AM( 8,K, 0),K=0, 2)
     & /  0.2437513E-01,  0.1600939E-02,  0.6855336E-03 /
 
      DATA MEXVEC(-1) / 8 /
      DATA MLFVEC(-1) / 2 /
      DATA UT1VEC(-1) /  0.5243571E+01 /
      DATA UT2VEC(-1) / -0.2870513E+01 /
      DATA ALFVEC(-1) /  0.6701448E+00 /
      DATA QMAVEC(-1) /  0.0000000E+00 /
      DATA (AM( 0,K,-1),K=0, 2)
     & /  0.2428863E+02,  0.1907035E+01, -0.4606457E+00 /
      DATA (AM( 1,K,-1),K=0, 2)
     & /  0.2006810E+01, -0.1265915E+00,  0.7153556E-02 /
      DATA (AM( 2,K,-1),K=0, 2)
     & / -0.1884546E+02, -0.2339471E+01,  0.5740679E+01 /
      DATA (AM( 3,K,-1),K=0, 2)
     & / -0.2527892E+02, -0.2044124E+01,  0.1280470E+02 /
      DATA (AM( 4,K,-1),K=0, 2)
     & / -0.1013824E+03, -0.1594199E+01,  0.2216401E+00 /
      DATA (AM( 5,K,-1),K=0, 2)
     & /  0.8070930E+02,  0.1792072E+01, -0.2164364E+02 /
      DATA (AM( 6,K,-1),K=0, 2)
     & / -0.4641050E+02,  0.1977338E+00,  0.1273014E+02 /
      DATA (AM( 7,K,-1),K=0, 2)
     & / -0.3910568E+02,  0.1719632E+01,  0.1086525E+02 /
      DATA (AM( 8,K,-1),K=0, 2)
     & / -0.1185496E+01, -0.1905847E+00, -0.8744118E-03 /
 
      DATA MEXVEC(-2) / 7 /
      DATA MLFVEC(-2) / 2 /
      DATA UT1VEC(-2) /  0.4782210E+01 /
      DATA UT2VEC(-2) / -0.1976856E+02 /
      DATA ALFVEC(-2) /  0.7558374E+00 /
      DATA QMAVEC(-2) /  0.0000000E+00 /
      DATA (AM( 0,K,-2),K=0, 2)
     & / -0.6216935E+00,  0.2369963E+00, -0.7909949E-02 /
      DATA (AM( 1,K,-2),K=0, 2)
     & /  0.1245440E+01, -0.1031510E+00,  0.4916523E-02 /
      DATA (AM( 2,K,-2),K=0, 2)
     & / -0.7060824E+01, -0.3875283E-01,  0.1784981E+00 /
      DATA (AM( 3,K,-2),K=0, 2)
     & / -0.7430595E+01,  0.1964572E+00, -0.1284999E+00 /
      DATA (AM( 4,K,-2),K=0, 2)
     & / -0.6897810E+01,  0.2620543E+01,  0.8012553E-02 /
      DATA (AM( 5,K,-2),K=0, 2)
     & /  0.1507713E+02,  0.2340307E-01,  0.2482535E+01 /
      DATA (AM( 6,K,-2),K=0, 2)
     & / -0.1815341E+01, -0.1538698E+01, -0.2014208E+01 /
      DATA (AM( 7,K,-2),K=0, 2)
     & / -0.2571932E+02,  0.2903941E+00, -0.2848206E+01 /
 
      DATA MEXVEC(-3) / 7 /
      DATA MLFVEC(-3) / 2 /
      DATA UT1VEC(-3) /  0.4518239E+01 /
      DATA UT2VEC(-3) / -0.2690590E+01 /
      DATA ALFVEC(-3) /  0.6124079E+00 /
      DATA QMAVEC(-3) /  0.0000000E+00 /
      DATA (AM( 0,K,-3),K=0, 2)
     & / -0.2734458E+01, -0.7245673E+00, -0.6351374E+00 /
      DATA (AM( 1,K,-3),K=0, 2)
     & /  0.2927174E+01,  0.4822709E+00, -0.1088787E-01 /
      DATA (AM( 2,K,-3),K=0, 2)
     & / -0.1771017E+02, -0.1416635E+01,  0.8467622E+01 /
      DATA (AM( 3,K,-3),K=0, 2)
     & / -0.4972782E+02, -0.3348547E+01,  0.1767061E+02 /
      DATA (AM( 4,K,-3),K=0, 2)
     & / -0.7102770E+01, -0.3205337E+01,  0.4101704E+00 /
      DATA (AM( 5,K,-3),K=0, 2)
     & /  0.7169698E+02, -0.2205985E+01, -0.2463931E+02 /
      DATA (AM( 6,K,-3),K=0, 2)
     & / -0.4090347E+02,  0.2103486E+01,  0.1416507E+02 /
      DATA (AM( 7,K,-3),K=0, 2)
     & / -0.2952639E+02,  0.5376136E+01,  0.7825585E+01 /
 
      DATA MEXVEC(-4) / 7 /
      DATA MLFVEC(-4) / 2 /
      DATA UT1VEC(-4) /  0.2783230E+01 /
      DATA UT2VEC(-4) / -0.1746328E+01 /
      DATA ALFVEC(-4) /  0.1115653E+01 /
      DATA QMAVEC(-4) /  0.1300000E+01 /
      DATA (AM( 0,K,-4),K=0, 2)
     & / -0.1743872E+01, -0.1128921E+01, -0.2841969E+00 /
      DATA (AM( 1,K,-4),K=0, 2)
     & /  0.3345755E+01,  0.3187765E+00,  0.1378124E+00 /
      DATA (AM( 2,K,-4),K=0, 2)
     & / -0.2037615E+02,  0.4121687E+01,  0.2236520E+00 /
      DATA (AM( 3,K,-4),K=0, 2)
     & / -0.4703104E+02,  0.5353087E+01, -0.1455347E+01 /
      DATA (AM( 4,K,-4),K=0, 2)
     & / -0.1060230E+02, -0.1551122E+01, -0.1078863E+01 /
      DATA (AM( 5,K,-4),K=0, 2)
     & /  0.5088892E+02, -0.8197304E+01,  0.8083451E+01 /
      DATA (AM( 6,K,-4),K=0, 2)
     & / -0.2819070E+02,  0.4554086E+01, -0.5890995E+01 /
      DATA (AM( 7,K,-4),K=0, 2)
     & / -0.1098238E+02,  0.2590096E+01, -0.8062879E+01 /
 
      DATA MEXVEC(-5) / 6 /
      DATA MLFVEC(-5) / 2 /
      DATA UT1VEC(-5) /  0.1619654E+02 /
      DATA UT2VEC(-5) / -0.3367346E+01 /
      DATA ALFVEC(-5) /  0.5109891E-02 /
      DATA QMAVEC(-5) /  0.4500000E+01 /
      DATA (AM( 0,K,-5),K=0, 2)
     & / -0.6800138E+01,  0.2493627E+01, -0.1075724E+01 /
      DATA (AM( 1,K,-5),K=0, 2)
     & /  0.3036555E+01,  0.3324733E+00,  0.2008298E+00 /
      DATA (AM( 2,K,-5),K=0, 2)
     & / -0.5203879E+01, -0.8493476E+01, -0.4523208E+01 /
      DATA (AM( 3,K,-5),K=0, 2)
     & / -0.1524239E+01, -0.3411912E+01, -0.1771867E+02 /
      DATA (AM( 4,K,-5),K=0, 2)
     & / -0.1099444E+02,  0.1320930E+01, -0.2353831E+01 /
      DATA (AM( 5,K,-5),K=0, 2)
     & /  0.1699299E+02, -0.3565802E+02,  0.3566872E+02 /
      DATA (AM( 6,K,-5),K=0, 2)
     & / -0.1465793E+02,  0.2703365E+02, -0.2176372E+02 /
 
      IF(Q .LE. QMAVEC(IFL)) THEN
         PYCT5M = 0.D0
         RETURN
      ENDIF
 
      IF(X .GE. 1.D0) THEN
         PYCT5M = 0.D0
         RETURN
      ENDIF
 
      TMP = LOG(Q/ALFVEC(IFL))
      IF(TMP .LE. 0.D0) THEN
         PYCT5M = 0.D0
         RETURN
      ENDIF
 
      SB = LOG(TMP)
      SB1 = SB - 1.2D0
      SB2 = SB1*SB1
 
      DO 110 I = 0, NEX
         AF(I) = 0.D0
         SBX = 1.D0
         DO 100 K = 0, MLFVEC(IFL)
            AF(I) = AF(I) + SBX*AM(I,K,IFL)
            SBX = SB1*SBX
  100    CONTINUE
  110 CONTINUE
 
      Y = -LOG(X)
      U = LOG(X/0.00001D0)
 
      PART1 = AF(1)*Y**(1.D0+0.01D0*AF(4))*(1.D0+ AF(8)*U)
      PART2 = AF(0)*(1.D0 - X) + AF(3)*X
      PART3 = X*(1.D0-X)*(AF(5)+AF(6)*(1.D0-X)+AF(7)*X*(1.D0-X))
      PART4 = UT1VEC(IFL)*LOG(1.D0-X) +
     &	      AF(2)*LOG(1.D0+EXP(UT2VEC(IFL))-X)
 
      PYCT5M = EXP(LOG(X) + PART1 + PART2 + PART3 + PART4)
 
C...Include threshold factor.
      PYCT5M = PYCT5M * (1.D0 - QMAVEC(IFL)/Q)
 
      RETURN
      END
