/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.javascript;

import com.sun.script.javascript.RhinoClassShutter;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;
import sun.security.util.SecurityConstants;

final class RhinoWrapFactory
extends WrapFactory {
    private static RhinoWrapFactory theInstance;

    private RhinoWrapFactory() {
    }

    static synchronized WrapFactory getInstance() {
        if (theInstance == null) {
            theInstance = new RhinoWrapFactory();
        }
        return theInstance;
    }

    public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
        SecurityManager sm = System.getSecurityManager();
        ClassShutter classShutter = RhinoClassShutter.getInstance();
        if (javaObject instanceof ClassLoader) {
            if (sm != null) {
                try {
                    sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
                }
                catch (SecurityException se) {
                    return null;
                }
            }
            return super.wrapAsJavaObject(cx, scope, javaObject, (Class)staticType);
        }
        String name = null;
        if (javaObject instanceof Class) {
            name = ((Class)javaObject).getName();
        } else if (javaObject instanceof Member) {
            Member member = (Member)javaObject;
            if (sm != null && !Modifier.isPublic(member.getModifiers())) {
                return null;
            }
            name = member.getDeclaringClass().getName();
        }
        if (name != null) {
            if (!classShutter.visibleToScripts(name)) {
                return null;
            }
            return super.wrapAsJavaObject(cx, scope, javaObject, (Class)staticType);
        }
        Class<?> dynamicType = javaObject.getClass();
        String name2 = dynamicType.getName();
        if (!classShutter.visibleToScripts(name2)) {
            Class<?> type = null;
            if (staticType != null && staticType.isInterface()) {
                type = staticType;
            } else {
                while (dynamicType != null) {
                    name2 = (dynamicType = dynamicType.getSuperclass()).getName();
                    if (!classShutter.visibleToScripts(name2)) continue;
                    type = dynamicType;
                    break;
                }
                assert (type != null) : "even java.lang.Object is not accessible?";
            }
            return new RhinoJavaObject(scope, javaObject, type);
        }
        return super.wrapAsJavaObject(cx, scope, javaObject, (Class)staticType);
    }

    private static class RhinoJavaObject
    extends NativeJavaObject {
        RhinoJavaObject(Scriptable scope, Object obj, Class type) {
            super(scope, null, type);
            this.javaObject = obj;
        }
    }
}

