// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// The [SVG](https://learn.microsoft.com/en-us/typography/opentype/spec/svg) table
#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct SvgMarker {}

impl SvgMarker {
    pub fn version_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn svg_document_list_offset_byte_range(&self) -> Range<usize> {
        let start = self.version_byte_range().end;
        start..start + Offset32::RAW_BYTE_LEN
    }

    pub fn _reserved_byte_range(&self) -> Range<usize> {
        let start = self.svg_document_list_offset_byte_range().end;
        start..start + u16::RAW_BYTE_LEN
    }
}

impl MinByteRange for SvgMarker {
    fn min_byte_range(&self) -> Range<usize> {
        0..self._reserved_byte_range().end
    }
}

impl TopLevelTable for Svg<'_> {
    /// `SVG `
    const TAG: Tag = Tag::new(b"SVG ");
}

impl<'a> FontRead<'a> for Svg<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        cursor.advance::<u16>();
        cursor.advance::<Offset32>();
        cursor.advance::<u16>();
        cursor.finish(SvgMarker {})
    }
}

/// The [SVG](https://learn.microsoft.com/en-us/typography/opentype/spec/svg) table
pub type Svg<'a> = TableRef<'a, SvgMarker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> Svg<'a> {
    /// Table version (starting at 0). Set to 0.
    pub fn version(&self) -> u16 {
        let range = self.shape.version_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Offset to the SVGDocumentList, from the start of the SVG table.
    /// Must be non-zero.
    pub fn svg_document_list_offset(&self) -> Offset32 {
        let range = self.shape.svg_document_list_offset_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Attempt to resolve [`svg_document_list_offset`][Self::svg_document_list_offset].
    pub fn svg_document_list(&self) -> Result<SVGDocumentList<'a>, ReadError> {
        let data = self.data;
        self.svg_document_list_offset().resolve(data)
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for Svg<'a> {
    fn type_name(&self) -> &str {
        "Svg"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("version", self.version())),
            1usize => Some(Field::new(
                "svg_document_list_offset",
                FieldType::offset(self.svg_document_list_offset(), self.svg_document_list()),
            )),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for Svg<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}

/// [SVGDocumentList](https://learn.microsoft.com/en-us/typography/opentype/spec/svg)
#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct SVGDocumentListMarker {
    document_records_byte_len: usize,
}

impl SVGDocumentListMarker {
    pub fn num_entries_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn document_records_byte_range(&self) -> Range<usize> {
        let start = self.num_entries_byte_range().end;
        start..start + self.document_records_byte_len
    }
}

impl MinByteRange for SVGDocumentListMarker {
    fn min_byte_range(&self) -> Range<usize> {
        0..self.document_records_byte_range().end
    }
}

impl<'a> FontRead<'a> for SVGDocumentList<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        let num_entries: u16 = cursor.read()?;
        let document_records_byte_len = (num_entries as usize)
            .checked_mul(SVGDocumentRecord::RAW_BYTE_LEN)
            .ok_or(ReadError::OutOfBounds)?;
        cursor.advance_by(document_records_byte_len);
        cursor.finish(SVGDocumentListMarker {
            document_records_byte_len,
        })
    }
}

/// [SVGDocumentList](https://learn.microsoft.com/en-us/typography/opentype/spec/svg)
pub type SVGDocumentList<'a> = TableRef<'a, SVGDocumentListMarker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> SVGDocumentList<'a> {
    /// Number of SVGDocumentRecords. Must be non-zero.
    pub fn num_entries(&self) -> u16 {
        let range = self.shape.num_entries_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Array of SVGDocumentRecords.
    pub fn document_records(&self) -> &'a [SVGDocumentRecord] {
        let range = self.shape.document_records_byte_range();
        self.data.read_array(range).unwrap()
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for SVGDocumentList<'a> {
    fn type_name(&self) -> &str {
        "SVGDocumentList"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("num_entries", self.num_entries())),
            1usize => Some(Field::new(
                "document_records",
                traversal::FieldType::array_of_records(
                    stringify!(SVGDocumentRecord),
                    self.document_records(),
                    self.offset_data(),
                ),
            )),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for SVGDocumentList<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}

/// [SVGDocumentRecord](https://learn.microsoft.com/en-us/typography/opentype/spec/svg)
#[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Copy, bytemuck :: AnyBitPattern)]
#[repr(C)]
#[repr(packed)]
pub struct SVGDocumentRecord {
    /// The first glyph ID for the range covered by this record.
    pub start_glyph_id: BigEndian<GlyphId16>,
    /// The last glyph ID for the range covered by this record.
    pub end_glyph_id: BigEndian<GlyphId16>,
    /// Offset from the beginning of the SVGDocumentList to an SVG
    /// document. Must be non-zero.
    pub svg_doc_offset: BigEndian<u32>,
    /// Length of the SVG document data. Must be non-zero.
    pub svg_doc_length: BigEndian<u32>,
}

impl SVGDocumentRecord {
    /// The first glyph ID for the range covered by this record.
    pub fn start_glyph_id(&self) -> GlyphId16 {
        self.start_glyph_id.get()
    }

    /// The last glyph ID for the range covered by this record.
    pub fn end_glyph_id(&self) -> GlyphId16 {
        self.end_glyph_id.get()
    }

    /// Offset from the beginning of the SVGDocumentList to an SVG
    /// document. Must be non-zero.
    pub fn svg_doc_offset(&self) -> u32 {
        self.svg_doc_offset.get()
    }

    /// Length of the SVG document data. Must be non-zero.
    pub fn svg_doc_length(&self) -> u32 {
        self.svg_doc_length.get()
    }
}

impl FixedSize for SVGDocumentRecord {
    const RAW_BYTE_LEN: usize =
        GlyphId16::RAW_BYTE_LEN + GlyphId16::RAW_BYTE_LEN + u32::RAW_BYTE_LEN + u32::RAW_BYTE_LEN;
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeRecord<'a> for SVGDocumentRecord {
    fn traverse(self, data: FontData<'a>) -> RecordResolver<'a> {
        RecordResolver {
            name: "SVGDocumentRecord",
            get_field: Box::new(move |idx, _data| match idx {
                0usize => Some(Field::new("start_glyph_id", self.start_glyph_id())),
                1usize => Some(Field::new("end_glyph_id", self.end_glyph_id())),
                2usize => Some(Field::new("svg_doc_offset", self.svg_doc_offset())),
                3usize => Some(Field::new("svg_doc_length", self.svg_doc_length())),
                _ => None,
            }),
            data,
        }
    }
}
