// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A tool use content block. Contains information about a tool that the model is requesting be run., The model uses the result from the tool to generate a response.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ToolUseBlock {
    /// <p>The ID for the tool request.</p>
    pub tool_use_id: ::std::string::String,
    /// <p>The name of the tool that the model wants to use.</p>
    pub name: ::std::string::String,
    /// <p>The input to pass to the tool.</p>
    pub input: ::aws_smithy_types::Document,
}
impl ToolUseBlock {
    /// <p>The ID for the tool request.</p>
    pub fn tool_use_id(&self) -> &str {
        use std::ops::Deref;
        self.tool_use_id.deref()
    }
    /// <p>The name of the tool that the model wants to use.</p>
    pub fn name(&self) -> &str {
        use std::ops::Deref;
        self.name.deref()
    }
    /// <p>The input to pass to the tool.</p>
    pub fn input(&self) -> &::aws_smithy_types::Document {
        &self.input
    }
}
impl ToolUseBlock {
    /// Creates a new builder-style object to manufacture [`ToolUseBlock`](crate::types::ToolUseBlock).
    pub fn builder() -> crate::types::builders::ToolUseBlockBuilder {
        crate::types::builders::ToolUseBlockBuilder::default()
    }
}

/// A builder for [`ToolUseBlock`](crate::types::ToolUseBlock).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ToolUseBlockBuilder {
    pub(crate) tool_use_id: ::std::option::Option<::std::string::String>,
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) input: ::std::option::Option<::aws_smithy_types::Document>,
}
impl ToolUseBlockBuilder {
    /// <p>The ID for the tool request.</p>
    /// This field is required.
    pub fn tool_use_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.tool_use_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID for the tool request.</p>
    pub fn set_tool_use_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.tool_use_id = input;
        self
    }
    /// <p>The ID for the tool request.</p>
    pub fn get_tool_use_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.tool_use_id
    }
    /// <p>The name of the tool that the model wants to use.</p>
    /// This field is required.
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the tool that the model wants to use.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name of the tool that the model wants to use.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>The input to pass to the tool.</p>
    /// This field is required.
    pub fn input(mut self, input: ::aws_smithy_types::Document) -> Self {
        self.input = ::std::option::Option::Some(input);
        self
    }
    /// <p>The input to pass to the tool.</p>
    pub fn set_input(mut self, input: ::std::option::Option<::aws_smithy_types::Document>) -> Self {
        self.input = input;
        self
    }
    /// <p>The input to pass to the tool.</p>
    pub fn get_input(&self) -> &::std::option::Option<::aws_smithy_types::Document> {
        &self.input
    }
    /// Consumes the builder and constructs a [`ToolUseBlock`](crate::types::ToolUseBlock).
    /// This method will fail if any of the following fields are not set:
    /// - [`tool_use_id`](crate::types::builders::ToolUseBlockBuilder::tool_use_id)
    /// - [`name`](crate::types::builders::ToolUseBlockBuilder::name)
    /// - [`input`](crate::types::builders::ToolUseBlockBuilder::input)
    pub fn build(self) -> ::std::result::Result<crate::types::ToolUseBlock, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::ToolUseBlock {
            tool_use_id: self.tool_use_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "tool_use_id",
                    "tool_use_id was not specified but it is required when building ToolUseBlock",
                )
            })?,
            name: self.name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "name",
                    "name was not specified but it is required when building ToolUseBlock",
                )
            })?,
            input: self.input.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "input",
                    "input was not specified but it is required when building ToolUseBlock",
                )
            })?,
        })
    }
}
