/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.net.ftp.parser.VMSFTPEntryParser;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class VMSVersioningFTPEntryParser
extends VMSFTPEntryParser {
    private Perl5Matcher _preparse_matcher_;
    private Pattern _preparse_pattern_;
    private static final String PRE_PARSE_REGEX = "(.*);([0-9]+)\\s*.*";

    public VMSVersioningFTPEntryParser() {
        try {
            this._preparse_matcher_ = new Perl5Matcher();
            this._preparse_pattern_ = new Perl5Compiler().compile(PRE_PARSE_REGEX);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new IllegalArgumentException("Unparseable regex supplied:  (.*);([0-9]+)\\s*.*");
        }
    }

    protected boolean isVersioning() {
        return true;
    }

    public List preParse(List list) {
        NameVersion nameVersion;
        NameVersion nameVersion2;
        String string;
        String string2;
        MatchResult matchResult;
        String string3;
        list = super.preParse(list);
        HashMap<String, NameVersion> hashMap = new HashMap<String, NameVersion>();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            string3 = ((String)listIterator.next()).trim();
            matchResult = null;
            if (!this._preparse_matcher_.matches(string3, this._preparse_pattern_)) continue;
            matchResult = this._preparse_matcher_.getMatch();
            string2 = matchResult.group(1);
            string = matchResult.group(2);
            nameVersion2 = new NameVersion(string2, string);
            nameVersion = (NameVersion)hashMap.get(string2);
            if (nameVersion != null && nameVersion2.versionNumber < nameVersion.versionNumber) {
                listIterator.remove();
                continue;
            }
            hashMap.put(string2, nameVersion2);
        }
        while (listIterator.hasPrevious()) {
            string3 = ((String)listIterator.previous()).trim();
            matchResult = null;
            if (!this._preparse_matcher_.matches(string3, this._preparse_pattern_)) continue;
            matchResult = this._preparse_matcher_.getMatch();
            string2 = matchResult.group(1);
            string = matchResult.group(2);
            nameVersion2 = new NameVersion(string2, string);
            nameVersion = (NameVersion)hashMap.get(string2);
            if (nameVersion == null || nameVersion2.versionNumber >= nameVersion.versionNumber) continue;
            listIterator.remove();
        }
        return list;
    }

    private class NameVersion {
        String name;
        int versionNumber;

        NameVersion(String string, String string2) {
            this.name = string;
            this.versionNumber = Integer.parseInt(string2);
        }
    }
}

