/* txtserve.c */

/* Send text to clients generated by the parser */

#include <string.h>
#include "stats.h"
#include "parseout.h"
#include "wstypes.h"
#include "setup.h"
#include "config.h"
#include "server.h"

static int txtserve_bufflen = 0 ;
static char *txtserve_buffer = NULL ;

/* Build the message */

void *
txtserve_build(wsstruct *wd, int *len)
{
  statsmean means ;

  if (!setup_txt_format[0])
  {
    *len = 0 ;
    return NULL ;
  }

  stats_do_ws_means(wd, &means) ;

  if (parseout_parse_and_realloc(
    &txtserve_buffer, &txtserve_bufflen,
    &means,
    setup_txt_format, "\n") < 0) return NULL ;

  *len = strlen(txtserve_buffer) ;

  return txtserve_buffer ;
}


/* Build the message and send to clients */

int
txtserve_tx(wsstruct *wd)
{
  char *message ;
  int len ;

  message = txtserve_build(wd, &len) ;

  if (len <= 0) return -1 ;

  if (server_txt_tcp.port!=0)
  {
    /* Check connexion status */
    server_poll_clients(&server_txt_tcp) ;

    /* Send data */
    server_send_to_clients(message, &server_txt_tcp) ;
  }

#ifdef HAVE_SYS_UN_H
  if (setup_txt_un_name[0])
  {
    /* Check connexion status */
    server_poll_clients(&server_txt_un) ;

    /* Send data */
    server_send_to_clients(message, &server_txt_un) ;
  }
#endif

  return 0 ; /* Ok */
}
