/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.app;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Objects;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.admin.sessions.AbstractServerSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class ExasolServerSession
extends AbstractServerSession {
    private final BigDecimal sessionID;
    private String userName;
    private String status;
    private String commandName;
    private Integer stmtId;
    private String Duration;
    private Integer queryTimeout;
    private String activity;
    private BigDecimal tempDbRam;
    private Timestamp loginTime;
    private String client;
    private String driver;
    private Boolean encrypted;
    private String host;
    private String osUser;
    private String osName;
    private String scopeSchema;
    private String priority;
    private Boolean nice;
    private Integer resources;
    private String sqlText;

    public ExasolServerSession(ResultSet dbResult) {
        this.sessionID = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"SESSION_ID");
        this.userName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"USER_NAME");
        this.status = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS");
        this.commandName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMMAND_NAME");
        this.stmtId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"STMT_ID");
        this.Duration = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DURATION");
        this.queryTimeout = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"QUERY_TIMEOUT");
        this.activity = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACTIVITY");
        this.tempDbRam = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"TEMP_DB_RAM");
        this.loginTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LOGIN_TIME");
        this.client = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CLIENT");
        this.driver = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DRIVER");
        this.encrypted = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"ENCRYPTED");
        this.host = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"HOST");
        this.osUser = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OS_USER");
        this.osName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OS_NAME");
        this.scopeSchema = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCOPE_SCHEMA");
        this.priority = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PRIORITY");
        this.nice = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"NICE");
        this.resources = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"RESOURCES");
        this.sqlText = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SQL_TEXT");
    }

    public String toString() {
        return this.sessionID.toString();
    }

    @Nullable
    public String getActiveQuery() {
        if ("IDLE".equals(this.status)) {
            return null;
        }
        return this.sqlText;
    }

    public String getSessionId() {
        return String.valueOf(this.sessionID);
    }

    @Property(viewable=true, editable=false, order=1)
    public BigDecimal getSessionID() {
        return this.sessionID;
    }

    @Property(viewable=true, editable=false, order=2)
    public String getUserName() {
        return this.userName;
    }

    @Property(viewable=true, editable=false, order=2)
    public String getStatus() {
        return this.status;
    }

    @Property(viewable=true, editable=false, order=3)
    public String getCommandName() {
        return this.commandName;
    }

    @Property(viewable=true, editable=false, order=4)
    public Integer getStmtId() {
        return this.stmtId;
    }

    @Property(viewable=true, editable=false, order=5)
    public String getDuration() {
        return this.Duration;
    }

    @Property(viewable=true, editable=false, order=6)
    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    @Property(viewable=true, editable=false, order=7)
    public String getActivity() {
        return this.activity;
    }

    @Property(viewable=true, editable=false, order=8)
    public BigDecimal getTempDbRam() {
        return this.tempDbRam;
    }

    @Property(viewable=true, editable=false, order=9)
    public Timestamp getLoginTime() {
        return this.loginTime;
    }

    @Property(viewable=true, editable=false, order=10)
    public String getClient() {
        return this.client;
    }

    @Property(viewable=true, editable=false, order=11)
    public String getDriver() {
        return this.driver;
    }

    @Property(viewable=true, editable=false, order=12)
    public Boolean getEncrypted() {
        return this.encrypted;
    }

    @Property(viewable=true, editable=false, order=13)
    public String getHost() {
        return this.host;
    }

    @Property(viewable=true, editable=false, order=14)
    public String getOsUser() {
        return this.osUser;
    }

    @Property(viewable=true, editable=false, order=15)
    public String getOsName() {
        return this.osName;
    }

    @Property(viewable=true, editable=false, order=16)
    public String getScopeSchema() {
        return this.scopeSchema;
    }

    @Property(viewable=true, editable=false, order=17)
    public String getPriority() {
        return this.priority;
    }

    @Property(viewable=true, editable=false, order=18)
    public Boolean getNice() {
        return this.nice;
    }

    @Property(viewable=true, editable=false, order=19)
    public Integer getResources() {
        return this.resources;
    }

    @Property(viewable=true, editable=false, order=20)
    public String getSqlText() {
        return this.sqlText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ExasolServerSession that = (ExasolServerSession)((Object)o);
        return this.sessionID != null && this.sessionID.compareTo(that.sessionID) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.sessionID);
    }
}

