/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.Date;
import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ExasolConnection
implements DBPRefreshableObject,
DBPNamedObject2,
DBPSaveableObject,
DBPScriptObject {
    private ExasolDataSource dataSource;
    private String connectionName;
    private String connectionString;
    private String userName;
    private String password = "";
    private Date created;
    private String comment = "";
    private Boolean persisted;

    public ExasolConnection(ExasolDataSource dataSource) {
        this.dataSource = dataSource;
        this.persisted = false;
    }

    public ExasolConnection(ExasolDataSource dataSource, String name, String url, String comment, String user, String password) {
        this.persisted = false;
        this.connectionName = name;
        this.connectionString = url;
        this.comment = comment;
        this.userName = user;
        this.password = password;
        this.dataSource = dataSource;
    }

    public ExasolConnection(ExasolDataSource dataSource, ResultSet dbResult) {
        this.dataSource = dataSource;
        if (dbResult != null) {
            this.persisted = true;
            this.connectionName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONNECTION_NAME");
            this.connectionString = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONNECTION_STRING");
            this.created = JDBCUtils.safeGetDate((ResultSet)dbResult, (String)"CREATED");
            this.comment = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONNECTION_COMMENT");
            this.userName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"USER_NAME");
        } else {
            this.connectionName = "new connection";
            this.persisted = false;
            this.password = "";
        }
    }

    @Property(viewable=true, editable=true, order=10)
    @NotNull
    public String getName() {
        return this.connectionName;
    }

    public void setName(@NotNull String name) {
        this.connectionName = name;
    }

    @Property(viewable=true, editable=true, updatable=true, order=20)
    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String url) {
        this.connectionString = url;
    }

    @Property(viewable=true, order=30)
    public Date getCreated() {
        return this.created;
    }

    @Property(viewable=true, editable=true, updatable=true, order=30)
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=50)
    public String getDescription() {
        return this.comment;
    }

    public void setDescription(String comment) {
        this.comment = comment;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public ExasolDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.getDataSource().refreshObject(monitor);
        return this;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.getDataSource().isAuthorizedForConnections()) {
            return ExasolUtils.getConnectionDdl(this, monitor);
        }
        return "User needs full access to dictionary or dba privilege to generate ddl for connections";
    }

    @Property(viewable=true, editable=true, updatable=true, password=true, order=35)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        return "Connection " + this.getName();
    }
}

