/*******************************************************************/
/*  slibtool: a strong libtool implementation, written in C        */
/*  Copyright (C) 2016--2024  SysDeer Technologies, LLC            */
/*  Released under the Standard MIT License; see COPYING.SLIBTOOL. */
/*******************************************************************/

#include <fcntl.h>
#include <stdio.h>
#include <slibtool/slibtool.h>
#include "slibtool_driver_impl.h"
#include "slibtool_dprintf_impl.h"
#include "slibtool_errinfo_impl.h"
#include "slibtool_metafile_impl.h"
#include "slibtool_visibility_impl.h"

static int  slbt_create_default_object_wrapper(
	const struct slbt_driver_ctx *	dctx,
	struct slbt_exec_ctx *		ectx)
{
	int					ret;
	int					fdout;
	const struct slbt_source_version *	verinfo;

	if ((fdout = openat(
			slbt_driver_fdcwd(dctx),
			ectx->ltobjname,
			O_RDWR|O_CREAT|O_TRUNC,
			0644)) < 0)
		return SLBT_SYSTEM_ERROR(dctx,ectx->ltobjname);

	verinfo = slbt_api_source_version();

	ret = slbt_dprintf(fdout,
		"# libtool compatible object wrapper\n"
		"# Generated by %s (slibtool %d.%d.%d)\n"
		"# [commit reference: %s]\n\n"

		"pic_object='%s'\n"
		"non_pic_object='%s'\n",

		dctx->program,
		verinfo->major,verinfo->minor,verinfo->revision,
		verinfo->commit,

		(dctx->cctx->drvflags & SLBT_DRIVER_SHARED)
			? ectx->lobjname
			: "none",
		(dctx->cctx->drvflags & SLBT_DRIVER_STATIC)
			? ectx->aobjname
			: "none");

	close(fdout);

	return (ret < 0) ? SLBT_SYSTEM_ERROR(dctx,0) : 0;
}

static int  slbt_create_compatible_object_wrapper(
	const struct slbt_driver_ctx *	dctx,
	struct slbt_exec_ctx *		ectx)
{
	int					ret;
	int					fdout;
	const struct slbt_source_version *	verinfo;

	if ((fdout = openat(
			slbt_driver_fdcwd(dctx),
			ectx->ltobjname,
			O_RDWR|O_CREAT|O_TRUNC,
			0644)) < 0)
		return SLBT_SYSTEM_ERROR(dctx, ectx->ltobjname);

	verinfo = slbt_api_source_version();

	ret = slbt_dprintf(fdout,
		"# %s - a libtool object file\n"
		"# Generated by %s (slibtool %d.%d.%d)\n"
		"# [commit reference: %s]\n"
		"#\n"
		"# Please DO NOT delete this file!\n"
		"# It is necessary for linking the library.\n\n"

		"# Name of the PIC object.\n"
		"pic_object='%s'\n\n"

		"# Name of the non-PIC object\n"
		"non_pic_object='%s'\n",

		ectx->ltobjname,
		dctx->program,
		verinfo->major,verinfo->minor,verinfo->revision,
		verinfo->commit,

		(dctx->cctx->drvflags & SLBT_DRIVER_SHARED)
			? ectx->lobjname
			: "none",
		(dctx->cctx->drvflags & SLBT_DRIVER_STATIC)
			? ectx->aobjname
			: "none");

	close(fdout);

	return (ret < 0) ? SLBT_SYSTEM_ERROR(dctx,0) : 0;
}

slbt_hidden int slbt_create_object_wrapper(
	const struct slbt_driver_ctx *	dctx,
	struct slbt_exec_ctx *		ectx)
{
	if (dctx->cctx->drvflags & SLBT_DRIVER_LEGABITS)
		return slbt_create_compatible_object_wrapper(dctx,ectx);
	else
		return slbt_create_default_object_wrapper(dctx,ectx);
}
