/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.List;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;

public class RangeVariableResolver {
    Session session;
    QuerySpecification select;
    RangeVariable[] rangeVariables;
    Expression conditions;
    OrderedHashSet<RangeVariable> rangeVarSet = new OrderedHashSet();
    ParserDQL.CompileContext compileContext;
    SortAndSlice sortAndSlice = SortAndSlice.noSort;
    boolean reorder;
    HsqlArrayList<Expression>[] tempJoinExpressions;
    HsqlArrayList<Expression>[] joinExpressions;
    HsqlArrayList<Expression>[] whereExpressions;
    HsqlArrayList<Expression> queryConditions = new HsqlArrayList();
    Expression[] inExpressions;
    boolean[] inInJoin;
    int inExpressionCount = 0;
    boolean expandInExpression = true;
    int firstLeftJoinIndex;
    int firstRightJoinIndex;
    int lastRightJoinIndex;
    int firstLateralJoinIndex;
    int firstOuterJoinIndex;
    int lastOuterJoinIndex;
    OrderedIntHashSet colIndexSetEqual = new OrderedIntHashSet();
    IntKeyIntValueHashMap colIndexSetOther = new IntKeyIntValueHashMap();
    OrderedHashSet<Expression> tempExprSet = new OrderedHashSet();
    OrderedHashSet<RangeVariable> tempRangeSet = new OrderedHashSet();
    HashMap<ColumnSchema, Expression> tempMap = new HashMap();
    MultiValueHashMap<ColumnSchema, Expression> tempMultiMap = new MultiValueHashMap();

    RangeVariableResolver(Session session, QuerySpecification querySpecification) {
        this.session = session;
        this.select = querySpecification;
        this.rangeVariables = querySpecification.rangeVariables;
        this.conditions = querySpecification.queryCondition;
        this.compileContext = querySpecification.compileContext;
        this.sortAndSlice = querySpecification.sortAndSlice;
        this.reorder = true;
        this.initialise();
    }

    RangeVariableResolver(Session session, RangeVariable[] rangeVariableArray, Expression expression, ParserDQL.CompileContext compileContext, boolean bl) {
        this.session = session;
        this.rangeVariables = rangeVariableArray;
        this.conditions = expression;
        this.compileContext = compileContext;
        this.reorder = bl;
        this.initialise();
    }

    private void initialise() {
        int n;
        this.firstLeftJoinIndex = this.rangeVariables.length;
        this.firstRightJoinIndex = this.rangeVariables.length;
        this.firstLateralJoinIndex = this.rangeVariables.length;
        this.firstOuterJoinIndex = this.rangeVariables.length;
        this.inExpressions = new Expression[this.rangeVariables.length];
        this.inInJoin = new boolean[this.rangeVariables.length];
        this.tempJoinExpressions = new HsqlArrayList[this.rangeVariables.length];
        for (n = 0; n < this.rangeVariables.length; ++n) {
            this.tempJoinExpressions[n] = new HsqlArrayList();
        }
        this.joinExpressions = new HsqlArrayList[this.rangeVariables.length];
        for (n = 0; n < this.rangeVariables.length; ++n) {
            this.joinExpressions[n] = new HsqlArrayList();
        }
        this.whereExpressions = new HsqlArrayList[this.rangeVariables.length];
        for (n = 0; n < this.rangeVariables.length; ++n) {
            this.whereExpressions[n] = new HsqlArrayList();
        }
        this.queryConditions.clear();
    }

    void processConditions() {
        Object object;
        int n;
        if (this.session.sessionOptimization < 8) {
            this.reorder = false;
        }
        RangeVariableResolver.decomposeAndConditions(this.session, this.conditions, this.queryConditions);
        for (n = 0; n < this.rangeVariables.length; ++n) {
            this.rangeVarSet.add(this.rangeVariables[n]);
            if (this.rangeVariables[n].joinCondition == null) continue;
            RangeVariableResolver.decomposeAndConditions(this.session, this.rangeVariables[n].joinCondition, this.tempJoinExpressions[n]);
        }
        for (n = 0; n < this.queryConditions.size(); ++n) {
            int n2;
            object = this.queryConditions.get(n);
            if (((Expression)object).isTrue() || !((Expression)object).isSingleColumnEqual && !((Expression)object).isColumnCondition) continue;
            RangeVariable rangeVariable = ((Expression)object).getLeftNode().getRangeVariable();
            if (((Expression)object).getLeftNode().opType == 2 && rangeVariable != null && (n2 = this.rangeVarSet.getIndex(rangeVariable)) > 0) {
                this.rangeVariables[n2].isLeftJoin = false;
            }
            rangeVariable = ((Expression)object).getRightNode().getRangeVariable();
            if (((Expression)object).getRightNode().opType != 2 || rangeVariable == null || (n2 = this.rangeVarSet.getIndex(rangeVariable)) <= 0) continue;
            this.rangeVariables[n2].isLeftJoin = false;
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            object = this.rangeVariables[n];
            boolean bl = false;
            if (((RangeVariable)object).isLeftJoin) {
                if (this.firstLeftJoinIndex == this.rangeVariables.length) {
                    this.firstLeftJoinIndex = n;
                }
                bl = true;
            }
            if (((RangeVariable)object).isRightJoin) {
                if (this.firstRightJoinIndex == this.rangeVariables.length) {
                    this.firstRightJoinIndex = n;
                }
                this.lastRightJoinIndex = n;
                bl = true;
            }
            if (((RangeVariable)object).isLateral) {
                if (this.firstLateralJoinIndex == this.rangeVariables.length) {
                    this.firstLateralJoinIndex = n;
                }
                bl = true;
            }
            if (!bl) continue;
            if (this.firstOuterJoinIndex == this.rangeVariables.length) {
                this.firstOuterJoinIndex = n;
            }
            this.lastOuterJoinIndex = n;
        }
        this.expandConditions();
        this.conditions = null;
        this.reorder();
        this.assignToLists();
        this.assignToRangeVariables();
        if (this.select != null) {
            this.select.startInnerRange = 0;
            this.select.endInnerRange = this.rangeVariables.length;
            if (this.firstRightJoinIndex < this.rangeVariables.length) {
                this.select.startInnerRange = this.firstRightJoinIndex;
            }
            if (this.firstLeftJoinIndex < this.rangeVariables.length) {
                this.select.endInnerRange = this.firstLeftJoinIndex;
            }
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            this.rangeVariables[n].rangePositionInJoin = n;
        }
        if (this.expandInExpression && this.inExpressionCount != 0) {
            this.setInConditionsAsTables();
        }
    }

    static Expression decomposeAndConditions(Session session, Expression expression, List<Expression> list) {
        if (expression == null) {
            return Expression.EXPR_TRUE;
        }
        Expression expression2 = expression.getLeftNode();
        Expression expression3 = expression.getRightNode();
        int n = expression.getType();
        if (n == 49) {
            expression2 = RangeVariableResolver.decomposeAndConditions(session, expression2, list);
            expression3 = RangeVariableResolver.decomposeAndConditions(session, expression3, list);
            if (expression2.isTrue()) {
                return expression3;
            }
            if (expression3.isTrue()) {
                return expression2;
            }
            expression.setLeftNode(expression2);
            expression.setRightNode(expression3);
            return expression;
        }
        if (n == 40 && expression2.getType() == 25 && expression3.getType() == 25) {
            for (int i = 0; i < expression2.nodes.length; ++i) {
                ExpressionLogical expressionLogical = new ExpressionLogical(expression2.nodes[i], expression3.nodes[i]);
                ((Expression)expressionLogical).resolveTypes(session, null);
                list.add(expressionLogical);
            }
            return Expression.EXPR_TRUE;
        }
        if (!expression.isTrue()) {
            list.add(expression);
        }
        return Expression.EXPR_TRUE;
    }

    static Expression decomposeOrConditions(Expression expression, List<Expression> list) {
        if (expression == null) {
            return Expression.EXPR_FALSE;
        }
        Expression expression2 = expression.getLeftNode();
        Expression expression3 = expression.getRightNode();
        int n = expression.getType();
        if (n == 50) {
            expression2 = RangeVariableResolver.decomposeOrConditions(expression2, list);
            expression3 = RangeVariableResolver.decomposeOrConditions(expression3, list);
            if (expression2.isFalse()) {
                return expression3;
            }
            if (expression3.isFalse()) {
                return expression2;
            }
            expression = new ExpressionLogical(50, expression2, expression3);
            return expression;
        }
        if (!expression.isFalse()) {
            list.add(expression);
        }
        return Expression.EXPR_FALSE;
    }

    void expandConditions() {
        int n;
        HsqlArrayList<Expression>[] hsqlArrayListArray = this.tempJoinExpressions;
        if (this.firstRightJoinIndex == this.rangeVariables.length) {
            this.moveConditions(hsqlArrayListArray, 0, this.firstOuterJoinIndex, this.queryConditions, -1);
        }
        if (this.firstOuterJoinIndex < 2) {
            return;
        }
        for (n = 0; n < this.firstOuterJoinIndex; ++n) {
            this.moveConditions(hsqlArrayListArray, 0, this.firstOuterJoinIndex, hsqlArrayListArray[n], n);
        }
        if (this.firstOuterJoinIndex < 3) {
            return;
        }
        for (n = 0; n < this.firstOuterJoinIndex; ++n) {
            Expression expression;
            Object object;
            Object object2;
            HsqlArrayList<Expression> hsqlArrayList = hsqlArrayListArray[n];
            this.tempMultiMap.clear();
            this.tempExprSet.clear();
            this.tempMap.clear();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < hsqlArrayList.size(); ++i) {
                object2 = hsqlArrayList.get(i);
                if (((Expression)object2).isTrue()) continue;
                if (((Expression)object2).isSingleColumnEqual) {
                    bl = true;
                    if (((Expression)object2).getLeftNode().opType == 2) {
                        this.tempMap.put(((Expression)object2).getLeftNode().getColumn(), ((Expression)object2).getRightNode());
                        continue;
                    }
                    if (((Expression)object2).getRightNode().opType != 2) continue;
                    this.tempMap.put(((Expression)object2).getRightNode().getColumn(), ((Expression)object2).getLeftNode());
                    continue;
                }
                if (!((Expression)object2).isColumnEqual || ((Expression)object2).getLeftNode().getRangeVariable() == ((Expression)object2).getRightNode().getRangeVariable() || ((Expression)object2).getLeftNode().getRangeVariable() == null || ((Expression)object2).getRightNode().getRangeVariable() == null) continue;
                int n2 = this.rangeVarSet.getIndex(((Expression)object2).getLeftNode().getRangeVariable());
                if (n2 < 0) {
                    ((Expression)object2).isSingleColumnEqual = true;
                    ((Expression)object2).isSingleColumnCondition = true;
                    this.tempMap.put(((Expression)object2).getRightNode().getColumn(), ((Expression)object2).getLeftNode());
                    continue;
                }
                if (n2 >= this.firstOuterJoinIndex) continue;
                n2 = this.rangeVarSet.getIndex(((Expression)object2).getRightNode().getRangeVariable());
                if (n2 < 0) {
                    ((Expression)object2).isSingleColumnEqual = true;
                    ((Expression)object2).isSingleColumnCondition = true;
                    this.tempMap.put(((Expression)object2).getRightNode().getColumn(), ((Expression)object2).getLeftNode());
                    continue;
                }
                if (n2 >= this.firstOuterJoinIndex) continue;
                bl2 = true;
                if (((Expression)object2).getLeftNode().getRangeVariable() == this.rangeVariables[n]) {
                    object = ((Expression)object2).getLeftNode().getColumn();
                    this.tempMultiMap.put((ColumnSchema)object, ((Expression)object2).getRightNode());
                    if (this.tempMultiMap.valueCount((ColumnSchema)object) <= 1) continue;
                    bl3 = true;
                    continue;
                }
                if (((Expression)object2).getRightNode().getRangeVariable() != this.rangeVariables[n]) continue;
                object = ((Expression)object2).getRightNode().getColumn();
                this.tempMultiMap.put((ColumnSchema)object, ((Expression)object2).getLeftNode());
                if (this.tempMultiMap.valueCount((ColumnSchema)object) <= 1) continue;
                bl3 = true;
            }
            if (bl3) {
                Iterator iterator = this.tempMultiMap.keySet().iterator();
                while (iterator.hasNext()) {
                    object2 = (ColumnSchema)iterator.next();
                    Iterator<Expression> iterator2 = this.tempMultiMap.getValuesIterator(object2);
                    this.tempExprSet.clear();
                    while (iterator2.hasNext()) {
                        this.tempExprSet.add(iterator2.next());
                    }
                    while (this.tempExprSet.size() > 1) {
                        object = this.tempExprSet.remove(this.tempExprSet.size() - 1);
                        for (int i = 0; i < this.tempExprSet.size(); ++i) {
                            expression = this.tempExprSet.get(i);
                            this.closeJoinChain(hsqlArrayListArray, (Expression)object, expression);
                        }
                    }
                }
            }
            if (!bl2 || !bl) continue;
            Iterator iterator = this.tempMultiMap.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (ColumnSchema)iterator.next();
                Expression expression2 = this.tempMap.get(object2);
                if (expression2 == null) continue;
                object = this.tempMultiMap.getValuesIterator(object2);
                while (object.hasNext()) {
                    Expression expression3 = object.next();
                    expression = new ExpressionLogical(expression2, expression3);
                    int n3 = this.rangeVarSet.getIndex(expression3.getRangeVariable());
                    hsqlArrayListArray[n3].add(expression);
                }
            }
        }
    }

    void moveConditions(List<Expression>[] listArray, int n, int n2, List<Expression> list, int n3) {
        for (int i = 0; i < list.size(); ++i) {
            Expression expression = list.get(i);
            this.tempRangeSet.clear();
            expression.collectRangeVariables(this.rangeVariables, this.tempRangeSet);
            int n4 = this.rangeVarSet.getSmallestIndex(this.tempRangeSet);
            if (n4 < n || (n4 = this.rangeVarSet.getLargestIndex(this.tempRangeSet)) >= n2 || n4 == n3) continue;
            list.remove(i);
            listArray[n4].add(expression);
            --i;
        }
    }

    void closeJoinChain(List<Expression>[] listArray, Expression expression, Expression expression2) {
        int n;
        int n2;
        int n3 = this.rangeVarSet.getIndex(expression.getRangeVariable());
        int n4 = n2 = n3 > (n = this.rangeVarSet.getIndex(expression2.getRangeVariable())) ? n3 : n;
        if (n3 == -1 || n == -1) {
            return;
        }
        ExpressionLogical expressionLogical = new ExpressionLogical(expression, expression2);
        for (int i = 0; i < listArray[n2].size(); ++i) {
            if (!expressionLogical.equals(listArray[n2].get(i))) continue;
            return;
        }
        listArray[n2].add(expressionLogical);
    }

    void reorder() {
        if (!this.reorder) {
            return;
        }
        if (this.rangeVariables.length == 1 || this.firstRightJoinIndex != this.rangeVariables.length) {
            return;
        }
        if (this.firstLeftJoinIndex == 1) {
            return;
        }
        if (this.firstLateralJoinIndex != this.rangeVariables.length) {
            return;
        }
        if (this.sortAndSlice.usingIndex && this.sortAndSlice.primaryTableIndex != null) {
            return;
        }
        HsqlArrayList<Expression> hsqlArrayList = new HsqlArrayList<Expression>();
        HsqlArrayList<Expression> hsqlArrayList2 = new HsqlArrayList<Expression>();
        for (int i = 0; i < this.firstLeftJoinIndex; ++i) {
            HsqlArrayList<Expression> hsqlArrayList3 = this.tempJoinExpressions[i];
            for (int j = 0; j < hsqlArrayList3.size(); ++j) {
                Expression expression = hsqlArrayList3.get(j);
                if (expression.isColumnEqual) {
                    hsqlArrayList.add(expression);
                    continue;
                }
                if (!expression.isSingleColumnCondition) continue;
                hsqlArrayList2.add(expression);
            }
        }
        this.reorderRanges(hsqlArrayList2, hsqlArrayList);
    }

    void reorderRanges(HsqlArrayList<Expression> hsqlArrayList, HsqlArrayList<Expression> hsqlArrayList2) {
        int n;
        int n2;
        Object object;
        Object object2;
        if (hsqlArrayList.isEmpty()) {
            return;
        }
        int n3 = -1;
        RangeVariable rangeVariable = null;
        double d = 1024.0;
        for (int i = 0; i < this.firstLeftJoinIndex; ++i) {
            Table table = this.rangeVariables[i].rangeTable;
            if (table instanceof TableDerived) continue;
            this.collectIndexableColumns(this.rangeVariables[i], hsqlArrayList);
            object2 = table.getIndexForColumns(this.session, this.colIndexSetEqual, 40, false);
            object = null;
            for (n2 = 0; n2 < ((Index.IndexUse[])object2).length; ++n2) {
                object = object2[n2].index;
                double d2 = this.searchCost(this.session, table, (Index)object, object2[n2].columnCount, 40);
                if (!(d2 < d)) continue;
                d = d2;
                n3 = i;
            }
            if (object == null) {
                Iterator iterator = this.colIndexSetOther.keySet().iterator();
                while (iterator.hasNext()) {
                    int n4 = iterator.nextInt();
                    object = table.getIndexForColumn(this.session, n4);
                    if (object == null) continue;
                    d = (double)table.getRowStore(this.session).elementCount() / 2.0;
                    if (this.colIndexSetOther.get(n4, 0) <= 1) break;
                    d /= 2.0;
                    break;
                }
            }
            if (object == null || i != 0) continue;
            n3 = 0;
            break;
        }
        if (n3 < 0) {
            return;
        }
        if (n3 == 0 && this.firstLeftJoinIndex == 2) {
            return;
        }
        RangeVariable[] rangeVariableArray = new RangeVariable[this.rangeVariables.length];
        ArrayUtil.copyArray(this.rangeVariables, rangeVariableArray, this.rangeVariables.length);
        rangeVariable = rangeVariableArray[n3];
        rangeVariableArray[n3] = rangeVariableArray[0];
        rangeVariableArray[0] = rangeVariable;
        for (n3 = 1; n3 < this.firstLeftJoinIndex; ++n3) {
            int n5;
            boolean bl = false;
            for (n5 = 0; n5 < hsqlArrayList2.size(); ++n5) {
                object = hsqlArrayList2.get(n5);
                if (object == null || (n2 = this.getJoinedRangePosition((Expression)object, n3, rangeVariableArray)) < n3) continue;
                rangeVariable = rangeVariableArray[n3];
                rangeVariableArray[n3] = rangeVariableArray[n2];
                rangeVariableArray[n2] = rangeVariable;
                hsqlArrayList2.set(n5, null);
                bl = true;
                break;
            }
            if (bl) continue;
            for (n5 = 0; n5 < rangeVariableArray.length; ++n5) {
                object = rangeVariableArray[n5].rangeTable;
                this.collectIndexableColumns(rangeVariableArray[n5], hsqlArrayList);
                Index.IndexUse[] indexUseArray = ((Table)object).getIndexForColumns(this.session, this.colIndexSetEqual, 40, false);
                if (indexUseArray.length <= 0) continue;
                bl = true;
                break;
            }
            if (!bl) break;
        }
        if (n3 != this.firstLeftJoinIndex) {
            return;
        }
        ArrayUtil.copyArray(rangeVariableArray, this.rangeVariables, this.rangeVariables.length);
        hsqlArrayList2.clear();
        for (n = 0; n < this.firstLeftJoinIndex; ++n) {
            object2 = this.tempJoinExpressions[n];
            hsqlArrayList2.addAll((Collection)object2);
            ((HsqlArrayList)object2).clear();
        }
        this.tempJoinExpressions[this.firstLeftJoinIndex - 1].addAll(hsqlArrayList2);
        this.rangeVarSet.clear();
        for (n = 0; n < this.rangeVariables.length; ++n) {
            this.rangeVarSet.add(this.rangeVariables[n]);
        }
    }

    int getJoinedRangePosition(Expression expression, int n, RangeVariable[] rangeVariableArray) {
        int n2 = -1;
        this.tempRangeSet.clear();
        expression.getJoinRangeVariables(rangeVariableArray, this.tempRangeSet);
        for (int i = 0; i < this.tempRangeSet.size(); ++i) {
            for (int j = 0; j < rangeVariableArray.length; ++j) {
                if (this.tempRangeSet.get(i) != rangeVariableArray[j] || j < n) continue;
                if (n2 > 0) {
                    return -1;
                }
                n2 = j;
            }
        }
        return n2;
    }

    void assignToLists() {
        int n;
        int n2 = -1;
        for (n = 0; n < this.rangeVariables.length; ++n) {
            if (this.rangeVariables[n].isLeftJoin) {
                n2 = n;
            }
            if (this.rangeVariables[n].isRightJoin) {
                n2 = n;
            }
            if (n2 == n) {
                this.joinExpressions[n].addAll(this.tempJoinExpressions[n]);
                continue;
            }
            int n3 = n2 + 1;
            for (int i = 0; i < this.tempJoinExpressions[n].size(); ++i) {
                Expression expression = this.tempJoinExpressions[n].get(i);
                this.assignToJoinLists(expression, this.joinExpressions, n3);
            }
        }
        for (n = 0; n < this.queryConditions.size(); ++n) {
            this.assignToJoinLists(this.queryConditions.get(n), this.whereExpressions, this.lastRightJoinIndex);
        }
    }

    void assignToJoinLists(Expression expression, List<Expression>[] listArray, int n) {
        if (expression == null) {
            return;
        }
        this.tempRangeSet.clear();
        expression.collectRangeVariables(this.rangeVariables, this.tempRangeSet);
        int n2 = this.rangeVarSet.getLargestIndex(this.tempRangeSet);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n2 < n) {
            n2 = n;
        }
        if (expression instanceof ExpressionLogical && ((ExpressionLogical)expression).isTerminal) {
            n2 = listArray.length - 1;
        }
        listArray[n2].add(expression);
    }

    void assignToRangeVariables() {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            RangeVariable.RangeVariableConditions rangeVariableConditions;
            boolean bl = false;
            if (i < this.firstLeftJoinIndex && this.firstRightJoinIndex == this.rangeVariables.length) {
                rangeVariableConditions = this.rangeVariables[i].joinConditions[0];
                this.joinExpressions[i].addAll(this.whereExpressions[i]);
                this.setIndexConditions(rangeVariableConditions, this.joinExpressions[i], i, true);
                this.assignToRangeVariable(rangeVariableConditions, this.joinExpressions[i]);
                continue;
            }
            rangeVariableConditions = this.rangeVariables[i].joinConditions[0];
            this.setIndexConditions(rangeVariableConditions, this.joinExpressions[i], i, true);
            rangeVariableConditions = this.rangeVariables[i].joinConditions[0];
            if (rangeVariableConditions.hasIndex()) {
                bl = true;
            }
            this.assignToRangeVariable(rangeVariableConditions, this.joinExpressions[i]);
            rangeVariableConditions = this.rangeVariables[i].whereConditions[0];
            for (int j = i + 1; j < this.rangeVariables.length; ++j) {
                if (!this.rangeVariables[j].isRightJoin) continue;
                this.assignToRangeVariable(this.rangeVariables[j].whereConditions[0], this.whereExpressions[i]);
            }
            if (!bl) {
                this.setIndexConditions(rangeVariableConditions, this.whereExpressions[i], i, true);
            }
            this.assignToRangeVariable(rangeVariableConditions, this.whereExpressions[i]);
        }
    }

    void assignToRangeVariable(RangeVariable.RangeVariableConditions rangeVariableConditions, List<Expression> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = list.get(i);
            rangeVariableConditions.addCondition(expression);
        }
    }

    private void collectIndexableColumns(RangeVariable rangeVariable, List<Expression> list) {
        this.colIndexSetEqual.clear();
        this.colIndexSetOther.clear();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            Expression expression = list.get(i);
            if (!expression.isSingleColumnCondition) continue;
            if (expression.getLeftNode().getRangeVariable() == rangeVariable) {
                n2 = expression.getLeftNode().getColumnIndex();
            } else {
                if (expression.getRightNode().getRangeVariable() != rangeVariable) continue;
                n2 = expression.getRightNode().getColumnIndex();
            }
            if (expression.isSingleColumnEqual) {
                this.colIndexSetEqual.add(n2);
                continue;
            }
            int n3 = this.colIndexSetOther.get(n2, 0);
            this.colIndexSetOther.put(n2, n3 + 1);
        }
    }

    private void setIndexConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, List<Expression> list, int n, boolean bl) {
        int n2;
        if (list.isEmpty()) {
            return;
        }
        this.colIndexSetEqual.clear();
        this.colIndexSetOther.clear();
        int n3 = list.size();
        block8: for (n2 = 0; n2 < n3; ++n2) {
            Expression expression = list.get(n2);
            if (expression == null || !expression.isIndexable(rangeVariableConditions.rangeVar)) continue;
            int n4 = expression.getType();
            switch (n4) {
                case 50: {
                    continue block8;
                }
                case 2: {
                    continue block8;
                }
                case 40: {
                    if (expression.getSubType() == 52 || expression.getSubType() == 51 || expression.getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar) continue block8;
                    int n5 = expression.getLeftNode().getColumnIndex();
                    this.colIndexSetEqual.add(n5);
                    continue block8;
                }
                case 47: {
                    if (expression.getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar || rangeVariableConditions.rangeVar.isLeftJoin) continue block8;
                    int n5 = expression.getLeftNode().getColumnIndex();
                    this.colIndexSetEqual.add(n5);
                    continue block8;
                }
                case 48: {
                    if (expression.getLeftNode().getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar || rangeVariableConditions.rangeVar.isLeftJoin) continue block8;
                    int n5 = expression.getLeftNode().getLeftNode().getColumnIndex();
                    int n6 = this.colIndexSetOther.get(n5, 0);
                    this.colIndexSetOther.put(n5, n6 + 1);
                    continue block8;
                }
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    if (expression.getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar) continue block8;
                    int n5 = expression.getLeftNode().getColumnIndex();
                    int n6 = this.colIndexSetOther.get(n5, 0);
                    this.colIndexSetOther.put(n5, n6 + 1);
                    continue block8;
                }
                default: {
                    throw Error.runtimeError(201, "RangeVariableResolver");
                }
            }
        }
        this.setEqualityConditions(rangeVariableConditions, list, n);
        boolean bl2 = rangeVariableConditions.hasIndex();
        if (!bl2) {
            this.setNonEqualityConditions(rangeVariableConditions, list, n);
            bl2 = rangeVariableConditions.hasIndex();
        }
        if (n == 0 && this.sortAndSlice.usingIndex) {
            bl2 = true;
        }
        n2 = 0;
        if (!bl2 && bl) {
            int n7 = list.size();
            for (n3 = 0; n3 < n7; ++n3) {
                Expression expression = list.get(n3);
                if (expression == null) continue;
                if (expression.getType() == 50) {
                    bl2 = this.setOrConditions(rangeVariableConditions, (ExpressionLogical)expression, n);
                    if (!bl2) continue;
                    list.set(n3, null);
                    n2 = 1;
                    break;
                }
                if (expression.getType() != 40 || expression.exprSubType != 52 || n >= this.firstLeftJoinIndex || this.firstRightJoinIndex != this.rangeVariables.length || expression.getRightNode().isCorrelated()) continue;
                OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
                ((ExpressionLogical)expression).addLeftColumnsForAllAny(rangeVariableConditions.rangeVar, orderedIntHashSet);
                Index.IndexUse[] indexUseArray = rangeVariableConditions.rangeVar.rangeTable.getIndexForColumns(this.session, orderedIntHashSet, 40, false);
                if (indexUseArray.length == 0 || this.inExpressions[n] != null) continue;
                this.inExpressions[n] = expression;
                this.inInJoin[n] = rangeVariableConditions.isJoin;
                ++this.inExpressionCount;
                list.set(n3, null);
                break;
            }
        }
        int n8 = list.size();
        for (n3 = 0; n3 < n8; ++n3) {
            Expression expression = list.get(n3);
            if (expression == null) continue;
            if (n2 != 0) {
                for (int i = 0; i < rangeVariableConditions.rangeVar.joinConditions.length; ++i) {
                    if (rangeVariableConditions.isJoin) {
                        rangeVariableConditions.rangeVar.joinConditions[i].nonIndexCondition = ExpressionLogical.andExpressions(expression, rangeVariableConditions.rangeVar.joinConditions[i].nonIndexCondition);
                        continue;
                    }
                    rangeVariableConditions.rangeVar.whereConditions[i].nonIndexCondition = ExpressionLogical.andExpressions(expression, rangeVariableConditions.rangeVar.whereConditions[i].nonIndexCondition);
                }
                continue;
            }
            rangeVariableConditions.addCondition(expression);
            list.set(n3, null);
        }
    }

    private boolean setOrConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, ExpressionLogical expressionLogical, int n) {
        Object object;
        Object object2;
        HsqlArrayList<Expression> hsqlArrayList = new HsqlArrayList<Expression>();
        RangeVariableResolver.decomposeOrConditions(expressionLogical, hsqlArrayList);
        Object[] objectArray = new RangeVariable.RangeVariableConditions[hsqlArrayList.size()];
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            HsqlArrayList<Expression> hsqlArrayList2 = new HsqlArrayList<Expression>();
            object2 = hsqlArrayList.get(i);
            RangeVariableResolver.decomposeAndConditions(this.session, (Expression)object2, hsqlArrayList2);
            object = new RangeVariable.RangeVariableConditions(rangeVariableConditions);
            this.setIndexConditions((RangeVariable.RangeVariableConditions)object, hsqlArrayList2, n, false);
            objectArray[i] = object;
            if (((RangeVariable.RangeVariableConditions)object).hasIndex()) continue;
            return false;
        }
        Expression expression = null;
        for (int i = 0; i < objectArray.length; ++i) {
            object2 = objectArray[i];
            objectArray[i].excludeConditions = expression;
            if (i == objectArray.length - 1) break;
            object = null;
            if (((RangeVariable.RangeVariableConditions)object2).indexCond != null) {
                for (int j = 0; j < ((RangeVariable.RangeVariableConditions)object2).indexedColumnCount; ++j) {
                    object = ExpressionLogical.andExpressions((Expression)object, ((RangeVariable.RangeVariableConditions)object2).indexCond[j]);
                }
            }
            object = ExpressionLogical.andExpressions((Expression)object, ((RangeVariable.RangeVariableConditions)object2).indexEndCondition);
            object = ExpressionLogical.andExpressions((Expression)object, ((RangeVariable.RangeVariableConditions)object2).nonIndexCondition);
            expression = ExpressionLogical.orExpressions((Expression)object, expression);
        }
        if (expression != null) {
            // empty if block
        }
        if (rangeVariableConditions.isJoin) {
            rangeVariableConditions.rangeVar.joinConditions = objectArray;
            objectArray = new RangeVariable.RangeVariableConditions[hsqlArrayList.size()];
            ArrayUtil.fillArray(objectArray, rangeVariableConditions.rangeVar.whereConditions[0]);
            rangeVariableConditions.rangeVar.whereConditions = objectArray;
        } else {
            rangeVariableConditions.rangeVar.whereConditions = objectArray;
            objectArray = new RangeVariable.RangeVariableConditions[hsqlArrayList.size()];
            ArrayUtil.fillArray(objectArray, rangeVariableConditions.rangeVar.joinConditions[0]);
            rangeVariableConditions.rangeVar.joinConditions = objectArray;
        }
        return true;
    }

    private void setEqualityConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, List<Expression> list, int n) {
        Object object;
        int n2;
        Object[] objectArray;
        Index index = null;
        if (n == 0 && this.sortAndSlice.usingIndex && (index = this.sortAndSlice.primaryTableIndex) != null) {
            rangeVariableConditions.rangeIndex = index;
        }
        if (index == null) {
            objectArray = rangeVariableConditions.rangeVar.rangeTable.getIndexForColumns(this.session, this.colIndexSetEqual, 40, false);
            if (objectArray.length == 0) {
                return;
            }
            index = objectArray[0].index;
            double d = Double.MAX_VALUE;
            if (objectArray.length > 1) {
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    object = rangeVariableConditions.rangeVar.rangeTable.getRowStore(this.session);
                    double d2 = object.searchCost(this.session, objectArray[n2].index, objectArray[n2].columnCount, 40);
                    if (!(d2 < d)) continue;
                    d = d2;
                    index = objectArray[n2].index;
                }
            }
        }
        objectArray = index.getColumns();
        int n3 = objectArray.length;
        Expression[] expressionArray = new Expression[objectArray.length];
        for (n2 = 0; n2 < list.size(); ++n2) {
            int n4;
            int n5;
            object = list.get(n2);
            if (object == null || (n5 = ((Expression)object).getType()) != 40 && n5 != 47 || ((Expression)object).getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar || !((Expression)object).isIndexable(rangeVariableConditions.rangeVar) || (n4 = ArrayUtil.find(objectArray, ((Expression)object).getLeftNode().getColumnIndex())) == -1 || expressionArray[n4] != null) continue;
            expressionArray[n4] = object;
            list.set(n2, null);
        }
        n2 = 0;
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression = expressionArray[i];
            if (expression == null) {
                if (n3 == objectArray.length) {
                    n3 = i;
                }
                n2 = 1;
                continue;
            }
            if (n2 == 0) continue;
            list.add(expression);
            expressionArray[i] = null;
        }
        if (n3 > 0) {
            rangeVariableConditions.addIndexCondition(expressionArray, index, n3);
        }
    }

    private void setNonEqualityConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, List<Expression> list, int n) {
        Object object;
        int n2;
        if (this.colIndexSetOther.isEmpty()) {
            return;
        }
        int n3 = 0;
        Object object2 = null;
        if (n == 0 && this.sortAndSlice.usingIndex) {
            object2 = this.sortAndSlice.primaryTableIndex;
        }
        if (object2 == null) {
            Iterator iterator = this.colIndexSetOther.keySet().iterator();
            while (iterator.hasNext()) {
                int n4 = iterator.nextInt();
                n2 = this.colIndexSetOther.get(n4, 0);
                if (n2 <= n3 || (object = rangeVariableConditions.rangeVar.rangeTable.getIndexForColumn(this.session, n4)) == null) continue;
                object2 = object;
                n3 = n2;
            }
        }
        if (object2 == null) {
            return;
        }
        int[] nArray = object2.getColumns();
        for (n2 = 0; n2 < list.size(); ++n2) {
            object = list.get(n2);
            if (object == null) continue;
            boolean bl = false;
            switch (((Expression)object).getType()) {
                case 48: {
                    if (((Expression)object).getLeftNode().getType() != 47 || nArray[0] != ((Expression)object).getLeftNode().getLeftNode().getColumnIndex()) break;
                    bl = true;
                    break;
                }
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    if (nArray[0] != ((Expression)object).getLeftNode().getColumnIndex() || ((Expression)object).getRightNode() == null || ((Expression)object).getRightNode().isCorrelated()) break;
                    bl = true;
                }
            }
            if (!bl) continue;
            Expression[] expressionArray = new Expression[object2.getColumnCount()];
            expressionArray[0] = object;
            rangeVariableConditions.addIndexCondition(expressionArray, (Index)object2, 1);
            list.set(n2, null);
            break;
        }
    }

    void setInConditionsAsTables() {
        for (int i = this.rangeVariables.length - 1; i >= 0; --i) {
            int n;
            int n2;
            RangeVariable rangeVariable = this.rangeVariables[i];
            ExpressionLogical expressionLogical = (ExpressionLogical)this.inExpressions[i];
            if (expressionLogical == null) continue;
            OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
            expressionLogical.addLeftColumnsForAllAny(rangeVariable, orderedIntHashSet);
            Index.IndexUse[] indexUseArray = rangeVariable.rangeTable.getIndexForColumns(this.session, orderedIntHashSet, 40, false);
            Index index = indexUseArray[0].index;
            int n3 = 0;
            for (int j = 0; j < index.getColumnCount() && orderedIntHashSet.contains(index.getColumns()[j]); ++j) {
                ++n3;
            }
            RangeVariable rangeVariable2 = new RangeVariable(expressionLogical.getRightNode().getTable(), null, null, null, this.compileContext);
            rangeVariable2.isGenerated = true;
            RangeVariable[] rangeVariableArray = new RangeVariable[this.rangeVariables.length + 1];
            ArrayUtil.copyAdjustArray(this.rangeVariables, rangeVariableArray, rangeVariable2, i, 1);
            this.rangeVariables = rangeVariableArray;
            Expression[] expressionArray = new Expression[index.getColumnCount()];
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = index.getColumns()[n2];
                n = orderedIntHashSet.getIndex(n4);
                ExpressionLogical expressionLogical2 = new ExpressionLogical(rangeVariable, n4, rangeVariable2, n);
                expressionArray[n2] = expressionLogical2;
            }
            n2 = this.rangeVariables[i].isLeftJoin || this.rangeVariables[i].isRightJoin ? 1 : 0;
            RangeVariable.RangeVariableConditions rangeVariableConditions = !this.inInJoin[i] && n2 != 0 ? rangeVariable.whereConditions[0] : rangeVariable.joinConditions[0];
            rangeVariableConditions.addIndexCondition(expressionArray, index, n3);
            n = 0;
            while (n < orderedIntHashSet.size()) {
                int n5 = orderedIntHashSet.get(n);
                int n6 = n++;
                ExpressionLogical expressionLogical3 = new ExpressionLogical(rangeVariable, n5, rangeVariable2, n6);
                rangeVariableConditions.addCondition(expressionLogical3);
            }
        }
    }

    private double searchCost(Session session, Table table, Index index, int n, int n2) {
        if (table instanceof TableDerived) {
            return 1000.0;
        }
        return table.getRowStore(session).searchCost(session, index, n, n2);
    }
}

