/* $Id: fb_img.c,v 1.5 2002/10/10 16:16:04 ukai Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <stimg.h>
#include "fb.h"
#include "fb_img.h"

static int bg_r = 0, bg_g = 0, bg_b = 0;

static void draw(FB_IMAGE *img, int x, int y, int w, int h, STIMG *image);

void
fb_image_set_bg(int r, int g, int b)
{
  bg_r = r;
  bg_g = g;
  bg_b = b;
}

int
fb_image_clear(int x, int y, int w, int h)
{
    return fb_clear(x, y, w, h, bg_r, bg_g, bg_b);
}

int get_image_size(char *filename, int *w, int *h)
{
  if (filename == NULL)
    return 1;

  return stimg_animation_size(filename, w, h);
}

FB_ANIMATION *
fb_image_load(char *filename, int w, int h, int max_anim)
{
  STIMG_ANIMATION *animation;
  STIMG *image;
  int n, i, fw, fh, frame_num;
  FB_ANIMATION *fb_animation = NULL;
  FB_IMAGE *fb_image, *tmp_image = NULL;

  if (filename == NULL)
    return NULL;

  animation = stimg_animation_load(filename);
  if (animation == NULL)
    return NULL;

  if (stimg_animation_get_first_image(animation) == NULL)
    goto END;

  fw = stimg_animation_get_width(animation);
  fh = stimg_animation_get_height(animation);
  frame_num = n = stimg_animation_get_num(animation);

  if (max_anim < 0) {
    frame_num = (-max_anim > n) ? n : -max_anim;
  } else if (max_anim > 0) {
    frame_num = n = (max_anim > n) ? n : max_anim;
  }

  if (w < 1 || h < 1) {
    w = fw;
    h = fh;
  }

  if (w != fw || h != fh) {
    STIMG_ANIMATION *tmp;
    tmp = stimg_animation_resize(animation, w, h, 1);
    stimg_animation_delete(animation);
    if (tmp == NULL)
      return NULL;

    animation = tmp;
  }

  tmp_image = fb_image_new(w, h);
  if (tmp_image == NULL)
    goto END;

  fb_animation = fb_animation_new(w, h, frame_num);
  if (fb_animation == NULL)
    goto END;

  if (bg_r != 0 || bg_g != 0 || bg_b != 0) 
    fb_image_fill(tmp_image, bg_r, bg_g, bg_b);

  image = stimg_animation_get_first_image(animation);
  fb_image = fb_animation->first;

  for (i = 0; i < n; i++) {
    fb_image->delay = stimg_animation_get_delay(animation);

    fb_image_copy(fb_image, tmp_image);
    draw(fb_image, 
	 stimg_animation_get_x_offset(animation),
	 stimg_animation_get_y_offset(animation),
	 stimg_get_width(image), stimg_get_height(image),
	 image);

    switch (stimg_animation_get_action(animation)) {
    case STIMG_FRAME_RETAIN:
      fb_image_copy(tmp_image, fb_image);
      break;
    case STIMG_FRAME_DISPOSE:
      break;
    case STIMG_FRAME_REVERT:
      fb_image_copy(tmp_image, fb_animation->first);
      break;
    default:
      fb_image_copy(tmp_image, fb_animation->first);
    }

    if (max_anim >= 0 || i >= n - frame_num)
      fb_image = fb_image->next;

    image = stimg_animation_get_next_image(animation);
  }

  fb_animation->iterations = animation->iterations;

  END:
  if (tmp_image)
    fb_image_free(tmp_image);
  stimg_animation_delete(animation);
  return fb_animation;
}

static void
draw(FB_IMAGE * img, int x, int y, int w, int h, STIMG *image)
{
  int i, j, r, g, b;
  unsigned char *pixels;
  int alpha;

  if (img == NULL || image == NULL)
    return;
  pixels = stimg_get_data(image);
  alpha = stimg_get_has_alpha(image);
  for (j = 0; j < h; j++) {
    for (i = 0; i < w; i++) {
      r = *pixels++;
      g = *pixels++;
      b = *pixels++;
      if (!alpha || *pixels++ != 0) {
	fb_image_pset(img, i + x, j + y, r, g, b);
      }
    }
  }
  return;
}
