/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.conda;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.jetbrains.python.Result;
import com.jetbrains.python.ResultKt;
import com.jetbrains.python.errorProcessing.MessageError;
import com.jetbrains.python.errorProcessing.PyError;
import com.jetbrains.python.packaging.common.PythonPackageDetails;
import com.jetbrains.python.packaging.common.PythonSimplePackageDetails;
import com.jetbrains.python.packaging.conda.CommonKt;
import com.jetbrains.python.packaging.conda.CondaPackageCache;
import com.jetbrains.python.packaging.conda.CondaPackageDetails;
import com.jetbrains.python.packaging.repository.PyPIPackageRepository;
import com.jetbrains.python.packaging.repository.PyPackageRepository;
import com.jetbrains.python.packaging.repository.PyPackageRepositoryKt;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J&\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\t`\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/packaging/conda/CondaPackageRepository;", "Lcom/jetbrains/python/packaging/repository/PyPackageRepository;", "<init>", "()V", "getPackages", "", "", "buildPackageDetails", "Lcom/jetbrains/python/Result;", "Lcom/jetbrains/python/packaging/common/PythonPackageDetails;", "Lcom/jetbrains/python/errorProcessing/PyError;", "Lcom/jetbrains/python/errorProcessing/PyResult;", "packageName", "hasPackage", "", "versionSpecs", "Lcom/jetbrains/python/packaging/requirement/PyRequirementVersionSpec;", "getVersionForPackage", "", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nCondaPackageRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CondaPackageRepository.kt\ncom/jetbrains/python/packaging/conda/CondaPackageRepository\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n40#2,3:45\n40#2,3:51\n1761#3,3:48\n*S KotlinDebug\n*F\n+ 1 CondaPackageRepository.kt\ncom/jetbrains/python/packaging/conda/CondaPackageRepository\n*L\n16#1:45,3\n43#1:51,3\n38#1:48,3\n*E\n"})
public final class CondaPackageRepository
extends PyPackageRepository {
    @NotNull
    public static final CondaPackageRepository INSTANCE = new CondaPackageRepository();

    private CondaPackageRepository() {
        super("Conda", null, null);
    }

    @Override
    @NotNull
    public Set<String> getPackages() {
        boolean $i$f$service = false;
        Class<CondaPackageCache> serviceClass$iv = CondaPackageCache.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((CondaPackageCache)object).getPackages();
    }

    @Override
    @NotNull
    public Result<PythonPackageDetails, PyError> buildPackageDetails(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        List<String> list = this.getVersionForPackage(packageName);
        if (list == null) {
            return Result.Companion.failure(new MessageError("No conda package versions in cache"));
        }
        List<String> versions2 = list;
        PythonSimplePackageDetails pypiSimpleDetails = ResultKt.getOrNull(PyPackageRepositoryKt.buildPackageDetailsBySimpleDetailsProtocol(PyPIPackageRepository.INSTANCE, packageName));
        CondaPackageDetails condaDetails = CommonKt.toCondaPackageDetails(pypiSimpleDetails, packageName, versions2);
        return Result.Companion.success(condaDetails);
    }

    @Override
    protected boolean hasPackage(@NotNull String packageName, @Nullable PyRequirementVersionSpec versionSpecs) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            List<String> list = this.getVersionForPackage(packageName);
            if (list == null) {
                return false;
            }
            List<String> availableVersions = list;
            if (versionSpecs == null) {
                return true;
            }
            Iterable $this$any$iv = availableVersions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!versionSpecs.matches(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<String> getVersionForPackage(String packageName) {
        boolean $i$f$service = false;
        Class<CondaPackageCache> serviceClass$iv = CondaPackageCache.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((CondaPackageCache)object).get(packageName);
    }
}

