/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.actions.ActionController;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.column.TableColumnWidthProperty;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class CommonVcsLogUiImpl
extends AbstractVcsLogUi {
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final MyVcsLogUiPropertiesListener myPropertiesListener;
    @NotNull
    private final LinkedHashMap<String, VcsLogHighlighter> myHighlighters;

    public CommonVcsLogUiImpl(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VisiblePackRefresher refresher) {
        if (id == null) {
            CommonVcsLogUiImpl.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            CommonVcsLogUiImpl.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            CommonVcsLogUiImpl.$$$reportNull$$$0(2);
        }
        if (uiProperties == null) {
            CommonVcsLogUiImpl.$$$reportNull$$$0(3);
        }
        if (refresher == null) {
            CommonVcsLogUiImpl.$$$reportNull$$$0(4);
        }
        super(id, logData, manager, refresher);
        this.myHighlighters = new LinkedHashMap();
        this.myUiProperties = uiProperties;
        this.myPropertiesListener = new MyVcsLogUiPropertiesListener();
        this.myUiProperties.addChangeListener(this.myPropertiesListener, this);
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        this.updateDataPack(permGraphChanged);
        this.myPropertiesListener.onShowLongEdgesChanged();
    }

    protected abstract void updateDataPack(boolean var1);

    private boolean isHighlighterEnabled(@NotNull String id) {
        MainVcsLogUiProperties.VcsLogHighlighterProperty property;
        if (id == null) {
            CommonVcsLogUiImpl.$$$reportNull$$$0(5);
        }
        return this.myUiProperties.exists(property = MainVcsLogUiProperties.VcsLogHighlighterProperty.get(id)) && this.myUiProperties.get(property) != false;
    }

    protected void applyFiltersAndUpdateUi(@NotNull VcsLogFilterCollection filters) {
        if (filters == null) {
            CommonVcsLogUiImpl.$$$reportNull$$$0(6);
        }
        this.myRefresher.onFiltersChange(filters);
        JComponent toolbar2 = this.getToolbar();
        toolbar2.revalidate();
        toolbar2.repaint();
    }

    @Override
    @NotNull
    public MainVcsLogUiProperties getProperties() {
        MainVcsLogUiProperties mainVcsLogUiProperties = this.myUiProperties;
        if (mainVcsLogUiProperties == null) {
            CommonVcsLogUiImpl.$$$reportNull$$$0(7);
        }
        return mainVcsLogUiProperties;
    }

    protected void updateHighlighters() {
        this.myHighlighters.forEach((s, highlighter) -> this.getTable().removeHighlighter((VcsLogHighlighter)highlighter));
        this.myHighlighters.clear();
        for (VcsLogHighlighterFactory factory : LOG_HIGHLIGHTER_FACTORY_EP.getExtensionList()) {
            VcsLogHighlighter highlighter2 = factory.createHighlighter(this.myLogData, this);
            this.myHighlighters.put(factory.getId(), highlighter2);
            if (!this.isHighlighterEnabled(factory.getId())) continue;
            this.getTable().addHighlighter(highlighter2);
        }
        this.getTable().repaint();
    }

    @NotNull
    protected abstract JComponent getToolbar();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/CommonVcsLogUiImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/CommonVcsLogUiImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isHighlighterEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFiltersAndUpdateUi";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    private class MyVcsLogUiPropertiesListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        private MyVcsLogUiPropertiesListener() {
        }

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (property == null) {
                MyVcsLogUiPropertiesListener.$$$reportNull$$$0(0);
            }
            if (MainVcsLogUiProperties.SHOW_LONG_EDGES.equals(property)) {
                this.onShowLongEdgesChanged();
            } else if (MainVcsLogUiProperties.GRAPH_OPTIONS.equals(property)) {
                CommonVcsLogUiImpl.this.myRefresher.onGraphOptionsChange(CommonVcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.GRAPH_OPTIONS));
            } else if (CommonUiProperties.COLUMN_ID_ORDER.equals(property)) {
                CommonVcsLogUiImpl.this.getTable().onColumnOrderSettingChanged();
            } else if (property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
                VcsLogHighlighter highlighter = CommonVcsLogUiImpl.this.myHighlighters.get(((MainVcsLogUiProperties.VcsLogHighlighterProperty)property).getId());
                if (((Boolean)CommonVcsLogUiImpl.this.myUiProperties.get(property)).booleanValue()) {
                    CommonVcsLogUiImpl.this.getTable().addHighlighter(highlighter);
                } else {
                    CommonVcsLogUiImpl.this.getTable().removeHighlighter(highlighter);
                }
                CommonVcsLogUiImpl.this.getTable().repaint();
            } else if (property instanceof TableColumnWidthProperty) {
                CommonVcsLogUiImpl.this.getTable().forceReLayout(((TableColumnWidthProperty)property).getColumn());
            }
        }

        private void onShowLongEdgesChanged() {
            boolean newLongEdgesHiddenValue;
            ActionController actionController = CommonVcsLogUiImpl.this.myVisiblePack.getVisibleGraph().getActionController();
            boolean oldLongEdgesHiddenValue = actionController.areLongEdgesHidden();
            boolean bl = newLongEdgesHiddenValue = CommonVcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_LONG_EDGES) == false;
            if (newLongEdgesHiddenValue != oldLongEdgesHiddenValue) {
                actionController.setLongEdgesHidden(newLongEdgesHiddenValue);
                CommonVcsLogUiImpl.this.getTable().repaint();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/CommonVcsLogUiImpl$MyVcsLogUiPropertiesListener", "onPropertyChanged"));
        }
    }
}

