/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.diff.outputs;

import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001d\u0010\u0018\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jupyter/diff/outputs/DiffPainter;", "", "<init>", "()V", "paintDiffComponentTwoSide", "", "component", "Ljavax/swing/JComponent;", "editor", "Lcom/intellij/openapi/editor/Editor;", "side", "Lcom/intellij/diff/util/Side;", "paintDiffComponentThreeSide", "Lcom/intellij/diff/util/ThreeSide;", "doPaintDiffComponent", "color", "Ljava/awt/Color;", "paintAllComponents", "components", "", "type", "Lcom/intellij/diff/util/TextDiffType;", "paintComponentTree", "traverseAndPaint", "getDiffColor", "Lorg/jetbrains/annotations/NotNull;", "intellij.jupyter.diff"})
@SourceDebugExtension(value={"SMAP\nJupyterDiffOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDiffOutput.kt\ncom/intellij/jupyter/diff/outputs/DiffPainter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,302:1\n13472#2,2:303\n1869#3,2:305\n*S KotlinDebug\n*F\n+ 1 JupyterDiffOutput.kt\ncom/intellij/jupyter/diff/outputs/DiffPainter\n*L\n249#1:303,2\n256#1:305,2\n*E\n"})
final class DiffPainter {
    @NotNull
    public static final DiffPainter INSTANCE = new DiffPainter();

    private DiffPainter() {
    }

    public final void paintDiffComponentTwoSide(@NotNull JComponent component2, @NotNull Editor editor, @NotNull Side side) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Color color = this.getDiffColor(editor, side);
        this.doPaintDiffComponent(component2, color);
    }

    public final void paintDiffComponentThreeSide(@NotNull JComponent component2, @NotNull Editor editor, @NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Color color = this.getDiffColor(editor, side);
        this.doPaintDiffComponent(component2, color);
    }

    private final void doPaintDiffComponent(JComponent component2, Color color) {
        component2.setBackground(color);
        component2.setOpaque(true);
        Component[] componentArray = component2.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            INSTANCE.traverseAndPaint((JComponent)it, color);
        }
    }

    public final void paintAllComponents(@NotNull List<? extends JComponent> components, @NotNull Editor editor, @NotNull TextDiffType type) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Color color = this.getDiffColor(editor, type);
        Iterable $this$forEach$iv = components;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JComponent it = (JComponent)element$iv;
            boolean bl = false;
            it.setBackground(color);
            it.setOpaque(true);
            INSTANCE.paintComponentTree(it, color);
        }
    }

    private final void paintComponentTree(JComponent component2, Color color) {
        Object[] subcomponents = component2.getComponents();
        Iterator iterator = ArrayIteratorKt.iterator((Object[])subcomponents);
        while (iterator.hasNext()) {
            Component subcomponent = (Component)iterator.next();
            subcomponent.setBackground(color);
            if (subcomponent instanceof EditorComponentImpl) {
                ((EditorComponentImpl)subcomponent).getEditor().setBackgroundColor(color);
            }
            Intrinsics.checkNotNull((Object)subcomponent, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            this.paintComponentTree((JComponent)subcomponent, color);
        }
    }

    private final void traverseAndPaint(JComponent component2, Color color) {
        component2.setBackground(color);
        if (component2 instanceof EditorComponentImpl) {
            ((EditorComponentImpl)component2).getEditor().setBackgroundColor(color);
        }
        Iterator iterator = ArrayIteratorKt.iterator((Object[])component2.getComponents());
        while (iterator.hasNext()) {
            Component subcomponent = (Component)iterator.next();
            if (subcomponent instanceof CellRendererPane) continue;
            Intrinsics.checkNotNull((Object)subcomponent, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            this.traverseAndPaint((JComponent)subcomponent, color);
        }
    }

    private final Color getDiffColor(Editor editor, TextDiffType type) {
        Color color = type.getColor(editor);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
        return color;
    }

    private final Color getDiffColor(Editor editor, Side side) {
        switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1: {
                Color color = TextDiffType.DELETED.getColor(editor);
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
                return color;
            }
            case 2: {
                Color color = TextDiffType.INSERTED.getColor(editor);
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
                return color;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final Color getDiffColor(Editor editor, ThreeSide side) {
        switch (WhenMappings.$EnumSwitchMapping$1[side.ordinal()]) {
            case 1: {
                Color color = TextDiffType.DELETED.getColor(editor);
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
                return color;
            }
            case 2: {
                Color color = TextDiffType.MODIFIED.getColor(editor);
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
                return color;
            }
            case 3: {
                Color color = TextDiffType.INSERTED.getColor(editor);
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
                return color;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Side.values().length];
            try {
                nArray[Side.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Side.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ThreeSide.values().length];
            try {
                nArray[ThreeSide.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeSide.BASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeSide.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

