pub const ext = @import("ext.zig");
const gstcontroller = @This();

const std = @import("std");
const compat = @import("compat");
const gst = @import("gst1");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
/// A value mapping object that attaches multiple control sources to a guint
/// gobject properties representing a color. A control value of 0.0 will turn the
/// color component off and a value of 1.0 will be the color level.
pub const ARGBControlBinding = extern struct {
    pub const Parent = gst.ControlBinding;
    pub const Implements = [_]type{};
    pub const Class = gstcontroller.ARGBControlBindingClass;
    f_parent: gst.ControlBinding,
    f_cs_a: ?*gst.ControlSource,
    f_cs_r: ?*gst.ControlSource,
    f_cs_g: ?*gst.ControlSource,
    f_cs_b: ?*gst.ControlSource,
    f_cur_value: gobject.Value,
    f_last_value: u32,
    f__gst_reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const control_source_a = struct {
            pub const name = "control-source-a";

            pub const Type = ?*gst.ControlSource;
        };

        pub const control_source_b = struct {
            pub const name = "control-source-b";

            pub const Type = ?*gst.ControlSource;
        };

        pub const control_source_g = struct {
            pub const name = "control-source-g";

            pub const Type = ?*gst.ControlSource;
        };

        pub const control_source_r = struct {
            pub const name = "control-source-r";

            pub const Type = ?*gst.ControlSource;
        };
    };

    pub const signals = struct {};

    /// Create a new control-binding that attaches the given `gst.ControlSource` to the
    /// `gobject.Object` property.
    extern fn gst_argb_control_binding_new(p_object: *gst.Object, p_property_name: [*:0]const u8, p_cs_a: *gst.ControlSource, p_cs_r: *gst.ControlSource, p_cs_g: *gst.ControlSource, p_cs_b: *gst.ControlSource) *gstcontroller.ARGBControlBinding;
    pub const new = gst_argb_control_binding_new;

    extern fn gst_argb_control_binding_get_type() usize;
    pub const getGObjectType = gst_argb_control_binding_get_type;

    extern fn g_object_ref(p_self: *gstcontroller.ARGBControlBinding) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstcontroller.ARGBControlBinding) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ARGBControlBinding, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A value mapping object that attaches control sources to gobject properties. It
/// will map the control values directly to the target property range. If a
/// non-absolute direct control binding is used, the value range [0.0 ... 1.0]
/// is mapped to full target property range, and all values outside the range
/// will be clipped. An absolute control binding will not do any value
/// transformations.
pub const DirectControlBinding = extern struct {
    pub const Parent = gst.ControlBinding;
    pub const Implements = [_]type{};
    pub const Class = gstcontroller.DirectControlBindingClass;
    f_parent: gst.ControlBinding,
    f_cs: ?*gst.ControlSource,
    f_cur_value: gobject.Value,
    f_last_value: f64,
    f_byte_size: c_int,
    f_convert_value: ?gstcontroller.DirectControlBindingConvertValue,
    f_convert_g_value: ?gstcontroller.DirectControlBindingConvertGValue,
    anon0: extern union {
        f__gst_reserved: [4]*anyopaque,
        anon0: extern struct {
            f_want_absolute: c_int,
        },
    },

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const absolute = struct {
            pub const name = "absolute";

            pub const Type = c_int;
        };

        pub const control_source = struct {
            pub const name = "control-source";

            pub const Type = ?*gst.ControlSource;
        };
    };

    pub const signals = struct {};

    /// Create a new control-binding that attaches the `gst.ControlSource` to the
    /// `gobject.Object` property. It will map the control source range [0.0 ... 1.0] to
    /// the full target property range, and clip all values outside this range.
    extern fn gst_direct_control_binding_new(p_object: *gst.Object, p_property_name: [*:0]const u8, p_cs: *gst.ControlSource) *gstcontroller.DirectControlBinding;
    pub const new = gst_direct_control_binding_new;

    /// Create a new control-binding that attaches the `gst.ControlSource` to the
    /// `gobject.Object` property. It will directly map the control source values to the
    /// target property range without any transformations.
    extern fn gst_direct_control_binding_new_absolute(p_object: *gst.Object, p_property_name: [*:0]const u8, p_cs: *gst.ControlSource) *gstcontroller.DirectControlBinding;
    pub const newAbsolute = gst_direct_control_binding_new_absolute;

    extern fn gst_direct_control_binding_get_type() usize;
    pub const getGObjectType = gst_direct_control_binding_get_type;

    extern fn g_object_ref(p_self: *gstcontroller.DirectControlBinding) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstcontroller.DirectControlBinding) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DirectControlBinding, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `gstcontroller.InterpolationControlSource` is a `gst.ControlSource`, that interpolates values between user-given
/// control points. It supports several interpolation modes and property types.
///
/// To use `gstcontroller.InterpolationControlSource` get a new instance by calling
/// `gstcontroller.InterpolationControlSource.new`, bind it to a `gobject.ParamSpec` and set some
/// control points by calling `gstcontroller.TimedValueControlSource.set`.
///
/// All functions are MT-safe.
pub const InterpolationControlSource = extern struct {
    pub const Parent = gstcontroller.TimedValueControlSource;
    pub const Implements = [_]type{};
    pub const Class = gstcontroller.InterpolationControlSourceClass;
    f_parent: gstcontroller.TimedValueControlSource,
    f_priv: ?*gstcontroller.InterpolationControlSourcePrivate,
    f__gst_reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const mode = struct {
            pub const name = "mode";

            pub const Type = gstcontroller.InterpolationMode;
        };
    };

    pub const signals = struct {};

    /// This returns a new, unbound `gstcontroller.InterpolationControlSource`.
    extern fn gst_interpolation_control_source_new() *gstcontroller.InterpolationControlSource;
    pub const new = gst_interpolation_control_source_new;

    extern fn gst_interpolation_control_source_get_type() usize;
    pub const getGObjectType = gst_interpolation_control_source_get_type;

    extern fn g_object_ref(p_self: *gstcontroller.InterpolationControlSource) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstcontroller.InterpolationControlSource) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *InterpolationControlSource, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `gstcontroller.LFOControlSource` is a `gst.ControlSource`, that provides several periodic
/// waveforms as control values.
///
/// To use `gstcontroller.LFOControlSource` get a new instance by calling
/// `gstcontroller.LFOControlSource.new`, bind it to a `gobject.ParamSpec` and set the relevant
/// properties.
///
/// All functions are MT-safe.
pub const LFOControlSource = extern struct {
    pub const Parent = gst.ControlSource;
    pub const Implements = [_]type{};
    pub const Class = gstcontroller.LFOControlSourceClass;
    f_parent: gst.ControlSource,
    f_priv: ?*gstcontroller.LFOControlSourcePrivate,
    f_lock: glib.Mutex,
    f__gst_reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Specifies the amplitude for the waveform of this `gstcontroller.LFOControlSource`.
        pub const amplitude = struct {
            pub const name = "amplitude";

            pub const Type = f64;
        };

        /// Specifies the frequency that should be used for the waveform
        /// of this `gstcontroller.LFOControlSource`. It should be large enough
        /// so that the period is longer than one nanosecond.
        pub const frequency = struct {
            pub const name = "frequency";

            pub const Type = f64;
        };

        /// Specifies the value offset for the waveform of this `gstcontroller.LFOControlSource`.
        pub const offset = struct {
            pub const name = "offset";

            pub const Type = f64;
        };

        /// Specifies the timeshift to the right that should be used for the waveform
        /// of this `gstcontroller.LFOControlSource` in nanoseconds.
        ///
        /// To get a n nanosecond shift to the left use
        /// "(GST_SECOND / frequency) - n".
        pub const timeshift = struct {
            pub const name = "timeshift";

            pub const Type = u64;
        };

        /// Specifies the waveform that should be used for this `gstcontroller.LFOControlSource`.
        pub const waveform = struct {
            pub const name = "waveform";

            pub const Type = gstcontroller.LFOWaveform;
        };
    };

    pub const signals = struct {};

    /// This returns a new, unbound `gstcontroller.LFOControlSource`.
    extern fn gst_lfo_control_source_new() *gstcontroller.LFOControlSource;
    pub const new = gst_lfo_control_source_new;

    extern fn gst_lfo_control_source_get_type() usize;
    pub const getGObjectType = gst_lfo_control_source_get_type;

    extern fn g_object_ref(p_self: *gstcontroller.LFOControlSource) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstcontroller.LFOControlSource) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *LFOControlSource, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `gst.ControlBinding` that forwards requests to another `gst.ControlBinding`
pub const ProxyControlBinding = extern struct {
    pub const Parent = gst.ControlBinding;
    pub const Implements = [_]type{};
    pub const Class = gstcontroller.ProxyControlBindingClass;
    f_parent: gst.ControlBinding,
    f_ref_object: gobject.WeakRef,
    f_property_name: ?[*:0]u8,
    f__padding: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// `gstcontroller.ProxyControlBinding` forwards all access to data or ``sync_values``
    /// requests from `property_name` on `object` to the control binding at
    /// `ref_property_name` on `ref_object`.
    extern fn gst_proxy_control_binding_new(p_object: *gst.Object, p_property_name: [*:0]const u8, p_ref_object: *gst.Object, p_ref_property_name: [*:0]const u8) *gstcontroller.ProxyControlBinding;
    pub const new = gst_proxy_control_binding_new;

    extern fn gst_proxy_control_binding_get_type() usize;
    pub const getGObjectType = gst_proxy_control_binding_get_type;

    extern fn g_object_ref(p_self: *gstcontroller.ProxyControlBinding) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstcontroller.ProxyControlBinding) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ProxyControlBinding, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Base class for `gst.ControlSource` that use time-stamped values.
///
/// When overriding bind, chain up first to give this bind implementation a
/// chance to setup things.
///
/// All functions are MT-safe.
pub const TimedValueControlSource = extern struct {
    pub const Parent = gst.ControlSource;
    pub const Implements = [_]type{};
    pub const Class = gstcontroller.TimedValueControlSourceClass;
    f_parent: gst.ControlSource,
    f_lock: glib.Mutex,
    f_values: ?*glib.Sequence,
    f_nvalues: c_int,
    f_valid_cache: c_int,
    f_priv: ?*gstcontroller.TimedValueControlSourcePrivate,
    f__gst_reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted right after the new value has been added to `self`
        pub const value_added = struct {
            pub const name = "value-added";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_timed_value: *gstcontroller.ControlPoint, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(TimedValueControlSource, p_instance))),
                    gobject.signalLookup("value-added", TimedValueControlSource.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted right after the new value has been set on `timed_signals`
        pub const value_changed = struct {
            pub const name = "value-changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_timed_value: *gstcontroller.ControlPoint, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(TimedValueControlSource, p_instance))),
                    gobject.signalLookup("value-changed", TimedValueControlSource.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when `timed_value` is removed from `self`
        pub const value_removed = struct {
            pub const name = "value-removed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_timed_value: *gstcontroller.ControlPoint, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(TimedValueControlSource, p_instance))),
                    gobject.signalLookup("value-removed", TimedValueControlSource.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Find last value before given timestamp in control point list.
    /// If all values in the control point list come after the given
    /// timestamp or no values exist, `NULL` is returned.
    ///
    /// For use in control source implementations.
    extern fn gst_timed_value_control_source_find_control_point_iter(p_self: *TimedValueControlSource, p_timestamp: gst.ClockTime) ?*glib.SequenceIter;
    pub const findControlPointIter = gst_timed_value_control_source_find_control_point_iter;

    /// Returns a read-only copy of the list of `gst.TimedValue` for the given property.
    /// Free the list after done with it.
    extern fn gst_timed_value_control_source_get_all(p_self: *TimedValueControlSource) *glib.List;
    pub const getAll = gst_timed_value_control_source_get_all;

    /// Get the number of control points that are set.
    extern fn gst_timed_value_control_source_get_count(p_self: *TimedValueControlSource) c_int;
    pub const getCount = gst_timed_value_control_source_get_count;

    /// Set the value of given controller-handled property at a certain time.
    extern fn gst_timed_value_control_source_set(p_self: *TimedValueControlSource, p_timestamp: gst.ClockTime, p_value: f64) c_int;
    pub const set = gst_timed_value_control_source_set;

    /// Sets multiple timed values at once.
    extern fn gst_timed_value_control_source_set_from_list(p_self: *TimedValueControlSource, p_timedvalues: *const glib.SList) c_int;
    pub const setFromList = gst_timed_value_control_source_set_from_list;

    /// Used to remove the value of given controller-handled property at a certain
    /// time.
    extern fn gst_timed_value_control_source_unset(p_self: *TimedValueControlSource, p_timestamp: gst.ClockTime) c_int;
    pub const unset = gst_timed_value_control_source_unset;

    /// Used to remove all time-stamped values of given controller-handled property
    extern fn gst_timed_value_control_source_unset_all(p_self: *TimedValueControlSource) void;
    pub const unsetAll = gst_timed_value_control_source_unset_all;

    extern fn gst_timed_value_control_source_get_type() usize;
    pub const getGObjectType = gst_timed_value_control_source_get_type;

    extern fn g_object_ref(p_self: *gstcontroller.TimedValueControlSource) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstcontroller.TimedValueControlSource) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *TimedValueControlSource, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `gstcontroller.TriggerControlSource` is a `gst.ControlSource`, that returns values from user-given
/// control points. It allows for a tolerance on the time-stamps.
///
/// To use `gstcontroller.TriggerControlSource` get a new instance by calling
/// `gstcontroller.TriggerControlSource.new`, bind it to a `gobject.ParamSpec` and set some
/// control points by calling `gstcontroller.TimedValueControlSource.set`.
///
/// All functions are MT-safe.
pub const TriggerControlSource = extern struct {
    pub const Parent = gstcontroller.TimedValueControlSource;
    pub const Implements = [_]type{};
    pub const Class = gstcontroller.TriggerControlSourceClass;
    f_parent: gstcontroller.TimedValueControlSource,
    f_priv: ?*gstcontroller.TriggerControlSourcePrivate,
    f__gst_reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const tolerance = struct {
            pub const name = "tolerance";

            pub const Type = i64;
        };
    };

    pub const signals = struct {};

    /// This returns a new, unbound `gstcontroller.TriggerControlSource`.
    extern fn gst_trigger_control_source_new() *gstcontroller.TriggerControlSource;
    pub const new = gst_trigger_control_source_new;

    extern fn gst_trigger_control_source_get_type() usize;
    pub const getGObjectType = gst_trigger_control_source_get_type;

    extern fn g_object_ref(p_self: *gstcontroller.TriggerControlSource) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstcontroller.TriggerControlSource) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *TriggerControlSource, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The class structure of `gstcontroller.ARGBControlBinding`.
pub const ARGBControlBindingClass = extern struct {
    pub const Instance = gstcontroller.ARGBControlBinding;

    /// Parent class
    f_parent_class: gst.ControlBindingClass,
    f__gst_reserved: [4]*anyopaque,

    pub fn as(p_instance: *ARGBControlBindingClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// An internal structure for value+time and various temporary
/// values used for interpolation. This "inherits" from
/// GstTimedValue.
pub const ControlPoint = extern struct {
    /// timestamp of the value change
    f_timestamp: gst.ClockTime,
    /// the new value
    f_value: f64,
    anon0: extern union {
        anon0: extern struct {
            f_h: f64,
            f_z: f64,
        },
        anon1: extern struct {
            f_c1s: f64,
            f_c2s: f64,
            f_c3s: f64,
        },
        f__gst_reserved: [64]u8,
    },

    /// Copies a `gstcontroller.ControlPoint`
    extern fn gst_control_point_copy(p_cp: *ControlPoint) *gstcontroller.ControlPoint;
    pub const copy = gst_control_point_copy;

    /// Frees all data allocated by a `gstcontroller.ControlPoint` instance.
    extern fn gst_control_point_free(p_cp: *ControlPoint) void;
    pub const free = gst_control_point_free;

    extern fn gst_control_point_get_type() usize;
    pub const getGObjectType = gst_control_point_get_type;
};

/// The class structure of `gstcontroller.DirectControlBinding`.
pub const DirectControlBindingClass = extern struct {
    pub const Instance = gstcontroller.DirectControlBinding;

    /// Parent class
    f_parent_class: gst.ControlBindingClass,
    f__gst_reserved: [4]*anyopaque,

    pub fn as(p_instance: *DirectControlBindingClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const InterpolationControlSourceClass = extern struct {
    pub const Instance = gstcontroller.InterpolationControlSource;

    f_parent_class: gstcontroller.TimedValueControlSourceClass,
    f__gst_reserved: [4]*anyopaque,

    pub fn as(p_instance: *InterpolationControlSourceClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const InterpolationControlSourcePrivate = opaque {};

pub const LFOControlSourceClass = extern struct {
    pub const Instance = gstcontroller.LFOControlSource;

    f_parent_class: gst.ControlSourceClass,
    f__gst_reserved: [4]*anyopaque,

    pub fn as(p_instance: *LFOControlSourceClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const LFOControlSourcePrivate = opaque {};

/// Opaque `gstcontroller.ProxyControlBindingClass` struct
pub const ProxyControlBindingClass = extern struct {
    pub const Instance = gstcontroller.ProxyControlBinding;

    f_parent_class: gst.ControlBindingClass,
    f__padding: [4]*anyopaque,

    pub fn as(p_instance: *ProxyControlBindingClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const TimedValueControlSourceClass = extern struct {
    pub const Instance = gstcontroller.TimedValueControlSource;

    f_parent_class: gst.ControlSourceClass,
    f__gst_reserved: [4]*anyopaque,

    pub fn as(p_instance: *TimedValueControlSourceClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const TimedValueControlSourcePrivate = opaque {};

pub const TriggerControlSourceClass = extern struct {
    pub const Instance = gstcontroller.TriggerControlSource;

    f_parent_class: gstcontroller.TimedValueControlSourceClass,
    f__gst_reserved: [4]*anyopaque,

    pub fn as(p_instance: *TriggerControlSourceClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const TriggerControlSourcePrivate = opaque {};

/// The various interpolation modes available.
pub const InterpolationMode = enum(c_int) {
    none = 0,
    linear = 1,
    cubic = 2,
    cubic_monotonic = 3,
    _,

    extern fn gst_interpolation_mode_get_type() usize;
    pub const getGObjectType = gst_interpolation_mode_get_type;
};

/// The various waveform modes available.
pub const LFOWaveform = enum(c_int) {
    sine = 0,
    square = 1,
    saw = 2,
    reverse_saw = 3,
    triangle = 4,
    _,

    extern fn gst_lfo_waveform_get_type() usize;
    pub const getGObjectType = gst_lfo_waveform_get_type;
};

/// Reset the controlled value cache.
extern fn gst_timed_value_control_invalidate_cache(p_self: *gstcontroller.TimedValueControlSource) void;
pub const timedValueControlInvalidateCache = gst_timed_value_control_invalidate_cache;

/// Function to map a control-value to the target GValue.
pub const DirectControlBindingConvertGValue = *const fn (p_self: *gstcontroller.DirectControlBinding, p_src_value: f64, p_dest_value: *gobject.Value) callconv(.C) void;

/// Function to map a control-value to the target plain data type.
pub const DirectControlBindingConvertValue = *const fn (p_self: *gstcontroller.DirectControlBinding, p_src_value: f64, p_dest_value: ?*anyopaque) callconv(.C) void;
