# Attention! It possibly causes problems at static compiling, if your gcc compiler is too new.
%define shared  1

Name: 		elem
Version: 	1.0.3
Release: 	1
Vendor: 	Robert Scheck <elem@robert-scheck.de>
Packager:	Robert Scheck <elem@robert-scheck.de>
Summary(de):	Ein Periodensystem der Elemente fr Unix und Linux
Summary:  	A periodic table of the elements for Unix and Linux
Copyright: 	GPL
Group: 		X11/Utilities
URL: 		http://elem.sourceforge.net/
Source0: 	http://ftp.robert-scheck.de/linux/%{name}/%{version}/%{name}-src-%{version}-Linux.tgz
BuildRequires:	xforms-devel
%if %{shared}
Requires:       xforms
%else
BuildRequires:  gcc <= 2.96
%endif
BuildRoot: 	/tmp/%{name}-%{version}-root


%description -l de
Elem ist ein Periodensystem der Elemente fr unixartige Betriebssysteme. 
Durch einen Klick auf ein Element erscheint ein Dialogfenster mit weiteren 
Informationen zum entsprechenden Element. Die Summe der Atommassen aller 
angeklickten Elemente wird gebildet. Damit lsst sich die Molarmasse von 
Moleklen berechnen.

Elem wurde ursprnglich von Stefan Heimers programmiert. Robert Scheck hat 
es um neuere Daten ergnzt.

Stefan Heimers
Klingelbergstrasse 69
4056 Basel
Schweiz 

Internet: http://www.datanetworks.ch/~sheimers/ 
E-Mail:   stefan.heimers@kosta.ch

Robert Scheck
Kaerntner Str. 33
71229 Leonberg
Deutschland 

Internet: http://linux.robert-scheck.de/elem/
E-Mail:   elem@robert-scheck.de


%description
Elem is a periodic table of the elements for unix like operating systems. 
By clicking an element you get a message window showing some additional 
information on that specific element. The sum of all atomic masses of 
the clicked elements is displayed. This helps calculating the molar 
weight of molecules.

Elem was originally written by Stefan Heimers. It has been updated and 
improved by Robert Scheck.

Stefan Heimers
Klingelbergstrasse 69
4056 Basel
Schweiz 

Internet: http://www.datanetworks.ch/~sheimers/ 
E-Mail:   stefan.heimers@kosta.ch


Robert Scheck
Kaerntner Str. 33
71229 Leonberg
Deutschland 

Internet: http://linux.robert-scheck.de/elem/
E-Mail:   elem@robert-scheck.de


%prep
%setup -q


%build
%if %{shared}
  make all
%else
  make static-de
  make static-en
%endif


%install
rm -rf $RPM_BUILD_ROOT

# Create directory
mkdir -p ${RPM_BUILD_ROOT}/usr/local/bin/

# Install elem
%if %{shared}
  mv elem-de ${RPM_BUILD_ROOT}/usr/local/bin/elem-de
  mv elem-en ${RPM_BUILD_ROOT}/usr/local/bin/elem-en
%else
  mv elem-static-de ${RPM_BUILD_ROOT}/usr/local/bin/elem-de
  mv elem-static-en ${RPM_BUILD_ROOT}/usr/local/bin/elem-en
%endif
mv elem ${RPM_BUILD_ROOT}/usr/local/bin/elem
strip $RPM_BUILD_ROOT/usr/local/bin/elem-de
strip $RPM_BUILD_ROOT/usr/local/bin/elem-en


%clean
rm -rf $RPM_BUILD_ROOT $RPM_BUILD_DIR/%{name}-%{version}


%files 
%doc COPYING README TODO doc/*
/usr/local/bin/elem
/usr/local/bin/elem-de
/usr/local/bin/elem-en


%changelog
* Sun Sep 07 2003 - Robert Scheck <elem@robert-scheck.de> - 1.0.3-1
- Update to 1.0.3
- Static, shared and language rpms are merged to one spec file
- Multilanguage description and summary

* Tue Aug 27 2002 - Robert Scheck <elem@robert-scheck.de> - 1.0.2-1
- Update to 1.0.2
- Makefile edited
- Script decides whether the german or the english elem will be started

* Tue Aug 27 2002 - Robert Scheck <elem@robert-scheck.de> - 1.0.1-1
- Update to 1.0.1

* Tue Aug 27 2002 - Robert Scheck <elem@robert-scheck.de> - 1.0.0-1
- RPM should work with Red Hat Linux >= 6.2
- Created new spec file from nothing
- Update to 1.0.0

