/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.jcache;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.jsr107cache.CacheListener;

public class JCacheListenerAdaptor
implements CacheEventListener {
    private CacheListener cacheListener;

    public JCacheListenerAdaptor(CacheListener cacheListener) {
        this.cacheListener = cacheListener;
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (element != null) {
            this.cacheListener.onRemove(element.getObjectKey());
            if (cache.getSize() == 0) {
                this.cacheListener.onClear();
            }
        }
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (element != null) {
            this.cacheListener.onPut(element.getObjectKey());
        }
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (element != null) {
            this.cacheListener.onPut(element.getObjectKey());
        }
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        if (element != null) {
            this.cacheListener.onEvict(element.getObjectKey());
        }
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        if (element != null) {
            this.cacheListener.onEvict(element.getObjectKey());
        }
    }

    public void notifyRemoveAll(Ehcache cache) {
        this.cacheListener.onClear();
    }

    public void dispose() {
    }

    public CacheListener getCacheListener() {
        return this.cacheListener;
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        throw new CloneNotSupportedException("Cannot clone JCacheListenerAdaptor");
    }
}

