// swift-tools-version:5.3
import PackageDescription

let package = Package(
    name: "TreeSitterwerk",
    products: [
        .library(name: "TreeSitterwerk", targets: ["TreeSitterwerk"]),
    ],
    dependencies: [
        .package(url: "https://github.com/ChimeHQ/SwiftTreeSitter", from: "0.8.0"),
    ],
    targets: [
        .target(
            name: "TreeSitterwerk",
            dependencies: [],
            path: ".",
            sources: [
                "src/parser.c",
                // NOTE: if your language has an external scanner, add it here.
            ],
            resources: [
                .copy("queries")
            ],
            publicHeadersPath: "bindings/swift",
            cSettings: [.headerSearchPath("src")]
        ),
        .testTarget(
            name: "TreeSitterwerkTests",
            dependencies: [
                "SwiftTreeSitter",
                "TreeSitterwerk",
            ],
            path: "bindings/swift/TreeSitterwerkTests"
        )
    ],
    cLanguageStandard: .c11
)
