/*
 * PROPRIETARY INFORMATION.  This software is proprietary to POWDER
 * Development, and is not to be reproduced, transmitted, or disclosed
 * in any way without written permission.
 *
 * Produced by:	Jeff Lait
 *
 *      	POWDER Development
 *
 * NAME:        artifact.h ( POWDER Library, C++ )
 *
 * COMMENTS:
 *	This handles the randart (cool name - always read that as
 *	random artwork rather than random artifacts).  The idea is that
 *	artifact's properties are generated by their names.  Thus, the
 *	long sword Foobar will be the same from game to game.
 */

#ifndef __artifact__
#define __artifact__

#include "mygba.h"
#include "glbdef.h"
#include "buf.h"

class ARTIFACT
{
public:
    ARTIFACT();
    ~ARTIFACT();
    
    bool		 hasattack;
    ATTACK_DEF		 attack;
    bool		 hasthrownattack;
    ATTACK_DEF		 thrownattack;
    s8			 acbonus;
    u8			 lightradius;
    u8			 iscarryintrinsic;
    char 		*intrinsics;

    // This is used internally to chain the allocated artifacts.
    // Treat this as private.
    char		*name;
    ITEM_NAMES		 baseitem;
    ARTIFACT		*next;
};

// Global initialization code.
// This will reset the artifact tables.  It should be called
// on new game or load.
void
artifact_init();

// Builds a random artifact name.
BUF
artifact_buildname(ITEM_NAMES baseitem);

//
// This builds an artifact table for the given item.
// The long sword Foobar has different properties than
// the wooden shield Foobar.
//
// The returned pointer is persistant.
//
ARTIFACT *
artifact_buildartifact(const char *name, ITEM_NAMES baseitem);

#endif

