//go:build linux && cgo && !agent

package cluster

// The code below was generated by lxd-generate - DO NOT EDIT!

import (
	"context"
	"database/sql"
	"errors"
	"fmt"
	"net/http"
	"strings"

	"github.com/canonical/lxd/lxd/db/query"
	"github.com/canonical/lxd/shared/api"
)

var _ = api.ServerEnvironment{}

var authGroupObjects = RegisterStmt(`
SELECT auth_groups.id, auth_groups.name, auth_groups.description
  FROM auth_groups
  ORDER BY auth_groups.name
`)

var authGroupObjectsByID = RegisterStmt(`
SELECT auth_groups.id, auth_groups.name, auth_groups.description
  FROM auth_groups
  WHERE ( auth_groups.id = ? )
  ORDER BY auth_groups.name
`)

var authGroupObjectsByName = RegisterStmt(`
SELECT auth_groups.id, auth_groups.name, auth_groups.description
  FROM auth_groups
  WHERE ( auth_groups.name = ? )
  ORDER BY auth_groups.name
`)

var authGroupID = RegisterStmt(`
SELECT auth_groups.id FROM auth_groups
  WHERE auth_groups.name = ?
`)

var authGroupCreate = RegisterStmt(`
INSERT INTO auth_groups (name, description)
  VALUES (?, ?)
`)

var authGroupDeleteByName = RegisterStmt(`
DELETE FROM auth_groups WHERE name = ?
`)

var authGroupUpdate = RegisterStmt(`
UPDATE auth_groups
  SET name = ?, description = ?
 WHERE id = ?
`)

var authGroupRename = RegisterStmt(`
UPDATE auth_groups SET name = ? WHERE name = ?
`)

// authGroupColumns returns a string of column names to be used with a SELECT statement for the entity.
// Use this function when building statements to retrieve database entries matching the AuthGroup entity.
func authGroupColumns() string {
	return "auths_groups.id, auths_groups.name, auths_groups.description"
}

// getAuthGroups can be used to run handwritten sql.Stmts to return a slice of objects.
func getAuthGroups(ctx context.Context, stmt *sql.Stmt, args ...any) ([]AuthGroup, error) {
	objects := make([]AuthGroup, 0)

	dest := func(scan func(dest ...any) error) error {
		a := AuthGroup{}
		err := scan(&a.ID, &a.Name, &a.Description)
		if err != nil {
			return err
		}

		objects = append(objects, a)

		return nil
	}

	err := query.SelectObjects(ctx, stmt, dest, args...)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"auths_groups\" table: %w", err)
	}

	return objects, nil
}

// getAuthGroupsRaw can be used to run handwritten query strings to return a slice of objects.
func getAuthGroupsRaw(ctx context.Context, tx *sql.Tx, sql string, args ...any) ([]AuthGroup, error) {
	objects := make([]AuthGroup, 0)

	dest := func(scan func(dest ...any) error) error {
		a := AuthGroup{}
		err := scan(&a.ID, &a.Name, &a.Description)
		if err != nil {
			return err
		}

		objects = append(objects, a)

		return nil
	}

	err := query.Scan(ctx, tx, sql, dest, args...)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"auths_groups\" table: %w", err)
	}

	return objects, nil
}

// GetAuthGroups returns all available auth_groups.
// generator: auth_group GetMany
func GetAuthGroups(ctx context.Context, tx *sql.Tx, filters ...AuthGroupFilter) ([]AuthGroup, error) {
	var err error

	// Result slice.
	objects := make([]AuthGroup, 0)

	// Pick the prepared statement and arguments to use based on active criteria.
	var sqlStmt *sql.Stmt
	args := []any{}
	queryParts := [2]string{}

	if len(filters) == 0 {
		sqlStmt, err = Stmt(tx, authGroupObjects)
		if err != nil {
			return nil, fmt.Errorf("Failed to get \"authGroupObjects\" prepared statement: %w", err)
		}
	}

	for i, filter := range filters {
		if filter.Name != nil && filter.ID == nil {
			args = append(args, []any{filter.Name}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(tx, authGroupObjectsByName)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"authGroupObjectsByName\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(authGroupObjectsByName)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"authGroupObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.ID != nil && filter.Name == nil {
			args = append(args, []any{filter.ID}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(tx, authGroupObjectsByID)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"authGroupObjectsByID\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(authGroupObjectsByID)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"authGroupObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.ID == nil && filter.Name == nil {
			return nil, errors.New("Cannot filter on empty AuthGroupFilter")
		} else {
			return nil, errors.New("No statement exists for the given Filter")
		}
	}

	// Select.
	if sqlStmt != nil {
		objects, err = getAuthGroups(ctx, sqlStmt, args...)
	} else {
		queryStr := strings.Join(queryParts[:], "ORDER BY")
		objects, err = getAuthGroupsRaw(ctx, tx, queryStr, args...)
	}

	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"auths_groups\" table: %w", err)
	}

	return objects, nil
}

// GetAuthGroup returns the auth_group with the given key.
// generator: auth_group GetOne
func GetAuthGroup(ctx context.Context, tx *sql.Tx, name string) (*AuthGroup, error) {
	filter := AuthGroupFilter{}
	filter.Name = &name

	objects, err := GetAuthGroups(ctx, tx, filter)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"auths_groups\" table: %w", err)
	}

	switch len(objects) {
	case 0:
		return nil, api.StatusErrorf(http.StatusNotFound, "AuthGroup not found")
	case 1:
		return &objects[0], nil
	default:
		return nil, errors.New("More than one \"auths_groups\" entry matches")
	}
}

// GetAuthGroupID return the ID of the auth_group with the given key.
// generator: auth_group ID
func GetAuthGroupID(ctx context.Context, tx *sql.Tx, name string) (int64, error) {
	stmt, err := Stmt(tx, authGroupID)
	if err != nil {
		return -1, fmt.Errorf("Failed to get \"authGroupID\" prepared statement: %w", err)
	}

	row := stmt.QueryRowContext(ctx, name)
	var id int64
	err = row.Scan(&id)
	if errors.Is(err, sql.ErrNoRows) {
		return -1, api.StatusErrorf(http.StatusNotFound, "AuthGroup not found")
	}

	if err != nil {
		return -1, fmt.Errorf("Failed to get \"auths_groups\" ID: %w", err)
	}

	return id, nil
}

// AuthGroupExists checks if a auth_group with the given key exists.
// generator: auth_group Exists
func AuthGroupExists(ctx context.Context, tx *sql.Tx, name string) (bool, error) {
	_, err := GetAuthGroupID(ctx, tx, name)
	if err != nil {
		if api.StatusErrorCheck(err, http.StatusNotFound) {
			return false, nil
		}

		return false, err
	}

	return true, nil
}

// CreateAuthGroup adds a new auth_group to the database.
// generator: auth_group Create
func CreateAuthGroup(ctx context.Context, tx *sql.Tx, object AuthGroup) (int64, error) {
	// Check if a auth_group with the same key exists.
	exists, err := AuthGroupExists(ctx, tx, object.Name)
	if err != nil {
		return -1, fmt.Errorf("Failed to check for duplicates: %w", err)
	}

	if exists {
		return -1, api.StatusErrorf(http.StatusConflict, "This \"auths_groups\" entry already exists")
	}

	args := make([]any, 2)

	// Populate the statement arguments.
	args[0] = object.Name
	args[1] = object.Description

	// Prepared statement to use.
	stmt, err := Stmt(tx, authGroupCreate)
	if err != nil {
		return -1, fmt.Errorf("Failed to get \"authGroupCreate\" prepared statement: %w", err)
	}

	// Execute the statement.
	result, err := stmt.Exec(args...)
	if err != nil {
		return -1, fmt.Errorf("Failed to create \"auths_groups\" entry: %w", err)
	}

	id, err := result.LastInsertId()
	if err != nil {
		return -1, fmt.Errorf("Failed to fetch \"auths_groups\" entry ID: %w", err)
	}

	return id, nil
}

// DeleteAuthGroup deletes the auth_group matching the given key parameters.
// generator: auth_group DeleteOne-by-Name
func DeleteAuthGroup(ctx context.Context, tx *sql.Tx, name string) error {
	stmt, err := Stmt(tx, authGroupDeleteByName)
	if err != nil {
		return fmt.Errorf("Failed to get \"authGroupDeleteByName\" prepared statement: %w", err)
	}

	result, err := stmt.Exec(name)
	if err != nil {
		return fmt.Errorf("Delete \"auths_groups\": %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows: %w", err)
	}

	if n == 0 {
		return api.StatusErrorf(http.StatusNotFound, "AuthGroup not found")
	} else if n > 1 {
		return fmt.Errorf("Query deleted %d AuthGroup rows instead of 1", n)
	}

	return nil
}

// UpdateAuthGroup updates the auth_group matching the given key parameters.
// generator: auth_group Update
func UpdateAuthGroup(ctx context.Context, tx *sql.Tx, name string, object AuthGroup) error {
	id, err := GetAuthGroupID(ctx, tx, name)
	if err != nil {
		return err
	}

	stmt, err := Stmt(tx, authGroupUpdate)
	if err != nil {
		return fmt.Errorf("Failed to get \"authGroupUpdate\" prepared statement: %w", err)
	}

	result, err := stmt.Exec(object.Name, object.Description, id)
	if err != nil {
		return fmt.Errorf("Update \"auths_groups\" entry failed: %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows: %w", err)
	}

	if n != 1 {
		return fmt.Errorf("Query updated %d rows instead of 1", n)
	}

	return nil
}

// RenameAuthGroup renames the auth_group matching the given key parameters.
// generator: auth_group Rename
func RenameAuthGroup(ctx context.Context, tx *sql.Tx, name string, to string) error {
	stmt, err := Stmt(tx, authGroupRename)
	if err != nil {
		return fmt.Errorf("Failed to get \"authGroupRename\" prepared statement: %w", err)
	}

	result, err := stmt.Exec(to, name)
	if err != nil {
		return fmt.Errorf("Rename AuthGroup failed: %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows failed: %w", err)
	}

	if n != 1 {
		return fmt.Errorf("Query affected %d rows instead of 1", n)
	}

	return nil
}
