/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/***************************************************************************
 *            libusbhp.h
 *
 *  Thu Mar 16 10:48:40 CEST 2013
 *  Copyright 2013 Bent Bisballe Nyeng
 *  deva@aasimon.org
 ****************************************************************************/

/*
 *  This file is part of the Usb Hotplug Library (libusbhp)
 *
 *  Libusbhp is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Libusbhp is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with libusbhp; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 */
#ifndef __LIBUSBHP_H__
#define __LIBUSBHP_H__

#ifdef WIN32
#define CALL __stdcall
#ifdef BUILD_DLL
/* DLL export */
#define EXPORT __declspec(dllexport)
#else
/* EXE import */
#define EXPORT __declspec(dllimport)
#endif
#include <Winsock2.h>
#else
#define CALL
#define EXPORT
#include <sys/time.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif


struct libusbhp_t;

struct libusbhp_device_t {
	unsigned short idVendor;
	unsigned short idProduct;
};

typedef void (CALL *libusbhp_hotplug_cb_fn)(struct libusbhp_device_t *device,
                                            void *user_data);

EXPORT
 int libusbhp_init(struct libusbhp_t **handle);

EXPORT
 void libusbhp_exit(struct libusbhp_t *handle);

EXPORT
 int libusbhp_handle_events_timeout(struct libusbhp_t *handle,
                                    struct timeval *tv);

EXPORT
 void libusbhp_register_hotplug_listeners(struct libusbhp_t *handle,
                                        libusbhp_hotplug_cb_fn connected_cb,
                                        libusbhp_hotplug_cb_fn disconnected_cb,
                                        void *user_data);

#ifdef __cplusplus
}
#endif

/***
// Libusbx implementation:

typedef void LIBUSB_CALL (*libusb_hotplug_cb_fn)(struct libusb_device *device,
                                                 void *user_data);

int LIBUSB_CALL libusb_init(libusb_context **ctx);
void LIBUSB_CALL libusb_exit(libusb_context *ctx);
void LIBUSB_CALL libusb_set_debug(libusb_context *ctx, int level);
const char * LIBUSB_CALL libusb_strerror(enum libusb_error errcode);
const struct libusb_version * LIBUSB_CALL libusb_getversion(void);

void LIBUSB_CALL libusb_register_hotplug_listeners(libusb_context *ctx,
	libusb_hotplug_cb_fn connected_cb,
	libusb_hotplug_cb_fn disconnected_cb, void *user_data);
void LIBUSB_CALL libusb_unregister_hotplug_listeners(libusb_context *ctx);
int LIBUSB_CALL libusb_get_status(libusb_device *dev);

 ***/

#endif/*__LIBUSBHP_H__*/
