/* ARROWS - a game.
 * Author Jeremy Day (nor@noreason.ca)
 * Copyright 1993, 2004 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * draw.c is mostly a gtk version of some of the Borland Turbo C graphics API 
 * used by arrows.c 
 *
 */
#include "arrows.h"


GdkGC *gc=NULL;

/* Not exactly the best circle-drawing method here.  */
void circle(int x, int y, int radius)
{
	drawrect(x-radius, y-radius, x+radius, y+radius, FALSE);
}

void putpixel(int x, int y, int color)
{
	setcolor(color);
	gdk_draw_point(pixmap, gc, x, y);
	gtk_widget_queue_draw_area (drawing_area, x, y, 1, 1);
}

// Draw a polygon.  er... only if it's a rectangle, actually.  Which it is.
void drawpoly(int size, int poly[]) { n_drawpoly(size, poly, FALSE); }
void fillpoly(int size, int poly[]) { n_drawpoly(size, poly, TRUE); }
void n_drawpoly(int size, int poly[], gboolean fill)
{
	int x1, y1, x2, y2, i;
	x1=x2=poly[0]; 
	y1=y2=poly[1];
	for (i=2; i<size*2; i+=2)
	{
		if (poly[i]<x1) x1 = poly[i];
		if (poly[i]>x2) x2 = poly[i];
		if (poly[i+1]<y1) y1 = poly[i+1];
		if (poly[i+1]>y2) y2 = poly[i+1];
	}
	drawrect(x1, y1, x2, y2, fill);
}

void fillrect(int x1, int y1, int x2, int y2)
{
	drawrect(x1, y1, x2, y2, TRUE);
}

void drawrect(int x1, int y1, int x2, int y2, gboolean fill)
{
	GdkRectangle rect;
	rect.x=x1;
	rect.y=y1;
	rect.width=x2-x1+1;
	rect.height=y2-y1+1;
	gdk_draw_rectangle 
		(
			pixmap, gc, fill,
			rect.x, rect.y, rect.width, rect.height
		);
	gtk_widget_queue_draw_area 
		(
			drawing_area, rect.x, rect.y, rect.width, rect.height
		);
}

void clearviewport()
{
	setcolor(0);
	fillrect(0, 0, 640, 480);
}

inline void nline(int x1, int y1, int x2, int y2)
{
	gdk_draw_line(pixmap, gc, x1, y1, x2, y2);
}

inline void line(int x1, int y1, int x2, int y2)
{
	gdk_draw_line(pixmap, gc, x1, y1, x2, y2);
	gtk_widget_queue_draw_area 
		( drawing_area, x1, y1, x2-x1+1, y2-y1+1 );
}

void setcolor(int c)
{
	gc = (c==0 ? drawing_area->style->white_gc : drawing_area->style->black_gc);
}

void putimage(int x, int y, GdkPixmap *pic, int xor)
{
	setcolor(15);
	gdk_gc_set_function(gc, GDK_XOR);
	gdk_draw_drawable(pixmap, gc, pic, 0, 0, x, y, 13, 13);
	gdk_gc_set_function(gc, GDK_COPY);
	gtk_widget_queue_draw_area(drawing_area, x, y, 13, 13);
}

void draw_arrow ( int x, int y, int dir, int col )
{
	GdkGC *gc2, *gc1;
//	gc1 = (col==0 ? drawing_area->style->white_gc : drawing_area->style->mid_gc[2]);
	gc1 = (col==0 ? drawing_area->style->white_gc : drawing_area->style->black_gc);
	gc2 = (col==0 ? drawing_area->style->white_gc : drawing_area->style->black_gc);

	if (UP & dir) {
		gc = gc1;
		nline (x,y-8,x-3,y-4);
		nline (x,y-8,x+3,y-4);
		nline (x+1,y-1,x+1,y-7);
		nline (x-1,y-1,x-1,y-7);
		gc = gc2;
		nline (x,y,x,y-9);
		nline (x,y-9,x-3,y-5);
		nline (x,y-9,x+3,y-5);
	} if (DOWN & dir) {
		gc = gc1;
		nline (x,y+8,x-3,y+4);
		nline (x,y+8,x+3,y+4);
		nline (x+1,y+1,x+1,y+7);
		nline (x-1,y+1,x-1,y+7);
		gc = gc2;
		nline (x,y,x,y+9);
		nline (x,y+9,x-3,y+5);
		nline (x,y+9,x+3,y+5);
	} if (LEFT & dir) {
		gc = gc1;
		nline (x-8,y,x-4,y-3);
		nline (x-8,y,x-4,y+3);
		nline (x-1,y+1,x-7,y+1);
		nline (x-1,y-1,x-7,y-1);
		gc = gc2;
		nline (x,y,x-9,y);
		nline (x-9,y,x-5,y-3);
		nline (x-9,y,x-5,y+3);
	} if (RIGHT & dir) {
		gc = gc1;
		nline (x+8,y,x+4,y-3);
		nline (x+8,y,x+4,y+3);
		nline (x+1,y+1,x+7,y+1);
		nline (x+1,y-1,x+7,y-1);
		gc = gc2;
		nline (x,y,x+9,y);
		nline (x+9,y,x+5,y-3);
		nline (x+9,y,x+5,y+3);
	} if (_UP & dir){
		gc = gc2;
		nline (x,y,x,y-7);
		gc = gc1;
		nline (x+1,y+0,x+1,y-6);
		nline (x-1,y+0,x-1,y-6);
	} if (_DOWN & dir) {
		gc = gc2;
		nline (x,y,x,y+7);
		gc = gc1;
		nline (x+1,y-0,x+1,y+6);
		nline (x-1,y-0,x-1,y+6);
	} if (_LEFT & dir) {
		gc = gc2;
		nline (x,y,x-7,y);
		gc = gc1;
		nline (x+0,y-1,x-6,y-1);
		nline (x+0,y+1,x-6,y+1);
	} if (_RIGHT & dir){
		gc = gc2;
		nline (x,y,x+7,y);
		gc = gc1;
		nline (x-0,y-1,x+6,y-1);
		nline (x-0,y+1,x+6,y+1);
	}

	gtk_widget_queue_draw_area 
		( drawing_area, x-10, y-10, 20, 20 );
}

PangoFontDescription *fontdesc = NULL;

void outtextxy(int x, int y, char *s)
{
	PangoLayout *layout;
	if (fontdesc==NULL)
	{
		fontdesc = pango_font_description_from_string ("Luxi Mono 10");
	}
	layout = gtk_widget_create_pango_layout (drawing_area, s);
	pango_layout_set_font_description (layout, fontdesc); 
	gdk_draw_layout (pixmap, gc, x, y, layout);
	g_object_unref (layout);
	gtk_widget_queue_draw_area 
		( drawing_area, x, y, 640-x, 20 );  //xxx
}

