/*
*  qm_playlistview.h
*  QUIMUP playlist listview
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/


#ifndef QM_PLAYLIST_H
#define QM_PLAYLIST_H
#include <QtWidgets>
#include <QDrag>
#include <QApplication>
#include <QHeaderView>
#include <QTreeWidget>
#include <QTreeWidgetItem>
#include <QKeyEvent>
#include <QList>
#include <QListIterator>
#include <QMenu>
#include <QTime>
#include <QInputDialog>
#include <QMessageBox>
#include <QStringList>
#include <QUrl>
#include "qm_songinfo.h"
#include "qm_mpdcom.h"
#include "qm_config.h"

#define set_id(id)  setData(0, Qt::UserRole + 1, id)
#define set_state(state)  setData(0, Qt::UserRole + 2, state)
#define set_time(time)   setData(0, Qt::UserRole + 4, time)
#define set_uri(uri)   setData(0, Qt::UserRole + 5, uri)
#define set_type(type)   setData(0, Qt::UserRole + 6, type)
#define set_pos(pos)   setData(0, Qt::UserRole + 7, pos)

#define get_id   data(0, Qt::UserRole + 1).toInt()
#define get_state  data(0, Qt::UserRole + 2).toInt()
#define get_time  data(0, Qt::UserRole + 4).toInt()
#define get_file  data(0, Qt::UserRole + 5).toString()
#define get_type  data(0, Qt::UserRole + 6).toInt()
#define get_pos   data(0, Qt::UserRole + 7).toInt()

#define STATE_NEW   0
#define STATE_PLAYING  1
#define STATE_PLAYED  2

class qm_playlistView : public QTreeWidget
{
    Q_OBJECT

public:
    qm_playlistView(QWidget *, qm_Config *);
    virtual ~qm_playlistView();

public slots:
    void set_newsong(int);
    void set_status(int);
    void set_markplayed();
    void set_connected(qm_mpdCommand*, bool);
    void select_it(int);
    void on_open_with_request(QStringList&);
    void on_open_drop_request(QDropEvent*);
    void set_auto_columns();
    void resize_columns();
    void set_pos_time_column_width();
    void update_stream_title(int, QString);

private slots:
    void showLine_at(int);
    void on_new_playlist(qm_songinfo, int);
    void on_item_dclicked(QTreeWidgetItem *);
    void clear_it();
    void purge_it();
    void shuffle_it();
    void delete_it();
    void save_list();
    void save_selected();
    void reset_played();
    void reload_playlist();

private:
    bool
        b_is_on_start,
        b_streamplaying,
        b_mpd_connected,
        b_waspurged;

    QWidget *line;
    QStringList qeued_args_list;

    int
        current_song_pos,
        current_song_id,
        current_status,
        dropBeforeIndex,
        col_pos_width,
        col_time_width,
        resize_cols_count;
    QString
        string_time_width,
        string_pos_width;
    QIcon
        ic_track,
        ic_trackx,
        ic_stream,
        ic_track_played,
        ic_trackx_played,
        ic_stream_played,
        ic_wait,
        ic_stop,
        ic_play,
        ic_pause,
        ic_a_delete_selection,
        ic_a_clear_list,
        ic_a_purge_played,
        ic_a_reset_played,
        ic_a_shuffle_list,
        ic_a_save_list,
        ic_a_save_selection;
    QPixmap pxm_dragdrop;
    qm_mpdCommand *mpd_cmd;
    QColor  col_default_fg,
    col_playing_fg,
    col_played_fg;
    QHeaderView *hvw_playlist;
    qm_Config *config;
    QMenu *context_menu;
    QAction *a_shuffle_list,
            *a_save_list,
            *a_save_selection,
            *a_delete_selection,
            *a_clear_list,
            *a_purge_played,
            *a_reset_played;
    qm_IDlist get_played_IDs();
    QString into_time(int);
    void set_playlist_stats(int, int);
    bool file_check(const QString &);
    void setup_widgets();
    void set_themed_icons(bool);
    int get_string_width(QString);

protected:
    void resizeEvent (QResizeEvent *);
    void dropEvent(QDropEvent *);
    void dragLeaveEvent(QDragLeaveEvent *);
    void dragEnterEvent(QDragEnterEvent *);
    void dragMoveEvent(QDragMoveEvent *);
    void contextMenuEvent(QContextMenuEvent *);
    void keyPressEvent(QKeyEvent *);
    void startDrag(Qt::DropActions);

signals:
    void signal_playlist_statistics(QString);
    void signal_playlist_dropreceived(int);
};

#endif //  QM_PLAYLIST_H
