; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Sable"
!define PRODUCT_VERSION "1.0"
!define PRODUCT_PUBLISHER "Bumbershoot Software"
!define PRODUCT_WEB_SITE "http://www.stanford.edu/~mcmartin/sable/"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\Sable.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!define MUI_LICENSEPAGE_BUTTON "Install"
!define MUI_LICENSEPAGE_TEXT_BOTTOM "Press the Install button to continue."
!insertmacro MUI_PAGE_LICENSE "COPYING.TXT"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "Games\Sable"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\Sable.exe"
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\README.TXT"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "Sable-1.0-Win32-Setup.exe"
InstallDir "$PROGRAMFILES\Sable"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Section "Sable" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "SDL_mixer.dll"
  File "SDL_image.dll"
  File "SDL.dll"
  File "Sable.exe"
  File "README.TXT"
  File "libpng1.dll"
  File "jpeg.dll"
  File "COPYING.TXT"
  File "ChangeLog.txt"
  File "zlib.dll"
  SetOutPath "$INSTDIR\music"
  SetOutPath "$INSTDIR\sfx"
  SetOverwrite try
  File "sfx\expl_l.wav"
  File "sfx\expl_m.wav"
  File "sfx\expl_s.wav"
  File "sfx\pl_fire.wav"
  SetOutPath "$INSTDIR\textures"
  File "textures\font.png"
  File "textures\ground.png"
  File "textures\logo.png"
  File "textures\menu.png"
  SetOutPath "$INSTDIR\models"
  File "models\blossom.sva"
  File "models\ebullet.sva"
  File "models\enemy.sva"
  File "models\hbullet.sva"
  File "models\pylon.sva"
  File "models\sable.sva"
  SetOutPath "$INSTDIR"

; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Sable.lnk" "$INSTDIR\Sable.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -AdditionalIcons
  SetOutPath $INSTDIR
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" "$INSTDIR\uninst.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\Sable.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\Sable.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\textures\menu.png"
  Delete "$INSTDIR\textures\logo.png"
  Delete "$INSTDIR\textures\ground.png"
  Delete "$INSTDIR\textures\font.png"
  Delete "$INSTDIR\sfx\pl_fire.wav"
  Delete "$INSTDIR\sfx\expl_s.wav"
  Delete "$INSTDIR\sfx\expl_m.wav"
  Delete "$INSTDIR\sfx\expl_l.wav"
  Delete "$INSTDIR\models\blossom.sva"
  Delete "$INSTDIR\models\ebullet.sva"
  Delete "$INSTDIR\models\enemy.sva"
  Delete "$INSTDIR\models\hbullet.sva"
  Delete "$INSTDIR\models\pylon.sva"
  Delete "$INSTDIR\models\sable.sva"
  Delete "$INSTDIR\zlib.dll"
  Delete "$INSTDIR\ChangeLog.txt"
  Delete "$INSTDIR\COPYING.TXT"
  Delete "$INSTDIR\jpeg.dll"
  Delete "$INSTDIR\libpng1.dll"
  Delete "$INSTDIR\README.TXT"
  Delete "$INSTDIR\Sable.exe"
  Delete "$INSTDIR\SDL.dll"
  Delete "$INSTDIR\SDL_image.dll"
  Delete "$INSTDIR\SDL_mixer.dll"

  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Sable.lnk"

  RMDir "$SMPROGRAMS\$ICONS_GROUP"
  RMDir "$INSTDIR\music"
  RMDir "$INSTDIR\textures"
  RMDir "$INSTDIR\sfx"
  RMDir "$INSTDIR\models"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd