/******************************************************************************
 *{@C
 *      Copyright:      2005-2018 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on 
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOgl
 *      Filename:       tcl3dShapesMisc.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Declarations for miscellaneous shape functions.
 *
 *****************************************************************************/

#ifndef __TCL3D_SHAPES_MISC_H__
#define __TCL3D_SHAPES_MISC_H__

#ifdef __cplusplus
   extern "C" {
#endif

    void tcl3dBox    (const float lowerLeft[3], const float upperRight[3],
                      GLenum type);
    void tcl3dCube   (float cx, float cy, float cz, float size);
    void tcl3dSphere (float cx, float cy, float cz, float r, int p);
    void tcl3dHelix  (float cx, float cy, float cz, float r, int twists);

    void tcl3dCameraModel (void);
    void tcl3dTeapotModel (void);

#ifdef __cplusplus
   }
#endif

#endif /* __TCL3D_SHAPES_MISC_H__ */
