"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "RootFinder", {
  enumerable: true,
  get: function get() {
    return _RootFinder["default"];
  }
});
exports.assertDomAvailable = assertDomAvailable;
exports.compareNodeTypeOf = compareNodeTypeOf;
Object.defineProperty(exports, "createMountWrapper", {
  enumerable: true,
  get: function get() {
    return _createMountWrapper["default"];
  }
});
Object.defineProperty(exports, "createRenderWrapper", {
  enumerable: true,
  get: function get() {
    return _createRenderWrapper["default"];
  }
});
exports.displayNameOfNode = displayNameOfNode;
exports.elementToTree = elementToTree;
exports.ensureKeyOrUndefined = ensureKeyOrUndefined;
exports.fakeDynamicImport = fakeDynamicImport;
exports.findElement = findElement;
exports.flatten = flatten;
exports.getComponentStack = getComponentStack;
exports.getMaskedContext = getMaskedContext;
exports.getNodeFromRootFinder = getNodeFromRootFinder;
exports.getWrappingComponentMountRenderer = getWrappingComponentMountRenderer;
exports.isArrayLike = isArrayLike;
exports.mapNativeEventNames = mapNativeEventNames;
exports.nodeTypeFromType = nodeTypeFromType;
exports.propFromEvent = propFromEvent;
exports.propsWithKeysAndRef = propsWithKeysAndRef;
exports.simulateError = simulateError;
exports.spyMethod = spyMethod;
exports.spyProperty = spyProperty;
exports.withSetStateAllowed = withSetStateAllowed;
Object.defineProperty(exports, "wrap", {
  enumerable: true,
  get: function get() {
    return _wrapWithSimpleWrapper["default"];
  }
});
exports.wrapWithWrappingComponent = wrapWithWrappingComponent;
var _functionPrototype = _interopRequireDefault(require("function.prototype.name"));
var _object = _interopRequireDefault(require("object.fromentries"));
var _has = _interopRequireDefault(require("has"));
var _createMountWrapper = _interopRequireDefault(require("./createMountWrapper"));
var _createRenderWrapper = _interopRequireDefault(require("./createRenderWrapper"));
var _wrapWithSimpleWrapper = _interopRequireDefault(require("./wrapWithSimpleWrapper"));
var _RootFinder = _interopRequireDefault(require("./RootFinder"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function mapNativeEventNames(event) {
  var nativeToReactEventMap = {
    compositionend: 'compositionEnd',
    compositionstart: 'compositionStart',
    compositionupdate: 'compositionUpdate',
    keydown: 'keyDown',
    keyup: 'keyUp',
    keypress: 'keyPress',
    contextmenu: 'contextMenu',
    dblclick: 'doubleClick',
    doubleclick: 'doubleClick',
    // kept for legacy. TODO: remove with next major.
    dragend: 'dragEnd',
    dragenter: 'dragEnter',
    dragexist: 'dragExit',
    dragleave: 'dragLeave',
    dragover: 'dragOver',
    dragstart: 'dragStart',
    mousedown: 'mouseDown',
    mousemove: 'mouseMove',
    mouseout: 'mouseOut',
    mouseover: 'mouseOver',
    mouseup: 'mouseUp',
    touchcancel: 'touchCancel',
    touchend: 'touchEnd',
    touchmove: 'touchMove',
    touchstart: 'touchStart',
    canplay: 'canPlay',
    canplaythrough: 'canPlayThrough',
    durationchange: 'durationChange',
    loadeddata: 'loadedData',
    loadedmetadata: 'loadedMetadata',
    loadstart: 'loadStart',
    ratechange: 'rateChange',
    timeupdate: 'timeUpdate',
    volumechange: 'volumeChange',
    beforeinput: 'beforeInput',
    mouseenter: 'mouseEnter',
    mouseleave: 'mouseLeave',
    transitionend: 'transitionEnd',
    animationstart: 'animationStart',
    animationiteration: 'animationIteration',
    animationend: 'animationEnd',
    pointerdown: 'pointerDown',
    pointermove: 'pointerMove',
    pointerup: 'pointerUp',
    pointercancel: 'pointerCancel',
    gotpointercapture: 'gotPointerCapture',
    lostpointercapture: 'lostPointerCapture',
    pointerenter: 'pointerEnter',
    pointerleave: 'pointerLeave',
    pointerover: 'pointerOver',
    pointerout: 'pointerOut',
    auxclick: 'auxClick'
  };
  return nativeToReactEventMap[event] || event;
}

// 'click' => 'onClick'
// 'mouseEnter' => 'onMouseEnter'
function propFromEvent(event) {
  var nativeEvent = mapNativeEventNames(event);
  return "on".concat(nativeEvent[0].toUpperCase()).concat(nativeEvent.slice(1));
}
function withSetStateAllowed(fn) {
  // NOTE(lmr):
  // this is currently here to circumvent a React bug where `setState()` is
  // not allowed without global being defined.
  var cleanup = false;
  if (typeof global.document === 'undefined') {
    cleanup = true;
    global.document = {};
  }
  var result = fn();
  if (cleanup) {
    // This works around a bug in node/jest in that developers aren't able to
    // delete things from global when running in a node vm.
    global.document = undefined;
    delete global.document;
  }
  return result;
}
function assertDomAvailable(feature) {
  if (!global || !global.document || !global.document.createElement) {
    throw new Error("Enzyme's ".concat(feature, " expects a DOM environment to be loaded, but found none"));
  }
}
function displayNameOfNode(node) {
  if (!node) return null;
  var type = node.type;
  if (!type) return null;
  return type.displayName || (typeof type === 'function' ? (0, _functionPrototype["default"])(type) : type.name || type);
}
function nodeTypeFromType(type) {
  if (typeof type === 'string') {
    return 'host';
  }
  if (type && type.prototype && type.prototype.isReactComponent) {
    return 'class';
  }
  return 'function';
}
function getIteratorFn(obj) {
  var iteratorFn = obj && (typeof Symbol === 'function' && _typeof(Symbol.iterator) === 'symbol' && obj[Symbol.iterator] || obj['@@iterator']);
  if (typeof iteratorFn === 'function') {
    return iteratorFn;
  }
  return undefined;
}
function isIterable(obj) {
  return !!getIteratorFn(obj);
}
function isArrayLike(obj) {
  return Array.isArray(obj) || typeof obj !== 'string' && isIterable(obj);
}
function flatten(arrs) {
  // optimize for the most common case
  if (Array.isArray(arrs)) {
    return arrs.reduce(function (flatArrs, item) {
      return flatArrs.concat(isArrayLike(item) ? flatten(item) : item);
    }, []);
  }

  // fallback for arbitrary iterable children
  var flatArrs = [];
  var iteratorFn = getIteratorFn(arrs);
  var iterator = iteratorFn.call(arrs);
  var step = iterator.next();
  while (!step.done) {
    var item = step.value;
    var flatItem = void 0;
    if (isArrayLike(item)) {
      flatItem = flatten(item);
    } else {
      flatItem = item;
    }
    flatArrs = flatArrs.concat(flatItem);
    step = iterator.next();
  }
  return flatArrs;
}
function ensureKeyOrUndefined(key) {
  return key || (key === '' ? '' : undefined);
}
function elementToTree(el) {
  var recurse = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : elementToTree;
  if (typeof recurse !== 'function' && arguments.length === 3) {
    // special case for backwards compat for `.map(elementToTree)`
    recurse = elementToTree;
  }
  if (el === null || _typeof(el) !== 'object' || !('type' in el)) {
    return el;
  }
  var type = el.type,
    props = el.props,
    key = el.key,
    ref = el.ref;
  var children = props.children;
  var rendered = null;
  if (isArrayLike(children)) {
    rendered = flatten(children).map(function (x) {
      return recurse(x);
    });
  } else if (typeof children !== 'undefined') {
    rendered = recurse(children);
  }
  var nodeType = nodeTypeFromType(type);
  if (nodeType === 'host' && props.dangerouslySetInnerHTML) {
    if (props.children != null) {
      var error = new Error('Can only set one of `children` or `props.dangerouslySetInnerHTML`.');
      error.name = 'Invariant Violation';
      throw error;
    }
  }
  return {
    nodeType: nodeType,
    type: type,
    props: props,
    key: ensureKeyOrUndefined(key),
    ref: ref,
    instance: null,
    rendered: rendered
  };
}
function mapFind(arraylike, mapper, finder) {
  var found;
  var isFound = Array.prototype.find.call(arraylike, function (item) {
    found = mapper(item);
    return finder(found);
  });
  return isFound ? found : undefined;
}
function findElement(el, predicate) {
  if (el === null || _typeof(el) !== 'object' || !('type' in el)) {
    return undefined;
  }
  if (predicate(el)) {
    return el;
  }
  var rendered = el.rendered;
  if (isArrayLike(rendered)) {
    return mapFind(rendered, function (x) {
      return findElement(x, predicate);
    }, function (x) {
      return typeof x !== 'undefined';
    });
  }
  return findElement(rendered, predicate);
}
function propsWithKeysAndRef(node) {
  if (node.ref !== null || node.key !== null) {
    return _objectSpread(_objectSpread({}, node.props), {}, {
      key: node.key,
      ref: node.ref
    });
  }
  return node.props;
}
function getComponentStack(hierarchy) {
  var getNodeType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : nodeTypeFromType;
  var getDisplayName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : displayNameOfNode;
  var tuples = hierarchy.filter(function (node) {
    return node.type !== _RootFinder["default"];
  }).map(function (x) {
    return [getNodeType(x.type), getDisplayName(x)];
  }).concat([['class', 'WrapperComponent']]);
  return tuples.map(function (_ref, i, arr) {
    var _ref2 = _slicedToArray(_ref, 2),
      name = _ref2[1];
    var _ref3 = arr.slice(i + 1).find(function (_ref5) {
        var _ref6 = _slicedToArray(_ref5, 1),
          nodeType = _ref6[0];
        return nodeType !== 'host';
      }) || [],
      _ref4 = _slicedToArray(_ref3, 2),
      closestComponent = _ref4[1];
    return "\n    in ".concat(name).concat(closestComponent ? " (created by ".concat(closestComponent, ")") : '');
  }).join('');
}
function simulateError(error, catchingInstance, hierarchy) {
  var getNodeType = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : nodeTypeFromType;
  var getDisplayName = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : displayNameOfNode;
  var catchingType = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : {};
  var instance = catchingInstance || {};
  var componentDidCatch = instance.componentDidCatch;
  var getDerivedStateFromError = catchingType.getDerivedStateFromError;
  if (!componentDidCatch && !getDerivedStateFromError) {
    throw error;
  }
  if (getDerivedStateFromError) {
    var stateUpdate = getDerivedStateFromError.call(catchingType, error);
    instance.setState(stateUpdate);
  }
  if (componentDidCatch) {
    var componentStack = getComponentStack(hierarchy, getNodeType, getDisplayName);
    componentDidCatch.call(instance, error, {
      componentStack: componentStack
    });
  }
}
function getMaskedContext(contextTypes, unmaskedContext) {
  if (!contextTypes || !unmaskedContext) {
    return {};
  }
  return (0, _object["default"])(Object.keys(contextTypes).map(function (key) {
    return [key, unmaskedContext[key]];
  }));
}
function getNodeFromRootFinder(isCustomComponent, tree, options) {
  if (!isCustomComponent(options.wrappingComponent)) {
    return tree.rendered;
  }
  var rootFinder = findElement(tree, function (node) {
    return node.type === _RootFinder["default"];
  });
  if (!rootFinder) {
    throw new Error('`wrappingComponent` must render its children!');
  }
  return rootFinder.rendered;
}
function wrapWithWrappingComponent(createElement, node, options) {
  var wrappingComponent = options.wrappingComponent,
    wrappingComponentProps = options.wrappingComponentProps;
  if (!wrappingComponent) {
    return node;
  }
  return createElement(wrappingComponent, wrappingComponentProps, createElement(_RootFinder["default"], null, node));
}
function getWrappingComponentMountRenderer(_ref7) {
  var toTree = _ref7.toTree,
    getMountWrapperInstance = _ref7.getMountWrapperInstance;
  return {
    getNode: function getNode() {
      var instance = getMountWrapperInstance();
      return instance ? toTree(instance).rendered : null;
    },
    render: function render(el, context, callback) {
      var instance = getMountWrapperInstance();
      if (!instance) {
        throw new Error('The wrapping component may not be updated if the root is unmounted.');
      }
      return instance.setWrappingComponentProps(el.props, callback);
    }
  };
}
function fakeDynamicImport(moduleToImport) {
  return Promise.resolve({
    "default": moduleToImport
  });
}
function compareNodeTypeOf(node, matchingTypeOf) {
  if (!node) {
    return false;
  }
  return node.$$typeof === matchingTypeOf;
}

// TODO: when enzyme v3.12.0 is required, delete this
function spyMethod(instance, methodName) {
  var getStub = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : function () {};
  var lastReturnValue;
  var originalMethod = instance[methodName];
  var hasOwn = (0, _has["default"])(instance, methodName);
  var descriptor;
  if (hasOwn) {
    descriptor = Object.getOwnPropertyDescriptor(instance, methodName);
  }
  Object.defineProperty(instance, methodName, {
    configurable: true,
    enumerable: !descriptor || !!descriptor.enumerable,
    value: getStub(originalMethod) || function spied() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      var result = originalMethod.apply(this, args);
      lastReturnValue = result;
      return result;
    }
  });
  return {
    restore: function restore() {
      if (hasOwn) {
        if (descriptor) {
          Object.defineProperty(instance, methodName, descriptor);
        } else {
          instance[methodName] = originalMethod;
        }
      } else {
        delete instance[methodName];
      }
    },
    getLastReturnValue: function getLastReturnValue() {
      return lastReturnValue;
    }
  };
}

// TODO: when enzyme v3.12.0 is required, delete this
function spyProperty(instance, propertyName) {
  var handlers = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var originalValue = instance[propertyName];
  var hasOwn = (0, _has["default"])(instance, propertyName);
  var descriptor;
  if (hasOwn) {
    descriptor = Object.getOwnPropertyDescriptor(instance, propertyName);
  }
  var _wasAssigned = false;
  var holder = originalValue;
  var getV = handlers.get ? function () {
    var value = descriptor && descriptor.get ? descriptor.get.call(instance) : holder;
    return handlers.get.call(instance, value);
  } : function () {
    return holder;
  };
  var set = handlers.set ? function (newValue) {
    _wasAssigned = true;
    var handlerNewValue = handlers.set.call(instance, holder, newValue);
    holder = handlerNewValue;
    if (descriptor && descriptor.set) {
      descriptor.set.call(instance, holder);
    }
  } : function (v) {
    _wasAssigned = true;
    holder = v;
  };
  Object.defineProperty(instance, propertyName, {
    configurable: true,
    enumerable: !descriptor || !!descriptor.enumerable,
    get: getV,
    set: set
  });
  return {
    restore: function restore() {
      if (hasOwn) {
        if (descriptor) {
          Object.defineProperty(instance, propertyName, descriptor);
        } else {
          instance[propertyName] = holder;
        }
      } else {
        delete instance[propertyName];
      }
    },
    wasAssigned: function wasAssigned() {
      return _wasAssigned;
    }
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//# sourceMappingURL=Utils.js.map