/* 
   euses - A small utility in C that quickly displays use flag descriptions

   Copyright 2005-2020 Jeroen Roovers

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#include "config.h"

/* Maximum line length in description files */
#define LINE_LENGTH 1024

/* Output types: */
#define OUTPUT_NORMAL 0
#define OUTPUT_VERBOSE 1
#define OUTPUT_PEDANTIC 2

/* Search Targets: */
#define FLAG 0
#define DESC 1
#define PKG  2
#define LINE 3

/* Errors: */
#define FILE_ERR 0
#define FORMAT_ERR 1
#define NOT_IMPLEMENTED 2
#define OPTION_CONFLICT 3

/* File Formats */

#define FF_USE_DESC		1
#define FF_USE_LOCAL_DESC	2
#define FF_PROFILES_DESC	4

/* Which Description Files to Search */
#define SEARCH_LOCAL	1
#define SEARCH_USE	2
#define SEARCH_ALL_USE	3
#define SEARCH_ALL	4

/* Color Definitions: */
#define NORMAL_WHITE    "\033[00;00m"	/* Normal White    */
#define BRIGHT_WHITE    "\033[01;29m"	/* Bright White    */
#define NORMAL_BLACK    "\033[00;30m"	/* Normal Grey     */
#define BRIGHT_BLACK    "\033[01;30m"	/* Bright Grey     */
#define NORMAL_RED      "\033[00;31m"	/* Normal Red      */
#define BRIGHT_RED      "\033[01;31m"	/* Bright Red      */
#define NORMAL_GREEN    "\033[00;32m"	/* Normal Green    */
#define BRIGHT_GREEN    "\033[01;32m"	/* Bright Green    */
#define NORMAL_YELLOW   "\033[00;33m"	/* Normal Yellow   */
#define BRIGHT_YELLOW   "\033[01;33m"	/* Bright Yellow   */
#define NORMAL_BLUE     "\033[00;34m"	/* Normal Blue     */
#define BRIGHT_BLUE     "\033[01;34m"	/* Bright Blue     */
#define NORMAL_MAGENTA  "\033[00;35m"	/* Normal Magenta  */
#define BRIGHT_MAGENTA  "\033[01;35m"	/* Bright Magenta  */
#define NORMAL_CYAN     "\033[00;36m"	/* Normal Cyan     */
#define BRIGHT_CYAN     "\033[01;36m"	/* Bright Cyan     */
#define NORMAL_GREY     "\033[00;37m"	/* Normal Grey     */
#define BRIGHT_GREY     "\033[01;37m"	/* Bright Grey     */

/* Functions: */
static void usage();

static void version();

static void doerror(int err_no, char *filename, char *line);

static char *getportdir(char *portdir);

static int line_is_no_comment(char *line, char *desc_file_name);

static int pkg_flag_desc(char *line, char *package, char *flagdesc);

static int flag_desc(char *line, char *flag, char *desc);

static int match(char *string, FILE * fp, int colour, int output_type, int tgt,
		 int ign, int do_strict, char *desc_file_name);

static int printm(int colour, int fileformat, char *desc_file_name,
		  int output_type, char *package, char *flag, char *desc, int linecounter);

static void match_err(int colour, int output_type, char *string,
		      char *desc_file_name);

extern int main(int argc, char **argv);

/* TODO: Struct typedefs: */

typedef struct {
	char *pkg;
	char *flag;
	char *desc;
	struct pfd_t *next;
} pfd_t;
