<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# array2d

```go
import "github.com/zyedidia/generic/array2d"
```

Package array2d contains an implementation of a 2D array.

## Index

- [type Array2D](<#type-array2d>)
  - [func New[T any](width, height int) Array2D[T]](<#func-new>)
  - [func NewFilled[T any](width, height int, value T) Array2D[T]](<#func-newfilled>)
  - [func OfJagged[J ~[]S, S ~[]E, E any](width, height int, jagged J) Array2D[E]](<#func-ofjagged>)
  - [func (a Array2D[T]) Copy() Array2D[T]](<#func-array2dt-copy>)
  - [func (a Array2D[T]) Fill(x1, y1, x2, y2 int, value T)](<#func-array2dt-fill>)
  - [func (a Array2D[T]) Get(x, y int) T](<#func-array2dt-get>)
  - [func (a Array2D[T]) Height() int](<#func-array2dt-height>)
  - [func (a Array2D[T]) Row(y int) []T](<#func-array2dt-row>)
  - [func (a Array2D[T]) RowSpan(x1, x2, y int) []T](<#func-array2dt-rowspan>)
  - [func (a Array2D[T]) Set(x, y int, value T)](<#func-array2dt-set>)
  - [func (a Array2D[T]) String() string](<#func-array2dt-string>)
  - [func (a Array2D[T]) Width() int](<#func-array2dt-width>)


## type [Array2D](<https://github.com/zyedidia/generic/blob/master/array2d/array2d.go#L41-L44>)

Array2D is a 2\-dimensional array.

```go
type Array2D[T any] struct {
    // contains filtered or unexported fields
}
```

<details><summary>Example</summary>
<p>

```go
package main

import (
	"fmt"
	"strings"

	"github.com/zyedidia/generic/array2d"
)

type Sudoku struct {
	arr array2d.Array2D[byte]
}

func (s Sudoku) PrintBoard() {
	var sb strings.Builder
	for y := 0; y < s.arr.Height(); y++ {
		if y%3 == 0 {
			sb.WriteString("+-------+-------+-------+\n")
		}
		for x := 0; x < s.arr.Width(); x++ {
			if x%3 == 0 {
				sb.WriteString("| ")
			}
			val := s.arr.Get(x, y)
			if val == 0 {
				sb.WriteByte(' ')
			} else {
				fmt.Fprint(&sb, val)
			}
			sb.WriteByte(' ')
		}
		sb.WriteString("|\n")
	}
	sb.WriteString("+-------+-------+-------+\n")
	fmt.Print(sb.String())
}

func main() {
	s := Sudoku{
		arr: array2d.OfJagged(9, 9, [][]byte{
			{5, 3, 0, 0, 7, 0, 0, 0, 0},
			{6, 0, 0, 1, 9, 5, 0, 0, 0},
			{0, 9, 8, 0, 0, 0, 0, 6, 0},
			{8, 0, 0, 0, 6, 0, 0, 0, 3},
			{4, 0, 0, 8, 0, 3, 0, 0, 1},
			{7, 0, 0, 0, 2, 0, 0, 0, 6},
			{0, 6, 0, 0, 0, 0, 2, 8, 0},
			{0, 0, 0, 4, 1, 9, 0, 0, 5},
			{0, 0, 0, 0, 8, 0, 0, 7, 9},
		}),
	}

	s.arr.Set(2, 5, 3)

	s.PrintBoard()

}
```

#### Output

```
+-------+-------+-------+
| 5 3   |   7   |       |
| 6     | 1 9 5 |       |
|   9 8 |       |   6   |
+-------+-------+-------+
| 8     |   6   |     3 |
| 4     | 8   3 |     1 |
| 7   3 |   2   |     6 |
+-------+-------+-------+
|   6   |       | 2 8   |
|       | 4 1 9 |     5 |
|       |   8   |   7 9 |
+-------+-------+-------+
```

</p>
</details>

### func [New](<https://github.com/zyedidia/generic/blob/master/array2d/array2d.go#L10>)

```go
func New[T any](width, height int) Array2D[T]
```

New initializes a 2\-dimensional array with all zero values.

### func [NewFilled](<https://github.com/zyedidia/generic/blob/master/array2d/array2d.go#L19>)

```go
func NewFilled[T any](width, height int, value T) Array2D[T]
```

NewFilled initializes a 2\-dimensional array with a value.

### func [OfJagged](<https://github.com/zyedidia/generic/blob/master/array2d/array2d.go#L32>)

```go
func OfJagged[J ~[]S, S ~[]E, E any](width, height int, jagged J) Array2D[E]
```

OfJagged initializes a 2\-dimensional array based on a jagged slice of rows of values. Values from the jagged slice that are out of bounds are ignored.

### func \(Array2D\[T\]\) [Copy](<https://github.com/zyedidia/generic/blob/master/array2d/array2d.go#L112>)

```go
func (a Array2D[T]) Copy() Array2D[T]
```

Copy returns a shallow copy of this array.

### func \(Array2D\[T\]\) [Fill](<https://github.com/zyedidia/generic/blob/master/array2d/array2d.go#L152>)

```go
func (a Array2D[T]) Fill(x1, y1, x2, y2 int, value T)
```

Fill will assign all values inside the region to the specified value. The coordinates are inclusive, meaning all values from \[x1,y1\] including \[x1,y1\] to \[x2,y2\] including \[x2,y2\] are set.

The method sorts the arguments, so x2 may be lower than x1 and y2 may be lower than y1.

### func \(Array2D\[T\]\) [Get](<https://github.com/zyedidia/generic/blob/master/array2d/array2d.go#L70>)

```go
func (a Array2D[T]) Get(x, y int) T
```

Get returns a value from the array.

The function will panic on out\-of\-bounds access.

### func \(Array2D\[T\]\) [Height](<https://github.com/zyedidia/generic/blob/master/array2d/array2d.go#L107>)

```go
func (a Array2D[T]) Height() int
```

Height returns the height of this array. The maximum y value is Height\(\)\-1.

### func \(Array2D\[T\]\) [Row](<https://github.com/zyedidia/generic/blob/master/array2d/array2d.go#L139>)

```go
func (a Array2D[T]) Row(y int) []T
```

Row returns a mutable slice for an entire row. Changing values in this slice will affect the array.

### func \(Array2D\[T\]\) [RowSpan](<https://github.com/zyedidia/generic/blob/master/array2d/array2d.go#L124>)

```go
func (a Array2D[T]) RowSpan(x1, x2, y int) []T
```

RowSpan returns a mutable slice for part of a row. Changing values in this slice will affect the array.

### func \(Array2D\[T\]\) [Set](<https://github.com/zyedidia/generic/blob/master/array2d/array2d.go#L87>)

```go
func (a Array2D[T]) Set(x, y int, value T)
```

Set sets a value in the array.

The function will panic on out\-of\-bounds access.

### func \(Array2D\[T\]\) [String](<https://github.com/zyedidia/generic/blob/master/array2d/array2d.go#L47>)

```go
func (a Array2D[T]) String() string
```

String returns a string representation of this array.

### func \(Array2D\[T\]\) [Width](<https://github.com/zyedidia/generic/blob/master/array2d/array2d.go#L102>)

```go
func (a Array2D[T]) Width() int
```

Width returns the width of this array. The maximum x value is Width\(\)\-1.



Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)
