# generated by datamodel-codegen:
#   filename:  alpine_schema.json
#   version:   0.26.3

from __future__ import annotations

from enum import Enum
from typing import Dict, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel, StrictStr


class PublicKey(BaseModel):
    """The public key that can verify the package signature"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: str = Field(
        ...,
        description="Specifies the content of the public key inline within the document",
    )


class Algorithm(str, Enum):
    """The hashing function used to compute the hash value"""

    SHA256 = "sha256"


class Hash(BaseModel):
    """Specifies the hash algorithm and value for the package"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    algorithm: Algorithm = Field(
        ...,
        description="The hashing function used to compute the hash value",
    )
    value: StrictStr = Field(..., description="The hash value for the package")


class Package(BaseModel):
    """Information about the package associated with the entry"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    pkginfo: Optional[Dict[str, StrictStr]] = Field(
        default=None,
        description="Values of the .PKGINFO key / value pairs",
    )
    hash: Hash = Field(..., description="Specifies the hash algorithm and value for the package")
    content: Optional[str] = Field(
        default=None,
        description="Specifies the package inline within the document",
    )


class Hash1(Hash):
    """Specifies the hash algorithm and value for the package"""


class Package1(BaseModel):
    """Information about the package associated with the entry"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    pkginfo: Optional[Dict[str, StrictStr]] = Field(
        default=None,
        description="Values of the .PKGINFO key / value pairs",
    )
    hash: Optional[Hash1] = Field(
        default=None,
        description="Specifies the hash algorithm and value for the package",
    )
    content: str = Field(..., description="Specifies the package inline within the document")


class AlpineV001Schema(BaseModel):
    """Schema for Alpine Package entries"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    public_key: PublicKey = Field(
        ...,
        alias="publicKey",
        description="The public key that can verify the package signature",
    )
    package: Union[Package, Package1] = Field(
        ...,
        description="Information about the package associated with the entry",
    )


class AlpinePackageSchema(RootModel[AlpineV001Schema]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: AlpineV001Schema = Field(
        ...,
        description="Schema for Alpine package objects",
        title="Alpine Package Schema",
    )
