/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mam.element;

import org.jivesoftware.smackx.mam.element.MamElementFactory;
import org.jivesoftware.smackx.mam.element.MamV1ElementFactory;
import org.jivesoftware.smackx.mam.element.MamV2ElementFactory;

public enum MamVersion {
    MAM2("urn:xmpp:mam:2"){

        @Override
        public MamElementFactory newElementFactory() {
            return new MamV2ElementFactory();
        }
    }
    ,
    MAM1("urn:xmpp:mam:1"){

        @Override
        public MamElementFactory newElementFactory() {
            return new MamV1ElementFactory();
        }
    };

    private final String namespace;

    private MamVersion(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public abstract MamElementFactory newElementFactory();

    public static MamVersion fromNamespace(String namespace) {
        for (MamVersion v : MamVersion.values()) {
            if (!v.namespace.equals(namespace)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unsupported namespace: " + namespace);
    }
}

