/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.hoxt.provider;

import java.io.IOException;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.hoxt.packet.AbstractHttpOverXmpp;
import org.jivesoftware.smackx.shim.packet.HeadersExtension;
import org.jivesoftware.smackx.shim.provider.HeadersProvider;

public abstract class AbstractHttpOverXmppProvider<H extends AbstractHttpOverXmpp>
extends IqProvider<H> {
    private static final String ELEMENT_DATA = "data";
    private static final String ELEMENT_TEXT = "text";
    private static final String ELEMENT_BASE_64 = "base64";
    private static final String ELEMENT_CHUNKED_BASE_64 = "chunkedBase64";
    private static final String ELEMENT_XML = "xml";
    static final String ELEMENT_IBB = "ibb";
    static final String ELEMENT_SIPUB = "sipub";
    static final String ELEMENT_JINGLE = "jingle";
    private static final String ATTRIBUTE_STREAM_ID = "streamId";
    private static final String ATTRIBUTE_SID = "sid";
    static final String ATTRIBUTE_VERSION = "version";

    protected HeadersExtension parseHeaders(XmlPullParser parser) throws IOException, XmlPullParserException, SmackParsingException {
        HeadersExtension headersExtension = null;
        if (parser.next() == XmlPullParser.Event.START_ELEMENT && parser.getName().equals("headers")) {
            headersExtension = (HeadersExtension)HeadersProvider.INSTANCE.parse(parser);
            parser.next();
        }
        return headersExtension;
    }

    protected AbstractHttpOverXmpp.Data parseData(XmlPullParser parser) throws XmlPullParserException, IOException {
        AbstractHttpOverXmpp.HoxExtensionElement child = null;
        boolean done = false;
        AbstractHttpOverXmpp.Data data = null;
        if (parser.getEventType() == XmlPullParser.Event.START_ELEMENT) {
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT) {
                    switch (parser.getName()) {
                        case "text": {
                            child = AbstractHttpOverXmppProvider.parseText(parser);
                            break;
                        }
                        case "base64": {
                            child = AbstractHttpOverXmppProvider.parseBase64(parser);
                            break;
                        }
                        case "chunkedBase64": {
                            child = AbstractHttpOverXmppProvider.parseChunkedBase64(parser);
                            break;
                        }
                        case "xml": {
                            child = AbstractHttpOverXmppProvider.parseXml(parser);
                            break;
                        }
                        case "ibb": {
                            child = AbstractHttpOverXmppProvider.parseIbb(parser);
                            break;
                        }
                        case "sipub": {
                            throw new UnsupportedOperationException("sipub is not supported yet");
                        }
                        case "jingle": {
                            throw new UnsupportedOperationException("jingle is not supported yet");
                        }
                        default: {
                            throw new IllegalArgumentException("unsupported child tag: " + parser.getName());
                        }
                    }
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals(ELEMENT_DATA)) continue;
                done = true;
            }
            data = new AbstractHttpOverXmpp.Data(child);
        }
        return data;
    }

    private static AbstractHttpOverXmpp.Text parseText(XmlPullParser parser) throws XmlPullParserException, IOException {
        String text = null;
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.END_ELEMENT) {
                if (parser.getName().equals(ELEMENT_TEXT)) {
                    done = true;
                    continue;
                }
                throw new IllegalArgumentException("unexpected end tag of: " + parser.getName());
            }
            if (eventType == XmlPullParser.Event.TEXT_CHARACTERS) {
                text = parser.getText();
                continue;
            }
            throw new IllegalArgumentException("unexpected eventType: " + String.valueOf((Object)eventType));
        }
        return new AbstractHttpOverXmpp.Text(text);
    }

    private static AbstractHttpOverXmpp.Xml parseXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        StringBuilder builder = new StringBuilder();
        boolean done = false;
        boolean startClosed = true;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser.getName().equals(ELEMENT_XML)) {
                done = true;
                continue;
            }
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (!startClosed) {
                    builder.append('>');
                }
                builder.append('<');
                builder.append(parser.getName());
                AbstractHttpOverXmppProvider.appendXmlAttributes(parser, builder);
                startClosed = false;
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT) {
                if (startClosed) {
                    builder.append("</");
                    builder.append(parser.getName());
                    builder.append('>');
                    continue;
                }
                builder.append("/>");
                startClosed = true;
                continue;
            }
            if (eventType == XmlPullParser.Event.TEXT_CHARACTERS) {
                if (!startClosed) {
                    builder.append('>');
                    startClosed = true;
                }
                builder.append(StringUtils.escapeForXmlText(parser.getText()));
                continue;
            }
            throw new IllegalArgumentException("unexpected eventType: " + String.valueOf((Object)eventType));
        }
        return new AbstractHttpOverXmpp.Xml(builder.toString());
    }

    private static void appendXmlAttributes(XmlPullParser parser, StringBuilder builder) {
        int count = parser.getAttributeCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                builder.append(' ');
                builder.append(parser.getAttributeName(i));
                builder.append("=\"");
                builder.append(StringUtils.escapeForXml(parser.getAttributeValue(i)));
                builder.append('\"');
            }
        }
    }

    private static AbstractHttpOverXmpp.Base64 parseBase64(XmlPullParser parser) throws XmlPullParserException, IOException {
        String text = null;
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.END_ELEMENT) {
                if (parser.getName().equals(ELEMENT_BASE_64)) {
                    done = true;
                    continue;
                }
                throw new IllegalArgumentException("unexpected end tag of: " + parser.getName());
            }
            if (eventType == XmlPullParser.Event.TEXT_CHARACTERS) {
                text = parser.getText();
                continue;
            }
            throw new IllegalArgumentException("unexpected eventType: " + String.valueOf((Object)eventType));
        }
        return new AbstractHttpOverXmpp.Base64(text);
    }

    private static AbstractHttpOverXmpp.ChunkedBase64 parseChunkedBase64(XmlPullParser parser) throws XmlPullParserException, IOException {
        String streamId = parser.getAttributeValue("", ATTRIBUTE_STREAM_ID);
        AbstractHttpOverXmpp.ChunkedBase64 child = new AbstractHttpOverXmpp.ChunkedBase64(streamId);
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.END_ELEMENT) {
                if (parser.getName().equals(ELEMENT_CHUNKED_BASE_64)) {
                    done = true;
                    continue;
                }
                throw new IllegalArgumentException("unexpected end tag: " + parser.getName());
            }
            throw new IllegalArgumentException("unexpected event type: " + String.valueOf((Object)eventType));
        }
        return child;
    }

    private static AbstractHttpOverXmpp.Ibb parseIbb(XmlPullParser parser) throws XmlPullParserException, IOException {
        String sid = parser.getAttributeValue("", ATTRIBUTE_SID);
        AbstractHttpOverXmpp.Ibb child = new AbstractHttpOverXmpp.Ibb(sid);
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.END_ELEMENT) {
                if (parser.getName().equals(ELEMENT_IBB)) {
                    done = true;
                    continue;
                }
                throw new IllegalArgumentException("unexpected end tag: " + parser.getName());
            }
            throw new IllegalArgumentException("unexpected event type: " + String.valueOf((Object)eventType));
        }
        return child;
    }
}

