/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal.things;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.model.yaml.YamlElement;
import org.openhab.core.model.yaml.YamlElementName;
import org.openhab.core.model.yaml.internal.things.YamlChannelDTO;
import org.openhab.core.model.yaml.internal.util.YamlElementUtils;

@YamlElementName(value="things")
public class YamlThingDTO
implements YamlElement,
Cloneable {
    private static final Pattern THING_UID_SEGMENT_PATTERN = Pattern.compile("[a-zA-Z0-9_][a-zA-Z0-9_-]*");
    private static final Pattern CHANNEL_ID_PATTERN = Pattern.compile("[a-zA-Z0-9_][a-zA-Z0-9_-]*(#[a-zA-Z0-9_][a-zA-Z0-9_-]*)?");
    public String uid;
    public Boolean isBridge;
    public String bridge;
    public String label;
    public String location;
    public Map<@NonNull String, @NonNull Object> config;
    public Map<@NonNull String, @NonNull YamlChannelDTO> channels;

    @Override
    public @NonNull String getId() {
        return this.uid == null ? "" : this.uid;
    }

    @Override
    public void setId(@NonNull String id) {
        this.uid = id;
    }

    @Override
    public YamlElement cloneWithoutId() {
        try {
            YamlThingDTO copy = (YamlThingDTO)super.clone();
            copy.uid = null;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            return new YamlThingDTO();
        }
    }

    @Override
    public boolean isValid(@Nullable List<@NonNull String> errors, @Nullable List<@NonNull String> warnings) {
        String segment;
        if (this.uid == null || this.uid.isBlank()) {
            this.addToList(errors, "invalid thing: uid is missing while mandatory");
            return false;
        }
        boolean ok = true;
        String[] segments = this.uid.split(":");
        if (segments.length < 3) {
            this.addToList(errors, "invalid thing \"%s\": not enough segments in uid; minimum 3 is expected".formatted(this.uid));
            ok = false;
        }
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            segment = stringArray[n2];
            if (!THING_UID_SEGMENT_PATTERN.matcher(segment).matches()) {
                this.addToList(errors, "invalid thing \"%s\": segment \"%s\" in uid not matching the expected syntax %s".formatted(this.uid, segment, THING_UID_SEGMENT_PATTERN.pattern()));
                ok = false;
            }
            ++n2;
        }
        if (this.bridge != null && !this.bridge.isBlank()) {
            segments = this.bridge.split(":");
            if (segments.length < 3) {
                this.addToList(errors, "invalid thing \"%s\": not enough segments in value \"%s\" for \"bridge\" field; minimum 3 is expected".formatted(this.uid, this.bridge));
                ok = false;
            }
            stringArray = segments;
            n = segments.length;
            n2 = 0;
            while (n2 < n) {
                segment = stringArray[n2];
                if (!THING_UID_SEGMENT_PATTERN.matcher(segment).matches()) {
                    this.addToList(errors, "invalid thing \"%s\": segment \"%s\" in \"bridge\" field not matching the expected syntax %s".formatted(this.uid, segment, THING_UID_SEGMENT_PATTERN.pattern()));
                    ok = false;
                }
                ++n2;
            }
        }
        if (this.channels != null) {
            for (Map.Entry<String, YamlChannelDTO> entry : this.channels.entrySet()) {
                String channelId = entry.getKey();
                if (!CHANNEL_ID_PATTERN.matcher(channelId).matches()) {
                    this.addToList(errors, "invalid thing \"%s\": channel id \"%s\" not matching the expected syntax %s".formatted(this.uid, channelId, CHANNEL_ID_PATTERN.pattern()));
                    ok = false;
                }
                ArrayList<String> channelErrors = new ArrayList<String>();
                ArrayList<String> channelWarnings = new ArrayList<String>();
                ok &= entry.getValue().isValid(channelErrors, channelWarnings);
                channelErrors.forEach(error -> this.addToList(errors, "invalid thing \"%s\": channel \"%s\": %s".formatted(this.uid, channelId, error)));
                channelWarnings.forEach(warning -> this.addToList(warnings, "thing \"%s\": channel \"%s\": %s".formatted(this.uid, channelId, warning)));
            }
        }
        return ok;
    }

    private void addToList(@Nullable List<@NonNull String> list, String value) {
        if (list != null) {
            list.add(value);
        }
    }

    public boolean isBridge() {
        return this.isBridge == null ? false : this.isBridge;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.bridge, this.label, this.location);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        YamlThingDTO other = (YamlThingDTO)obj;
        return Objects.equals(this.uid, other.uid) && this.isBridge() == other.isBridge() && Objects.equals(this.bridge, other.bridge) && Objects.equals(this.label, other.label) && Objects.equals(this.location, other.location) && YamlElementUtils.equalsConfig(this.config, other.config) && this.equalsChannels(this.channels, other.channels);
    }

    private boolean equalsChannels(@Nullable Map<@NonNull String, @NonNull YamlChannelDTO> first, @Nullable Map<@NonNull String, @NonNull YamlChannelDTO> second) {
        if (first != null && second != null) {
            if (first.size() != second.size()) {
                return false;
            }
            return first.entrySet().stream().allMatch(e -> ((YamlChannelDTO)e.getValue()).equals(second.get(e.getKey())));
        }
        return first == null && second == null;
    }
}

