/** @file dlo_data.h
 *
 *  @brief Hard-wired screen mode-related data blocks.
 *
 *  DisplayLink Open Source Software (libdlo)
 *  Copyright (C) 2009, DisplayLink
 *  www.displaylink.com
 *
 *  This library is free software; you can redistribute it and/or modify it under
 *  the terms of the GNU Library General Public License as published by the Free
 *  Software Foundation; LGPL version 2, dated June 1991.
 *
 *  This library is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 *  FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef DLO_DLODATA_H
#define DLO_DLODATA_H        /**< Avoid multiple inclusion. */


/** Screen mode 640x480 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_640_480_60_24_0 "" \
        "\x79\x7C\xAD\x97\xAD\xFE\x4B\xDE\x1A\x2F\xA2\x94\x2C\xD5\xD3\x5C"

/** Mode data.
 */
#define DLO_MODE_DATA_640_480_60_24_0 "" \
        "\xE5\xDF\xC0\x52\x4F\xE1\xE6\xB4\xE3\xED\xC4\x21\x5E\x56\xC2\x53" \
        "\x35\x1C\xE8\xF2\xDF\xEF\x7F\x37\xF5\xA5\x4B\x56\xEB\xED\x34\x7B" \
        "\xFB\x89\xA3\x17\xE4\x69\xFF\x39\xD2\xAE\x09\xB6\xC0\xBE\x4D\xBC" \
        "\x84\x6D\x99\xDA\x6B\x28\xBD\xE1\x0E\xC2\xDD\xB0\xDB\x63\xAE\x27" \
        "\x17\x9C\xD6\xD8\xCC\xC5\x44\xFD\x1C\xEF\x49\x9B\xE8\x69\x69\xCA" \
        "\xA5\x9E\xC5\x6B\xF9\x71\xC1\x1B\x8F\x8C\x41\x6B\xC4\xBE\x2A\x6F" \
        "\x56\x82\x37\xC8\x83\x92\x27\x20\x08\x62\x76\x24\x41\xEE\x38\x33" \
        "\x20\x5C\xAA\xA7\x04\x95\xFA\x8F\xE9\xBA\xEE\xD4\x6C\x8F\x82\x42" \
        "\x4E\x0F\xB3\xFC\x5D\x25\x9D\x33\xB4\x6F\xBF\x54\xB7\xEB\x16\xF3" \
        "\xE9\x7C"

/** Screen mode 640x480 (at 73 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_640_480_73_24_0 "" \
        "\xA7\xA6\x78\x54\xA4\xC3\x33\xBF\xF3\xD5\x53\x1F\xAA\x27\x7B\x91"

/** Mode data.
 */
#define DLO_MODE_DATA_640_480_73_24_0 "" \
        "\x61\x1A\x38\x7B\x68\x45\x20\x90\x34\x5D\x1D\x6C\x9D\xC4\xA6\x0E" \
        "\xA3\xEA\x7F\xD9\x70\xAD\xE5\x53\xBE\xB4\x0B\xEC\xB5\xE4\xA1\xAC" \
        "\x5D\x7D\x06\x9A\x97\xE8\x3D\xFC\x7E\x81\x02\x07\xB1\x30\xC1\xAB" \
        "\x9C\xC3\x08\xEA\x79\xAA\xBD\x8F\xC1\x2B\xAA\x69\xD5\x17\xF3\x60" \
        "\x3B\x9F\x86\x86\x2C\x88\x02\x3F\x60\xF4\xA9\xFC\xD6\x8D\x41\x2E" \
        "\xDE\x64\x6F\xA2\x1F\x33\xB2\x76\x95\xF9\x89\xCC\x71\xEC\x00\x5E" \
        "\xFC\x9F\xC6\x32\xE3\xAB\x8D\xCA\xC6\x3D\xC9\x4E\xD2\xD5\x83\x7B" \
        "\x2F\x0C\x78\xE7\x3E\xE3\xEE\xD6\xCB\x95\x54\x02\x83\x46\x01\x78" \
        "\x1B\x33\xF7\x12\x47\x16\x05\xAF\x99\x56\x87\xF9\xFA\x3F\x93\x0C" \
        "\x79\xA6"

/** Screen mode 640x480 (at 75 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_640_480_75_24_0 "" \
        "\xBC\xD1\x26\x61\x95\x59\x20\x88\x2E\x73\xA7\xD9\x9A\x22\x6A\xFB"

/** Mode data.
 */
#define DLO_MODE_DATA_640_480_75_24_0 "" \
        "\xAA\xCE\xFB\xD4\xC3\x07\xC1\xBF\xAD\xA3\xEF\xA9\x2B\x77\xBD\x5D" \
        "\x03\xBE\x67\xF4\x99\xA1\xA3\x53\x25\x5B\x50\x6D\x0C\x3A\xA7\x4C" \
        "\xB0\x86\x04\x60\x01\x8C\xED\xBC\x5A\xF9\x3A\x0E\x1B\x10\xFF\x55" \
        "\x8B\x23\xAC\xDE\xEA\xB2\x2E\x8B\x02\x4E\xF1\x67\x9C\x85\x5D\x3B" \
        "\xE1\xC1\xAC\x3B\x26\xE2\xC3\x13\x25\xF4\xCC\xBC\xF0\xD9\x1F\x27" \
        "\x0C\xF0\x42\x6C\x18\x3B\x20\xC6\x29\xD7\x6C\x0A\x4B\xDC\x44\x3C" \
        "\x46\xDB\x6E\x78\xEB\xAB\x7A\xF5\x63\xE2\xAD\x77\x03\xA0\x9F\xCB" \
        "\x22\x4D\x03\x66\x0B\xF8\xE7\x26\xA4\x15\xF4\xF9\x13\xE7\x14\x97" \
        "\xF1\x98\xD0\x8B\x4E\xDB\xA5\xC6\x4E\x74\x19\x2C\xB2\x97\x55\xA4" \
        "\x0E\x61"

/** Screen mode 640x480 (at 85 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_640_480_85_24_0 "" \
        "\x6D\x0D\x6A\x02\x66\x8A\x8A\x94\xFD\x31\x6D\x98\x53\xD7\x93\x25"

/** Mode data.
 */
#define DLO_MODE_DATA_640_480_85_24_0 "" \
        "\xC6\x8C\x42\x4C\x95\xDA\xB4\x2F\xBD\xD9\x9E\x7C\x8F\x7B\x69\xA8" \
        "\x1B\xDA\x06\x96\x23\x9E\x94\xE2\xC2\xE9\xBB\xD3\x13\x6B\x9B\x21" \
        "\xC1\x4E\xD8\x3F\x81\x49\x6E\xD1\xAF\xB2\x4E\x8C\x24\x1A\xA8\xB6" \
        "\x4E\x11\x75\xB3\xE6\xC9\x3D\x36\x9A\xCC\x3B\xAA\x1F\xC4\x97\xD5" \
        "\x4A\x9D\xAA\xE0\x04\xF0\xB6\x2C\xBD\xE4\x41\x19\xF8\xA2\x77\x7C" \
        "\x46\x9D\x3A\xBD\x73\xC0\x64\x70\x84\x2B\xD7\x11\xF3\x43\xB5\xFB" \
        "\xE9\x0B\xB3\x4B\x2B\x80\x98\xEF\xDC\xDA\x46\xD6\xEC\xBD\x0B\x4D" \
        "\x64\x20\xF7\x17\x17\x33\x75\xB5\x30\x26\xDD\x0A\xA0\x99\x23\x11" \
        "\xF1\xDE\x80\xB0\xD6\xB0\xB7\x5A\xA9\xBD\x6D\x29\x42\x74\x75\x73" \
        "\xC5\x27"

/** Screen mode 720x400 (at 70 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_720_400_70_24_0 "" \
        "\x9C\xC5\x1C\x02\x4F\xA6\x97\x4D\xD7\x04\xE5\x2A\xDC\x78\x4F\x24"

/** Mode data.
 */
#define DLO_MODE_DATA_720_400_70_24_0 "" \
        "\xC4\x2C\x84\x13\xDD\xB8\x82\xCB\x62\xA3\x40\xFA\x41\x8B\x5E\x1B" \
        "\x74\x02\x11\xDD\x90\xB8\x14\x51\xE1\x28\x7E\x3B\x42\x6A\x6B\x9C" \
        "\x7E\x4B\xFC\x8A\x19\x8D\xF4\x23\xB4\x98\x96\x55\x68\x8F\xDA\x88" \
        "\x9C\xE0\x20\x5D\xB5\x9F\x34\x9B\xB2\xCF\x10\x6B\x2D\x66\x63\x0B" \
        "\xDE\x3C\xC4\x90\x3C\xB4\x23\xF9\x5C\x93\x6F\x43\x29\x20\x54\x90" \
        "\x94\xB8\x78\xED\x33\xC7\xDD\x8B\xAA\xD0\xF6\xDC\x78\xEB\x50\x23" \
        "\x83\x00\x6F\x42\x83\x58\xD7\x1C\xA0\xDF\x41\x9E\x69\xB5\xA4\x3A" \
        "\x31\x79\xCB\xDF\x59\x5E\x76\xFB\x89\x32\x2B\x00\xE5\xDF\x16\x52" \
        "\x4F\xE1\xCC\xB7\xE3\xED\xEE\xC1\x5E\x56\xDF\x4E\x35\x1C\x14\x99" \
        "\xDF\x6F"

/** Screen mode 720x400 (at 85 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_720_400_85_24_0 "" \
        "\x4E\xEB\x46\x9D\x91\xDD\xEA\x68\xE2\xCF\x92\xBE\x47\xE1\xE2\x7C"

/** Mode data.
 */
#define DLO_MODE_DATA_720_400_85_24_0 "" \
        "\xE6\x20\x16\xD8\xFE\x44\x88\xBF\x44\x7B\xBE\x98\xA3\xC9\x56\x4E" \
        "\xBC\x98\x6B\x8B\xCD\x50\xB0\xB8\x4D\x95\x32\xF7\xB8\xDE\x45\x3D" \
        "\x87\xD4\x13\xBF\x42\xE6\xC5\x86\x4E\x9D\xD7\x11\xD6\x1F\x1E\x11" \
        "\x55\x5E\xD5\x2E\xFE\x02\xD4\xB0\xDC\x10\xA0\x45\x44\x00\x2E\x0B" \
        "\x4C\x7B\x47\x1B\x06\x16\x20\x18\x6D\xED\x65\xC9\xC0\x11\xDD\x76" \
        "\x78\x8E\x2D\x5D\xD7\x5E\xF7\x6E\x17\x75\x14\x74\xA8\x4D\xFC\x6F" \
        "\x47\x50\x69\x15\x01\x3D\x92\xF5\x1D\xF6\x03\x4A\x89\xC5\x2D\x1E" \
        "\x3A\xBB\x25\x83\x3A\xFD\x72\xBD\xA2\x96\x61\x84\x45\x5F\x19\x21" \
        "\xB5\xBC\x3A\xF4\x7E\xFA\xBF\x0A\x5E\x82\xC8\xF6\x26\x4D\xA4\x06" \
        "\xD9\x97"

/** Screen mode 800x480 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_800_480_60_24_0 "" \
        "\x7A\x12\x36\x0B\xEF\x21\x74\xD1\xF0\x06\x8F\x38\xE8\x71\xB4\xCE"

/** Mode data.
 */
#define DLO_MODE_DATA_800_480_60_24_0 "" \
        "\x78\x67\x19\xF3\xB3\xD6\x5D\x7B\x4C\xCA\x26\x78\x41\x19\x19\xAC" \
        "\xFF\x38\xB3\x10\x71\x89\x6A\xEC\xA8\xC1\x4F\x1F\x77\x86\x5D\x7E" \
        "\xCE\xAF\x65\x7D\xFC\x30\x51\x67\x1F\x48\x30\x8E\x7A\x4B\x8A\xD4" \
        "\xCB\x62\x45\x58\x5C\x22\x1D\x56\x6E\x2F\x60\xE2\x06\x6D\xA1\xE3" \
        "\x82\x5F\x67\x95\x7A\x9F\x87\x43\xD8\x33\xEF\x0B\x5A\xDA\x09\x4F" \
        "\xD7\x25\x6F\xBC\xF8\xC7\x09\x9C\x12\xC3\xA7\x6F\xE7\xED\xA8\x70" \
        "\x8C\xB9\x65\x53\xDD\xA6\x7D\xDE\xD9\x4F\xDD\xD4\x6F\x28\xD6\x14" \
        "\xDC\x2D\x41\x53\x33\xD9\x0A\x86\x11\x3C\x41\x5A\x56\x48\xF9\x85" \
        "\x2B\x2F\x22\x66\x20\x39\xDA\xA1\x50\xCB\x5A\x58\x7D\x97\xFA\x2C" \
        "\x64\x9D"

/** Screen mode 800x600 (at 56 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_800_600_56_24_0 "" \
        "\x19\xFC\x59\x09\x1D\xCD\xDA\x0D\xD3\x6A\x45\xBB\xDB\xF9\x8A\x57"

/** Mode data.
 */
#define DLO_MODE_DATA_800_600_56_24_0 "" \
        "\xD7\x63\xD3\x78\x60\xAC\x0F\xFE\xF5\x0A\xC7\xF0\x17\x0E\x9C\x6C" \
        "\x47\xFF\xF5\x36\xFD\xDE\x22\xE6\xA1\x80\x4F\x0D\x90\x72\xE6\xAD" \
        "\x49\x95\x4B\xD4\x6A\x31\xF9\x6E\x6F\x6E\x93\xF5\x44\x46\x7A\x84" \
        "\xD4\x10\x51\x7A\xE1\xDF\x48\x32\x9D\x0E\x59\xD9\x0B\x57\x45\x7C" \
        "\x58\xF6\x72\x8D\xAF\x91\x7F\xBE\xE8\x2F\x3A\x7F\x3D\xF5\xD6\x39" \
        "\x1E\xB8\xB2\x1D\x7F\x6F\x60\xBC\x0F\xF8\xAD\x43\x76\xFA\x75\x19" \
        "\xFB\x5D\xA4\xCD\xF7\x38\x5F\x11\xD4\x56\x11\x9E\x79\xB4\x4A\x4D" \
        "\x7A\xC7\x03\xAC\xFB\xB4\x4F\x98\x93\xB0\xDC\xE2\x8F\xE9\x05\xB2" \
        "\x90\xE0\x8D\x41\xC2\xAF\xC5\xEE\x8B\x00\x90\x7C\x26\x87\x54\x4A" \
        "\x71\x2A"

/** Screen mode 800x600 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_800_600_60_24_0 "" \
        "\x02\x18\xF5\x1F\xE5\xCF\x2C\xB9\x39\x72\x74\x15\x6B\xFE\x6C\x71"

/** Mode data.
 */
#define DLO_MODE_DATA_800_600_60_24_0 "" \
        "\xC0\x2C\xFF\x8C\x0F\x57\x30\xD7\x8A\x19\xCE\xB2\x47\x2B\xE3\xFA" \
        "\xEE\x8F\x95\xF7\xA7\x78\x44\x39\x29\x78\xF4\x0C\xB7\x3F\xF8\xD4" \
        "\xFA\xAD\x2C\xB8\xF2\x1C\xBB\x16\x10\xCC\xF5\xD5\x53\x6C\x2E\x4E" \
        "\xEF\xB5\xF5\x81\x0A\xE1\x8F\x32\xC5\xB9\x96\xAB\x8C\xC2\xE3\xA7" \
        "\x32\x14\x76\xD5\x63\xC1\x8E\xD6\xCF\x95\x1B\x0C\x51\xA9\x88\xEB" \
        "\xF3\x89\x40\xB7\x41\xB6\x87\x10\x03\xDB\x09\xFE\xCD\xFF\x2A\x7C" \
        "\xB1\x76\x8C\x27\x04\xA8\x09\x3B\x9E\x63\xDE\xE0\x31\xC8\x9B\x5E" \
        "\x1E\x51\x5A\xB3\x1B\xE7\xEE\xAE\x54\x47\xBB\xF0\x9F\xAE\xBB\xF6" \
        "\x43\x35\x57\xAE\x87\x8C\x88\x8B\x61\x61\x47\xA9\x87\xF7\xC3\x86" \
        "\x8E\x53"

/** Screen mode 800x600 (at 72 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_800_600_72_24_0 "" \
        "\x81\x59\xC0\x67\x29\xEC\x20\x62\x5E\x94\x77\xCA\x93\xE3\x3B\xA5"

/** Mode data.
 */
#define DLO_MODE_DATA_800_600_72_24_0 "" \
        "\x3B\xD9\x26\xBF\xB4\xE3\x00\x22\x87\x3D\xCD\xDE\x26\x6E\x71\x13" \
        "\x15\x22\xFB\xA0\x3F\x4B\xE1\x33\xED\x36\x15\x71\x8E\xB6\x3A\xE5" \
        "\x69\x27\xF8\x8E\xBA\x43\x42\xC3\xB8\x6F\x25\xCD\xC0\xDB\x35\xE6" \
        "\xD0\x33\x02\xF8\xFF\x05\x73\x60\x06\x50\x6D\xB0\xF5\x86\x68\xC3" \
        "\x27\xD8\xB4\x63\x88\x6D\x0E\x55\x1C\x18\x76\xDF\x37\x0D\x50\x62" \
        "\xD0\x82\x75\x66\xB8\x0A\x40\x2D\x94\x85\xB1\x04\x44\x1E\xD1\xCA" \
        "\xF7\x97\xD8\x21\x28\xB5\xBE\x91\xC5\xC2\x1F\x48\x63\x70\xED\x4F" \
        "\x88\x9A\x02\xD0\xC3\x7C\x7A\x6A\x42\x11\xD7\xEA\x91\xF9\xCE\xAC" \
        "\xA3\x03\x8E\xBE\x14\x25\x74\x4B\xE5\x0B\x37\xEA\x5C\xB0\xA9\xD5" \
        "\xE5\x95"

/** Screen mode 800x600 (at 75 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_800_600_75_24_0 "" \
        "\x3F\xDB\xEE\x68\xC7\x0E\xCA\x26\xA3\x42\xF0\x36\x25\x2B\xDB\x48"

/** Mode data.
 */
#define DLO_MODE_DATA_800_600_75_24_0 "" \
        "\xB5\x2E\xA8\x75\xF5\xC0\x36\xD8\xBF\xB3\xA8\x4F\x6F\xA4\x68\x06" \
        "\xEC\xFB\x44\x53\xFC\x4B\xC2\x44\xF0\xFA\x20\x47\xC0\xC5\xDE\xB1" \
        "\x6B\xDF\x89\x24\xD1\xA6\xE1\x86\xAE\x7F\x19\xA5\x56\xE7\x52\xBC" \
        "\xD7\xCC\xAF\xED\x9C\x4F\xAF\x77\x49\x7C\x99\xA9\x0E\xB9\x41\xAE" \
        "\x34\xD1\xB3\x33\xAD\x12\x91\xFC\x6C\x78\x85\xD5\x91\x6B\xB2\x1E" \
        "\x28\x39\x15\x41\xF5\x14\x35\x9E\xAC\xE2\x0C\x9C\x69\x5C\x76\x86" \
        "\x55\xF1\x41\x36\x02\xE1\x6C\xAA\x60\x66\xE4\x1F\x5D\xB7\xED\x16" \
        "\x3F\x55\x21\x57\x56\xDA\xB3\x00\xA0\x15\x8F\x26\xC1\x08\xA6\x8B" \
        "\x19\x22\x5E\xD2\x48\x7B\x18\xA6\xD4\xF9\x9D\xD4\x85\x57\x05\xD9" \
        "\xC6\x31"

/** Screen mode 800x600 (at 85 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_800_600_85_24_0 "" \
        "\x51\x11\x2B\x19\x1F\xF6\x3F\xC2\x38\x2F\xF8\x5D\x5A\xD3\xA6\x0D"

/** Mode data.
 */
#define DLO_MODE_DATA_800_600_85_24_0 "" \
        "\x87\x1E\x1B\x28\xEA\x5B\xFA\xAB\x66\xC6\x43\x53\xC7\x3A\x77\xF4" \
        "\x08\x95\x51\x50\x9E\x8A\x19\x38\x55\x40\x3C\x31\x45\xEE\x59\xBA" \
        "\xF2\xB3\x3C\xFD\xEC\x2F\x58\xED\xEF\x1A\x7F\xDB\xF6\x02\x25\xCA" \
        "\x79\xCF\xC2\x7C\x95\x75\x30\xBB\x41\x3A\x3E\x27\x33\x0D\x37\x48" \
        "\x02\x6D\xDB\x86\x50\xB0\xCA\xAA\x92\x25\x08\xB7\xDE\x93\x51\x87" \
        "\xC0\x57\x8C\xA1\xE0\xE5\x38\xC1\x30\x97\x82\x6B\xE7\x96\x37\xA5" \
        "\x63\x0B\x79\xB8\x67\x28\x25\x60\x79\xF2\x1D\x98\xE2\xAC\x2E\x1B" \
        "\x1C\x7D\x3C\x9B\x63\x53\xFD\x73\x44\xAF\x8D\xDE\xB0\x98\xCD\x6E" \
        "\xBA\x60\x48\xC2\x74\x5A\x8E\x9A\xB3\x3F\x9A\x2B\x28\x42\x66\x93" \
        "\x1A\x26"

/** Screen mode 848x480 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_848_480_60_24_0 "" \
        "\x06\x53\xBC\x25\x49\xFB\xE8\x81\x2A\xE0\xDF\x85\xB4\x85\x92\x4C"

/** Mode data.
 */
#define DLO_MODE_DATA_848_480_60_24_0 "" \
        "\x27\x9E\x14\x5B\x10\x06\x0C\xE8\xFB\xD1\x12\x84\xC7\xEE\x60\x2E" \
        "\x1B\xC4\xE1\xE0\x98\x72\x13\xE1\xEC\x4A\x2D\xC2\xBB\x44\xEB\xCC" \
        "\x62\x2F\xE6\xC1\x71\x5D\x71\xD9\xBB\x90\xF3\xCC\x71\x7E\x5B\x71" \
        "\x77\xA5\x78\xCF\x02\x9A\xE7\xDF\x8F\xD4\xEE\xCF\xE7\x39\xA7\x75" \
        "\x9F\xE8\xCD\xCE\xDB\x5E\x7F\x61\x60\x45\xC6\x97\x91\x82\x6A\xFD" \
        "\x4C\xB1\xAB\xAA\xAE\xAB\x13\x92\x45\xB6\xFD\x8F\xD1\x34\xB8\x34" \
        "\x25\x45\xA5\xD7\xB7\xD6\x3E\x05\x9E\x25\x8E\xC5\xA9\xA3\x89\xC7" \
        "\xF9\x98\x2E\xB6\xEB\x04\xCE\x79\x9F\x01\x3F\x3C\xBF\xD6\xF8\xDA" \
        "\x3B\xFA\xDB\xA1\x78\xD6\xA2\x3D\xF4\xD9\x69\x37\xDE\x1F\x1C\x70" \
        "\xF0\x01"

/** Screen mode 1024x768 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1024_768_60_24_0 "" \
        "\xB6\xF8\xFC\x00\xF3\xE4\x81\x1E\xC5\x60\xA3\x79\xE5\x35\xC5\x15"

/** Mode data.
 */
#define DLO_MODE_DATA_1024_768_60_24_0 "" \
        "\xDD\x2A\x3A\x49\xE9\x99\xE3\xC8\xA0\xBA\x23\x3A\x3D\xEB\x21\xE4" \
        "\xA5\x54\x25\x0D\x51\xCC\xE6\x52\xA7\xD7\xCD\xFA\xD5\x9B\x5B\x41" \
        "\x0B\x49\xAB\xC6\xE3\x1A\xF2\x87\x81\x32\xF0\x3E\x40\x00\x51\x40" \
        "\x9E\x94\xF1\x22\xEE\xAC\xB2\xA2\x6B\x4D\xC4\x41\x5A\x9C\x45\x62" \
        "\x4F\x4E\x61\xDB\x1F\x0E\x79\x66\xE2\x20\x83\x9E\x2C\xAB\x28\x38" \
        "\xAC\xC1\x22\x81\xA5\x69\xFD\xFB\x26\x15\xF9\xC9\xFA\x90\xF2\x66" \
        "\x85\xC5\xAA\xA6\x4D\x8B\xC8\xA6\x03\x32\xDF\x98\xA9\x77\x9E\x57" \
        "\xEA\xC9\x9E\x29\xED\xFC\xC4\x78\x26\x0B\x2E\xC2\x41\x7C\x4A\xA3" \
        "\xAB\x66\x01\xA0\xE5\xA4\x8B\x80\xA0\x53\xE5\x5D\x59\x63\x62\xE8" \
        "\xFE\x6B"

/** Screen mode 1024x768 (at 70 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1024_768_70_24_0 "" \
        "\x2B\x71\x0C\x1F\x55\x8E\x3D\x1A\xEE\xE0\x93\xD4\x15\x58\xE9\x00"

/** Mode data.
 */
#define DLO_MODE_DATA_1024_768_70_24_0 "" \
        "\xE9\x15\xBC\xBE\x90\x6C\x07\x34\xF2\x79\xCA\x43\x44\x92\x65\x9A" \
        "\xC7\x41\xE9\x56\xE7\x27\x4A\x9C\x24\x04\x40\x97\xF5\xFD\xFF\x99" \
        "\xC8\x6A\xA0\xF3\x32\xE3\x4E\x40\xBC\xA5\xAE\x37\xBA\x89\xB0\xDD" \
        "\x10\xD2\x10\x76\xE8\x80\xAF\x15\xC1\x16\x65\x80\xA2\xCE\xFD\x14" \
        "\x66\xD8\xAA\x83\x7C\xD6\xE2\xF2\x26\x36\xD5\xF2\x36\xA5\x7F\x4D" \
        "\xF6\x21\x14\x58\xB5\xFA\x54\x07\xE6\x91\x93\xB9\xB9\x4B\xB5\x0C" \
        "\xD6\xAE\x6C\x2D\x12\x51\xED\x13\x6C\xD7\x07\x15\x6D\x88\x10\x62" \
        "\x94\x4F\x77\xB7\xEC\xA3\xD4\xAD\xDF\xCC\x76\x2D\x39\x90\xEE\xB1" \
        "\x98\x09\xA2\x28\x03\xF8\x1F\x1C\x01\xCA\xAA\xC0\xC2\x92\xDE\xD8" \
        "\xFC\x59"

/** Screen mode 1024x768 (at 75 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1024_768_75_24_0 "" \
        "\x10\xFC\xF8\x65\x8A\x35\x80\x78\x15\x13\x4C\x2A\x6C\x35\x2B\x74"

/** Mode data.
 */
#define DLO_MODE_DATA_1024_768_75_24_0 "" \
        "\xE6\xB2\x51\x5B\x75\x7E\x2A\xBC\xA5\x4A\xC0\xC0\xEA\x20\x67\xCC" \
        "\x89\x74\x5D\x3B\x7D\xB4\x29\x82\xA8\x28\x97\x86\x13\x0E\xE3\xCC" \
        "\x95\x10\x43\x65\x15\x64\xA0\xF9\xA7\x20\xFE\x61\x0A\xFF\x6E\xEC" \
        "\x7E\x55\x17\x4F\xA2\x61\x77\x7E\x9A\x3B\x04\xFF\xC0\xA0\xAE\x82" \
        "\x3F\x81\x1A\xEB\x45\x8B\x37\x99\xA6\xED\xB1\x66\x78\x02\x8C\xB3" \
        "\xE7\x88\xD5\x57\xD8\xE7\xFD\x7F\x49\x8B\xBE\xC6\xD1\xDD\x60\xB5" \
        "\x41\xCD\x1B\x3E\xEC\x69\x18\xE9\x77\x71\x7F\x0E\x11\xCB\x47\x82" \
        "\x89\x2C\xCA\x54\x5E\x33\x9C\x60\x61\x42\x55\xB4\x4B\xC2\x9C\x37" \
        "\xFD\x37\xD4\x47\xC5\x08\xDF\x14\xCB\xCD\xD9\xCD\xA0\xC1\x42\x21" \
        "\xD2\xD9"

/** Screen mode 1024x768 (at 85 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1024_768_85_24_0 "" \
        "\x02\x10\x92\x8C\x45\x12\x05\x5A\x25\x51\x85\x91\x87\xB0\x05\x8C"

/** Mode data.
 */
#define DLO_MODE_DATA_1024_768_85_24_0 "" \
        "\xA7\xC9\xD0\x6E\x6E\x77\xDA\xD3\x25\xEA\x3B\xA4\x4B\x35\x88\x4E" \
        "\x22\x53\xC4\x82\xB0\x14\x40\x54\x8A\xB6\x42\xF2\xBB\xC8\x4B\x24" \
        "\x52\xF9\xC3\x37\xBE\xCF\x99\x01\x5A\x56\xB2\xA8\xE7\xF3\x53\x7B" \
        "\x37\x55\xFE\x97\xF3\x05\xFF\xC0\x71\x60\xBB\xD9\xCC\x49\xFA\x73" \
        "\x2C\x39\x72\x25\x27\xFB\x83\x7D\x44\x58\x86\x5D\x6F\xFC\xCF\xD4" \
        "\xCF\x7C\xC1\x33\x35\x21\x30\x70\xA8\x36\x60\xBB\xA8\xE2\x74\x05" \
        "\xBB\xB3\xC5\x60\xBD\x4B\xC0\x6C\x04\x41\xD2\xE6\xFA\xEB\x67\x02" \
        "\x6A\x77\x82\x4D\xF7\x05\xAC\xA8\xA3\x8F\x21\xCA\x24\xF3\x53\x52" \
        "\x2A\x99\xEA\xE5\xBD\x76\x3C\x85\x73\x98\xD8\x46\xA7\xAC\xA8\xB7" \
        "\x3A\xA9"

/** Screen mode 1152x864 (at 75 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1152_864_75_24_0 "" \
        "\xAE\xFE\x44\xF3\x10\x49\x4E\x35\x9B\xD3\xC7\x22\x83\xCC\xAE\x40"

/** Mode data.
 */
#define DLO_MODE_DATA_1152_864_75_24_0 "" \
        "\x65\xB5\xCB\x8E\x46\x49\x3E\xFB\x60\x91\xC1\x32\x82\xD3\xCA\x2F" \
        "\x4A\x49\xB1\xA8\x17\xA1\x12\x37\xBB\x1C\x5F\x69\x41\xA8\x72\xB2" \
        "\xB8\x37\x9C\x7E\xE3\x5C\xA2\xD3\x19\x59\xE2\x75\xA7\xC9\x25\xBB" \
        "\x6E\x77\xD1\x2D\x25\xEA\x36\x43\x4B\x35\x87\xB3\x22\x53\xC9\xB5" \
        "\xB0\x14\x4B\x1D\x8A\xB6\x57\x78\xBB\xC8\x5C\x3B\x52\xF9\xD6\x3C" \
        "\xBE\xCF\x82\xCB\x5A\x56\xAF\x2E\xE7\xF3\x4C\x85\x37\x55\xE3\x91" \
        "\xF3\x05\xE4\x3C\x71\x60\xAE\xB6\xCC\x49\xEF\x6A\x2C\x39\x61\x75" \
        "\x27\xFB\xB0\x7D\x44\x58\xB3\x32\x6F\xFC\xF8\xBF\xCF\x7C\xFB\xCC" \
        "\x35\x21\x0E\x8B\xA8\x36\x5E\xC4\xA8\xE2\x7D\xFC\xBB\xB3\x2D\x9C" \
        "\xBD\xCB"

/** Screen mode 1280x768 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1280_768_60_24_0 "" \
        "\x73\x9D\x25\x83\xE6\x73\xB8\x81\x46\x7F\xA3\xC9\x4C\x52\x09\xB4"

/** Mode data.
 */
#define DLO_MODE_DATA_1280_768_60_24_0 "" \
        "\xB0\x52\xEB\x22\x12\xDD\x55\x65\x5C\x01\x38\xD9\xA2\x1A\xE6\x1F" \
        "\x75\x89\x16\x6E\x7A\x2E\xFC\x28\x9F\x3C\xD0\xE6\xC8\x0F\xD9\xCE" \
        "\x66\xBD\xDA\xE1\x28\x88\x61\x5B\xB2\x1B\x03\x5B\x3E\x37\xD7\x54" \
        "\xD8\xC4\xCA\xBC\x85\xBE\x2E\x50\xA2\x39\xC1\xB1\xB9\xBC\x92\xA9" \
        "\x09\xCA\x4D\xFA\x67\x4D\x55\x1E\x2D\xAC\x8C\xBB\x76\x81\xEE\xEE" \
        "\x14\xEF\xBC\xD8\x4D\xB6\x0B\xB0\x74\xEB\xDF\xDB\xF4\x30\xB8\xF2" \
        "\xBA\x97\x4A\x67\xAB\x3E\x84\x6B\xC6\x23\x2E\x3A\x69\x39\x04\x67" \
        "\x01\xAF\xEE\xE6\x96\xCC\x9E\xFF\x68\xF4\x6A\x0F\x73\x52\x1E\x0A" \
        "\x0F\x11\x4A\xE8\x12\x72\xF6\x0E\xA0\xE2\x8A\xC3\x1E\x6C\x49\xA5" \
        "\x6C\xBE"

/** Screen mode 1280x1024 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1280_1024_60_24_0 "" \
        "\x6A\xF0\x37\x50\x63\xEF\xD2\xA9\x6F\x75\x72\xBB\xC7\x7B\x6F\x1A"

/** Mode data.
 */
#define DLO_MODE_DATA_1280_1024_60_24_0 "" \
        "\x23\x4A\x78\x7C\xD1\xB8\x0E\x6B\x15\x93\x96\x77\x78\x44\xCC\x16" \
        "\x7F\xE3\xD7\x39\x3F\x2E\x99\xD2\xB9\x68\x8E\xC4\x1A\x9B\xF4\x35" \
        "\x61\xB5\x48\x5C\x94\xA6\x84\xB2\x88\x2B\x47\x84\x84\x73\x7F\x2C" \
        "\xD0\xC4\x3D\x5D\x20\x61\x4A\xB1\x73\x4C\xDD\x6A\xB4\xFD\xE9\x94" \
        "\x3C\xD1\x44\x0A\x08\xCD\xF5\xE5\xBD\x0D\x99\xCD\x9C\x2A\xC9\x06" \
        "\x1D\x22\x1C\xB1\x9A\x94\x95\x65\x3C\x43\x19\x73\x83\xF7\x51\x1F" \
        "\x5C\x3C\xE1\x59\xD5\xC3\xF2\x27\x28\xCE\x22\x7B\x2A\x70\x04\xE4" \
        "\xD9\xFE\x8A\x6E\x28\x27\xC5\x40\x4E\xF8\x83\x5B\x82\x41\xA6\x62" \
        "\xC1\x73\x3A\x5C\xF6\x90\x43\x39\xF2\xF5\x74\x80\x74\x44\xBD\xB1" \
        "\x08\x53"

/** Screen mode 1280x1024 (at 75 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1280_1024_75_24_0 "" \
        "\xDB\xCF\xE1\x3F\xBE\xB3\xE8\x2D\x29\x5B\xE8\xF0\xD6\x57\x0B\xFF"

/** Mode data.
 */
#define DLO_MODE_DATA_1280_1024_75_24_0 "" \
        "\xBA\x89\x45\x90\x10\xD2\x1B\x50\xE8\x80\xA2\xE9\xC1\x16\x6A\x6D" \
        "\xA2\xCE\xF0\xD4\x66\xD8\xA1\x18\x7C\xD6\xF7\xD8\x26\x36\xC2\x7E" \
        "\x36\xA5\x6A\x9A\xF6\x21\x0F\xF3\xB5\xFA\x49\x07\xE6\x91\x8C\x4B" \
        "\xB9\x4B\xA8\x0C\xD6\xAE\x77\xD1\x12\x51\xF8\x21\x6C\xD7\x12\xED" \
        "\x6D\x88\x03\x5D\x94\x4F\x44\xB7\xEC\xA3\xE1\x3F\xDF\xCC\x41\x85" \
        "\x39\x90\xD4\x4E\x98\x09\x9C\xD3\x03\xF8\x21\xE3\x01\xCA\xA3\x39" \
        "\xC2\x92\x36\x23\xFC\xD9\x99\x08\x7B\xC0\x9C\xCE\x21\xF4\xBA\xBE" \
        "\x22\x36\x9C\xB4\xE4\x4A\xFB\xC1\x1E\x9B\xAC\xFF\xB3\x5A\xD4\x0D" \
        "\x7C\x1C\x28\xBB\x8E\x8B\xD8\x8E\x1E\xFE\xEE\xD9\xE7\x04\x99\x20" \
        "\xE8\xB1"

/** Screen mode 1280x1024 (at 85 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1280_1024_85_24_0 "" \
        "\xE4\xE9\xAF\xA2\x9D\x98\xD0\xC6\xF3\xB8\xB6\xC9\x10\xC1\xC8\xA6"

/** Mode data.
 */
#define DLO_MODE_DATA_1280_1024_85_24_0 "" \
        "\x93\xB0\x06\xA2\x8F\xE9\x2C\xB3\x90\xE0\xA6\x66\xC2\xAF\xEC\x00" \
        "\x8B\x00\x8C\x0B\x26\x87\xAF\x8A\x71\xAA\x43\x0F\x64\xF4\xC5\xF3" \
        "\x04\x62\xE6\x7A\x36\xDE\xFA\x1A\x19\x93\x12\xD1\x0F\x74\x12\xAF" \
        "\x46\x2C\x4D\x23\x34\xCF\x57\x3B\x16\xFE\x0B\xDC\x42\xDB\x0C\x80" \
        "\x39\x44\xDF\x0C\x8B\x58\x28\xB3\x05\x00\x2F\xB9\xB8\xC0\xB6\xA1" \
        "\x3C\x38\x80\xA1\x6C\x45\x4F\xF1\xE6\xB2\xBB\xA4\x75\x7E\x3C\x44" \
        "\xA5\x4A\xD6\x28\xEA\x20\x7D\x78\x89\x74\x45\x97\x7D\xB4\x31\xB5" \
        "\xA8\x28\xB1\xB0\x13\x0E\xC1\xCC\x95\x10\x61\x62\x15\x64\x81\x4A" \
        "\xA7\x20\xDD\x3A\x0A\xFF\x4F\x39\x7E\x55\x03\xB0\xA2\x61\x84\x7E" \
        "\x9A\xBB"

/** Screen mode 1280x768 (at 75 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1280_768_75_24_0 "" \
        "\x87\x94\x88\x24\x2C\x58\xEA\x1F\x10\xA1\xE9\x20\x62\xB1\xC6\x43"

/** Mode data.
 */
#define DLO_MODE_DATA_1280_768_75_24_0 "" \
        "\x20\x5C\x76\xA7\x04\x95\xDE\x8B\xE9\xBA\xCA\x66\x6C\x8F\xA9\x5B" \
        "\x4E\x0F\x9A\xCA\x5D\x25\xB2\x6C\xB4\x6F\xA5\xE4\xB7\xEB\xEF\x58" \
        "\xE9\xFC\x9C\xD2\xF4\xE4\xB1\x47\xA9\xC6\xE4\xF6\xAD\xC6\x9C\x38" \
        "\x7F\x29\x2F\x59\x97\x93\xA6\x07\x91\x33\x1A\x1F\x0B\xBE\x9D\xE7" \
        "\x3C\x7E\xCC\x60\xF4\x2E\x59\x92\x01\x7B\xCB\xB2\x85\x9D\x18\xA7" \
        "\x6E\x0C\x56\xFF\xCA\x58\x32\xAB\xF1\xBB\xC7\x6B\x82\xEE\x11\x9C" \
        "\x3D\x90\xAB\x2D\x4A\xE6\x22\x30\xEB\x42\xA1\xA6\x07\x6A\x14\x4F" \
        "\x58\x1F\x86\xDF\xCB\x19\xF5\x7F\xB3\x90\x28\x41\xD4\xA1\x1C\x1B" \
        "\xA6\xD0\x45\x85\x0F\xDB\xBB\xA1\xBA\xCF\xF5\xAB\x88\xB9\xF6\x32" \
        "\x0F\xC9"

/** Screen mode 1280x768 (at 85 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1280_768_85_24_0 "" \
        "\x74\xE4\x58\xA1\x3C\x43\xC0\x4D\xE4\xA9\x6D\x46\x5B\x34\x89\xE5"

/** Mode data.
 */
#define DLO_MODE_DATA_1280_768_85_24_0 "" \
        "\x5B\xA6\xDC\x6E\xE2\xD7\xAD\xE3\xF3\xCF\x02\x6D\xD9\xDD\x83\xEB" \
        "\xE4\x12\x6B\xC6\x3D\x1C\x18\x54\x7A\x30\x1A\x0C\x24\xD0\x54\x05" \
        "\xE6\xAC\x4E\x76\xCE\x92\xA5\x1D\x8B\xE9\x5E\x53\x42\x0F\x1F\x9C" \
        "\x2A\x15\x6B\xB1\x8D\xA0\x3E\x8E\xBC\x0A\x22\xB2\x46\x6A\x18\x18" \
        "\xAC\xA4\x46\x5D\xF1\x37\x62\xE3\xB2\x38\x33\xFD\xF2\x02\x46\xF2" \
        "\xAB\x20\x68\x60\x7D\xCF\xA6\xE3\x47\x9A\x9B\xA7\xA9\x80\xAB\x54" \
        "\x35\xAD\x93\xFB\x98\xE0\x48\x7D\x67\x70\x91\x3B\x5A\x75\x8F\x97" \
        "\x2B\xC6\xF3\x34\x44\xB1\x6B\x60\x0B\x74\x46\x54\x94\xC3\xDD\xC0" \
        "\xDC\x75\xFF\x99\x10\x5E\x90\x26\xD8\x56\x99\x1E\x0E\x84\x7F\x8B" \
        "\x43\x88"

/** Screen mode 1280x800 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1280_800_60_24_0 "" \
        "\x59\xFF\xC3\x96\x42\x84\xE3\x26\x2D\x50\x6C\x88\x84\xF6\x6E\x2A"

/** Mode data.
 */
#define DLO_MODE_DATA_1280_800_60_24_0 "" \
        "\x55\x5E\x21\x5E\xFE\x02\xD8\x84\xDC\x10\xAC\xF6\x44\x00\x22\x46" \
        "\x4C\x7B\x4B\xCC\x06\x16\x34\xFC\x6D\xED\x71\x58\xC0\x11\xC9\xA4" \
        "\x78\x8E\x39\xC3\xD7\x5E\xEB\x67\x17\x75\x08\x14\xA8\x4D\xE0\x5C" \
        "\x47\x50\x75\x35\x01\x3D\x86\x42\x1D\xF6\x15\x09\x89\xC5\x3F\xFA" \
        "\x3A\xBB\x09\x86\x3A\xFD\x46\xB8\xA2\x96\x55\x2B\x45\x5F\x22\x94" \
        "\xB5\xBC\x03\x09\x7E\xFA\x80\x25\x5E\x82\xC2\x09\x26\x4D\x4D\x33" \
        "\xD9\x17\x66\x3C\x4C\xAF\x47\x81\x15\x47\x9B\x39\x6B\x15\x62\x30" \
        "\x79\x1B\xFD\x3B\x86\x24\xA8\xD1\x47\xC2\x1C\x97\x8A\x07\x01\x66" \
        "\xFC\xC7\x4C\xF9\xC0\x2C\x2B\x8C\x0F\x57\x2F\xD6\x8A\x19\x30\x6D" \
        "\x47\xAB"

/** Screen mode 1280x960 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1280_960_60_24_0 "" \
        "\x42\xAB\xE3\x84\x2F\xC6\xAA\x5D\x17\x17\xE5\x9B\x0D\x53\xC5\xA6"

/** Mode data.
 */
#define DLO_MODE_DATA_1280_960_60_24_0 "" \
        "\x3D\xAD\x8C\xC7\x3D\x3F\x34\x45\xB6\x05\x97\xE1\x57\x34\xEA\x4E" \
        "\x1E\xDD\xDA\x98\x2B\x31\xEB\xEF\x9B\xD5\x73\xB1\x7E\x68\xD5\xCC" \
        "\xD5\xB8\x72\xBD\xC7\x7C\x2D\x07\x90\xFE\x49\xD7\x79\x43\x63\x49" \
        "\xA5\xA3\x12\x82\x8E\xA8\xD7\x6C\xD2\xCB\x75\x03\x94\xE0\xD2\x9E" \
        "\x10\x40\x53\xD7\x63\xBA\x11\x24\x20\x27\x07\xE4\xEB\x27\xD0\x8A" \
        "\x53\x34\x80\x2D\xCC\x32\x7F\x27\xC3\x8B\x74\x36\x9D\x75\xDD\x82" \
        "\xE4\xE5\x40\xA2\xE2\x78\x3D\x48\x0F\x2C\xB4\x64\x65\xAB\xCF\x2E" \
        "\xFD\xA5\x9A\xC0\x4E\x32\x72\x1D\x2A\xFC\x9D\xC7\xE9\x28\xA5\x57" \
        "\xE7\xB5\x23\x44\xAF\x3E\xCC\xF4\x14\xCC\x98\x3A\x81\x83\x69\xFE" \
        "\x07\x8F"

/** Screen mode 1280x960 (at 85 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1280_960_85_24_0 "" \
        "\xF6\x75\x37\x25\x3C\xE1\x82\x53\xF8\x68\xEE\x05\xBB\xB4\xAB\xBC"

/** Mode data.
 */
#define DLO_MODE_DATA_1280_960_85_24_0 "" \
        "\x58\x1F\x5A\xDF\xCB\x19\xD1\x74\xB3\x90\x0C\x65\xD4\xA1\x37\xD5" \
        "\xA6\xD0\x6C\xF7\x0F\xDB\x94\x9E\xBA\xCF\xEF\x01\x88\xB9\x0F\x2B" \
        "\x0F\x49\xD0\x81\x31\xF5\x40\x7E\x69\x88\x7E\x59\x46\xA0\xEC\xCF" \
        "\x04\x19\x75\x02\xD9\x6C\xE2\x12\xA3\x1D\x4E\x73\xAF\xC9\xD6\x37" \
        "\xCB\xA8\xB1\xEE\xF4\x9F\x36\x0C\x46\x74\xE0\x54\x17\x48\xDC\xCE" \
        "\xDF\x94\xF7\x1D\x1A\x17\x46\xE8\x51\x63\x7F\xD7\x5B\x34\x72\x14" \
        "\x69\xED\x18\xE2\x12\xFE\x65\xB9\x90\x34\xAB\xFE\xD1\xFE\x42\x25" \
        "\x8D\xF8\xA6\x73\x9F\x8D\x9E\xE1\x8F\x00\xD1\xE3\xF4\x68\x30\xA9" \
        "\x99\x10\xE2\xC7\x62\x54\x55\x6F\x9E\xEF\x7A\xD7\x01\x1E\x5D\x87" \
        "\xD1\x43"

/** Screen mode 1360x768 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1360_768_60_24_0 "" \
        "\x84\x36\xDB\xC0\x18\x5D\x13\x10\xC5\x02\x16\x81\xB6\xC1\x3D\xA6"

/** Mode data.
 */
#define DLO_MODE_DATA_1360_768_60_24_0 "" \
        "\x99\xDA\xC7\x8E\xCA\xE9\x49\xCB\xB6\xB4\xF8\x21\x10\x3B\xC1\x42" \
        "\x8C\x08\x1E\x52\x9A\xA9\x4A\x17\x4B\x9A\x07\x0A\xDE\xB0\x6D\x89" \
        "\x0C\x62\x11\x38\x93\x01\x9E\x33\xC8\xE6\x0E\x17\x02\x35\x69\x2B" \
        "\x73\x37\x44\xD3\x5B\x4F\xF7\xC0\x86\x5F\x1E\x9D\xA8\x70\x2B\x3C" \
        "\x30\x89\x7F\x65\x5C\x7A\xB6\x36\x4D\xA8\xE9\xFB\xCF\x07\x5F\x65" \
        "\xDA\x93\x2B\x98\x12\xB8\x39\xBD\x08\x5F\xB7\x99\x36\x37\x3C\x9E" \
        "\x7D\x1B\xB2\xA7\x54\xCB\x26\xC7\xAF\x78\xAC\x03\x8C\xA7\x89\xE4" \
        "\x66\x4A\xC1\x04\xF7\xEC\x74\xFB\xC7\x07\x9F\x81\x7F\x4C\x75\x5E" \
        "\xC3\xCD\x1B\xF7\x05\x1E\xF2\xB7\x03\x2C\x3C\xA4\x12\x9B\xFA\xA0" \
        "\xC4\xEA"

/** Screen mode 1366x768 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1366_768_60_24_0 "" \
        "\x6E\xF3\xC9\x86\x50\xDD\x97\x16\xDF\xAD\x97\x95\x6E\xD4\x3B\x46"

/** Mode data.
 */
#define DLO_MODE_DATA_1366_768_60_24_0 "" \
        "\x2A\x70\xE7\xB0\xD9\xFE\xA9\x6F\x28\x27\xE0\x53\x4E\xF8\xA4\x45" \
        "\x82\x41\x8C\x7D\xC1\x73\x14\xE9\xF6\x90\x6D\xAA\xF2\xF5\x6D\xE0" \
        "\x74\x44\x45\x0E\x08\xD3\x0A\x6A\x06\xE1\x06\x5B\xB2\x89\x47\x47" \
        "\xB5\x0D\x74\x4F\x39\xF5\xB3\xA5\xCC\x57\x1E\x01\x97\xD5\xF4\xE4" \
        "\x09\x58\x0A\x79\xEC\x77\xF7\x4B\xCC\x9D\xF2\xB1\x3F\x68\xDF\x67" \
        "\x21\x03\x8A\x8D\xFD\x52\x92\x9A\x91\x56\x7A\x3A\x5F\xE0\x1E\x6D" \
        "\xA8\x53\x1A\x61\xFC\xBC\xE1\x2E\x2F\x9E\x07\xFE\xB5\xD9\x74\x92" \
        "\x2A\xA4\x2C\x08\xCA\xAF\x3D\xFB\x2E\xDF\xCE\xE9\xF7\xF2\x9E\x05" \
        "\x7C\xEB\x17\x1E\x51\xEF\xE1\x09\x6B\xE2\x5E\xD4\xA6\x7F\x18\x15" \
        "\xF3\xB8"

/** Screen mode 1400x1050 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1400_1050_60_24_0 "" \
        "\x95\xCB\x91\xE5\xA8\x28\xFB\x87\xD5\x92\x1C\x44\x66\x57\x8A\x98"

/** Mode data.
 */
#define DLO_MODE_DATA_1400_1050_60_24_0 "" \
        "\xC6\x8C\x42\x4C\x95\xDA\xB4\x2F\xBD\xD9\x9E\xAD\x8F\x7B\x69\x15" \
        "\x1B\xDA\x06\x79\x23\x9E\x94\xF2\xC2\xE9\xBB\x34\x13\x6B\x9B\xB2" \
        "\xC1\x4E\xD8\x69\x81\x49\x6E\x64\xAF\xB2\x4E\x69\x24\x1A\xA8\xBB" \
        "\x4E\x11\x75\x38\xE6\xC9\x3D\xE9\x9A\xCC\x3B\xAA\x1F\xC4\x97\xD5" \
        "\x4A\x9D\xAA\xE7\x04\xF0\xB6\xD4\xBD\xE4\x41\xCF\xF8\xA2\x77\x0B" \
        "\x46\x9D\x3A\xBD\x73\xC0\x64\x76\x84\x2B\xD7\x11\xF3\x43\xB5\xF6" \
        "\xE9\x0B\xB3\x4E\x2B\x80\x98\x15\xDC\xDA\x46\xE8\xEC\xBD\x0B\x0E" \
        "\x64\x20\xF7\x17\x17\x33\x75\xBA\x30\x26\xDD\xFA\xA0\x99\x23\x11" \
        "\xF1\xDE\x80\xB7\xD6\xB0\xB7\xA2\xA9\xBD\x6D\x29\x42\x74\x75\x73" \
        "\xC5\x27"

/** Screen mode 1400x1050 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1400_1050_60_24_1 "" \
        "\xCB\xA2\x00\x73\xCB\xFC\xFB\xA0\x8E\x17\xE4\xF5\x6F\x6F\x8D\x1D"

/** Mode data.
 */
#define DLO_MODE_DATA_1400_1050_60_24_1 "" \
        "\xDA\x01\x80\xE4\x99\x82\x8F\x40\xE9\x6E\xDD\xA6\x7F\xDE\x19\xFC" \
        "\x48\xF7\x90\x61\xE4\x2F\xA3\x72\x4A\xC5\x17\xBE\x27\x77\x35\x6A" \
        "\x74\x8E\xB5\x45\xA0\x6E\x3D\x58\x2E\xBA\x9A\xB6\xA3\xAC\x26\xD4" \
        "\xE8\xC6\xF8\xE3\x59\x7D\x76\x1C\x45\x07\x8A\x82\x96\x3B\x8B\x45" \
        "\xB7\x90\x79\xDB\x06\x4E\x97\x7F\x4E\x6A\xF0\xE7\x09\x7B\x3F\x05" \
        "\x20\x42\x7D\xAC\xBF\x79\x4D\x42\xC7\x19\x48\x2A\xC4\xA0\xCD\x9B" \
        "\xED\x6E\xB0\xF7\xAD\x31\xB1\xDB\xA0\x4D\x06\x41\xE2\x8F\x06\x63" \
        "\xD0\x48\xB5\xD5\x10\xB7\x47\x7D\xBC\xDE\x1D\x05\x55\x3B\x8F\x78" \
        "\xAA\x5C\x69\x52\x48\x3D\x48\xC5\x4C\x92\x8F\x48\x62\x9E\x71\xDC" \
        "\x36\xD2"

/** Screen mode 1400x1050 (at 75 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1400_1050_75_24_0 "" \
        "\x8E\x2F\xD0\x59\x2B\xCB\xFA\xB9\xE2\xDE\xAE\x51\x4D\x3C\x6E\x4D"

/** Mode data.
 */
#define DLO_MODE_DATA_1400_1050_75_24_0 "" \
        "\x25\xF4\x22\x48\xF0\xD9\x0D\xA9\x0C\xF0\x50\x5D\x18\x3B\x36\x2D" \
        "\x29\xD7\x7A\x1D\x4B\xDC\x56\xA2\x46\xDB\x7C\x33\xEB\xAB\x64\xBB" \
        "\x63\xE2\xB1\x4C\x03\xA0\x8B\xBB\x22\x4D\x29\x10\x0B\xF8\xC9\x3F" \
        "\xA4\x15\xDA\xCB\x13\xE7\x31\xF7\xF1\x98\xF7\x76\x4E\xDB\x80\xB9" \
        "\x4E\x74\x09\x29\xB2\x97\xBA\x23\x0E\xE1\xE9\x69\x17\x56\x3B\xD0" \
        "\x64\x78\x70\x27\x34\xB4\xD0\xE9\xF9\x4C\x0F\xF1\xF8\x55\x4C\x12" \
        "\x99\xF9\x07\x97\x06\xDC\xD8\x9E\xC5\x50\x58\x3B\xE8\x4A\x4F\x12" \
        "\x69\xAB\x7C\xDA\x8A\x95\x4B\xEF\x77\xFD\xE1\x0F\x21\x1D\x57\x86" \
        "\x46\xBE\x2B\x5A\xBF\xF5\xD2\xBF\xF7\xCF\x67\xEC\x0B\x32\xCC\x90" \
        "\x0C\x28"

/** Screen mode 1400x1050 (at 85 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1400_1050_85_24_0 "" \
        "\x66\xC2\x92\x91\x8D\x8C\x4A\x6F\x6A\xF9\xC1\xB8\x35\x2F\x05\xD7"

/** Mode data.
 */
#define DLO_MODE_DATA_1400_1050_85_24_0 "" \
        "\x73\x98\x38\x46\xA7\xAC\x57\x49\x3A\x29\x40\xA6\xB1\xC7\xF6\xC8" \
        "\x43\xA7\x39\x93\x0C\xB6\x05\xD3\x80\x50\x23\x08\xCE\x1E\x0B\x6B" \
        "\xBB\x3F\x75\xCE\x8D\x9D\xF5\x67\xCB\xD3\x28\x29\x1B\x2D\x30\x40" \
        "\xFC\xFA\xA2\x75\xB7\xF5\x02\xC2\x52\x10\x11\x2A\xDA\x47\x21\x20" \
        "\x01\xE9\x92\xD8\x0E\xA7\xB8\x11\x8F\x3D\x2A\xDB\x83\xB1\x05\x48" \
        "\xC4\x57\xF7\x3E\x32\x0A\x8A\xDD\xD8\x2D\x0C\x33\xE1\x36\x8A\x6E" \
        "\xF9\x86\xFD\x46\x50\xE8\x75\x5F\xB1\xA2\x97\xA1\x17\xF9\xBD\x70" \
        "\x98\x9B\xEC\xAF\x88\xC2\xB2\x15\xE0\xFB\xEE\x3A\x8B\x7B\x39\xAE" \
        "\xC9\x35\x9D\x58\xCB\x24\x35\xE4\xC4\x49\x1C\x35\x89\xE6\xE6\xE7" \
        "\xF6\x0E"

/* DL160 modes... */

/** Screen mode 1600x1200 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1600_1200_60_24_0 "" \
        "\x3C\x79\x81\x0F\xF2\xAB\x85\xC7\x3A\xE8\xEB\xCB\xF3\x32\x12\x9C"

/** Mode data.
 */
#define DLO_MODE_DATA_1600_1200_60_24_0 "" \
        "\x85\x2C\x9A\xF4\x29\x03\x6E\x4C\x58\x8D\xE3\x93\x40\x23\x71\xD2" \
        "\x52\xA1\x70\x77\x9D\x48\x00\xDC\x93\x3C\x5C\x80\xBF\x3F\x0F\xF8" \
        "\x5F\x72\x48\x38\x23\x69\xA7\x4A\x1D\x8D\x8E\x55\x66\x77\x27\xBF" \
        "\x80\x35\x55\x7A\x9A\x40\x9A\xDD\x2F\x12\xB1\xFD\x85\x0F\x43\x23" \
        "\xE5\x36\xE8\x05\x2B\x69\x48\x1E\xB8\x52\xF2\xFF\xB7\x02\x23\x0A" \
        "\x8D\x74\x36\xFB\xAF\x5B\x8B\x2D\x40\x92\x09\x17\x15\xAE\x4E\xFF" \
        "\x0F\x9D\xD7\x9E\x22\xA4\xE0\x87\x6F\x70\x66\x58\xFF\xAA\xEB\x8B" \
        "\xFA\xB3\xEF\x84\x49\xF0\x10\xE7\x3E\x6F\x4F\x24\xFB\x43\x7D\x3B" \
        "\x4C\xD4\xEA\x75\xFA\xF5\xB7\xFF\xD1\x9B\x39\x77\xD9\xA6\xE1\x5E" \
        "\x0B\x20"

/** Screen mode 1920x1080 (at 60 Hz, 24 bpp).
 */
#define DLO_MODE_ENABLE_1920_1080_60_24_0 "" \
        "\xC1\xCA\xC3\xB3\x75\x48\x7A\xAF\x30\x65\x7B\x24\x97\x8D\xC0\x64"

/** Mode data.
 */
#define DLO_MODE_DATA_1920_1080_60_24_0 "" \
        "\x0D\x58\x81\xE3\x3E\x98\x55\x00\x24\x27\x6C\x99\x39\xC8\x72\xD8" \
        "\xBB\x8E\x1E\xA2\xCA\x92\xD2\xAB\x59\x06\xE0\x65\xAA\xB5\x9D\xAC" \
        "\x2C\xB5\xDA\x17\x17\x2D\xBE\x19\x8B\xCA\x76\x3D\x8E\x3A\x96\x8F" \
        "\x59\xF1\xD1\xA6\x75\xD1\xAE\xB7\x59\xA9\x60\xA4\x56\x56\x39\x8E" \
        "\x90\xC3\x80\x58\x0E\x9A\x77\x00\xF8\xE4\x24\x74\xDE\xF6\x29\x34" \
        "\x94\x09\x17\x73\x74\xC8\xF6\xC0\x38\x05\x32\xD7\xC9\x73\xF1\x99" \
        "\x53\x4F\x1B\x04\x23\x80\x6F\x08\x79\x05\x22\x2F\x3D\xC8\x17\x9D" \
        "\x69\x61\x8C\x96\x22\x28\x7C\x4F\x5F\xA6\x7D\xF1\x30\x38\x36\xFE" \
        "\x1B\x75\xA7\x2C\xDF\x7D\x17\x33\x7E\x9F\xF3\xFC\x0A\xDC\xB3\xDB" \
        "\xB2\xE0"

/** Data to send after a mode change.
 */
#define DLO_MODE_POSTAMBLE "\x57\xCD\xDC\xA7\x1C\x88\x5E\x15\x60\xFE\xC6\x97\x16\x3D\x47\xF2"

/** Number of entries in the @a dlo_mode_data array.
 */
#define DLO_MODE_DATA_NUM (35u)

/** Lowest mode number supported by the DL120.
 */
#define DLO_DL120_MODES (2u)


#endif
