/*
Copyright 2024 The KEDA Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/kedacore/keda/v2/apis/keda/v1alpha1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// ScaledJobLister helps list ScaledJobs.
// All objects returned here must be treated as read-only.
type ScaledJobLister interface {
	// List lists all ScaledJobs in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.ScaledJob, err error)
	// ScaledJobs returns an object that can list and get ScaledJobs.
	ScaledJobs(namespace string) ScaledJobNamespaceLister
	ScaledJobListerExpansion
}

// scaledJobLister implements the ScaledJobLister interface.
type scaledJobLister struct {
	listers.ResourceIndexer[*v1alpha1.ScaledJob]
}

// NewScaledJobLister returns a new ScaledJobLister.
func NewScaledJobLister(indexer cache.Indexer) ScaledJobLister {
	return &scaledJobLister{listers.New[*v1alpha1.ScaledJob](indexer, v1alpha1.Resource("scaledjob"))}
}

// ScaledJobs returns an object that can list and get ScaledJobs.
func (s *scaledJobLister) ScaledJobs(namespace string) ScaledJobNamespaceLister {
	return scaledJobNamespaceLister{listers.NewNamespaced[*v1alpha1.ScaledJob](s.ResourceIndexer, namespace)}
}

// ScaledJobNamespaceLister helps list and get ScaledJobs.
// All objects returned here must be treated as read-only.
type ScaledJobNamespaceLister interface {
	// List lists all ScaledJobs in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.ScaledJob, err error)
	// Get retrieves the ScaledJob from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.ScaledJob, error)
	ScaledJobNamespaceListerExpansion
}

// scaledJobNamespaceLister implements the ScaledJobNamespaceLister
// interface.
type scaledJobNamespaceLister struct {
	listers.ResourceIndexer[*v1alpha1.ScaledJob]
}
