/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	acmev1 "github.com/cert-manager/cert-manager/pkg/apis/acme/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// ChallengeLister helps list Challenges.
// All objects returned here must be treated as read-only.
type ChallengeLister interface {
	// List lists all Challenges in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*acmev1.Challenge, err error)
	// Challenges returns an object that can list and get Challenges.
	Challenges(namespace string) ChallengeNamespaceLister
	ChallengeListerExpansion
}

// challengeLister implements the ChallengeLister interface.
type challengeLister struct {
	listers.ResourceIndexer[*acmev1.Challenge]
}

// NewChallengeLister returns a new ChallengeLister.
func NewChallengeLister(indexer cache.Indexer) ChallengeLister {
	return &challengeLister{listers.New[*acmev1.Challenge](indexer, acmev1.Resource("challenge"))}
}

// Challenges returns an object that can list and get Challenges.
func (s *challengeLister) Challenges(namespace string) ChallengeNamespaceLister {
	return challengeNamespaceLister{listers.NewNamespaced[*acmev1.Challenge](s.ResourceIndexer, namespace)}
}

// ChallengeNamespaceLister helps list and get Challenges.
// All objects returned here must be treated as read-only.
type ChallengeNamespaceLister interface {
	// List lists all Challenges in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*acmev1.Challenge, err error)
	// Get retrieves the Challenge from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*acmev1.Challenge, error)
	ChallengeNamespaceListerExpansion
}

// challengeNamespaceLister implements the ChallengeNamespaceLister
// interface.
type challengeNamespaceLister struct {
	listers.ResourceIndexer[*acmev1.Challenge]
}
